/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.sys;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Properties;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.PropertyUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.block.FileMode;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTDB {
    private static final Logger log = LoggerFactory.getLogger(TDB.class);
    public static final Logger syslog = LoggerFactory.getLogger((String)"TDB");
    public static final Logger errlog = LoggerFactory.getLogger((String)"TDB");
    public static final int SizeOfLong = 8;
    public static final int SizeOfInt = 4;
    public static final int SizeOfNodeId = 8;
    public static final int SizeOfPointer = 4;
    public static final int LenIndexTripleRecord = 24;
    public static final int LenIndexQuadRecord = 32;
    public static final int LenNodeHash = 16;
    public static final RecordFactory indexRecordTripleFactory = new RecordFactory(24, 0);
    public static final RecordFactory indexRecordQuadFactory = new RecordFactory(32, 0);
    public static final RecordFactory nodeRecordFactory = new RecordFactory(16, 8);
    public static final String symbolNamespace = "http://jena.hpl.hp.com/TDB#";
    public static final String tdbSymbolPrefix = "tdb";
    public static final String tdbPropertyRoot = "org.apache.jena.tdb";
    public static final Symbol symLogDuplicates = SystemTDB.allocSymbol("logDuplicates");
    public static final Symbol symFileMode = SystemTDB.allocSymbol("fileMode");
    public static final Symbol symIndexType = SystemTDB.allocSymbol("indexType");
    public static final Symbol symTupleFilter = SystemTDB.allocSymbol("tupleFilter");
    private static final String propertyFileKey1 = "org.apache.jena.tdb.settings";
    private static final String propertyFileKey2 = "tdb:settings";
    private static String propertyFileName = null;
    public static final boolean is64bitSystem;
    private static Properties properties;
    public static final int BlockSize = 8192;
    public static final int BlockSizeTest = 1024;
    public static final int BlockSizeTestMem = 500;
    public static final int OrderMem = 5;
    public static final int SegmentSize = 0x800000;
    public static final int ObjectFileWriteCacheSize = 8192;
    public static final int Node2NodeIdCacheSize;
    public static final int NodeId2NodeCacheSize;
    public static final int NodeMissCacheSize = 100;
    public static final int BlockWriteCacheSize;
    public static final int BlockReadCacheSize;
    public static ReorderTransformation defaultReorderTransform;
    public static final ByteOrder NetworkOrder;
    public static String propertyEnableInlineLiterals1;
    public static String propertyEnableInlineLiterals2;
    public static final boolean enableInlineLiterals;
    public static boolean NullOut;
    public static final byte FillByte = -1;
    public static boolean Checking;
    public static boolean DiskLocationMultiJvmUsagePrevention;
    public static final boolean isWindows;
    private static FileMode fileMode;

    public static void init() {
    }

    public static void panic(Class<?> clazz, String string) {
        Log.fatal(clazz, (String)string);
        throw new TDBException(string);
    }

    public static Symbol allocSymbol(String shortName) {
        if (shortName.startsWith(tdbSymbolPrefix)) {
            throw new TDBException("Symbol short name begins with the TDB namespace prefix: " + shortName);
        }
        if (shortName.startsWith("http:")) {
            throw new TDBException("Symbol short name begins with http: " + shortName);
        }
        return SystemTDB.allocSymbol(symbolNamespace, shortName);
    }

    private static Symbol allocSymbol(String namespace, String shortName) {
        return Symbol.create((String)(namespace + shortName));
    }

    private static int intValue(String prefix, String name, int defaultValue) {
        name = !prefix.endsWith(".") ? prefix + "." + name : prefix + name;
        return SystemTDB.intValue(name, defaultValue);
    }

    private static int intValue(String name, int defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        if (name.length() == 0) {
            throw new TDBException("Empty string for value name");
        }
        if (properties == null) {
            return defaultValue;
        }
        String x = properties.getProperty(name);
        if (x == null) {
            return defaultValue;
        }
        TDB.logInfo.info("Set: " + name + " = " + x);
        int v = Integer.parseInt(x);
        return v;
    }

    private static Properties readPropertiesFile() {
        if (propertyFileName == null) {
            return null;
        }
        Properties p = new Properties();
        try {
            TDB.logInfo.info("Using properties from '" + propertyFileName + "'");
            PropertyUtils.loadFromFile((Properties)p, (String)propertyFileName);
        }
        catch (FileNotFoundException ex) {
            log.debug("No system properties file (" + propertyFileName + ")");
            return null;
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
        return p;
    }

    private static boolean determineIfWindows() {
        String s = System.getProperty("os.name");
        if (s == null) {
            return false;
        }
        return s.startsWith("Windows ");
    }

    private static boolean determineIf64Bit() {
        String s = System.getProperty("sun.arch.data.model");
        if (s != null) {
            boolean b = s.equals("64");
            TDB.logInfo.debug("System architecture: " + (b ? "64 bit" : "32 bit"));
            return b;
        }
        s = System.getProperty("java.vm.info");
        if (s == null) {
            log.warn("Can't determine the data model");
            return false;
        }
        log.debug("Can't determine the data model from 'sun.arch.data.model' - using java.vm.info");
        boolean b = s.contains("64");
        TDB.logInfo.debug("System architecture: (from java.vm.info) " + (b ? "64 bit" : "32 bit"));
        return b;
    }

    public static FileMode fileMode() {
        if (fileMode == null) {
            fileMode = SystemTDB.determineFileMode();
        }
        return fileMode;
    }

    public static void setFileMode(FileMode newFileMode) {
        if (fileMode != null) {
            log.warn("System file mode already determined - setting it has no effect");
            return;
        }
        fileMode = newFileMode;
    }

    static void internalSetFileMode(FileMode newFileMode) {
        fileMode = newFileMode;
    }

    private static FileMode determineFileMode() {
        String x = ARQ.getContext().getAsString(symFileMode, "default");
        if (x.equalsIgnoreCase("direct")) {
            TDB.logInfo.info("File mode: direct (forced)");
            return FileMode.direct;
        }
        if (x.equalsIgnoreCase("mapped")) {
            TDB.logInfo.info("File mode: mapped (forced)");
            return FileMode.mapped;
        }
        if (x.equalsIgnoreCase("default")) {
            if (is64bitSystem) {
                TDB.logInfo.debug("File mode: Mapped");
                return FileMode.mapped;
            }
            TDB.logInfo.debug("File mode: Direct");
            return FileMode.direct;
        }
        throw new TDBException("Unrecognized file mode (not one of 'default', 'direct' or 'mapped': " + x);
    }

    static {
        propertyFileName = System.getProperty(propertyFileKey1);
        if (propertyFileName == null) {
            propertyFileName = System.getProperty(propertyFileKey2);
        }
        is64bitSystem = SystemTDB.determineIf64Bit();
        properties = SystemTDB.readPropertiesFile();
        Node2NodeIdCacheSize = SystemTDB.intValue("Node2NodeIdCacheSize", is64bitSystem ? 100000 : 50000);
        NodeId2NodeCacheSize = SystemTDB.intValue("NodeId2NodeCacheSize", is64bitSystem ? 500000 : 50000);
        BlockWriteCacheSize = SystemTDB.intValue("BlockWriteCacheSize", 2000);
        BlockReadCacheSize = SystemTDB.intValue("BlockReadCacheSize", 10000);
        defaultReorderTransform = ReorderLib.fixed();
        NetworkOrder = ByteOrder.BIG_ENDIAN;
        propertyEnableInlineLiterals1 = "org.apache.jena.tdb.store.enableInlineLiterals";
        propertyEnableInlineLiterals2 = "tdb:store.enableInlineLiterals";
        Properties sysProperties = System.getProperties();
        String key = null;
        if (sysProperties.containsKey(propertyEnableInlineLiterals1)) {
            key = propertyFileKey1;
        } else if (sysProperties.containsKey(propertyEnableInlineLiterals2)) {
            key = propertyFileKey2;
        }
        enableInlineLiterals = key == null ? true : Boolean.valueOf(sysProperties.getProperty(key));
        NullOut = false;
        Checking = false;
        DiskLocationMultiJvmUsagePrevention = true;
        isWindows = SystemTDB.determineIfWindows();
        fileMode = null;
    }
}

