/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.sys;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.transaction.DatasetGraphTransaction;

public class TDBInternal {
    public static NodeId getNodeId(Dataset ds, Node node) {
        return TDBInternal.getNodeId(ds.asDatasetGraph(), node);
    }

    public static NodeId getNodeId(DatasetGraph ds, Node node) {
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(ds);
        return TDBInternal.getNodeId(dsg, node);
    }

    public static NodeId getNodeId(DatasetGraphTDB dsg, Node node) {
        if (dsg == null) {
            return null;
        }
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        NodeId nodeId = nodeTable.getNodeIdForNode(node);
        return nodeId;
    }

    public static Node getNode(Dataset ds, NodeId nodeId) {
        return TDBInternal.getNode(ds.asDatasetGraph(), nodeId);
    }

    public static Node getNode(DatasetGraph ds, NodeId nodeId) {
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(ds);
        return TDBInternal.getNode(dsg, nodeId);
    }

    public static Node getNode(DatasetGraphTDB dsg, NodeId nodeId) {
        if (dsg == null) {
            return null;
        }
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        Node node = nodeTable.getNodeForNodeId(nodeId);
        return node;
    }

    public static DatasetGraphTDB getDatasetGraphTDB(Dataset ds) {
        return TDBInternal.getDatasetGraphTDB(ds.asDatasetGraph());
    }

    public static DatasetGraphTDB getDatasetGraphTDB(DatasetGraph dsg) {
        if (dsg instanceof DatasetGraphTransaction) {
            return ((DatasetGraphTransaction)dsg).getDatasetGraphToQuery();
        }
        if (dsg instanceof DatasetGraphTDB) {
            return (DatasetGraphTDB)dsg;
        }
        return null;
    }

    public static DatasetGraphTDB getBaseDatasetGraphTDB(DatasetGraph datasetGraph) {
        if (datasetGraph instanceof DatasetGraphTransaction) {
            return ((DatasetGraphTransaction)datasetGraph).getBaseDatasetGraph();
        }
        throw new TDBException("Not a suitable DatasetGraph to get it's base storage: " + Lib.classShortName(datasetGraph.getClass()));
    }
}

