/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.JPanel;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.DataSeries;
import org.jCharts.chartData.interfaces.IAxisDataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.LineChartProperties;
import org.jCharts.properties.PointChartProperties;
import org.jCharts.types.ChartType;

public class LineGraph
extends JPanel {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected double[][] data = null;
    protected String title;
    protected String xAxisTitle;
    protected String yAxisTitle;
    protected String[] xAxisLabels;
    protected String[] yAxisLabel;
    protected int width;
    protected int height;
    private static final Shape[] SHAPE_ARRAY = new Shape[]{PointChartProperties.SHAPE_CIRCLE, PointChartProperties.SHAPE_DIAMOND, PointChartProperties.SHAPE_SQUARE, PointChartProperties.SHAPE_TRIANGLE};
    private static final Paint[] PAINT_ARRAY = new Paint[]{Color.black, Color.blue, Color.green, Color.magenta, Color.orange, Color.red, Color.yellow, Color.darkGray, Color.gray, Color.lightGray, Color.pink, Color.cyan};
    protected int shape_counter = 0;
    protected int paint_counter = -1;

    public LineGraph() {
    }

    public LineGraph(LayoutManager layout) {
        super(layout);
    }

    public LineGraph(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public void setData(double[][] data) {
        this.data = data;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setXAxisTitle(String title) {
        this.xAxisTitle = title;
    }

    public void setYAxisTitle(String title) {
        this.yAxisTitle = title;
    }

    public void setXAxisLabels(String[] labels) {
        this.xAxisLabels = labels;
    }

    public void setYAxisLabels(String[] label) {
        this.yAxisLabel = label;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void paintComponent(Graphics g) {
        this.paint_counter = -1;
        if (this.data != null && this.title != null && this.xAxisLabels != null && this.xAxisTitle != null && this.yAxisLabel != null && this.yAxisTitle != null) {
            this.drawSample(this.title, this.xAxisLabels, this.xAxisTitle, this.yAxisTitle, this.data, this.width, this.height, g);
        }
    }

    private void drawSample(String _title, String[] _xAxisLabels, String _xAxisTitle, String _yAxisTitle, double[][] _data, int _width, int _height, Graphics g) {
        try {
            if (_width == 0) {
                _width = 450;
            }
            if (_height == 0) {
                _height = 250;
            }
            this.setPreferredSize(new Dimension(_width, _height));
            DataSeries dataSeries = new DataSeries(_xAxisLabels, _xAxisTitle, _yAxisTitle, _title);
            String[] legendLabels = this.yAxisLabel;
            Paint[] paints = this.createPaint(_data.length);
            Shape[] shapes = this.createShapes(_data.length);
            Stroke[] lstrokes = this.createStrokes(_data.length);
            LineChartProperties lineChartProperties = new LineChartProperties(lstrokes, shapes);
            AxisChartDataSet axisChartDataSet = new AxisChartDataSet(_data, legendLabels, paints, ChartType.LINE, (ChartTypeProperties)lineChartProperties);
            dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
            ChartProperties chartProperties = new ChartProperties();
            AxisProperties axisProperties = new AxisProperties();
            axisProperties.getYAxisProperties().setShowGridLines(1);
            axisProperties.setXAxisLabelsAreVertical(true);
            DataAxisProperties daxp = (DataAxisProperties)axisProperties.getYAxisProperties();
            daxp.setRoundToNearest(1);
            LegendProperties legendProperties = new LegendProperties();
            AxisChart axisChart = new AxisChart((IAxisDataSeries)dataSeries, chartProperties, axisProperties, legendProperties, _width, _height);
            axisChart.setGraphics2D((Graphics2D)g);
            axisChart.render();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public Shape[] createShapes(int count) {
        Shape[] shapes = new Shape[count];
        for (int idx = 0; idx < count; ++idx) {
            shapes[idx] = this.nextShape();
        }
        return shapes;
    }

    public Shape nextShape() {
        ++this.shape_counter;
        if (this.shape_counter >= SHAPE_ARRAY.length - 1) {
            this.shape_counter = 0;
        }
        return SHAPE_ARRAY[this.shape_counter];
    }

    public Stroke[] createStrokes(int count) {
        Stroke[] str = new Stroke[count];
        for (int idx = 0; idx < count; ++idx) {
            str[idx] = this.nextStroke();
        }
        return str;
    }

    public Stroke nextStroke() {
        return new BasicStroke(1.0f);
    }

    public Paint[] createPaint(int count) {
        Paint[] pts = new Paint[count];
        for (int idx = 0; idx < count; ++idx) {
            pts[idx] = this.nextPaint();
        }
        return pts;
    }

    public Paint nextPaint() {
        ++this.paint_counter;
        if (this.paint_counter == PAINT_ARRAY.length - 1) {
            this.paint_counter = 0;
        }
        return PAINT_ARRAY[this.paint_counter];
    }
}

