/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.RateRenderer;
import org.apache.jorphan.gui.RendererUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class StatVisualizer
extends AbstractVisualizer
implements Clearable,
ActionListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String USE_GROUP_NAME = "useGroupName";
    private static final String SAVE_HEADERS = "saveHeaders";
    private static final String[] COLUMNS = new String[]{"sampler_label", "aggregate_report_count", "average", "aggregate_report_median", "aggregate_report_90%_line", "aggregate_report_min", "aggregate_report_max", "aggregate_report_error%", "aggregate_report_rate", "aggregate_report_bandwidth"};
    private final String TOTAL_ROW_LABEL = JMeterUtils.getResString((String)"aggregate_report_total_label");
    private JTable myJTable;
    private JScrollPane myScrollPane;
    private final JButton saveTable = new JButton(JMeterUtils.getResString((String)"aggregate_graph_save_table"));
    private final JCheckBox saveHeaders = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_save_table_header"), true);
    private final JCheckBox useGroupName = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_use_group_name"));
    private transient ObjectTableModel model;
    private final transient Object lock = new Object();
    private final Map<String, SamplingStatCalculator> tableRows = new ConcurrentHashMap<String, SamplingStatCalculator>();
    private static final TableCellRenderer[] RENDERERS = new TableCellRenderer[]{null, null, null, null, null, null, null, new NumberRenderer("#0.00%"), new RateRenderer("#.0"), new NumberRenderer("#.0")};

    public StatVisualizer() {
        this.model = new ObjectTableModel(COLUMNS, SamplingStatCalculator.class, new Functor[]{new Functor("getLabel"), new Functor("getCount"), new Functor("getMeanAsNumber"), new Functor("getMedian"), new Functor("getPercentPoint", new Object[]{new Float(0.9)}), new Functor("getMin"), new Functor("getMax"), new Functor("getErrorPercentage"), new Functor("getRate"), new Functor("getKBPerSecond")}, new Functor[]{null, null, null, null, null, null, null, null, null, null}, new Class[]{String.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, String.class, String.class, String.class});
        this.clearData();
        this.init();
    }

    @Deprecated
    public static boolean testFunctors() {
        StatVisualizer instance = new StatVisualizer();
        return instance.model.checkFunctors(null, instance.getClass());
    }

    public String getLabelResource() {
        return "aggregate_report";
    }

    public void add(final SampleResult res) {
        JMeterUtils.runSafe((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SamplingStatCalculator tot;
                SamplingStatCalculator row = null;
                String sampleLabel = res.getSampleLabel(StatVisualizer.this.useGroupName.isSelected());
                Object object = StatVisualizer.this.lock;
                synchronized (object) {
                    row = (SamplingStatCalculator)StatVisualizer.this.tableRows.get(sampleLabel);
                    if (row == null) {
                        row = new SamplingStatCalculator(sampleLabel);
                        StatVisualizer.this.tableRows.put(row.getLabel(), row);
                        StatVisualizer.this.model.insertRow((Object)row, StatVisualizer.this.model.getRowCount() - 1);
                    }
                }
                object = row;
                synchronized (object) {
                    row.addSample(res);
                }
                SamplingStatCalculator samplingStatCalculator = tot = (SamplingStatCalculator)StatVisualizer.this.tableRows.get(StatVisualizer.this.TOTAL_ROW_LABEL);
                synchronized (samplingStatCalculator) {
                    tot.addSample(res);
                }
                StatVisualizer.this.model.fireTableDataChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Object object = this.lock;
        synchronized (object) {
            this.model.clearData();
            this.tableRows.clear();
            this.tableRows.put(this.TOTAL_ROW_LABEL, new SamplingStatCalculator(this.TOTAL_ROW_LABEL));
            this.model.addRow((Object)this.tableRows.get(this.TOTAL_ROW_LABEL));
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.makeTitlePanel());
        this.myJTable = new JTable((TableModel)this.model);
        this.myJTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.myJTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        RendererUtils.applyRenderers((JTable)this.myJTable, (TableCellRenderer[])RENDERERS);
        this.myScrollPane = new JScrollPane(this.myJTable);
        this.add(mainPanel, "North");
        this.add(this.myScrollPane, "Center");
        this.saveTable.addActionListener(this);
        JPanel opts = new JPanel();
        opts.add((Component)this.useGroupName, "West");
        opts.add((Component)this.saveTable, "Center");
        opts.add((Component)this.saveHeaders, "East");
        this.add(opts, "South");
    }

    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        c.setProperty(USE_GROUP_NAME, this.useGroupName.isSelected(), false);
        c.setProperty(SAVE_HEADERS, this.saveHeaders.isSelected(), true);
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.useGroupName.setSelected(el.getPropertyAsBoolean(USE_GROUP_NAME, false));
        this.saveHeaders.setSelected(el.getPropertyAsBoolean(SAVE_HEADERS, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.saveTable) {
            JFileChooser chooser = FileDialoger.promptToSaveFile((String)"aggregate.csv");
            if (chooser == null) {
                return;
            }
            FileWriter writer = null;
            try {
                writer = new FileWriter(chooser.getSelectedFile());
                CSVSaveService.saveCSVStats((DefaultTableModel)this.model, (FileWriter)writer, (boolean)this.saveHeaders.isSelected());
            }
            catch (FileNotFoundException e) {
                log.warn(e.getMessage());
                JOrphanUtils.closeQuietly((Closeable)writer);
            }
            catch (IOException e2) {
                log.warn(e2.getMessage());
                {
                    catch (Throwable throwable) {
                        JOrphanUtils.closeQuietly(writer);
                        throw throwable;
                    }
                }
                JOrphanUtils.closeQuietly((Closeable)writer);
            }
            JOrphanUtils.closeQuietly((Closeable)writer);
        }
    }
}

