/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.assertions.JSONPathAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

@GUIMenuSortOrder(value=2)
public class JSONPathAssertionGui
extends AbstractAssertionGui
implements ChangeListener {
    private static final long serialVersionUID = -6008018002423594040L;
    private JLabeledTextField jsonPath = null;
    private JLabeledTextArea jsonValue = null;
    private JCheckBox jsonValidation = null;
    private JCheckBox expectNull = null;
    private JCheckBox invert = null;
    private JCheckBox isRegex;

    public JSONPathAssertionGui() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.jsonPath = new JLabeledTextField(JMeterUtils.getResString((String)"json_assertion_path"));
        this.jsonValidation = new JCheckBox(JMeterUtils.getResString((String)"json_assertion_validation"));
        this.isRegex = new JCheckBox(JMeterUtils.getResString((String)"json_assertion_regex"));
        this.jsonValue = new JLabeledTextArea(JMeterUtils.getResString((String)"json_assertion_expected_value"));
        this.expectNull = new JCheckBox(JMeterUtils.getResString((String)"json_assertion_null"));
        this.invert = new JCheckBox(JMeterUtils.getResString((String)"json_assertion_invert"));
        this.jsonValidation.addChangeListener(this);
        this.expectNull.addChangeListener(this);
        panel.add((Component)this.jsonPath);
        panel.add((Component)this.jsonValidation);
        panel.add((Component)this.isRegex);
        panel.add((Component)this.jsonValue);
        panel.add((Component)this.expectNull);
        panel.add((Component)this.invert);
        this.add((Component)panel, "Center");
    }

    public void clearGui() {
        super.clearGui();
        this.jsonPath.setText("$.");
        this.jsonValue.setText("");
        this.jsonValidation.setSelected(false);
        this.expectNull.setSelected(false);
        this.invert.setSelected(false);
        this.isRegex.setSelected(true);
    }

    public TestElement createTestElement() {
        JSONPathAssertion jpAssertion = new JSONPathAssertion();
        this.modifyTestElement((TestElement)jpAssertion);
        return jpAssertion;
    }

    public String getLabelResource() {
        return "json_assertion_title";
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JSONPathAssertion) {
            JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
            jpAssertion.setJsonPath(this.jsonPath.getText());
            jpAssertion.setExpectedValue(this.jsonValue.getText());
            jpAssertion.setJsonValidationBool(this.jsonValidation.isSelected());
            jpAssertion.setExpectNull(this.expectNull.isSelected());
            jpAssertion.setInvert(this.invert.isSelected());
            jpAssertion.setIsRegex(this.isRegex.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
        this.jsonPath.setText(jpAssertion.getJsonPath());
        this.jsonValue.setText(jpAssertion.getExpectedValue());
        this.jsonValidation.setSelected(jpAssertion.isJsonValidationBool());
        this.expectNull.setSelected(jpAssertion.isExpectNull());
        this.invert.setSelected(jpAssertion.isInvert());
        this.isRegex.setSelected(jpAssertion.isUseRegex());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.jsonValue.setEnabled(this.jsonValidation.isSelected() && !this.expectNull.isSelected());
        this.isRegex.setEnabled(this.jsonValidation.isSelected() && !this.expectNull.isSelected());
    }
}

