/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.client;

import java.io.Closeable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.client.InitialContextFactory;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ReceiveSubscriber
implements Closeable,
MessageListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final Connection CONN;
    private final Session SESSION;
    private final MessageConsumer SUBSCRIBER;
    private final LinkedBlockingQueue<Message> queue;

    public ReceiveSubscriber(boolean useProps, String initialContextFactory, String providerUrl, String connfactory, String destinationName, String durableSubscriptionId, String clientId, String jmsSelector, boolean useAuth, String securityPrincipal, String securityCredentials) throws NamingException, JMSException {
        this(0, useProps, initialContextFactory, providerUrl, connfactory, destinationName, durableSubscriptionId, clientId, jmsSelector, useAuth, securityPrincipal, securityCredentials, false);
    }

    public ReceiveSubscriber(int queueSize, boolean useProps, String initialContextFactory, String providerUrl, String connfactory, String destinationName, String durableSubscriptionId, String clientId, String jmsSelector, boolean useAuth, String securityPrincipal, String securityCredentials) throws NamingException, JMSException {
        this(queueSize, useProps, initialContextFactory, providerUrl, connfactory, destinationName, durableSubscriptionId, clientId, jmsSelector, useAuth, securityPrincipal, securityCredentials, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiveSubscriber(int queueSize, boolean useProps, String initialContextFactory, String providerUrl, String connfactory, String destinationName, String durableSubscriptionId, String clientId, String jmsSelector, boolean useAuth, String securityPrincipal, String securityCredentials, boolean useMessageListener) throws NamingException, JMSException {
        boolean initSuccess = false;
        try {
            Context ctx = InitialContextFactory.getContext(useProps, initialContextFactory, providerUrl, useAuth, securityPrincipal, securityCredentials);
            this.CONN = Utils.getConnection(ctx, connfactory);
            if (!this.isEmpty(clientId)) {
                this.CONN.setClientID(clientId);
            }
            this.SESSION = this.CONN.createSession(false, 1);
            Destination dest = Utils.lookupDestination(ctx, destinationName);
            this.SUBSCRIBER = this.createSubscriber(this.SESSION, dest, durableSubscriptionId, jmsSelector);
            if (useMessageListener) {
                this.queue = queueSize <= 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(queueSize);
                this.SUBSCRIBER.setMessageListener((MessageListener)this);
            } else {
                this.queue = null;
            }
            log.debug("<init> complete");
            initSuccess = true;
        }
        finally {
            if (!initSuccess) {
                this.close();
            }
        }
    }

    private MessageConsumer createSubscriber(Session session, Destination destination, String durableSubscriptionId, String jmsSelector) throws JMSException {
        if (this.isEmpty(durableSubscriptionId)) {
            if (this.isEmpty(jmsSelector)) {
                return session.createConsumer(destination);
            }
            return session.createConsumer(destination, jmsSelector);
        }
        if (this.isEmpty(jmsSelector)) {
            return session.createDurableSubscriber((Topic)destination, durableSubscriptionId);
        }
        return session.createDurableSubscriber((Topic)destination, durableSubscriptionId, jmsSelector, false);
    }

    public void start() throws JMSException {
        log.debug("start()");
        this.CONN.start();
    }

    public void stop() throws JMSException {
        log.debug("stop()");
        this.CONN.stop();
    }

    public Message getMessage(long timeout) throws JMSException {
        Message message = null;
        if (this.queue != null) {
            try {
                message = timeout < 10L ? this.queue.poll() : this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return message;
        }
        message = timeout < 10L ? this.SUBSCRIBER.receiveNoWait() : this.SUBSCRIBER.receive(timeout);
        return message;
    }

    public void close() {
        log.debug("close()");
        try {
            if (this.CONN != null) {
                this.CONN.stop();
            }
        }
        catch (JMSException e) {
            log.error(e.getMessage());
        }
        Utils.close(this.SUBSCRIBER, log);
        Utils.close(this.SESSION, log);
        Utils.close(this.CONN, log);
    }

    public void onMessage(Message message) {
        if (!this.queue.offer(message)) {
            log.warn("Could not add message to queue");
        }
    }

    private boolean isEmpty(String s1) {
        return s1 == null || s1.trim().equals("");
    }
}

