/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.charting;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileNameExtensionFilter;
import kg.apc.jmeter.charting.AbstractGraphPanelChartElement;
import kg.apc.jmeter.charting.AbstractGraphRow;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPanelChart
extends JComponent
implements ClipboardOwner {
    private static final String AD_TEXT = "http://apc.kg";
    private static final String NO_SAMPLES = "Waiting for samples...";
    private static final int spacing = 5;
    public static final int CHART_PERCENTAGE = 0;
    public static final int CHART_DEFAULT = -1;
    private static final Logger log;
    private Rectangle legendRect;
    private Rectangle xAxisRect;
    private Rectangle yAxisRect;
    private Rectangle chartRect;
    private static final Rectangle zeroRect;
    private AbstractMap<String, AbstractGraphRow> rows;
    private double maxYVal;
    private double minYVal;
    private long maxXVal;
    private long minXVal;
    private long currentXVal;
    private static final int gridLinesCount = 10;
    private NumberRenderer yAxisLabelRenderer;
    private NumberRenderer xAxisLabelRenderer;
    private boolean drawCurrentX = false;
    private int forcedMinX = -1;
    private int chartType = -1;
    private Stroke dashStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{1.0f, 4.0f}, 0.0f);
    private Stroke thickStroke = new BasicStroke(3.0f, 0, 2);
    private String errorMessage = null;
    private Color gradientColor = new Color(229, 236, 246);
    private Color axisColor = new Color(199, 206, 216);
    private static String savePath;
    private int maxPoints = -1;
    private static boolean drawGradient;
    private static boolean neverDrawFinalZeroingLines;
    private static boolean optimizeYAxis;
    private static boolean neverDrawCurrentX;
    private boolean settingsDrawGradient;
    private boolean settingsDrawFinalZeroingLines;
    private boolean settingsDrawCurrentX;

    public void setSettingsDrawCurrentX(boolean settingsDrawCurrentX) {
        this.settingsDrawCurrentX = settingsDrawCurrentX;
    }

    public void setSettingsDrawFinalZeroingLines(boolean settingsDrawFinalZeroingLines) {
        this.settingsDrawFinalZeroingLines = settingsDrawFinalZeroingLines;
    }

    public void setSettingsDrawGradient(boolean settingsDrawGradient) {
        this.settingsDrawGradient = settingsDrawGradient;
    }

    public boolean isSettingsDrawCurrentX() {
        return this.settingsDrawCurrentX;
    }

    public boolean isSettingsDrawFinalZeroingLines() {
        return this.settingsDrawFinalZeroingLines;
    }

    public boolean isSettingsDrawGradient() {
        return this.settingsDrawGradient;
    }

    public GraphPanelChart() {
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.darkGray));
        this.yAxisLabelRenderer = new NumberRenderer("#.#");
        this.xAxisLabelRenderer = new NumberRenderer("#.#");
        this.legendRect = new Rectangle();
        this.yAxisRect = new Rectangle();
        this.xAxisRect = new Rectangle();
        this.chartRect = new Rectangle();
        this.setDefaultDimensions();
        this.registerPopup();
        this.settingsDrawCurrentX = !neverDrawCurrentX;
        this.settingsDrawGradient = drawGradient;
        this.settingsDrawFinalZeroingLines = !neverDrawFinalZeroingLines;
    }

    public void setChartType(int type) {
        this.chartType = type;
    }

    private void drawFinalLines(AbstractGraphRow row, Graphics g, int prevX, int prevY, double dxForDVal, Stroke oldStroke) {
        if (row.isDrawLine() && this.settingsDrawFinalZeroingLines) {
            if (row.isDrawThickLines()) {
                ((Graphics2D)g).setStroke(this.thickStroke);
            }
            g.setColor(row.getColor());
            g.drawLine(prevX, prevY, (int)((double)prevX + dxForDVal), this.chartRect.y + this.chartRect.height);
            if (row.isDrawThickLines()) {
                ((Graphics2D)g).setStroke(oldStroke);
            }
        }
    }

    private boolean drawMessages(Graphics2D g) {
        if (this.errorMessage != null) {
            g.setColor(Color.RED);
            g.drawString(this.errorMessage, this.getWidth() / 2 - g.getFontMetrics(g.getFont()).stringWidth(this.errorMessage) / 2, this.getHeight() / 2);
            return true;
        }
        if (this.rows.isEmpty()) {
            g.setColor(Color.BLACK);
            g.drawString(NO_SAMPLES, this.getWidth() / 2 - g.getFontMetrics(g.getFont()).stringWidth(NO_SAMPLES) / 2, this.getHeight() / 2);
            return true;
        }
        return false;
    }

    private void getMinMaxDataValues() {
        this.maxXVal = 0L;
        this.maxYVal = 0.0;
        this.minXVal = Long.MAX_VALUE;
        this.minYVal = Double.MAX_VALUE;
        Iterator<Map.Entry<String, AbstractGraphRow>> it = this.rows.entrySet().iterator();
        Map.Entry<String, AbstractGraphRow> row = null;
        while (it.hasNext()) {
            row = it.next();
            AbstractGraphRow rowValue = row.getValue();
            if (!rowValue.isDrawOnChart()) continue;
            if (rowValue.getMaxY() > this.maxYVal) {
                this.maxYVal = rowValue.getMaxY();
            }
            if (rowValue.getMaxX() > this.maxXVal) {
                this.maxXVal = rowValue.getMaxX();
            }
            if (rowValue.getMinX() < this.minXVal) {
                this.minXVal = rowValue.getMinX();
            }
            if (!(rowValue.getMinY() < this.minYVal)) continue;
            this.minYVal = rowValue.getMinY() >= 0.0 ? rowValue.getMinY() : 0.0;
        }
        if ((long)this.forcedMinX >= 0L) {
            this.minXVal = this.forcedMinX;
        }
        if (this.minXVal == Long.MAX_VALUE && this.maxXVal == 0L && row != null) {
            this.maxXVal = row.getValue().getMaxX();
            this.minXVal = row.getValue().getMinX();
            this.minYVal = 0.0;
            this.maxYVal = 10.0;
        } else if (optimizeYAxis) {
            this.computeChartSteps();
        } else {
            this.minYVal = 0.0;
        }
    }

    private void computeChartSteps() {
        if (this.chartType == 0) {
            this.minYVal = 0.0;
            this.maxYVal = 100.0;
            return;
        }
        if (this.maxYVal - this.minYVal < 0.1) {
            this.maxYVal = this.minYVal + 1.0;
        }
        double step = (this.maxYVal - this.minYVal) / 10.0;
        int pow = -1;
        double factor = -1.0;
        boolean found = false;
        block0: while (!found) {
            double testFactor = ++pow > 0 ? 0.5 : 1.0;
            for (double f = 0.0; f <= 5.0; f += testFactor) {
                double testStep = Math.pow(10.0, pow) * f;
                if (!(testStep >= step)) continue;
                factor = f;
                found = true;
                continue block0;
            }
        }
        double foundStep = Math.pow(10.0, pow) * factor;
        this.minYVal -= this.minYVal % foundStep;
        if (this.minYVal + foundStep * 10.0 < this.maxYVal) {
            foundStep = Math.pow(10.0, pow) * (factor + (pow > 0 ? 0.5 : 1.0));
        }
        double trim = 10.0;
        while (this.minYVal - this.minYVal % trim + foundStep * 10.0 >= this.maxYVal && this.minYVal > 0.0) {
            this.minYVal -= this.minYVal % trim;
            trim *= 10.0;
        }
        this.maxYVal = this.minYVal + foundStep * 10.0;
    }

    private void setDefaultDimensions() {
        this.chartRect.setBounds(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        this.legendRect.setBounds(zeroRect);
        this.xAxisRect.setBounds(zeroRect);
        this.yAxisRect.setBounds(zeroRect);
    }

    private void calculateYAxisDimensions(FontMetrics fm) {
        this.yAxisLabelRenderer.setValue((Object)this.maxYVal);
        int axisWidth = fm.stringWidth(this.yAxisLabelRenderer.getText()) + 15;
        this.yAxisRect.setBounds(this.chartRect.x, this.chartRect.y, axisWidth, this.chartRect.height);
        this.chartRect.setBounds(this.chartRect.x + axisWidth, this.chartRect.y, this.chartRect.width - axisWidth, this.chartRect.height);
    }

    private void calculateXAxisDimensions(FontMetrics fm) {
        int axisHeight = fm.getHeight() + 5;
        this.xAxisLabelRenderer.setValue((Object)this.maxXVal);
        int axisEndSpace = fm.stringWidth(this.xAxisLabelRenderer.getText()) / 2;
        this.xAxisRect.setBounds(this.chartRect.x, this.chartRect.y + this.chartRect.height - axisHeight, this.chartRect.width, axisHeight);
        this.chartRect.setBounds(this.chartRect.x, this.chartRect.y, this.chartRect.width - axisEndSpace, this.chartRect.height - axisHeight);
        this.yAxisRect.setBounds(this.yAxisRect.x, this.yAxisRect.y, this.yAxisRect.width, this.chartRect.height);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawPanel(g2d);
        g.drawImage(image, 0, 0, this);
    }

    private void drawPanel(Graphics2D g) {
        g.setColor(Color.white);
        if (this.settingsDrawGradient) {
            GradientPaint gdp = new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, this.getHeight(), this.gradientColor);
            g.setPaint(gdp);
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintAd(g);
        if (this.drawMessages(g)) {
            return;
        }
        this.setDefaultDimensions();
        this.getMinMaxDataValues();
        try {
            this.paintLegend(g);
            this.calculateYAxisDimensions(g.getFontMetrics(g.getFont()));
            this.calculateXAxisDimensions(g.getFontMetrics(g.getFont()));
            this.paintYAxis(g);
            this.paintXAxis(g);
            this.paintChart(g);
        }
        catch (Exception e) {
            log.error("Error in paintComponent", (Throwable)e);
        }
    }

    private void paintLegend(Graphics g) {
        int legendHeight;
        int rectH;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int rectW = rectH = fm.getHeight();
        Iterator<Map.Entry<String, AbstractGraphRow>> it = this.rows.entrySet().iterator();
        int currentX = this.chartRect.x;
        int currentY = this.chartRect.y;
        int n = legendHeight = it.hasNext() ? rectH + 5 : 0;
        while (it.hasNext()) {
            Map.Entry<String, AbstractGraphRow> row = it.next();
            if (!row.getValue().isShowInLegend() || !row.getValue().isDrawOnChart()) continue;
            if (currentX + rectW + 2 + fm.stringWidth(row.getKey()) > this.getWidth()) {
                currentY += rectH + 2;
                legendHeight += rectH + 2;
                currentX = this.chartRect.x;
            }
            g.setColor(row.getValue().getColor());
            g.fillRect(currentX, currentY, rectW, rectH);
            g.setColor(Color.black);
            g.drawRect(currentX, currentY, rectW, rectH);
            g.drawString(row.getKey(), currentX += rectW + 2, (int)((double)currentY + (double)rectH * 0.9));
            currentX += fm.stringWidth(row.getKey()) + 5;
        }
        this.legendRect.setBounds(this.chartRect.x, this.chartRect.y, this.chartRect.width, legendHeight);
        this.chartRect.setBounds(this.chartRect.x, this.chartRect.y + legendHeight + 5, this.chartRect.width, this.chartRect.height - legendHeight - 5);
    }

    private void paintYAxis(Graphics g) {
        int gridLineY;
        int n;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int shift = 0;
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        g.setColor(this.axisColor);
        for (n = 0; n <= 10; ++n) {
            gridLineY = this.chartRect.y + (int)((double)(10 - n) * (double)this.chartRect.height / 10.0);
            g.drawLine(this.chartRect.x - 3, gridLineY, this.chartRect.x + 3, gridLineY);
        }
        for (n = 0; n <= 10; ++n) {
            if (n != 0) {
                ((Graphics2D)g).setStroke(this.dashStroke);
                shift = 7;
            }
            gridLineY = this.chartRect.y + (int)((double)(10 - n) * (double)this.chartRect.height / 10.0);
            g.setColor(this.axisColor);
            g.drawLine(this.chartRect.x + shift, gridLineY, this.chartRect.x + this.chartRect.width, gridLineY);
            g.setColor(Color.black);
            this.yAxisLabelRenderer.setValue((Object)((this.minYVal * 10.0 + (double)n * (this.maxYVal - this.minYVal)) / 10.0));
            String valueLabel = this.yAxisLabelRenderer.getText();
            int labelXPos = this.yAxisRect.x + this.yAxisRect.width - fm.stringWidth(valueLabel) - 5 - 2;
            g.drawString(valueLabel, labelXPos, gridLineY + fm.getAscent() / 2);
        }
        ((Graphics2D)g).setStroke(oldStroke);
    }

    private void paintXAxis(Graphics g) {
        int gridLineX;
        int n;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int shift = 0;
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        g.setColor(this.axisColor);
        for (n = 0; n <= 10; ++n) {
            gridLineX = this.chartRect.x + (int)((double)n * ((double)this.chartRect.width / 10.0));
            g.drawLine(gridLineX, this.chartRect.y + this.chartRect.height - 3, gridLineX, this.chartRect.y + this.chartRect.height + 3);
        }
        for (n = 0; n <= 10; ++n) {
            if (n != 0) {
                ((Graphics2D)g).setStroke(this.dashStroke);
                shift = 7;
            }
            gridLineX = this.chartRect.x + (int)((double)n * ((double)this.chartRect.width / 10.0));
            g.setColor(this.axisColor);
            g.drawLine(gridLineX, this.chartRect.y + this.chartRect.height - shift, gridLineX, this.chartRect.y);
            g.setColor(Color.black);
            this.xAxisLabelRenderer.setValue((Object)((double)this.minXVal + (double)n * (double)(this.maxXVal - this.minXVal) / 10.0));
            String valueLabel = this.xAxisLabelRenderer.getText();
            int labelXPos = gridLineX - fm.stringWidth(valueLabel) / 2;
            g.drawString(valueLabel, labelXPos, this.xAxisRect.y + fm.getAscent() + 5);
        }
        ((Graphics2D)g).setStroke(oldStroke);
        if (this.drawCurrentX && this.settingsDrawCurrentX) {
            gridLineX = this.chartRect.x + (int)((double)(this.currentXVal - this.minXVal) * (double)this.chartRect.width / (double)(this.maxXVal - this.minXVal));
            g.setColor(Color.GRAY);
            g.drawLine(gridLineX, this.chartRect.y, gridLineX, this.chartRect.y + this.chartRect.height);
            g.setColor(Color.black);
        }
    }

    private void paintChart(Graphics g) {
        g.setColor(Color.yellow);
        Iterator<Map.Entry<String, AbstractGraphRow>> it = this.rows.entrySet().iterator();
        int biggestRowSize = this.getBiggestRowSize();
        while (it.hasNext()) {
            Map.Entry<String, AbstractGraphRow> row = it.next();
            if (!row.getValue().isDrawOnChart()) continue;
            this.paintRow(g, row.getValue(), biggestRowSize);
        }
    }

    private boolean isChartPointValid(int x, int y) {
        boolean ret = true;
        if (x < this.chartRect.x || x > this.chartRect.x + this.chartRect.width) {
            ret = false;
        } else if (y < this.chartRect.y || y > this.chartRect.y + this.chartRect.height) {
            ret = false;
        }
        return ret;
    }

    public void setMaxPoints(int maxPoints) {
        this.maxPoints = maxPoints;
    }

    private int getBiggestRowSize() {
        int max = 1;
        for (Map.Entry<String, AbstractGraphRow> row : this.rows.entrySet()) {
            int size;
            if (!row.getValue().isDrawOnChart() || (size = row.getValue().size()) <= max) continue;
            max = size;
        }
        return max;
    }

    private void paintRow(Graphics g, AbstractGraphRow row, int biggestRowSize) {
        int factor = this.maxPoints > 0 ? biggestRowSize / this.maxPoints + 1 : 1;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> it = row.iterator();
        int radius = row.getMarkerSize();
        int prevX = this.settingsDrawFinalZeroingLines ? this.chartRect.x : -1;
        int prevY = this.chartRect.y + this.chartRect.height;
        double dxForDVal = this.maxXVal <= this.minXVal ? 0.0 : (double)this.chartRect.width / (double)(this.maxXVal - this.minXVal);
        double dyForDVal = this.maxYVal <= this.minYVal ? 0.0 : (double)this.chartRect.height / (this.maxYVal - this.minYVal);
        Stroke oldStroke = null;
        if (row.isDrawThickLines()) {
            oldStroke = ((Graphics2D)g).getStroke();
        }
        boolean firstPoint = true;
        int nbAveragedValues = 0;
        while (it.hasNext()) {
            Map.Entry<Long, AbstractGraphPanelChartElement> element;
            if (!row.isDrawOnChart()) continue;
            double calcPointX = 0.0;
            double calcPointY = 0.0;
            if (factor == 1 || firstPoint) {
                firstPoint = false;
                element = it.next();
                calcPointX = element.getKey().doubleValue();
                calcPointY = element.getValue().getValue();
            } else {
                nbAveragedValues = 0;
                for (int i = 0; i < factor; ++i) {
                    if (!it.hasNext()) continue;
                    ++nbAveragedValues;
                    element = it.next();
                    calcPointX += element.getKey().doubleValue();
                    calcPointY += element.getValue().getValue();
                }
                calcPointX /= (double)nbAveragedValues;
                calcPointY /= (double)nbAveragedValues;
            }
            int x = this.chartRect.x + (int)((calcPointX - (double)this.minXVal) * dxForDVal);
            int yHeight = (int)((calcPointY - this.minYVal) * dyForDVal);
            int y = this.chartRect.y + this.chartRect.height - yHeight;
            if (row.isDrawThickLines()) {
                ((Graphics2D)g).setStroke(this.thickStroke);
            }
            if (row.isDrawLine()) {
                if (prevX > 0) {
                    g.setColor(row.getColor());
                    if (this.isChartPointValid(x, y)) {
                        g.drawLine(prevX, prevY, x, y);
                    }
                }
                prevX = x;
                prevY = y;
            }
            if (row.isDrawBar()) {
                g.setColor(row.getColor());
                if (this.isChartPointValid(x, y)) {
                    g.fillRect(x - this.chartRect.width / 10 / 2 - 1, y, this.chartRect.width / 10 - 2, yHeight);
                }
            }
            if (row.isDrawThickLines()) {
                ((Graphics2D)g).setStroke(oldStroke);
            }
            if (row.isDrawValueLabel()) {
                g.setColor(Color.DARK_GRAY);
                this.yAxisLabelRenderer.setValue((Object)calcPointY);
                g.drawString(this.yAxisLabelRenderer.getText(), x + row.getMarkerSize() + 5, y + fm.getAscent() / 2);
            }
            if (radius == 0) continue;
            g.setColor(row.getColor());
            if (!this.isChartPointValid(x, y)) continue;
            g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
        }
        this.drawFinalLines(row, g, prevX, prevY, dxForDVal, oldStroke);
    }

    public void setRows(AbstractMap<String, AbstractGraphRow> aRows) {
        this.rows = aRows;
    }

    public void setyAxisLabelRenderer(NumberRenderer yAxisLabelRenderer) {
        this.yAxisLabelRenderer = yAxisLabelRenderer;
    }

    public void setxAxisLabelRenderer(NumberRenderer xAxisLabelRenderer) {
        this.xAxisLabelRenderer = xAxisLabelRenderer;
    }

    public void setDrawFinalZeroingLines(boolean drawFinalZeroingLines) {
        this.settingsDrawFinalZeroingLines = drawFinalZeroingLines && !neverDrawFinalZeroingLines;
    }

    public void setDrawCurrentX(boolean drawCurrentX) {
        this.drawCurrentX = drawCurrentX;
    }

    public void setCurrentX(long currentX) {
        this.currentXVal = currentX;
    }

    public void setForcedMinX(int i) {
        this.forcedMinX = i;
    }

    private void paintAd(Graphics2D g) {
        Font oldFont = g.getFont();
        g.setFont(g.getFont().deriveFont(10.0f));
        g.setColor(this.axisColor);
        Composite oldComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.7f));
        g.drawString(AD_TEXT, this.getWidth() - g.getFontMetrics().stringWidth(AD_TEXT) - 5, g.getFontMetrics().getHeight() - 5 + 1);
        g.setComposite(oldComposite);
        g.setFont(oldFont);
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
    }

    public void setErrorMessage(String msg) {
        if (msg != null && msg.trim().length() > 0) {
            this.errorMessage = msg;
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private Image getImage() {
        return this.getBufferedImage();
    }

    private BufferedImage getBufferedImage() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawPanel(g2);
        return image;
    }

    private void registerPopup() {
        JPopupMenu popup = new JPopupMenu();
        this.setComponentPopupMenu(popup);
        JMenuItem itemCopy = new JMenuItem("Copy Image to Clipboard");
        JMenuItem itemSave = new JMenuItem("Save Image as...");
        itemCopy.addActionListener(new CopyAction());
        itemSave.addActionListener(new SaveAction());
        popup.add(itemCopy);
        popup.add(itemSave);
    }

    static {
        String cfgNeverDrawFinalCurrentX;
        String cfgOptimizeYAxis;
        String cfgNeverDrawFinalZeroingLines;
        log = LoggingManager.getLoggerForClass();
        zeroRect = new Rectangle();
        savePath = null;
        drawGradient = true;
        neverDrawFinalZeroingLines = false;
        optimizeYAxis = true;
        neverDrawCurrentX = false;
        String cfgDrawGradient = JMeterUtils.getProperty((String)"jmeterPlugin.drawGradient");
        if (cfgDrawGradient != null) {
            drawGradient = "true".equalsIgnoreCase(cfgDrawGradient);
        }
        if ((cfgNeverDrawFinalZeroingLines = JMeterUtils.getProperty((String)"jmeterPlugin.neverDrawFinalZeroingLines")) != null) {
            neverDrawFinalZeroingLines = "true".equalsIgnoreCase(cfgNeverDrawFinalZeroingLines);
        }
        if ((cfgOptimizeYAxis = JMeterUtils.getProperty((String)"jmeterPlugin.optimizeYAxis")) != null) {
            optimizeYAxis = "true".equalsIgnoreCase(cfgOptimizeYAxis);
        }
        if ((cfgNeverDrawFinalCurrentX = JMeterUtils.getProperty((String)"jmeterPlugin.neverDrawCurrentX")) != null) {
            neverDrawCurrentX = "true".equalsIgnoreCase(cfgNeverDrawFinalCurrentX);
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = savePath != null ? new JFileChooser(new File(savePath)) : new JFileChooser();
            chooser.setFileFilter(new FileNameExtensionFilter("PNG Images", "png"));
            int returnVal = chooser.showSaveDialog(GraphPanelChart.this);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                if (!file.getAbsolutePath().toUpperCase().endsWith(".PNG")) {
                    file = new File(file.getAbsolutePath() + ".png");
                }
                savePath = file.getParent();
                boolean doSave = true;
                if (file.exists()) {
                    int choice = JOptionPane.showConfirmDialog(GraphPanelChart.this, "Do you want to overwrite " + file.getAbsolutePath() + "?", "Save Image as", 0, 3);
                    boolean bl = doSave = choice == 0;
                }
                if (doSave) {
                    try {
                        FileOutputStream fos = new FileOutputStream(file);
                        ImageIO.write((RenderedImage)GraphPanelChart.this.getBufferedImage(), "png", fos);
                        fos.flush();
                        fos.close();
                    }
                    catch (IOException ex) {
                        JOptionPane.showConfirmDialog(GraphPanelChart.this, "Impossible to write the image to the file:\n" + ex.getMessage(), "Save Image as", -1, 0);
                    }
                }
            }
        }
    }

    private class CopyAction
    implements ActionListener {
        private CopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = GraphPanelChart.this.getToolkit().getSystemClipboard();
            Transferable transferable = new Transferable(){

                public Object getTransferData(DataFlavor flavor) {
                    if (this.isDataFlavorSupported(flavor)) {
                        return GraphPanelChart.this.getImage();
                    }
                    return null;
                }

                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.imageFlavor};
                }

                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return DataFlavor.imageFlavor.equals(flavor);
                }
            };
            clipboard.setContents(transferable, GraphPanelChart.this);
        }
    }
}

