/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.charting;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import kg.apc.jmeter.charting.AbstractGraphPanelChartElement;
import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphPanelChartSumElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphRowSumValues
extends AbstractGraphRow
implements Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> {
    private ConcurrentSkipListMap<Long, GraphPanelChartSumElement> values = new ConcurrentSkipListMap();
    private double rollingSum;
    private Iterator<Map.Entry<Long, GraphPanelChartSumElement>> iterator;
    private boolean isRollingSum = true;

    public GraphRowSumValues() {
    }

    public GraphRowSumValues(boolean doRollingSum) {
        this.isRollingSum = doRollingSum;
    }

    public void setMaxY(double val) {
        this.maxY = val;
    }

    @Override
    public void add(long xVal, double yVal) {
        if (this.values.containsKey(xVal)) {
            GraphPanelChartSumElement el = this.values.get(xVal);
            el.add(yVal);
            yVal = el.getValue();
        } else {
            GraphPanelChartSumElement el = new GraphPanelChartSumElement(yVal);
            this.values.put(xVal, el);
        }
        super.add(xVal, yVal);
    }

    @Override
    public Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> iterator() {
        this.rollingSum = 0.0;
        this.iterator = this.values.entrySet().iterator();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Map.Entry<Long, AbstractGraphPanelChartElement> next() {
        Map.Entry<Long, GraphPanelChartSumElement> entry = this.iterator.next();
        GraphPanelChartSumElement ret = entry.getValue();
        ExactEntry retValue = null;
        if (this.isRollingSum) {
            this.rollingSum += ret.getValue();
            retValue = new ExactEntry(entry.getKey(), new GraphPanelChartSumElement(this.rollingSum));
        } else {
            retValue = new ExactEntry(entry.getKey(), new GraphPanelChartSumElement(ret.getValue()));
        }
        return retValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int size() {
        return this.values.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExactEntry
    implements Map.Entry<Long, AbstractGraphPanelChartElement> {
        private long key;
        private final AbstractGraphPanelChartElement value;

        public ExactEntry(long aKey, AbstractGraphPanelChartElement aValue) {
            this.key = aKey;
            this.value = aValue;
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public AbstractGraphPanelChartElement getValue() {
            return this.value;
        }

        @Override
        public AbstractGraphPanelChartElement setValue(AbstractGraphPanelChartElement value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

