/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.dcerpc;

import kg.apc.jmeter.dcerpc.BinaryUtils;
import kg.apc.jmeter.dcerpc.RPCPacket;

public class RPCCallRequest
extends RPCPacket {
    public static final short HEADER_LENGTH = 24;
    private int allocHint;
    protected short contextID;
    protected short opNum;
    private byte[] stubData;

    public RPCCallRequest(int acallID, short aOpnum, byte[] aStubData, byte aPacketFlags) {
        if (aStubData == null) {
            throw new IllegalArgumentException("Stub data cannot be null");
        }
        this.packetType = 0;
        this.packetFlags = aPacketFlags;
        this.callID = acallID;
        this.opNum = aOpnum;
        this.stubData = aStubData;
        this.allocHint = this.stubData.length;
    }

    protected byte[] getBodyBytes() {
        return this.stubData;
    }

    protected byte[] getHeaderBytes() {
        byte[] result = new byte[8];
        int curPos = 0;
        System.arraycopy(BinaryUtils.intToByteArray(this.allocHint), 0, result, curPos, 4);
        System.arraycopy(BinaryUtils.shortToByteArray(this.contextID), 0, result, curPos += 4, 2);
        System.arraycopy(BinaryUtils.shortToByteArray(this.opNum), 0, result, curPos += 2, 2);
        curPos += 2;
        return result;
    }

    public void setAllocHint(int allocHint) {
        this.allocHint = allocHint;
    }
}

