/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.perfmon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import kg.apc.jmeter.perfmon.agent.MetricsGetter;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class AgentConnector {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String host;
    private int port;
    private Socket socket = null;
    private PrintWriter out = null;
    private BufferedReader in = null;
    private String remoteServerName = null;

    public AgentConnector(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void connect(Socket aSocket) throws UnknownHostException, IOException {
        this.socket = aSocket;
        this.out = new PrintWriter(this.socket.getOutputStream(), true);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.remoteServerName = this.getData("name");
    }

    public void disconnect() {
        try {
            this.out.println("bye");
            this.out.close();
            this.in.close();
            this.socket.close();
        }
        catch (IOException e) {
            log.error("Exception disconnecting agent:", (Throwable)e);
        }
    }

    private String getData(String data) {
        this.out.println(data);
        String ret = Long.toString(-2L);
        try {
            ret = this.in.readLine();
        }
        catch (IOException ex) {
            log.error("Error receiving data", (Throwable)ex);
        }
        log.debug("Read " + data + "=" + ret);
        return ret;
    }

    public long getMem() {
        String value = this.getData("mem");
        long ret = value != null ? Long.parseLong(value) : -2L;
        return ret;
    }

    public double getCpu() {
        String value = this.getData("cpu");
        double ret = value != null ? Double.parseDouble(value) : -2.0;
        return ret;
    }

    public long[] getSwap() {
        long[] ret = new long[2];
        String value = this.getData("swp");
        if (value != null) {
            ret[0] = Long.parseLong(value.substring(0, value.indexOf(58)));
            ret[1] = Long.parseLong(value.substring(value.indexOf(58) + 1));
        } else {
            ret = MetricsGetter.AGENT_ERROR_ARRAY;
        }
        return ret;
    }

    public long[] getDisksIO() {
        long[] ret = new long[2];
        String value = this.getData("dio");
        if (value != null) {
            ret[0] = Long.parseLong(value.substring(0, value.indexOf(58)));
            ret[1] = Long.parseLong(value.substring(value.indexOf(58) + 1));
        } else {
            ret = MetricsGetter.AGENT_ERROR_ARRAY;
        }
        return ret;
    }

    public long[] getNetIO() {
        long[] ret = new long[2];
        String value = this.getData("nio");
        if (value != null) {
            ret[0] = Long.parseLong(value.substring(0, value.indexOf(58)));
            ret[1] = Long.parseLong(value.substring(value.indexOf(58) + 1));
        } else {
            ret = MetricsGetter.AGENT_ERROR_ARRAY;
        }
        return ret;
    }

    public String getRemoteServerName() {
        return this.remoteServerName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

