/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.perfmon.agent;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import kg.apc.jmeter.perfmon.agent.ServerAgent;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.Swap;

public class MetricsGetter {
    public static final String BADCMD = "badCmd";
    public static final String BYE = "bye";
    public static final String CPU = "cpu";
    public static final String DISKIO = "dio";
    public static final String MEMORY = "mem";
    public static final String NAME = "name";
    public static final String NETWORK = "nio";
    public static final String SWAP = "swp";
    public static final long SIGAR_ERROR = -1L;
    public static final long AGENT_ERROR = -2L;
    public static final long[] SIGAR_ERROR_ARRAY = new long[]{-1L, -1L};
    public static final long[] AGENT_ERROR_ARRAY = new long[]{-2L, -2L};
    private static MetricsGetter instance = new MetricsGetter();
    private String hostName = null;
    private SigarProxy sigarProxy = null;
    private FileSystem[] fileSystems = null;
    private String[] networkInterfaces = null;

    private MetricsGetter() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
            this.sigarProxy = SigarProxyCache.newInstance((Sigar)new Sigar(), (int)500);
            this.initFileSystems();
            this.initNetworkInterfaces();
        }
        catch (UnknownHostException e) {
            ServerAgent.logMessage(e.getMessage());
        }
    }

    public static MetricsGetter getInstance() {
        return instance;
    }

    public final void initNetworkInterfaces() {
        try {
            this.networkInterfaces = this.sigarProxy.getNetInterfaceList();
        }
        catch (SigarException ex) {
            this.networkInterfaces = new String[0];
            ServerAgent.logMessage("Error while getting network interfaces: " + ex.getMessage());
        }
    }

    public final void initFileSystems() {
        try {
            int i;
            ArrayList<FileSystem> tmp = new ArrayList<FileSystem>();
            FileSystem[] fs = this.sigarProxy.getFileSystemList();
            for (i = 0; i < fs.length; ++i) {
                FileSystem fileSystem = fs[i];
                if (fileSystem.getType() != 2) continue;
                tmp.add(fileSystem);
            }
            this.fileSystems = new FileSystem[tmp.size()];
            for (i = 0; i < tmp.size(); ++i) {
                this.fileSystems[i] = (FileSystem)tmp.get(i);
            }
        }
        catch (SigarException ex) {
            this.fileSystems = new FileSystem[0];
            ServerAgent.logMessage("Error while getting disks: " + ex.getMessage());
        }
    }

    private double getCpuUsage() {
        try {
            return this.sigarProxy.getCpuPerc().getCombined();
        }
        catch (SigarException e) {
            ServerAgent.logMessage(e.getMessage());
            return -2.0;
        }
    }

    private long getUsedMem() {
        try {
            return this.sigarProxy.getMem().getUsed();
        }
        catch (SigarException e) {
            ServerAgent.logMessage(e.getMessage());
            return -2L;
        }
    }

    private long[] getSwap() {
        long[] ret = new long[2];
        try {
            Swap metrics = this.sigarProxy.getSwap();
            ret[0] = metrics.getPageIn();
            ret[1] = metrics.getPageOut();
        }
        catch (SigarException e) {
            ServerAgent.logMessage(e.getMessage());
            ret = AGENT_ERROR_ARRAY;
        }
        return ret;
    }

    private long[] getNetIO() {
        if (this.networkInterfaces.length == 0) {
            return SIGAR_ERROR_ARRAY;
        }
        long[] ret = new long[]{0L, 0L};
        try {
            for (int i = 0; i < this.networkInterfaces.length; ++i) {
                NetInterfaceStat metrics = this.sigarProxy.getNetInterfaceStat(this.networkInterfaces[i]);
                long rxBytes = metrics.getRxBytes();
                long txBytes = metrics.getTxBytes();
                if (rxBytes == -1L || txBytes == -1L) continue;
                ret[0] = ret[0] + rxBytes;
                ret[1] = ret[1] + txBytes;
            }
        }
        catch (SigarException ex) {
            ret = AGENT_ERROR_ARRAY;
        }
        return ret;
    }

    private long[] getDisksIO() {
        if (this.fileSystems.length == 0) {
            return SIGAR_ERROR_ARRAY;
        }
        long[] ret = new long[]{0L, 0L};
        try {
            for (int i = 0; i < this.fileSystems.length; ++i) {
                FileSystemUsage metrics = this.sigarProxy.getFileSystemUsage(this.fileSystems[i].getDevName());
                long reads = metrics.getDiskReads();
                long writes = metrics.getDiskWrites();
                if (reads == -1L || writes == -1L) {
                    return SIGAR_ERROR_ARRAY;
                }
                ret[0] = ret[0] + reads;
                ret[1] = ret[1] + writes;
            }
        }
        catch (SigarException ex) {
            ret = AGENT_ERROR_ARRAY;
        }
        return ret;
    }

    private String getServerName() {
        return this.hostName;
    }

    public String getValues(String value) {
        StringBuilder buff = new StringBuilder();
        if (value.equals(CPU)) {
            buff.append(this.getCpuUsage());
        } else if (value.equals(MEMORY)) {
            buff.append(this.getUsedMem());
        } else if (value.equals(SWAP)) {
            long[] values = this.getSwap();
            buff.append(values[0]);
            buff.append(":");
            buff.append(values[1]);
        } else if (value.equals(DISKIO)) {
            long[] values = this.getDisksIO();
            buff.append(values[0]);
            buff.append(":");
            buff.append(values[1]);
        } else if (value.equals(NETWORK)) {
            long[] values = this.getNetIO();
            buff.append(values[0]);
            buff.append(":");
            buff.append(values[1]);
        } else if (value.equals(NAME)) {
            buff.append(this.getServerName());
        } else {
            buff.append(BADCMD);
        }
        return buff.toString();
    }
}

