/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;

public class DummySampler
extends AbstractSampler {
    public static final String IS_SUCCESSFUL = "SUCCESFULL";
    public static final String RESPONSE_CODE = "RESPONSE_CODE";
    public static final String RESPONSE_MESSAGE = "RESPONSE_MESSAGE";
    public static final String RESPONSE_DATA = "RESPONSE_DATA";
    public static final String RESPONSE_TIME = "RESPONSE_TIME";

    public SampleResult sample(Entry e) {
        SampleResult res = new SampleResult();
        res.sampleStart();
        try {
            Thread.sleep(this.getResponseTime());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        res.sampleEnd();
        res.setSampleLabel(this.getName());
        res.setSamplerData(this.getResponseData());
        res.setResponseCode(this.getResponseCode());
        res.setResponseMessage(this.getResponseMessage());
        res.setSuccessful(this.isSuccessfull());
        res.setDataType("text");
        res.setResponseData(this.getResponseData().getBytes());
        return res;
    }

    public void setSuccessful(boolean selected) {
        this.setProperty(IS_SUCCESSFUL, selected);
    }

    public void setResponseCode(String text) {
        this.setProperty(RESPONSE_CODE, text);
    }

    public void setResponseMessage(String text) {
        this.setProperty(RESPONSE_MESSAGE, text);
    }

    public void setResponseData(String text) {
        this.setProperty(RESPONSE_DATA, text);
    }

    public boolean isSuccessfull() {
        return this.getPropertyAsBoolean(IS_SUCCESSFUL);
    }

    public String getResponseCode() {
        return this.getPropertyAsString(RESPONSE_CODE);
    }

    public String getResponseMessage() {
        return this.getPropertyAsString(RESPONSE_MESSAGE);
    }

    public String getResponseData() {
        return this.getPropertyAsString(RESPONSE_DATA);
    }

    public int getResponseTime() {
        int time = 0;
        try {
            time = Integer.valueOf(this.getPropertyAsString(RESPONSE_TIME));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return time;
    }

    public void setResponseTime(String time) {
        this.setProperty(RESPONSE_TIME, time);
    }
}

