/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.Color;
import kg.apc.jmeter.charting.GraphRowAverages;
import kg.apc.jmeter.charting.GraphRowOverallAverages;
import kg.apc.jmeter.vizualizers.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class TimesVsThreadsGui
extends AbstractGraphPanelVisualizer {
    public TimesVsThreadsGui() {
        this.graphPanel.getGraphObject().setDrawCurrentX(true);
        this.graphPanel.getGraphObject().setForcedMinX(0);
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return "Response Times vs Threads";
    }

    public void add(SampleResult res) {
        GraphRowOverallAverages avgRow;
        GraphRowAverages row;
        String label = res.getSampleLabel();
        String averageLabel = "Average " + res.getSampleLabel();
        if (!this.model.containsKey(label) || !this.model.containsKey(averageLabel)) {
            row = this.getNewRow(label);
            avgRow = this.getNewAveragesRow(averageLabel, row.getColor());
        } else {
            row = (GraphRowAverages)this.model.get(label);
            avgRow = (GraphRowOverallAverages)this.model.get(averageLabel);
        }
        row.add(res.getAllThreads(), res.getTime());
        avgRow.add(res.getAllThreads(), res.getTime());
        this.graphPanel.getGraphObject().setCurrentX(res.getAllThreads());
        this.updateGui(null);
    }

    private synchronized GraphRowOverallAverages getNewAveragesRow(String averageLabel, Color color) {
        GraphRowOverallAverages avgRow = null;
        if (!this.model.containsKey(averageLabel)) {
            avgRow = new GraphRowOverallAverages();
            avgRow.setLabel(averageLabel);
            avgRow.setColor(color);
            avgRow.setMarkerSize(4);
            avgRow.setDrawValueLabel(true);
            avgRow.setShowInLegend(false);
            this.model.put(averageLabel, avgRow);
            this.graphPanel.addRow(avgRow);
        } else {
            avgRow = (GraphRowOverallAverages)this.model.get(averageLabel);
        }
        return avgRow;
    }

    private synchronized GraphRowAverages getNewRow(String label) {
        GraphRowAverages row = null;
        if (!this.model.containsKey(label)) {
            row = new GraphRowAverages();
            row.setLabel(label);
            row.setColor(this.colors.getNextColor());
            row.setDrawLine(true);
            row.setMarkerSize(2);
            this.model.put(label, row);
            this.graphPanel.addRow(row);
        } else {
            row = (GraphRowAverages)this.model.get(label);
        }
        return row;
    }

    protected JSettingsPanel getSettingsPanel() {
        return new JSettingsPanel(this, false, true, true, false, false);
    }
}

