/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.jorphan.collections.HashTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListedHashTree
extends HashTree
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 240L;
    private final List<Object> order = new LinkedList<Object>();

    public ListedHashTree() {
    }

    public ListedHashTree(Object key) {
        this();
        this.data.put(key, new ListedHashTree());
        this.order.add(key);
    }

    public ListedHashTree(Collection<?> keys) {
        this();
        for (Object temp : keys) {
            this.data.put(temp, new ListedHashTree());
            this.order.add(temp);
        }
    }

    public ListedHashTree(Object[] keys) {
        this();
        for (int x = 0; x < keys.length; ++x) {
            this.data.put(keys[x], new ListedHashTree());
            this.order.add(keys[x]);
        }
    }

    @Override
    public Object clone() {
        ListedHashTree newTree = new ListedHashTree();
        this.cloneTree(newTree);
        return newTree;
    }

    @Override
    public void set(Object key, Object value) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, value);
    }

    @Override
    public void set(Object key, HashTree t) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, t);
    }

    @Override
    public void set(Object key, Object[] values) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, values);
    }

    @Override
    public void set(Object key, Collection<?> values) {
        if (!this.data.containsKey(key)) {
            this.order.add(key);
        }
        super.set(key, values);
    }

    @Override
    public void replace(Object currentKey, Object newKey) {
        HashTree tree = this.getTree(currentKey);
        this.data.remove(currentKey);
        this.data.put(newKey, tree);
        this.order.set(this.order.indexOf(currentKey), newKey);
    }

    @Override
    public HashTree createNewTree() {
        return new ListedHashTree();
    }

    @Override
    public HashTree createNewTree(Object key) {
        return new ListedHashTree(key);
    }

    @Override
    public HashTree createNewTree(Collection<?> values) {
        return new ListedHashTree(values);
    }

    @Override
    public HashTree add(Object key) {
        if (!this.data.containsKey(key)) {
            HashTree newTree = this.createNewTree();
            this.data.put(key, newTree);
            this.order.add(key);
            return newTree;
        }
        return this.getTree(key);
    }

    @Override
    public Collection<Object> list() {
        return this.order;
    }

    @Override
    public HashTree remove(Object key) {
        this.order.remove(key);
        return (HashTree)this.data.remove(key);
    }

    @Override
    public Object[] getArray() {
        return this.order.toArray();
    }

    @Override
    public int hashCode() {
        int hc = 17;
        hc = hc * 37 + (this.order == null ? 0 : ((Object)this.order).hashCode());
        hc = hc * 37 + super.hashCode();
        return hc;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ListedHashTree)) {
            return false;
        }
        ListedHashTree lht = (ListedHashTree)o;
        return super.equals(lht) && ((Object)this.order).equals(lht.order);
    }

    @Override
    public Set<Object> keySet() {
        return this.data.keySet();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    @Override
    public void clear() {
        super.clear();
        this.order.clear();
    }
}

