/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassFinder {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String DOT_JAR = ".jar";
    private static final String DOT_CLASS = ".class";
    private static final int DOT_CLASS_LEN = ".class".length();

    private ClassFinder() {
    }

    public static List<String> findClassesThatExtend(String[] paths, Class<?>[] superClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(paths, superClasses, false);
    }

    private static String[] addJarsInPath(String[] paths) {
        HashSet<String> fullList = new HashSet<String>();
        for (int i = 0; i < paths.length; ++i) {
            File dir;
            String path = paths[i];
            fullList.add(path);
            if (path.endsWith(DOT_JAR) || !(dir = new File(path)).exists() || !dir.isDirectory()) continue;
            String[] jars = dir.list(new FilenameFilter(){

                public boolean accept(File f, String name) {
                    return name.endsWith(ClassFinder.DOT_JAR);
                }
            });
            for (int x = 0; x < jars.length; ++x) {
                fullList.add(jars[x]);
            }
        }
        return fullList.toArray(new String[fullList.size()]);
    }

    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, null, null);
    }

    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses, String contains, String notContains) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, contains, notContains, false);
    }

    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, innerClasses, null, null, true);
    }

    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, false, null, null, true);
    }

    private static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] classNames, boolean innerClasses, String contains, String notContains, boolean annotations) throws IOException {
        if (log.isDebugEnabled()) {
            for (int i = 0; i < classNames.length; ++i) {
                log.debug("superclass: " + classNames[i].getName());
            }
        }
        strPathsOrJars = ClassFinder.addJarsInPath(strPathsOrJars);
        for (int k = 0; k < strPathsOrJars.length; ++k) {
            strPathsOrJars[k] = ClassFinder.fixPathEntry(strPathsOrJars[k]);
            if (!log.isDebugEnabled()) continue;
            log.debug("strPathsOrJars : " + strPathsOrJars[k]);
        }
        List<String> listPaths = ClassFinder.getClasspathMatches(strPathsOrJars);
        if (log.isDebugEnabled()) {
            for (String path : listPaths) {
                log.debug("listPaths : " + path);
            }
        }
        Class<?>[] annoclassNames = classNames;
        TreeSet listClasses = annotations ? new AnnoFilterTreeSet(annoclassNames, innerClasses) : new FilterTreeSet(classNames, innerClasses, contains, notContains);
        ClassFinder.findClassesInPaths(listPaths, listClasses);
        if (log.isDebugEnabled()) {
            log.debug("listClasses.size()=" + listClasses.size());
            for (String clazz : listClasses) {
                log.debug("listClasses : " + clazz);
            }
        }
        return new ArrayList<String>(listClasses);
    }

    private static List<String> getClasspathMatches(String[] strPathsOrJars) {
        String javaClassPath = System.getProperty("java.class.path");
        StringTokenizer stPaths = new StringTokenizer(javaClassPath, System.getProperty("path.separator"));
        if (log.isDebugEnabled()) {
            log.debug("Classpath = " + javaClassPath);
            for (int i = 0; i < strPathsOrJars.length; ++i) {
                log.debug("strPathsOrJars[" + i + "] : " + strPathsOrJars[i]);
            }
        }
        ArrayList<String> listPaths = new ArrayList<String>();
        String strPath = null;
        while (stPaths.hasMoreTokens()) {
            strPath = ClassFinder.fixPathEntry(stPaths.nextToken());
            if (strPathsOrJars == null) {
                log.debug("Adding: " + strPath);
                listPaths.add(strPath);
                continue;
            }
            boolean found = false;
            for (int i = 0; i < strPathsOrJars.length; ++i) {
                if (!strPath.endsWith(strPathsOrJars[i])) continue;
                found = true;
                log.debug("Adding " + strPath + " found at " + i);
                listPaths.add(strPath);
                break;
            }
            if (found) continue;
            log.debug("Did not find: " + strPath);
        }
        return listPaths;
    }

    private static String fixPathEntry(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(".")) {
            return System.getProperty("user.dir");
        }
        path = path.trim().replace('\\', '/');
        path = JOrphanUtils.substitute(path, "//", "/");
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static boolean isChildOf(Class<?>[] parentClasses, String strClassName, ClassLoader contextClassLoader) {
        try {
            Class<?> c = Class.forName(strClassName, false, contextClassLoader);
            if (!c.isInterface() && !Modifier.isAbstract(c.getModifiers())) {
                for (int i = 0; i < parentClasses.length; ++i) {
                    if (!parentClasses[i].isAssignableFrom(c)) continue;
                    return true;
                }
            }
        }
        catch (UnsupportedClassVersionError ignored) {
            log.debug(ignored.getLocalizedMessage());
        }
        catch (NoClassDefFoundError ignored) {
            log.debug(ignored.getLocalizedMessage());
        }
        catch (ClassNotFoundException ignored) {
            log.debug(ignored.getLocalizedMessage());
        }
        return false;
    }

    private static boolean hasAnnotationOnMethod(Class<? extends Annotation>[] annotations, String classInQuestion, ClassLoader contextClassLoader) {
        try {
            Class<?> c = Class.forName(classInQuestion, false, contextClassLoader);
            for (Method method : c.getMethods()) {
                for (Class<? extends Annotation> annotation : annotations) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    return true;
                }
            }
        }
        catch (NoClassDefFoundError ignored) {
            log.debug(ignored.getLocalizedMessage());
        }
        catch (ClassNotFoundException ignored) {
            log.debug(ignored.getLocalizedMessage());
        }
        return false;
    }

    private static String fixClassName(String strClassName) {
        strClassName = strClassName.replace('\\', '.');
        strClassName = strClassName.replace('/', '.');
        strClassName = strClassName.substring(0, strClassName.length() - DOT_CLASS_LEN);
        return strClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findClassesInOnePath(String strPath, Set<String> listClasses) throws IOException {
        File file = new File(strPath);
        if (file.isDirectory()) {
            ClassFinder.findClassesInPathsDir(strPath, file, listClasses);
        } else if (file.exists()) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String strEntry = entries.nextElement().toString();
                    if (!strEntry.endsWith(DOT_CLASS)) continue;
                    listClasses.add(ClassFinder.fixClassName(strEntry));
                }
            }
            catch (IOException e) {
                log.warn("Can not open the jar " + strPath + " " + e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private static void findClassesInPaths(List<String> listPaths, Set<String> listClasses) throws IOException {
        for (String path : listPaths) {
            ClassFinder.findClassesInOnePath(path, listClasses);
        }
    }

    private static void findClassesInPathsDir(String strPathElement, File dir, Set<String> listClasses) throws IOException {
        String[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            File file = new File(dir, list[i]);
            if (file.isDirectory()) {
                ClassFinder.findClassesInPathsDir(strPathElement, file, listClasses);
                continue;
            }
            if (!list[i].endsWith(DOT_CLASS) || !file.exists() || file.length() == 0L) continue;
            String path = file.getPath();
            listClasses.add(path.substring(strPathElement.length() + 1, path.lastIndexOf(".")).replace(File.separator.charAt(0), '.'));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnoFilterTreeSet
    extends TreeSet<String> {
        private static final long serialVersionUID = 240L;
        private final boolean inner;
        private final Class<? extends Annotation>[] annotations;
        private final transient ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        AnnoFilterTreeSet(Class<? extends Annotation>[] annotations, boolean inner) {
            this.annotations = annotations;
            this.inner = inner;
        }

        @Override
        public boolean add(String s) {
            if (this.contains(s)) {
                return false;
            }
            if ((s.indexOf("$") == -1 || this.inner) && ClassFinder.hasAnnotationOnMethod(this.annotations, s, this.contextClassLoader)) {
                return super.add(s);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterTreeSet
    extends TreeSet<String> {
        private static final long serialVersionUID = 234L;
        private final Class<?>[] parents;
        private final boolean inner;
        private final String contains;
        private final String notContains;
        private final transient ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        FilterTreeSet(Class<?>[] parents, boolean inner, String contains, String notContains) {
            this.parents = parents;
            this.inner = inner;
            this.contains = contains;
            this.notContains = notContains;
        }

        @Override
        public boolean add(String s) {
            if (this.contains(s)) {
                return false;
            }
            if (this.contains != null && s.indexOf(this.contains) == -1) {
                return false;
            }
            if (this.notContains != null && s.indexOf(this.notContains) != -1) {
                return false;
            }
            if ((s.indexOf("$") == -1 || this.inner) && ClassFinder.isChildOf(this.parents, s, this.contextClassLoader)) {
                return super.add(s);
            }
            return false;
        }
    }
}

