/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.security.Permission;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.JMeter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMeterMojo
extends AbstractMojo {
    private static final Pattern PAT_ERROR = Pattern.compile(".*\\s+ERROR\\s+.*");
    private List<String> includes;
    private List<String> excludes;
    private File srcDir;
    private File reportDir;
    private File jmeterProps;
    private File repoDir;
    private Map jmeterUserProperties;
    private boolean remote;
    private MavenProject mavenProject;
    private File workDir;
    private File saveServiceProps;
    private File upgradeProps;
    private File jmeterLog;
    private DateFormat fmt = new SimpleDateFormat("yyMMdd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initSystemProps();
        try {
            String[] stringArray;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.srcDir);
            if (this.includes == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "**/*.jmx";
            } else {
                stringArray = this.includes.toArray(new String[0]);
            }
            scanner.setIncludes(stringArray);
            if (this.excludes != null) {
                scanner.setExcludes(this.excludes.toArray(new String[0]));
            }
            scanner.scan();
            for (String file : scanner.getIncludedFiles()) {
                this.executeTest(new File(this.srcDir, file));
            }
            this.checkForErrors();
        }
        finally {
            this.saveServiceProps.delete();
            this.upgradeProps.delete();
        }
    }

    private void checkForErrors() throws MojoExecutionException, MojoFailureException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.jmeterLog));
            while ((line = in.readLine()) != null) {
                if (!PAT_ERROR.matcher(line).find()) continue;
                throw new MojoFailureException("There were test errors");
            }
            in.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't read log file", (Exception)e);
        }
    }

    private void initSystemProps() throws MojoExecutionException {
        this.workDir = new File("target" + File.separator + "jmeter");
        this.workDir.mkdirs();
        this.createSaveServiceProps();
        this.jmeterLog = new File(this.workDir, "jmeter.log");
        try {
            System.setProperty("log_file", this.jmeterLog.getCanonicalPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't get canonical path for log file", (Exception)e);
        }
    }

    private void createSaveServiceProps() throws MojoExecutionException {
        this.saveServiceProps = new File(this.workDir, "saveservice.properties");
        this.upgradeProps = new File(this.workDir, "upgrade.properties");
        try {
            FileWriter out = new FileWriter(this.saveServiceProps);
            IOUtils.copy((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("saveservice.properties"), (Writer)out);
            out.flush();
            out.close();
            System.setProperty("saveservice_properties", File.separator + "target" + File.separator + "jmeter" + File.separator + "saveservice.properties");
            out = new FileWriter(this.upgradeProps);
            IOUtils.copy((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream("upgrade.properties"), (Writer)out);
            out.flush();
            out.close();
            System.setProperty("upgrade_properties", File.separator + "target" + File.separator + "jmeter" + File.separator + "upgrade.properties");
            System.setProperty("search_paths", this.repoDir.toString() + "/org/apache/jmeter/jmeter/2.3/jmeter-2.3.jar");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create temporary saveservice.properties", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTest(File test) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Executing test: " + test.getCanonicalPath()));
            String reportFileName = test.getName().substring(0, test.getName().lastIndexOf(".")) + "-" + this.fmt.format(new Date()) + ".xml";
            List<String> argsTmp = Arrays.asList("-n", "-t", test.getCanonicalPath(), "-l", this.reportDir.toString() + File.separator + reportFileName, "-p", this.jmeterProps.toString(), "-d", System.getProperty("user.dir"));
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(argsTmp);
            args.addAll(this.getUserProperties());
            if (this.remote) {
                args.add("-r");
            }
            SecurityManager oldManager = System.getSecurityManager();
            System.setSecurityManager(new SecurityManager(){

                public void checkExit(int status) {
                    throw new ExitException(status);
                }

                public void checkPermission(Permission perm, Object context) {
                }

                public void checkPermission(Permission perm) {
                }
            });
            Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    if (e instanceof ExitException && ((ExitException)e).getCode() == 0) {
                        return;
                    }
                    JMeterMojo.this.getLog().error((CharSequence)("Error in thread " + t.getName()));
                }
            });
            try {
                int activeThreadCount;
                int startThreadCount = Thread.activeCount();
                new JMeter().start(args.toArray(new String[0]));
                while ((activeThreadCount = Thread.activeCount()) > startThreadCount) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            catch (ExitException e) {
                if (e.getCode() != 0) {
                    throw new MojoExecutionException("Test failed", (Exception)e);
                }
            }
            finally {
                System.setSecurityManager(oldManager);
                Thread.setDefaultUncaughtExceptionHandler(oldHandler);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't execute test", (Exception)e);
        }
    }

    private ArrayList<String> getUserProperties() {
        ArrayList<String> propsList = new ArrayList<String>();
        if (this.jmeterUserProperties == null) {
            return propsList;
        }
        Set keySet = this.jmeterUserProperties.keySet();
        for (String key : keySet) {
            propsList.add("-J");
            propsList.add(key + "=" + this.jmeterUserProperties.get(key));
        }
        return propsList;
    }

    private static class ExitException
    extends SecurityException {
        private static final long serialVersionUID = 5544099211927987521L;
        public int _rc;

        public ExitException(int rc) {
            super(Integer.toString(rc));
            this._rc = rc;
        }

        public int getCode() {
            return this._rc;
        }
    }
}

