/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonReaderFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.converter.BigDecimalConverter;
import org.apache.johnzon.mapper.converter.BigIntegerConverter;
import org.apache.johnzon.mapper.converter.BooleanConverter;
import org.apache.johnzon.mapper.converter.ByteConverter;
import org.apache.johnzon.mapper.converter.CachedDelegateConverter;
import org.apache.johnzon.mapper.converter.CharacterConverter;
import org.apache.johnzon.mapper.converter.ClassConverter;
import org.apache.johnzon.mapper.converter.DateConverter;
import org.apache.johnzon.mapper.converter.DoubleConverter;
import org.apache.johnzon.mapper.converter.FloatConverter;
import org.apache.johnzon.mapper.converter.IntegerConverter;
import org.apache.johnzon.mapper.converter.LongConverter;
import org.apache.johnzon.mapper.converter.ShortConverter;
import org.apache.johnzon.mapper.converter.StringConverter;

public class MapperBuilder {
    private static final Map<Class<?>, Converter<?>> DEFAULT_CONVERTERS = new HashMap();
    private JsonReaderFactory readerFactory;
    private JsonGeneratorFactory generatorFactory;
    private boolean doCloseOnStreams = false;
    private int version = -1;
    private Comparator<String> attributeOrder = null;
    private final Map<Class<?>, Converter<?>> converters = new HashMap(DEFAULT_CONVERTERS);

    public Mapper build() {
        if (this.readerFactory == null || this.generatorFactory == null) {
            JsonProvider provider = JsonProvider.provider();
            Map config = Collections.emptyMap();
            if (this.readerFactory == null) {
                this.readerFactory = provider.createReaderFactory(config);
            }
            if (this.generatorFactory == null) {
                this.generatorFactory = provider.createGeneratorFactory(config);
            }
        }
        return new Mapper(this.readerFactory, this.generatorFactory, this.doCloseOnStreams, this.converters, this.version, this.attributeOrder);
    }

    public MapperBuilder setAttributeOrder(Comparator<String> attributeOrder) {
        this.attributeOrder = attributeOrder;
        return this;
    }

    public MapperBuilder setReaderFactory(JsonReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
        return this;
    }

    public MapperBuilder setGeneratorFactory(JsonGeneratorFactory generatorFactory) {
        this.generatorFactory = generatorFactory;
        return this;
    }

    public MapperBuilder setDoCloseOnStreams(boolean doCloseOnStreams) {
        this.doCloseOnStreams = doCloseOnStreams;
        return this;
    }

    public MapperBuilder addPropertyEditor(Class<?> clazz, Converter<?> converter) {
        this.converters.put(clazz, converter);
        return this;
    }

    public MapperBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    static {
        DEFAULT_CONVERTERS.put(Date.class, new DateConverter("yyyyMMddHHmmssZ"));
        DEFAULT_CONVERTERS.put(Class.class, new ClassConverter());
        DEFAULT_CONVERTERS.put(String.class, new StringConverter());
        DEFAULT_CONVERTERS.put(BigDecimal.class, new BigDecimalConverter());
        DEFAULT_CONVERTERS.put(BigInteger.class, new BigIntegerConverter());
        DEFAULT_CONVERTERS.put(Byte.class, new CachedDelegateConverter<Byte>(new ByteConverter()));
        DEFAULT_CONVERTERS.put(Character.class, new CharacterConverter());
        DEFAULT_CONVERTERS.put(Double.class, new DoubleConverter());
        DEFAULT_CONVERTERS.put(Float.class, new FloatConverter());
        DEFAULT_CONVERTERS.put(Integer.class, new IntegerConverter());
        DEFAULT_CONVERTERS.put(Long.class, new LongConverter());
        DEFAULT_CONVERTERS.put(Short.class, new ShortConverter());
        DEFAULT_CONVERTERS.put(Boolean.class, new CachedDelegateConverter<Boolean>(new BooleanConverter()));
        DEFAULT_CONVERTERS.put(Byte.TYPE, DEFAULT_CONVERTERS.get(Byte.class));
        DEFAULT_CONVERTERS.put(Character.TYPE, new CharacterConverter());
        DEFAULT_CONVERTERS.put(Double.TYPE, DEFAULT_CONVERTERS.get(Double.class));
        DEFAULT_CONVERTERS.put(Float.TYPE, DEFAULT_CONVERTERS.get(Float.class));
        DEFAULT_CONVERTERS.put(Integer.TYPE, DEFAULT_CONVERTERS.get(Integer.class));
        DEFAULT_CONVERTERS.put(Long.TYPE, DEFAULT_CONVERTERS.get(Long.class));
        DEFAULT_CONVERTERS.put(Short.TYPE, DEFAULT_CONVERTERS.get(Short.class));
        DEFAULT_CONVERTERS.put(Boolean.TYPE, DEFAULT_CONVERTERS.get(Boolean.class));
    }
}

