/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.reflection;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.JohnzonConverter;
import org.apache.johnzon.mapper.JohnzonIgnore;
import org.apache.johnzon.mapper.MapperException;

public class Mappings {
    protected final ConcurrentMap<Type, ClassMapping> classes = new ConcurrentHashMap<Type, ClassMapping>();
    protected final ConcurrentMap<Type, CollectionMapping> collections = new ConcurrentHashMap<Type, CollectionMapping>();
    protected final Comparator<String> fieldOrdering;

    public Mappings(Comparator<String> attributeOrder) {
        this.fieldOrdering = attributeOrder;
    }

    public <T> CollectionMapping findCollectionMapping(ParameterizedType genericType, Class<T> raw) {
        CollectionMapping collectionMapping = (CollectionMapping)this.collections.get(genericType);
        if (collectionMapping == null) {
            collectionMapping = this.createCollectionMapping(genericType, raw);
            if (collectionMapping == null) {
                return null;
            }
            CollectionMapping existing = this.collections.putIfAbsent(genericType, collectionMapping);
            if (existing != null) {
                collectionMapping = existing;
            }
        }
        return collectionMapping;
    }

    private <T> CollectionMapping createCollectionMapping(ParameterizedType aType, Class<T> raw) {
        Type[] fieldArgTypes = aType.getActualTypeArguments();
        if (fieldArgTypes.length == 1) {
            Class collectionType;
            if (List.class.isAssignableFrom(raw)) {
                collectionType = List.class;
            } else if (SortedSet.class.isAssignableFrom(raw)) {
                collectionType = SortedSet.class;
            } else if (Set.class.isAssignableFrom(raw)) {
                collectionType = Set.class;
            } else if (Queue.class.isAssignableFrom(raw)) {
                collectionType = Queue.class;
            } else if (Collection.class.isAssignableFrom(raw)) {
                collectionType = Collection.class;
            } else {
                return null;
            }
            CollectionMapping mapping = new CollectionMapping(Mappings.isPrimitive(fieldArgTypes[0]), collectionType, fieldArgTypes[0]);
            this.collections.putIfAbsent(aType, mapping);
            return mapping;
        }
        return null;
    }

    public static boolean isPrimitive(Type type) {
        if (type == String.class) {
            return true;
        }
        if (type == Character.TYPE || type == Character.class) {
            return true;
        }
        if (type == Long.TYPE || type == Long.class) {
            return true;
        }
        if (type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class) {
            return true;
        }
        if (type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class) {
            return true;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return true;
        }
        if (type == BigDecimal.class) {
            return true;
        }
        return type == BigInteger.class;
    }

    public ClassMapping getClassMapping(Type clazz) {
        return (ClassMapping)this.classes.get(clazz);
    }

    public ClassMapping findOrCreateClassMapping(Type clazz) {
        ClassMapping classMapping = (ClassMapping)this.classes.get(clazz);
        if (classMapping == null) {
            if (!Class.class.isInstance(clazz) || Map.class.isAssignableFrom((Class)Class.class.cast(clazz))) {
                return null;
            }
            classMapping = this.createClassMapping((Class)Class.class.cast(clazz));
            ClassMapping existing = this.classes.putIfAbsent(clazz, classMapping);
            if (existing != null) {
                classMapping = existing;
            }
        }
        return classMapping;
    }

    private ClassMapping createClassMapping(Class<?> clazz) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            TreeMap<String, Getter> getters = this.fieldOrdering != null ? new TreeMap(this.fieldOrdering) : new HashMap();
            TreeMap<String, Setter> setters = this.fieldOrdering != null ? new TreeMap(this.fieldOrdering) : new HashMap();
            for (PropertyDescriptor descriptor : propertyDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                Method readMethod;
                JohnzonIgnore readIgnore;
                JohnzonIgnore writeIgnore;
                Method writeMethod = descriptor.getWriteMethod();
                JohnzonIgnore johnzonIgnore = writeIgnore = writeMethod != null ? writeMethod.getAnnotation(JohnzonIgnore.class) : null;
                if (writeMethod != null && writeMethod.getDeclaringClass() != Object.class && (writeIgnore == null || writeIgnore.minVersion() >= 0)) {
                    if (descriptor.getName().equals("metaClass")) continue;
                    Type param = writeMethod.getGenericParameterTypes()[0];
                    setters.put(descriptor.getName(), new Setter(writeMethod, Mappings.isPrimitive(param), param, Mappings.findConverter(writeMethod), writeIgnore != null ? writeIgnore.minVersion() : -1));
                }
                JohnzonIgnore johnzonIgnore2 = readIgnore = (readMethod = descriptor.getReadMethod()) != null ? readMethod.getAnnotation(JohnzonIgnore.class) : null;
                if (readMethod == null || readMethod.getDeclaringClass() == Object.class || readIgnore != null && readIgnore.minVersion() < 0 || descriptor.getName().equals("metaClass")) continue;
                Class<?> returnType = readMethod.getReturnType();
                getters.put(descriptor.getName(), new Getter(readMethod, Mappings.isPrimitive(returnType), returnType.isArray(), Collection.class.isAssignableFrom(returnType), Map.class.isAssignableFrom(returnType), Mappings.findConverter(readMethod), readIgnore != null ? readIgnore.minVersion() : -1));
            }
            return new ClassMapping(clazz, getters, setters);
        }
        catch (IntrospectionException e) {
            throw new MapperException(e);
        }
    }

    private static Converter findConverter(Method method) {
        Converter<?> converter = null;
        if (method.getAnnotation(JohnzonConverter.class) != null) {
            try {
                converter = method.getAnnotation(JohnzonConverter.class).value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return converter;
    }

    public static class Setter {
        public final Method setter;
        public final int version;
        public final Type paramType;
        public final Converter<?> converter;
        public final boolean primitive;

        public Setter(Method setter, boolean primitive, Type paramType, Converter<?> converter, int version) {
            this.setter = setter;
            this.paramType = paramType;
            this.converter = converter;
            this.version = version;
            this.primitive = primitive;
        }
    }

    public static class Getter {
        public final Method setter;
        public final int version;
        public final Converter<Object> converter;
        public final boolean primitive;
        public final boolean array;
        public final boolean map;
        public final boolean collection;

        public Getter(Method setter, boolean primitive, boolean array, boolean collection, boolean map, Converter<Object> converter, int version) {
            this.setter = setter;
            this.converter = converter;
            this.version = version;
            this.array = array;
            this.map = map && converter == null;
            this.collection = collection;
            this.primitive = primitive;
        }
    }

    public static class CollectionMapping {
        public final Class<?> raw;
        public final Type arg;
        public final boolean primitive;

        public CollectionMapping(boolean primitive, Class<?> collectionType, Type fieldArgType) {
            this.raw = collectionType;
            this.arg = fieldArgType;
            this.primitive = primitive;
        }
    }

    public static class ClassMapping {
        public final Class<?> clazz;
        public final Map<String, Getter> getters;
        public final Map<String, Setter> setters;

        protected ClassMapping(Class<?> clazz, Map<String, Getter> getters, Map<String, Setter> setters) {
            this.clazz = clazz;
            this.getters = getters;
            this.setters = setters;
        }
    }
}

