/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.connect.runtime.SessionKey;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.WorkerConfigTransformer;
import org.apache.kafka.connect.util.ConnectorTaskId;

public class ClusterConfigState {
    public static final long NO_OFFSET = -1L;
    public static final ClusterConfigState EMPTY = new ClusterConfigState(-1L, null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet());
    private final long offset;
    private final SessionKey sessionKey;
    private final Map<String, Integer> connectorTaskCounts;
    private final Map<String, Map<String, String>> connectorConfigs;
    private final Map<String, TargetState> connectorTargetStates;
    private final Map<ConnectorTaskId, Map<String, String>> taskConfigs;
    private final Set<String> inconsistentConnectors;
    private final WorkerConfigTransformer configTransformer;

    public ClusterConfigState(long offset, SessionKey sessionKey, Map<String, Integer> connectorTaskCounts, Map<String, Map<String, String>> connectorConfigs, Map<String, TargetState> connectorTargetStates, Map<ConnectorTaskId, Map<String, String>> taskConfigs, Set<String> inconsistentConnectors) {
        this(offset, sessionKey, connectorTaskCounts, connectorConfigs, connectorTargetStates, taskConfigs, inconsistentConnectors, null);
    }

    public ClusterConfigState(long offset, SessionKey sessionKey, Map<String, Integer> connectorTaskCounts, Map<String, Map<String, String>> connectorConfigs, Map<String, TargetState> connectorTargetStates, Map<ConnectorTaskId, Map<String, String>> taskConfigs, Set<String> inconsistentConnectors, WorkerConfigTransformer configTransformer) {
        this.offset = offset;
        this.sessionKey = sessionKey;
        this.connectorTaskCounts = connectorTaskCounts;
        this.connectorConfigs = connectorConfigs;
        this.connectorTargetStates = connectorTargetStates;
        this.taskConfigs = taskConfigs;
        this.inconsistentConnectors = inconsistentConnectors;
        this.configTransformer = configTransformer;
    }

    public long offset() {
        return this.offset;
    }

    public SessionKey sessionKey() {
        return this.sessionKey;
    }

    public boolean contains(String connector) {
        return this.connectorConfigs.containsKey(connector);
    }

    public Set<String> connectors() {
        return this.connectorConfigs.keySet();
    }

    public Map<String, String> connectorConfig(String connector) {
        Map<String, String> configs = this.connectorConfigs.get(connector);
        if (this.configTransformer != null) {
            configs = this.configTransformer.transform(connector, configs);
        }
        return configs;
    }

    public Map<String, String> rawConnectorConfig(String connector) {
        return this.connectorConfigs.get(connector);
    }

    public TargetState targetState(String connector) {
        return this.connectorTargetStates.get(connector);
    }

    public Map<String, String> taskConfig(ConnectorTaskId task) {
        Map<String, String> configs = this.taskConfigs.get(task);
        if (this.configTransformer != null) {
            configs = this.configTransformer.transform(task.connector(), configs);
        }
        return configs;
    }

    public Map<String, String> rawTaskConfig(ConnectorTaskId task) {
        return this.taskConfigs.get(task);
    }

    public List<Map<String, String>> allTaskConfigs(String connector) {
        TreeMap<Integer, Map<String, String>> taskConfigs = new TreeMap<Integer, Map<String, String>>();
        for (Map.Entry<ConnectorTaskId, Map<String, String>> taskConfigEntry : this.taskConfigs.entrySet()) {
            if (!taskConfigEntry.getKey().connector().equals(connector)) continue;
            Map<String, String> configs = taskConfigEntry.getValue();
            if (this.configTransformer != null) {
                configs = this.configTransformer.transform(connector, configs);
            }
            taskConfigs.put(taskConfigEntry.getKey().task(), configs);
        }
        return new LinkedList<Map<String, String>>(taskConfigs.values());
    }

    public int taskCount(String connectorName) {
        Integer count = this.connectorTaskCounts.get(connectorName);
        return count == null ? 0 : count;
    }

    public List<ConnectorTaskId> tasks(String connectorName) {
        if (this.inconsistentConnectors.contains(connectorName)) {
            return Collections.emptyList();
        }
        Integer numTasks = this.connectorTaskCounts.get(connectorName);
        if (numTasks == null) {
            return Collections.emptyList();
        }
        ArrayList<ConnectorTaskId> taskIds = new ArrayList<ConnectorTaskId>();
        for (int taskIndex = 0; taskIndex < numTasks; ++taskIndex) {
            ConnectorTaskId taskId = new ConnectorTaskId(connectorName, taskIndex);
            taskIds.add(taskId);
        }
        return taskIds;
    }

    public Set<String> inconsistentConnectors() {
        return this.inconsistentConnectors;
    }

    public String toString() {
        return "ClusterConfigState{offset=" + this.offset + ", sessionKey=" + (this.sessionKey != null ? "[hidden]" : "null") + ", connectorTaskCounts=" + this.connectorTaskCounts + ", connectorConfigs=" + this.connectorConfigs + ", taskConfigs=" + this.taskConfigs + ", inconsistentConnectors=" + this.inconsistentConnectors + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterConfigState that = (ClusterConfigState)o;
        return this.offset == that.offset && Objects.equals(this.sessionKey, that.sessionKey) && Objects.equals(this.connectorTaskCounts, that.connectorTaskCounts) && Objects.equals(this.connectorConfigs, that.connectorConfigs) && Objects.equals(this.connectorTargetStates, that.connectorTargetStates) && Objects.equals(this.taskConfigs, that.taskConfigs) && Objects.equals(this.inconsistentConnectors, that.inconsistentConnectors) && Objects.equals(this.configTransformer, that.configTransformer);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.sessionKey, this.connectorTaskCounts, this.connectorConfigs, this.connectorTargetStates, this.taskConfigs, this.inconsistentConnectors, this.configTransformer);
    }
}

