/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.distributed.Crypto;
import org.apache.kafka.connect.runtime.rest.HerderRequestHandler;
import org.apache.kafka.connect.runtime.rest.InternalRequestSignature;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.resources.ConnectResource;
import org.apache.kafka.connect.util.FutureCallback;

@Produces(value={"application/json"})
public abstract class InternalClusterResource
implements ConnectResource {
    private static final TypeReference<List<Map<String, String>>> TASK_CONFIGS_TYPE = new TypeReference<List<Map<String, String>>>(){};
    private final HerderRequestHandler requestHandler;
    @Context
    UriInfo uriInfo;

    protected InternalClusterResource(RestClient restClient) {
        this.requestHandler = new HerderRequestHandler(restClient, DEFAULT_REST_REQUEST_TIMEOUT_MS);
    }

    @Override
    public void requestTimeout(long requestTimeoutMs) {
        this.requestHandler.requestTimeoutMs(requestTimeoutMs);
    }

    protected abstract Herder herderForRequest();

    @POST
    @Path(value="/{connector}/tasks")
    @Operation(hidden=true, summary="This operation is only for inter-worker communications")
    public void putTaskConfigs(@PathParam(value="connector") String connector, @Context HttpHeaders headers, @QueryParam(value="forward") Boolean forward, byte[] requestBody) throws Throwable {
        List taskConfigs = (List)new ObjectMapper().readValue(requestBody, TASK_CONFIGS_TYPE);
        FutureCallback<Void> cb = new FutureCallback<Void>();
        this.herderForRequest().putTaskConfigs(connector, taskConfigs, cb, InternalRequestSignature.fromHeaders(Crypto.SYSTEM, requestBody, headers));
        this.requestHandler.completeOrForwardRequest(cb, this.uriInfo.getPath(), "POST", headers, taskConfigs, forward);
    }

    @PUT
    @Path(value="/{connector}/fence")
    @Operation(hidden=true, summary="This operation is only for inter-worker communications")
    public void fenceZombies(@PathParam(value="connector") String connector, @Context HttpHeaders headers, @QueryParam(value="forward") Boolean forward, byte[] requestBody) throws Throwable {
        FutureCallback<Void> cb = new FutureCallback<Void>();
        this.herderForRequest().fenceZombieSourceTasks(connector, cb, InternalRequestSignature.fromHeaders(Crypto.SYSTEM, requestBody, headers));
        this.requestHandler.completeOrForwardRequest(cb, this.uriInfo.getPath(), "PUT", headers, requestBody, forward);
    }
}

