/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Frequencies;
import org.apache.kafka.common.metrics.stats.Frequency;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FrequenciesTest {
    private static final double DELTA = 1.0E-4;
    private MetricConfig config;
    private Time time;
    private Metrics metrics;

    @Before
    public void setup() {
        this.config = new MetricConfig().eventWindow(50L).samples(2);
        this.time = new MockTime();
        this.metrics = new Metrics(this.config, Arrays.asList(new JmxReporter()), this.time, true);
    }

    @After
    public void tearDown() {
        this.metrics.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFrequencyCenterValueAboveMax() {
        new Frequencies(4, 1.0, 4.0, new Frequency[]{this.freq("1", 1.0), this.freq("2", 20.0)});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFrequencyCenterValueBelowMin() {
        new Frequencies(4, 1.0, 4.0, new Frequency[]{this.freq("1", 1.0), this.freq("2", -20.0)});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMoreFrequencyParametersThanBuckets() {
        new Frequencies(1, 1.0, 4.0, new Frequency[]{this.freq("1", 1.0), this.freq("2", -20.0)});
    }

    @Test
    public void testBooleanFrequencies() {
        int i;
        MetricName metricTrue = this.name("true");
        MetricName metricFalse = this.name("false");
        Frequencies frequencies = Frequencies.forBooleanValues((MetricName)metricFalse, (MetricName)metricTrue);
        CompoundStat.NamedMeasurable falseMetric = (CompoundStat.NamedMeasurable)frequencies.stats().get(0);
        CompoundStat.NamedMeasurable trueMetric = (CompoundStat.NamedMeasurable)frequencies.stats().get(1);
        for (i = 0; i != 25; ++i) {
            frequencies.record(this.config, 0.0, this.time.milliseconds());
        }
        for (i = 0; i != 75; ++i) {
            frequencies.record(this.config, 1.0, this.time.milliseconds());
        }
        Assert.assertEquals((double)0.25, (double)falseMetric.stat().measure(this.config, this.time.milliseconds()), (double)1.0E-4);
        Assert.assertEquals((double)0.75, (double)trueMetric.stat().measure(this.config, this.time.milliseconds()), (double)1.0E-4);
        for (i = 0; i != 40; ++i) {
            frequencies.record(this.config, 0.0, this.time.milliseconds());
        }
        for (i = 0; i != 60; ++i) {
            frequencies.record(this.config, 1.0, this.time.milliseconds());
        }
        Assert.assertEquals((double)0.4, (double)falseMetric.stat().measure(this.config, this.time.milliseconds()), (double)1.0E-4);
        Assert.assertEquals((double)0.6, (double)trueMetric.stat().measure(this.config, this.time.milliseconds()), (double)1.0E-4);
    }

    @Test
    public void testUseWithMetrics() {
        int i;
        MetricName name1 = this.name("1");
        MetricName name2 = this.name("2");
        MetricName name3 = this.name("3");
        MetricName name4 = this.name("4");
        Frequencies frequencies = new Frequencies(4, 1.0, 4.0, new Frequency[]{new Frequency(name1, 1.0), new Frequency(name2, 2.0), new Frequency(name3, 3.0), new Frequency(name4, 4.0)});
        Sensor sensor = this.metrics.sensor("test", this.config, new Sensor[0]);
        sensor.add((CompoundStat)frequencies);
        Metric metric1 = (Metric)this.metrics.metrics().get(name1);
        Metric metric2 = (Metric)this.metrics.metrics().get(name2);
        Metric metric3 = (Metric)this.metrics.metrics().get(name3);
        Metric metric4 = (Metric)this.metrics.metrics().get(name4);
        for (i = 0; i != 100; ++i) {
            frequencies.record(this.config, (double)(i % 4 + 1), this.time.milliseconds());
        }
        Assert.assertEquals((double)0.25, (double)metric1.value(), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)metric2.value(), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)metric3.value(), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)metric4.value(), (double)1.0E-4);
        for (i = 0; i != 100; ++i) {
            frequencies.record(this.config, (double)(i % 2 + 1), this.time.milliseconds());
        }
        Assert.assertEquals((double)0.5, (double)metric1.value(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)metric2.value(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)metric3.value(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)metric4.value(), (double)1.0E-4);
        for (i = 0; i != 50; ++i) {
            frequencies.record(this.config, 4.0, this.time.milliseconds());
        }
        Assert.assertEquals((double)0.25, (double)metric1.value(), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)metric2.value(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)metric3.value(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)metric4.value(), (double)1.0E-4);
    }

    protected MetricName name(String metricName) {
        return new MetricName(metricName, "group-id", "desc", Collections.emptyMap());
    }

    protected Frequency freq(String name, double value) {
        return new Frequency(this.name(name), value);
    }
}

