/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.kafka.common.protocol.MessageUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public final class MessageUtilTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testSimpleUtf8Lengths() {
        this.validateUtf8Length("");
        this.validateUtf8Length("abc");
        this.validateUtf8Length("This is a test string.");
    }

    @Test
    public void testMultibyteUtf8Lengths() {
        this.validateUtf8Length("A\u00ea\u00f1\u00fcC");
        this.validateUtf8Length("\ud801\udc00");
        this.validateUtf8Length("M\u00fcO");
    }

    private void validateUtf8Length(String string) {
        byte[] arr = string.getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((long)arr.length, (long)MessageUtil.serializedUtf8Length((CharSequence)string));
    }

    @Test
    public void testDeepToString() {
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)MessageUtil.deepToString(Arrays.asList(1, 2, 3).iterator()));
        Assert.assertEquals((Object)"[foo]", (Object)MessageUtil.deepToString(Arrays.asList("foo").iterator()));
    }
}

