/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.File;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.Security;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.ssl.SslEngineBuilder;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.ssl.mock.TestProvider;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.junit.Assert;
import org.junit.Test;

public class SslFactoryTest {
    @Test
    public void testSslFactoryConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertNotNull((Object)engine);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"TLSv1.2"}), (Object)Utils.mkSet((Object[])engine.getEnabledProtocols()));
        Assert.assertEquals((Object)false, (Object)engine.getUseClientMode());
    }

    @Test
    public void testSslFactoryWithCustomKeyManagerConfiguration() throws Exception {
        TestProvider provider = new TestProvider();
        Security.addProvider(provider);
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig("TestAlgorithm", "TestAlgorithm");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assert.assertNotNull((String)"SslEngineBuilder not created", (Object)sslFactory.sslEngineBuilder());
        Security.removeProvider(provider.getName());
    }

    @Test
    public void testSslFactoryWithoutPasswordConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        serverSslConfig.remove("ssl.truststore.password");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        try {
            sslFactory.configure(serverSslConfig);
        }
        catch (Exception e) {
            Assert.fail((String)("An exception was thrown when configuring the truststore without a password: " + e));
        }
    }

    @Test
    public void testClientMode() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> clientSslConfig = TestSslUtils.createSslConfig(false, true, Mode.CLIENT, trustStoreFile, "client");
        SslFactory sslFactory = new SslFactory(Mode.CLIENT);
        sslFactory.configure(clientSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assert.assertTrue((boolean)engine.getUseClientMode());
    }

    @Test
    public void testReconfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SslEngineBuilder sslEngineBuilder = sslFactory.sslEngineBuilder();
        Assert.assertNotNull((String)"SslEngineBuilder not created", (Object)sslEngineBuilder);
        sslFactory.reconfigure(sslConfig);
        Assert.assertSame((String)"SslEngineBuilder recreated unnecessarily", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        trustStoreFile = File.createTempFile("truststore", ".jks");
        sslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineBuilder not recreated", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        sslEngineBuilder = sslFactory.sslEngineBuilder();
        trustStoreFile.setLastModified(System.currentTimeMillis() + 10000L);
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineBuilder not recreated", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        sslEngineBuilder = sslFactory.sslEngineBuilder();
        File keyStoreFile = new File((String)sslConfig.get("ssl.keystore.location"));
        keyStoreFile.setLastModified(System.currentTimeMillis() + 10000L);
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineBuilder not recreated", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        sslEngineBuilder = sslFactory.sslEngineBuilder();
        keyStoreFile.setLastModified(System.currentTimeMillis() + 15000L);
        sslFactory.validateReconfiguration(sslConfig);
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SslEngineBuilder not recreated", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
        sslEngineBuilder = sslFactory.sslEngineBuilder();
        keyStoreFile.setLastModified(System.currentTimeMillis() + 20000L);
        Files.delete(keyStoreFile.toPath());
        sslFactory.reconfigure(sslConfig);
        Assert.assertSame((String)"SslEngineBuilder recreated unnecessarily", (Object)sslEngineBuilder, (Object)sslFactory.sslEngineBuilder());
    }

    @Test
    public void testReconfigurationWithoutTruststore() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        sslConfig.remove("ssl.truststore.location");
        sslConfig.remove("ssl.truststore.password");
        sslConfig.remove("ssl.truststore.type");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SSLContext sslContext = sslFactory.sslEngineBuilder().sslContext();
        Assert.assertNotNull((String)"SSL context not created", (Object)sslContext);
        Assert.assertSame((String)"SSL context recreated unnecessarily", (Object)sslContext, (Object)sslFactory.sslEngineBuilder().sslContext());
        Assert.assertFalse((boolean)sslFactory.createSslEngine("localhost", 0).getUseClientMode());
        Map<String, Object> sslConfig2 = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        try {
            sslFactory.validateReconfiguration(sslConfig2);
            Assert.fail((String)"Truststore configured dynamically for listener without previous truststore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testReconfigurationWithoutKeystore() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        sslConfig.remove("ssl.keystore.location");
        sslConfig.remove("ssl.keystore.password");
        sslConfig.remove("ssl.keystore.type");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(sslConfig);
        SSLContext sslContext = sslFactory.sslEngineBuilder().sslContext();
        Assert.assertNotNull((String)"SSL context not created", (Object)sslContext);
        Assert.assertSame((String)"SSL context recreated unnecessarily", (Object)sslContext, (Object)sslFactory.sslEngineBuilder().sslContext());
        Assert.assertFalse((boolean)sslFactory.createSslEngine("localhost", 0).getUseClientMode());
        File newTrustStoreFile = File.createTempFile("truststore", ".jks");
        sslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, newTrustStoreFile, "server");
        sslConfig.remove("ssl.keystore.location");
        sslConfig.remove("ssl.keystore.password");
        sslConfig.remove("ssl.keystore.type");
        sslFactory.reconfigure(sslConfig);
        Assert.assertNotSame((String)"SSL context not recreated", (Object)sslContext, (Object)sslFactory.sslEngineBuilder().sslContext());
        sslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, newTrustStoreFile, "server");
        try {
            sslFactory.validateReconfiguration(sslConfig);
            Assert.fail((String)"Keystore configured dynamically for listener without previous keystore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testKeyStoreTrustStoreValidation() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        Assert.assertNotNull((String)"SslEngineBuilder not created", (Object)sslFactory.sslEngineBuilder());
    }

    @Test
    public void testUntrustedKeyStoreValidationFails() throws Exception {
        File trustStoreFile1 = File.createTempFile("truststore1", ".jks");
        File trustStoreFile2 = File.createTempFile("truststore2", ".jks");
        Map<String, Object> sslConfig1 = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile1, "server");
        Map<String, Object> sslConfig2 = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile2, "server");
        SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);
        for (String key : Arrays.asList("ssl.truststore.location", "ssl.truststore.password", "ssl.truststore.type", "ssl.trustmanager.algorithm")) {
            sslConfig1.put(key, sslConfig2.get(key));
        }
        try {
            sslFactory.configure(sslConfig1);
            Assert.fail((String)"Validation did not fail with untrusted truststore");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testKeystoreVerifiableUsingTruststore() throws Exception {
        File trustStoreFile1 = File.createTempFile("truststore1", ".jks");
        Map<String, Object> sslConfig1 = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile1, "server");
        SslFactory sslFactory = new SslFactory(Mode.SERVER, null, true);
        sslFactory.configure(sslConfig1);
        File trustStoreFile2 = File.createTempFile("truststore2", ".jks");
        Map<String, Object> sslConfig2 = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile2, "server");
        try {
            sslFactory.validateReconfiguration(sslConfig2);
            Assert.fail((String)"ValidateReconfiguration did not fail as expected");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    @Test
    public void testCertificateEntriesValidation() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        Map<String, Object> newCnConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, File.createTempFile("truststore", ".jks"), "server", "Another CN");
        KeyStore ks1 = this.sslKeyStore(serverSslConfig).load();
        KeyStore ks2 = this.sslKeyStore(serverSslConfig).load();
        Assert.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        ks2.setCertificateEntry("another", ks1.getCertificate("localhost"));
        Assert.assertEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks2));
        KeyStore ks3 = this.sslKeyStore(newCnConfig).load();
        Assert.assertNotEquals((Object)SslFactory.CertificateEntries.create((KeyStore)ks1), (Object)SslFactory.CertificateEntries.create((KeyStore)ks3));
    }

    private SslEngineBuilder.SecurityStore sslKeyStore(Map<String, Object> sslConfig) {
        return new SslEngineBuilder.SecurityStore((String)sslConfig.get("ssl.keystore.type"), (String)sslConfig.get("ssl.keystore.location"), (Password)sslConfig.get("ssl.keystore.password"), (Password)sslConfig.get("ssl.key.password"));
    }

    private SslEngineBuilder.SecurityStore sslTrustStore(Map<String, Object> sslConfig) {
        return new SslEngineBuilder.SecurityStore((String)sslConfig.get("ssl.truststore.type"), (String)sslConfig.get("ssl.truststore.location"), (Password)sslConfig.get("ssl.truststore.password"), null);
    }
}

