/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.junit.Assert;
import org.junit.Test;

public class ConsumerGroupMetadataTest {
    private String groupId = "group";

    @Test
    public void testAssignmentConstructor() {
        String memberId = "member";
        int generationId = 2;
        String groupInstanceId = "instance";
        ConsumerGroupMetadata groupMetadata = new ConsumerGroupMetadata(this.groupId, generationId, memberId, Optional.of(groupInstanceId));
        Assert.assertEquals((Object)this.groupId, (Object)groupMetadata.groupId());
        Assert.assertEquals((long)generationId, (long)groupMetadata.generationId());
        Assert.assertEquals((Object)memberId, (Object)groupMetadata.memberId());
        Assert.assertTrue((boolean)groupMetadata.groupInstanceId().isPresent());
        Assert.assertEquals((Object)groupInstanceId, groupMetadata.groupInstanceId().get());
    }

    @Test
    public void testGroupIdConstructor() {
        ConsumerGroupMetadata groupMetadata = new ConsumerGroupMetadata(this.groupId);
        Assert.assertEquals((Object)this.groupId, (Object)groupMetadata.groupId());
        Assert.assertEquals((long)-1L, (long)groupMetadata.generationId());
        Assert.assertEquals((Object)"", (Object)groupMetadata.memberId());
        Assert.assertFalse((boolean)groupMetadata.groupInstanceId().isPresent());
    }

    @Test
    public void testInvalidGroupId() {
        String memberId = "member";
        int generationId = 2;
        Assert.assertThrows(NullPointerException.class, () -> new ConsumerGroupMetadata(null, generationId, memberId, Optional.empty()));
    }

    @Test
    public void testInvalidMemberId() {
        int generationId = 2;
        Assert.assertThrows(NullPointerException.class, () -> new ConsumerGroupMetadata(this.groupId, generationId, null, Optional.empty()));
    }

    @Test
    public void testInvalidInstanceId() {
        String memberId = "member";
        int generationId = 2;
        Assert.assertThrows(NullPointerException.class, () -> new ConsumerGroupMetadata(this.groupId, generationId, memberId, null));
    }
}

