/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.io.IOException;
import java.util.Optional;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.utils.Serializer;
import org.junit.Assert;
import org.junit.Test;

public class OffsetAndMetadataTest {
    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNegativeOffset() {
        new OffsetAndMetadata(-239L, Optional.of(15), "");
    }

    @Test
    public void testSerializationRoundtrip() throws IOException, ClassNotFoundException {
        this.checkSerde(new OffsetAndMetadata(239L, Optional.of(15), "blah"));
        this.checkSerde(new OffsetAndMetadata(239L, "blah"));
        this.checkSerde(new OffsetAndMetadata(239L));
    }

    private void checkSerde(OffsetAndMetadata offsetAndMetadata) throws IOException, ClassNotFoundException {
        byte[] bytes = Serializer.serialize(offsetAndMetadata);
        OffsetAndMetadata deserialized = (OffsetAndMetadata)Serializer.deserialize(bytes);
        Assert.assertEquals((Object)offsetAndMetadata, (Object)deserialized);
    }

    @Test
    public void testDeserializationCompatibilityBeforeLeaderEpoch() throws IOException, ClassNotFoundException {
        String fileName = "serializedData/offsetAndMetadataBeforeLeaderEpoch";
        Object deserializedObject = Serializer.deserialize(fileName);
        Assert.assertEquals((Object)new OffsetAndMetadata(10L, "test commit metadata"), (Object)deserializedObject);
    }

    @Test
    public void testDeserializationCompatibilityWithLeaderEpoch() throws IOException, ClassNotFoundException {
        String fileName = "serializedData/offsetAndMetadataWithLeaderEpoch";
        Object deserializedObject = Serializer.deserialize(fileName);
        Assert.assertEquals((Object)new OffsetAndMetadata(10L, Optional.of(235), "test commit metadata"), (Object)deserializedObject);
    }
}

