/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeAssignorTest {
    private RangeAssignor assignor = new RangeAssignor();
    private String topic1 = "topic1";
    private String topic2 = "topic2";
    private final String consumer1 = "consumer1";
    private final String instance1 = "instance1";
    private final String consumer2 = "consumer2";
    private final String instance2 = "instance2";
    private final String consumer3 = "consumer3";
    private final String instance3 = "instance3";
    private List<AbstractPartitionAssignor.MemberInfo> staticMemberInfos;

    @Before
    public void setUp() {
        this.staticMemberInfos = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        this.staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo("consumer1", Optional.of("instance1")));
        this.staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo("consumer2", Optional.of("instance2")));
        this.staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo("consumer3", Optional.of("instance3")));
    }

    @Test
    public void testOneConsumerNoTopic() {
        HashMap partitionsPerTopic = new HashMap();
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer1", new ConsumerPartitionAssignor.Subscription(Collections.emptyList())));
        Assert.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        Assert.assertTrue((boolean)((List)assignment.get("consumer1")).isEmpty());
    }

    @Test
    public void testOneConsumerNonexistentTopic() {
        HashMap partitionsPerTopic = new HashMap();
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer1", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1))));
        Assert.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        Assert.assertTrue((boolean)((List)assignment.get("consumer1")).isEmpty());
    }

    @Test
    public void testOneConsumerOneTopic() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic1, 3);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer1", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1))));
        Assert.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0), RangeAssignorTest.tp(this.topic1, 1), RangeAssignorTest.tp(this.topic1, 2)), (List)assignment.get("consumer1"));
    }

    @Test
    public void testOnlyAssignsPartitionsFromSubscribedTopics() {
        String otherTopic = "other";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic1, 3);
        partitionsPerTopic.put(otherTopic, 3);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer1", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1))));
        Assert.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0), RangeAssignorTest.tp(this.topic1, 1), RangeAssignorTest.tp(this.topic1, 2)), (List)assignment.get("consumer1"));
    }

    @Test
    public void testOneConsumerMultipleTopics() {
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(1, 2);
        Map assignment = this.assignor.assign(partitionsPerTopic, Collections.singletonMap("consumer1", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2))));
        Assert.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0), RangeAssignorTest.tp(this.topic2, 0), RangeAssignorTest.tp(this.topic2, 1)), (List)assignment.get("consumer1"));
    }

    @Test
    public void testTwoConsumersOneTopicOnePartition() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic1, 1);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put("consumer1", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1)));
        consumers.put("consumer2", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0)), (List)assignment.get("consumer1"));
        this.assertAssignment(Collections.emptyList(), (List)assignment.get("consumer2"));
    }

    @Test
    public void testTwoConsumersOneTopicTwoPartitions() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic1, 2);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put("consumer1", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1)));
        consumers.put("consumer2", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0)), (List)assignment.get("consumer1"));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 1)), (List)assignment.get("consumer2"));
    }

    @Test
    public void testMultipleConsumersMixedTopics() {
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 2);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put("consumer1", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1)));
        consumers.put("consumer2", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2)));
        consumers.put("consumer3", new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0)), (List)assignment.get("consumer1"));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 1), RangeAssignorTest.tp(this.topic2, 0), RangeAssignorTest.tp(this.topic2, 1)), (List)assignment.get("consumer2"));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 2)), (List)assignment.get("consumer3"));
    }

    @Test
    public void testTwoConsumersTwoTopicsSixPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put(consumer1, new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(topic1, topic2)));
        consumers.put(consumer2, new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(topic1, topic2)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 0), RangeAssignorTest.tp(topic1, 1), RangeAssignorTest.tp(topic2, 0), RangeAssignorTest.tp(topic2, 1)), (List)assignment.get(consumer1));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 2), RangeAssignorTest.tp(topic2, 2)), (List)assignment.get(consumer2));
    }

    @Test
    public void testTwoStaticConsumersTwoTopicsSixPartitions() {
        String consumerIdLow = "consumer-b";
        String consumerIdHigh = "consumer-a";
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        ConsumerPartitionAssignor.Subscription consumerLowSubscription = new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2), null, Collections.emptyList());
        consumerLowSubscription.setGroupInstanceId(Optional.of("instance1"));
        consumers.put(consumerIdLow, consumerLowSubscription);
        ConsumerPartitionAssignor.Subscription consumerHighSubscription = new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2), null, Collections.emptyList());
        consumerHighSubscription.setGroupInstanceId(Optional.of("instance2"));
        consumers.put(consumerIdHigh, consumerHighSubscription);
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0), RangeAssignorTest.tp(this.topic1, 1), RangeAssignorTest.tp(this.topic2, 0), RangeAssignorTest.tp(this.topic2, 1)), (List)assignment.get(consumerIdLow));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 2), RangeAssignorTest.tp(this.topic2, 2)), (List)assignment.get(consumerIdHigh));
    }

    @Test
    public void testOneStaticConsumerAndOneDynamicConsumerTwoTopicsSixPartitions() {
        String consumerIdLow = "consumer-b";
        String consumerIdHigh = "consumer-a";
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        ConsumerPartitionAssignor.Subscription consumerLowSubscription = new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2), null, Collections.emptyList());
        consumerLowSubscription.setGroupInstanceId(Optional.of("instance1"));
        consumers.put(consumerIdLow, consumerLowSubscription);
        consumers.put(consumerIdHigh, new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0), RangeAssignorTest.tp(this.topic1, 1), RangeAssignorTest.tp(this.topic2, 0), RangeAssignorTest.tp(this.topic2, 1)), (List)assignment.get(consumerIdLow));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 2), RangeAssignorTest.tp(this.topic2, 2)), (List)assignment.get(consumerIdHigh));
    }

    @Test
    public void testStaticMemberRangeAssignmentPersistent() {
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(5, 4);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        for (AbstractPartitionAssignor.MemberInfo m : this.staticMemberInfos) {
            ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2), null, Collections.emptyList());
            subscription.setGroupInstanceId(m.groupInstanceId);
            consumers.put(m.memberId, subscription);
        }
        String consumer4 = "consumer4";
        consumers.put(consumer4, new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2)));
        HashMap<String, List<TopicPartition>> expectedAssignment = new HashMap<String, List<TopicPartition>>();
        expectedAssignment.put("consumer1", RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0), RangeAssignorTest.tp(this.topic1, 1), RangeAssignorTest.tp(this.topic2, 0)));
        expectedAssignment.put("consumer2", RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 2), RangeAssignorTest.tp(this.topic2, 1)));
        expectedAssignment.put("consumer3", RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 3), RangeAssignorTest.tp(this.topic2, 2)));
        expectedAssignment.put(consumer4, RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 4), RangeAssignorTest.tp(this.topic2, 3)));
        Map assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assert.assertEquals(expectedAssignment, (Object)assignment);
        consumers.remove(consumer4);
        String consumer5 = "consumer5";
        consumers.put(consumer5, new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2)));
        expectedAssignment.remove(consumer4);
        expectedAssignment.put(consumer5, RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 4), RangeAssignorTest.tp(this.topic2, 3)));
        assignment = this.assignor.assign(partitionsPerTopic, consumers);
        Assert.assertEquals(expectedAssignment, (Object)assignment);
    }

    @Test
    public void testStaticMemberRangeAssignmentPersistentAfterMemberIdChanges() {
        Map<String, Integer> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(5, 5);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        for (AbstractPartitionAssignor.MemberInfo m : this.staticMemberInfos) {
            ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(RangeAssignorTest.topics(this.topic1, this.topic2), null, Collections.emptyList());
            subscription.setGroupInstanceId(m.groupInstanceId);
            consumers.put(m.memberId, subscription);
        }
        HashMap<String, List<TopicPartition>> expectedInstanceAssignment = new HashMap<String, List<TopicPartition>>();
        expectedInstanceAssignment.put("instance1", RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 0), RangeAssignorTest.tp(this.topic1, 1), RangeAssignorTest.tp(this.topic2, 0), RangeAssignorTest.tp(this.topic2, 1)));
        expectedInstanceAssignment.put("instance2", RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 2), RangeAssignorTest.tp(this.topic1, 3), RangeAssignorTest.tp(this.topic2, 2), RangeAssignorTest.tp(this.topic2, 3)));
        expectedInstanceAssignment.put("instance3", RangeAssignorTest.partitions(RangeAssignorTest.tp(this.topic1, 4), RangeAssignorTest.tp(this.topic2, 4)));
        Map<String, List<TopicPartition>> staticAssignment = RangeAssignorTest.checkStaticAssignment((AbstractPartitionAssignor)this.assignor, partitionsPerTopic, consumers);
        Assert.assertEquals(expectedInstanceAssignment, staticAssignment);
        String consumer4 = "consumer4";
        String consumer5 = "consumer5";
        consumers.put(consumer4, (ConsumerPartitionAssignor.Subscription)consumers.get("consumer3"));
        consumers.remove("consumer3");
        consumers.put(consumer5, (ConsumerPartitionAssignor.Subscription)consumers.get("consumer2"));
        consumers.remove("consumer2");
        Map<String, List<TopicPartition>> newStaticAssignment = RangeAssignorTest.checkStaticAssignment((AbstractPartitionAssignor)this.assignor, partitionsPerTopic, consumers);
        Assert.assertEquals(staticAssignment, newStaticAssignment);
    }

    static Map<String, List<TopicPartition>> checkStaticAssignment(AbstractPartitionAssignor assignor, Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> consumers) {
        Map assignmentByMemberId = assignor.assign(partitionsPerTopic, consumers);
        HashMap<String, List<TopicPartition>> assignmentByInstanceId = new HashMap<String, List<TopicPartition>>();
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> entry : consumers.entrySet()) {
            String memberId = entry.getKey();
            Optional instanceId = entry.getValue().groupInstanceId();
            instanceId.ifPresent(id -> {
                List cfr_ignored_0 = (List)assignmentByInstanceId.put((String)id, (List<TopicPartition>)assignmentByMemberId.get(memberId));
            });
        }
        return assignmentByInstanceId;
    }

    private void assertAssignment(List<TopicPartition> expected, List<TopicPartition> actual) {
        Assert.assertEquals(new HashSet<TopicPartition>(expected), new HashSet<TopicPartition>(actual));
    }

    private Map<String, Integer> setupPartitionsPerTopicWithTwoTopics(int numberOfPartitions1, int numberOfPartitions2) {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic1, numberOfPartitions1);
        partitionsPerTopic.put(this.topic2, numberOfPartitions2);
        return partitionsPerTopic;
    }

    private static List<String> topics(String ... topics) {
        return Arrays.asList(topics);
    }

    private static List<TopicPartition> partitions(TopicPartition ... partitions) {
        return Arrays.asList(partitions);
    }

    private static TopicPartition tp(String topic, int partition) {
        return new TopicPartition(topic, partition);
    }
}

