/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConsumerProtocolTest {
    private final TopicPartition tp1 = new TopicPartition("foo", 1);
    private final TopicPartition tp2 = new TopicPartition("bar", 2);
    private final Optional<String> groupInstanceId = Optional.of("instance.id");

    @Test
    public void serializeDeserializeSubscriptionAllVersions() {
        List<TopicPartition> ownedPartitions = Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 0));
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), ByteBuffer.wrap("hello".getBytes()), ownedPartitions);
        for (short version = 0; version <= 1; version = (short)(version + 1)) {
            ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)version);
            ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
            Assert.assertEquals((Object)subscription.topics(), (Object)parsedSubscription.topics());
            Assert.assertEquals((Object)subscription.userData(), (Object)parsedSubscription.userData());
            Assert.assertFalse((boolean)parsedSubscription.groupInstanceId().isPresent());
            if (version >= 1) {
                Assert.assertEquals(TestUtils.toSet(subscription.ownedPartitions()), TestUtils.toSet(parsedSubscription.ownedPartitions()));
                continue;
            }
            Assert.assertEquals(Collections.emptyList(), (Object)parsedSubscription.ownedPartitions());
        }
    }

    @Test
    public void serializeDeserializeMetadata() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), ByteBuffer.wrap(new byte[0]));
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        Assert.assertEquals((Object)subscription.topics(), (Object)parsedSubscription.topics());
        Assert.assertEquals((long)0L, (long)parsedSubscription.userData().limit());
        Assert.assertFalse((boolean)parsedSubscription.groupInstanceId().isPresent());
    }

    @Test
    public void serializeDeserializeMetadataAndGroupInstanceId() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), ByteBuffer.wrap(new byte[0]));
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        parsedSubscription.setGroupInstanceId(this.groupInstanceId);
        Assert.assertEquals((Object)subscription.topics(), (Object)parsedSubscription.topics());
        Assert.assertEquals((long)0L, (long)parsedSubscription.userData().limit());
        Assert.assertEquals(this.groupInstanceId, (Object)parsedSubscription.groupInstanceId());
    }

    @Test
    public void serializeDeserializeNullSubscriptionUserData() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null);
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        Assert.assertEquals((Object)subscription.topics(), (Object)parsedSubscription.topics());
        Assert.assertNull((Object)parsedSubscription.userData());
    }

    @Test
    public void deserializeOldSubscriptionVersion() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null);
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)0);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        Assert.assertEquals((Object)parsedSubscription.topics(), (Object)parsedSubscription.topics());
        Assert.assertNull((Object)parsedSubscription.userData());
        Assert.assertTrue((boolean)parsedSubscription.ownedPartitions().isEmpty());
    }

    @Test
    public void deserializeNewSubscriptionWithOldVersion() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(Arrays.asList("foo", "bar"), null, Collections.singletonList(this.tp2));
        ByteBuffer buffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription);
        ConsumerProtocol.deserializeVersion((ByteBuffer)buffer);
        ConsumerPartitionAssignor.Subscription parsedSubscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer, (short)0);
        Assert.assertEquals((Object)subscription.topics(), (Object)parsedSubscription.topics());
        Assert.assertNull((Object)parsedSubscription.userData());
        Assert.assertTrue((boolean)parsedSubscription.ownedPartitions().isEmpty());
        Assert.assertFalse((boolean)parsedSubscription.groupInstanceId().isPresent());
    }

    @Test
    public void deserializeFutureSubscriptionVersion() {
        short version = 100;
        Schema subscriptionSchemaV100 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)Type.STRING)), new Field("user_data", (Type)Type.NULLABLE_BYTES), new Field("owned_partitions", (Type)new ArrayOf((Type)ConsumerProtocolSubscription.TopicPartition.SCHEMA_1)), new Field("foo", (Type)Type.STRING)});
        Struct subscriptionV100 = new Struct(subscriptionSchemaV100);
        subscriptionV100.set("topics", (Object)new Object[]{"topic"});
        subscriptionV100.set("user_data", (Object)ByteBuffer.wrap(new byte[0]));
        subscriptionV100.set("owned_partitions", (Object)new Object[]{new Struct(ConsumerProtocolSubscription.TopicPartition.SCHEMA_1).set("topic", (Object)this.tp2.topic()).set("partitions", (Object)new Object[]{this.tp2.partition()})});
        subscriptionV100.set("foo", (Object)"bar");
        Struct headerV100 = new Struct(new Schema(new Field[]{new Field("version", (Type)Type.INT16)}));
        headerV100.set("version", (Object)version);
        ByteBuffer buffer = ByteBuffer.allocate(subscriptionV100.sizeOf() + headerV100.sizeOf());
        headerV100.writeTo(buffer);
        subscriptionV100.writeTo(buffer);
        buffer.flip();
        ConsumerPartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)buffer);
        subscription.setGroupInstanceId(this.groupInstanceId);
        Assert.assertEquals(Collections.singletonList("topic"), (Object)subscription.topics());
        Assert.assertEquals(Collections.singletonList(this.tp2), (Object)subscription.ownedPartitions());
        Assert.assertEquals(this.groupInstanceId, (Object)subscription.groupInstanceId());
    }

    @Test
    public void serializeDeserializeAssignmentAllVersions() {
        List<TopicPartition> partitions = Arrays.asList(this.tp1, this.tp2);
        ConsumerPartitionAssignor.Assignment assignment = new ConsumerPartitionAssignor.Assignment(partitions, ByteBuffer.wrap("hello".getBytes()));
        for (short version = 0; version <= 1; version = (short)(version + 1)) {
            ByteBuffer buffer = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)assignment, (short)version);
            ConsumerPartitionAssignor.Assignment parsedAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
            Assert.assertEquals(TestUtils.toSet(partitions), TestUtils.toSet(parsedAssignment.partitions()));
            Assert.assertEquals((Object)assignment.userData(), (Object)parsedAssignment.userData());
        }
    }

    @Test
    public void serializeDeserializeAssignment() {
        List<TopicPartition> partitions = Arrays.asList(this.tp1, this.tp2);
        ByteBuffer buffer = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(partitions, ByteBuffer.wrap(new byte[0])));
        ConsumerPartitionAssignor.Assignment parsedAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
        Assert.assertEquals(TestUtils.toSet(partitions), TestUtils.toSet(parsedAssignment.partitions()));
        Assert.assertEquals((long)0L, (long)parsedAssignment.userData().limit());
    }

    @Test
    public void deserializeNullAssignmentUserData() {
        List<TopicPartition> partitions = Arrays.asList(this.tp1, this.tp2);
        ByteBuffer buffer = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(partitions, null));
        ConsumerPartitionAssignor.Assignment parsedAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
        Assert.assertEquals(TestUtils.toSet(partitions), TestUtils.toSet(parsedAssignment.partitions()));
        Assert.assertNull((Object)parsedAssignment.userData());
    }

    @Test
    public void deserializeFutureAssignmentVersion() {
        short version = 100;
        Schema assignmentSchemaV100 = new Schema(new Field[]{new Field("assigned_partitions", (Type)new ArrayOf((Type)ConsumerProtocolAssignment.TopicPartition.SCHEMA_0)), new Field("user_data", (Type)Type.BYTES), new Field("foo", (Type)Type.STRING)});
        Struct assignmentV100 = new Struct(assignmentSchemaV100);
        assignmentV100.set("assigned_partitions", (Object)new Object[]{new Struct(ConsumerProtocolAssignment.TopicPartition.SCHEMA_0).set("topic", (Object)this.tp1.topic()).set("partitions", (Object)new Object[]{this.tp1.partition()})});
        assignmentV100.set("user_data", (Object)ByteBuffer.wrap(new byte[0]));
        assignmentV100.set("foo", (Object)"bar");
        Struct headerV100 = new Struct(new Schema(new Field[]{new Field("version", (Type)Type.INT16)}));
        headerV100.set("version", (Object)version);
        ByteBuffer buffer = ByteBuffer.allocate(assignmentV100.sizeOf() + headerV100.sizeOf());
        headerV100.writeTo(buffer);
        assignmentV100.writeTo(buffer);
        buffer.flip();
        ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)buffer);
        Assert.assertEquals(TestUtils.toSet(Collections.singletonList(this.tp1)), TestUtils.toSet(assignment.partitions()));
    }
}

