/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.SimpleExampleMessageData;
import org.apache.kafka.common.message.SimpleExampleMessageDataJsonConverter;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.utils.ByteUtils;
import org.junit.Assert;
import org.junit.Test;

public class SimpleExampleMessageTest {
    @Test
    public void shouldStoreField() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{1, 2, 3});
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        out.setZeroCopyByteBuffer(buf);
        Assert.assertEquals((Object)uuid, (Object)out.processId());
        Assert.assertEquals((Object)buf, (Object)out.zeroCopyByteBuffer());
        out.setNullableZeroCopyByteBuffer(null);
        Assert.assertNull((Object)out.nullableZeroCopyByteBuffer());
        out.setNullableZeroCopyByteBuffer(buf);
        Assert.assertEquals((Object)buf, (Object)out.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldThrowIfCannotWriteNonIgnorableField() {
        SimpleExampleMessageData out = new SimpleExampleMessageData().setProcessId(UUID.randomUUID());
        Assert.assertThrows(UnsupportedVersionException.class, () -> out.write((Writable)new ByteBufferAccessor(ByteBuffer.allocate(64)), new ObjectSerializationCache(), (short)0));
        Assert.assertThrows(UnsupportedVersionException.class, () -> out.toStruct((short)0));
    }

    @Test
    public void shouldDefaultField() {
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        Assert.assertEquals((Object)UUID.fromString("00000000-0000-0000-0000-000000000000"), (Object)out.processId());
        Assert.assertEquals((Object)ByteUtils.EMPTY_BUF, (Object)out.zeroCopyByteBuffer());
        Assert.assertEquals((Object)ByteUtils.EMPTY_BUF, (Object)out.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldRoundTripFieldThroughStruct() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{1, 2, 3});
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        out.setZeroCopyByteBuffer(buf);
        Struct struct = out.toStruct((short)1);
        SimpleExampleMessageData in = new SimpleExampleMessageData();
        in.fromStruct(struct, (short)1);
        buf.rewind();
        Assert.assertEquals((Object)uuid, (Object)in.processId());
        Assert.assertEquals((Object)buf, (Object)in.zeroCopyByteBuffer());
        Assert.assertEquals((Object)ByteUtils.EMPTY_BUF, (Object)in.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldRoundTripFieldThroughStructWithNullable() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer buf1 = ByteBuffer.wrap(new byte[]{1, 2, 3});
        ByteBuffer buf2 = ByteBuffer.wrap(new byte[]{4, 5, 6});
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        out.setZeroCopyByteBuffer(buf1);
        out.setNullableZeroCopyByteBuffer(buf2);
        Struct struct = out.toStruct((short)1);
        SimpleExampleMessageData in = new SimpleExampleMessageData();
        in.fromStruct(struct, (short)1);
        buf1.rewind();
        buf2.rewind();
        Assert.assertEquals((Object)uuid, (Object)in.processId());
        Assert.assertEquals((Object)buf1, (Object)in.zeroCopyByteBuffer());
        Assert.assertEquals((Object)buf2, (Object)in.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldRoundTripFieldThroughBuffer() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{1, 2, 3});
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        out.setZeroCopyByteBuffer(buf);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        ByteBuffer buffer = ByteBuffer.allocate(out.size(cache, (short)1));
        out.write((Writable)new ByteBufferAccessor(buffer), cache, (short)1);
        buffer.rewind();
        SimpleExampleMessageData in = new SimpleExampleMessageData();
        in.read((Readable)new ByteBufferAccessor(buffer), (short)1);
        buf.rewind();
        Assert.assertEquals((Object)uuid, (Object)in.processId());
        Assert.assertEquals((Object)buf, (Object)in.zeroCopyByteBuffer());
        Assert.assertEquals((Object)ByteUtils.EMPTY_BUF, (Object)in.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldRoundTripFieldThroughBufferWithNullable() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer buf1 = ByteBuffer.wrap(new byte[]{1, 2, 3});
        ByteBuffer buf2 = ByteBuffer.wrap(new byte[]{4, 5, 6});
        SimpleExampleMessageData out = new SimpleExampleMessageData();
        out.setProcessId(uuid);
        out.setZeroCopyByteBuffer(buf1);
        out.setNullableZeroCopyByteBuffer(buf2);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        ByteBuffer buffer = ByteBuffer.allocate(out.size(cache, (short)1));
        out.write((Writable)new ByteBufferAccessor(buffer), cache, (short)1);
        buffer.rewind();
        SimpleExampleMessageData in = new SimpleExampleMessageData();
        in.read((Readable)new ByteBufferAccessor(buffer), (short)1);
        buf1.rewind();
        buf2.rewind();
        Assert.assertEquals((Object)uuid, (Object)in.processId());
        Assert.assertEquals((Object)buf1, (Object)in.zeroCopyByteBuffer());
        Assert.assertEquals((Object)buf2, (Object)in.nullableZeroCopyByteBuffer());
    }

    @Test
    public void shouldImplementEqualsAndHashCode() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer buf = ByteBuffer.wrap(new byte[]{1, 2, 3});
        SimpleExampleMessageData a = new SimpleExampleMessageData();
        a.setProcessId(uuid);
        a.setZeroCopyByteBuffer(buf);
        SimpleExampleMessageData b = new SimpleExampleMessageData();
        b.setProcessId(uuid);
        b.setZeroCopyByteBuffer(buf);
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
        Assert.assertEquals((Object)a.toString(), (Object)b.toString());
        a.setNullableZeroCopyByteBuffer(buf);
        b.setNullableZeroCopyByteBuffer(buf);
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
        Assert.assertEquals((Object)a.toString(), (Object)b.toString());
        a.setNullableZeroCopyByteBuffer(null);
        b.setNullableZeroCopyByteBuffer(null);
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
        Assert.assertEquals((Object)a.toString(), (Object)b.toString());
    }

    @Test
    public void testMyTaggedIntArray() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assert.assertEquals(Collections.emptyList(), message.myTaggedIntArray()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyTaggedIntArray(Arrays.asList(1, 2, 3)), message -> Assert.assertEquals(Arrays.asList(1, 2, 3), message.myTaggedIntArray()));
    }

    @Test
    public void testMyNullableString() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assert.assertTrue((message.myNullableString() == null ? 1 : 0) != 0));
        this.testRoundTrip(new SimpleExampleMessageData().setMyNullableString("foobar"), message -> Assert.assertEquals((Object)"foobar", (Object)message.myNullableString()));
    }

    @Test
    public void testMyInt16() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assert.assertEquals((long)123L, (long)message.myInt16()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyInt16((short)456), message -> Assert.assertEquals((long)456L, (long)message.myInt16()));
    }

    @Test
    public void testMyString() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assert.assertEquals((Object)"", (Object)message.myString()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyString("abc"), message -> Assert.assertEquals((Object)"abc", (Object)message.myString()));
    }

    @Test
    public void testMyBytes() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assert.assertArrayEquals((byte[])new byte[0], (byte[])message.myBytes()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyBytes(new byte[]{67, 102}), message -> Assert.assertArrayEquals((byte[])new byte[]{67, 102}, (byte[])message.myBytes()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyBytes(null), message -> Assert.assertTrue((message.myBytes() == null ? 1 : 0) != 0));
    }

    @Test
    public void testTaggedUuid() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assert.assertEquals((Object)UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367"), (Object)message.taggedUuid()));
        this.testRoundTrip(new SimpleExampleMessageData().setTaggedUuid(UUID.fromString("01234567-89ab-cdef-0123-456789abcdef")), message -> Assert.assertEquals((Object)UUID.fromString("01234567-89ab-cdef-0123-456789abcdef"), (Object)message.taggedUuid()));
    }

    @Test
    public void testTaggedLong() {
        this.testRoundTrip(new SimpleExampleMessageData(), message -> Assert.assertEquals((long)0xCAFCACAFCACAFCAL, (long)message.taggedLong()));
        this.testRoundTrip(new SimpleExampleMessageData().setMyString("blah").setMyTaggedIntArray(Arrays.asList(4)).setTaggedLong(81984200049378354L), message -> Assert.assertEquals((long)81984200049378354L, (long)message.taggedLong()));
    }

    @Test
    public void testMyStruct() {
        SimpleExampleMessageData.MyStruct myStruct = new SimpleExampleMessageData.MyStruct().setStructId(10).setArrayInStruct(Collections.singletonList(new SimpleExampleMessageData.StructArray().setArrayFieldId(20)));
        this.testRoundTrip(new SimpleExampleMessageData().setMyStruct(myStruct), message -> Assert.assertEquals((Object)myStruct, (Object)message.myStruct()), (short)2);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testMyStructUnsupportedVersion() {
        SimpleExampleMessageData.MyStruct myStruct = new SimpleExampleMessageData.MyStruct().setStructId(10);
        this.testRoundTrip(new SimpleExampleMessageData().setMyStruct(myStruct), (short)1);
    }

    @Test
    public void testMyTaggedStruct() {
        SimpleExampleMessageData.TaggedStruct myStruct = new SimpleExampleMessageData.TaggedStruct().setStructId("abc");
        this.testRoundTrip(new SimpleExampleMessageData().setMyTaggedStruct(myStruct), message -> Assert.assertEquals((Object)myStruct, (Object)message.myTaggedStruct()), (short)2);
        this.testRoundTrip(new SimpleExampleMessageData().setMyString("abc"), message -> Assert.assertEquals((Object)"abc", (Object)message.myString()), (short)1);
        this.testRoundTrip(new SimpleExampleMessageData().setMyString("abc"), message -> Assert.assertEquals((Object)"abc", (Object)message.myString()), (short)2);
    }

    @Test
    public void testCommonStruct() {
        SimpleExampleMessageData message = new SimpleExampleMessageData();
        message.setMyCommonStruct(new SimpleExampleMessageData.TestCommonStruct().setFoo(1).setBar(2));
        message.setMyOtherCommonStruct(new SimpleExampleMessageData.TestCommonStruct().setFoo(3).setBar(4));
        this.testRoundTrip(message, (short)2);
    }

    private ByteBuffer serialize(SimpleExampleMessageData message, short version) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        message.write((Writable)new ByteBufferAccessor(buf), cache, version);
        buf.flip();
        Assert.assertEquals((long)size, (long)buf.remaining());
        return buf;
    }

    private SimpleExampleMessageData deserialize(ByteBuffer buf, short version) {
        SimpleExampleMessageData message = new SimpleExampleMessageData();
        message.read((Readable)new ByteBufferAccessor(buf.duplicate()), version);
        return message;
    }

    private ByteBuffer serializeThroughStruct(SimpleExampleMessageData message, short version) {
        Struct struct = message.toStruct(version);
        int size = struct.sizeOf();
        ByteBuffer buf = ByteBuffer.allocate(size);
        struct.writeTo(buf);
        buf.flip();
        Assert.assertEquals((long)size, (long)buf.remaining());
        return buf;
    }

    private SimpleExampleMessageData deserializeThroughStruct(ByteBuffer buf, short version) {
        Schema schema = SimpleExampleMessageData.SCHEMAS[version];
        Struct struct = schema.read(buf);
        return new SimpleExampleMessageData(struct, version);
    }

    private void testRoundTrip(SimpleExampleMessageData message, short version) {
        this.testRoundTrip(message, m -> {}, version);
    }

    private void testRoundTrip(SimpleExampleMessageData message, Consumer<SimpleExampleMessageData> validator) {
        this.testRoundTrip(message, validator, (short)1);
    }

    private void testRoundTrip(SimpleExampleMessageData message, Consumer<SimpleExampleMessageData> validator, short version) {
        validator.accept(message);
        ByteBuffer buf = this.serialize(message, version);
        SimpleExampleMessageData message2 = this.deserialize(buf.duplicate(), version);
        validator.accept(message2);
        Assert.assertEquals((Object)message, (Object)message2);
        Assert.assertEquals((long)message.hashCode(), (long)message2.hashCode());
        Assert.assertEquals((Object)buf, (Object)this.serializeThroughStruct(message, version));
        SimpleExampleMessageData messageFromStruct = this.deserializeThroughStruct(buf.duplicate(), version);
        validator.accept(messageFromStruct);
        Assert.assertEquals((Object)message, (Object)messageFromStruct);
        Assert.assertEquals((long)message.hashCode(), (long)messageFromStruct.hashCode());
        JsonNode serializedJson = SimpleExampleMessageDataJsonConverter.write(message, version);
        SimpleExampleMessageData messageFromJson = SimpleExampleMessageDataJsonConverter.read(serializedJson, version);
        validator.accept(messageFromJson);
        Assert.assertEquals((Object)message, (Object)messageFromJson);
        Assert.assertEquals((long)message.hashCode(), (long)messageFromJson.hashCode());
    }
}

