/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;

public class NetworkTestUtils {
    public static NioEchoServer createEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol, AbstractConfig serverConfig, CredentialCache credentialCache, Time time) throws Exception {
        return NetworkTestUtils.createEchoServer(listenerName, securityProtocol, serverConfig, credentialCache, 100, time);
    }

    public static NioEchoServer createEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol, AbstractConfig serverConfig, CredentialCache credentialCache, int failedAuthenticationDelayMs, Time time) throws Exception {
        NioEchoServer server = new NioEchoServer(listenerName, securityProtocol, serverConfig, "localhost", null, credentialCache, failedAuthenticationDelayMs, time);
        server.start();
        return server;
    }

    public static NioEchoServer createEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol, AbstractConfig serverConfig, CredentialCache credentialCache, int failedAuthenticationDelayMs, Time time, DelegationTokenCache tokenCache) throws Exception {
        NioEchoServer server = new NioEchoServer(listenerName, securityProtocol, serverConfig, "localhost", null, credentialCache, failedAuthenticationDelayMs, time, tokenCache);
        server.start();
        return server;
    }

    public static Selector createSelector(ChannelBuilder channelBuilder, Time time) {
        return new Selector(5000L, new Metrics(), time, "MetricGroup", channelBuilder, new LogContext());
    }

    public static void checkClientConnection(Selector selector, String node, int minMessageSize, int messageCount) throws Exception {
        NetworkTestUtils.waitForChannelReady(selector, node);
        String prefix = TestUtils.randomString(minMessageSize);
        int requests = 0;
        int responses = 0;
        selector.send((Send)new NetworkSend(node, ByteBuffer.wrap((prefix + "-0").getBytes(StandardCharsets.UTF_8))));
        ++requests;
        while (responses < messageCount) {
            selector.poll(0L);
            Assert.assertEquals((String)("No disconnects should have occurred ." + selector.disconnected()), (long)0L, (long)selector.disconnected().size());
            for (NetworkReceive receive : selector.completedReceives()) {
                Assert.assertEquals((Object)(prefix + "-" + responses), (Object)new String(Utils.toArray((ByteBuffer)receive.payload()), StandardCharsets.UTF_8));
                ++responses;
            }
            for (int i = 0; i < selector.completedSends().size() && requests < messageCount && selector.isChannelReady(node); ++i, ++requests) {
                selector.send((Send)new NetworkSend(node, ByteBuffer.wrap((prefix + "-" + requests).getBytes())));
            }
        }
    }

    public static void waitForChannelReady(Selector selector, String node) throws IOException {
        int secondsLeft = 30;
        while (!selector.isChannelReady(node) && secondsLeft-- > 0) {
            selector.poll(1000L);
        }
        Assert.assertTrue((boolean)selector.isChannelReady(node));
    }

    public static ChannelState waitForChannelClose(Selector selector, String node, ChannelState.State channelState) throws IOException {
        boolean closed = false;
        for (int i = 0; i < 300; ++i) {
            selector.poll(100L);
            if (selector.channel(node) != null || selector.closingChannel(node) != null) continue;
            closed = true;
            break;
        }
        Assert.assertTrue((String)"Channel was not closed by timeout", (boolean)closed);
        ChannelState finalState = (ChannelState)selector.disconnected().get(node);
        Assert.assertEquals((Object)channelState, (Object)finalState.state());
        return finalState;
    }

    public static void completeDelayedChannelClose(Selector selector, long currentTimeNanos) {
        selector.completeDelayedChannelClose(currentTimeNanos);
    }

    public static Map<?, ?> delayedClosingChannels(Selector selector) {
        return selector.delayedClosingChannels();
    }
}

