/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public final class MessageUtilTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testDeepToString() {
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)MessageUtil.deepToString(Arrays.asList(1, 2, 3).iterator()));
        Assert.assertEquals((Object)"[foo]", (Object)MessageUtil.deepToString(Arrays.asList("foo").iterator()));
    }

    @Test
    public void testByteBufferToArray() {
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])MessageUtil.byteBufferToArray((ByteBuffer)ByteBuffer.wrap(new byte[]{1, 2, 3})));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])MessageUtil.byteBufferToArray((ByteBuffer)ByteBuffer.wrap(new byte[0])));
    }

    @Test
    public void testDuplicate() {
        Assert.assertEquals(null, (Object)MessageUtil.duplicate(null));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])MessageUtil.duplicate((byte[])new byte[0]));
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])MessageUtil.duplicate((byte[])new byte[]{1, 2, 3}));
    }

    @Test
    public void testCompareRawTaggedFields() {
        Assert.assertTrue((boolean)MessageUtil.compareRawTaggedFields(null, null));
        Assert.assertTrue((boolean)MessageUtil.compareRawTaggedFields(null, Collections.emptyList()));
        Assert.assertTrue((boolean)MessageUtil.compareRawTaggedFields(Collections.emptyList(), null));
        Assert.assertFalse((boolean)MessageUtil.compareRawTaggedFields(Collections.emptyList(), Collections.singletonList(new RawTaggedField(1, new byte[]{1}))));
        Assert.assertFalse((boolean)MessageUtil.compareRawTaggedFields(null, Collections.singletonList(new RawTaggedField(1, new byte[]{1}))));
        Assert.assertFalse((boolean)MessageUtil.compareRawTaggedFields(Collections.singletonList(new RawTaggedField(1, new byte[]{1})), Collections.emptyList()));
        Assert.assertTrue((boolean)MessageUtil.compareRawTaggedFields(Arrays.asList(new RawTaggedField(1, new byte[]{1}), new RawTaggedField(2, new byte[0])), Arrays.asList(new RawTaggedField(1, new byte[]{1}), new RawTaggedField(2, new byte[0]))));
    }
}

