/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class DescribeAclsRequestTest {
    private static final short V0 = 0;
    private static final short V1 = 1;
    private static final AclBindingFilter LITERAL_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "foo", PatternType.LITERAL), new AccessControlEntryFilter("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));
    private static final AclBindingFilter PREFIXED_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.GROUP, "prefix", PatternType.PREFIXED), new AccessControlEntryFilter("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
    private static final AclBindingFilter ANY_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.GROUP, "bar", PatternType.ANY), new AccessControlEntryFilter("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
    private static final AclBindingFilter UNKNOWN_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, "foo", PatternType.LITERAL), new AccessControlEntryFilter("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));

    @Test
    public void shouldThrowOnV0IfPrefixed() {
        Assert.assertThrows(UnsupportedVersionException.class, () -> new DescribeAclsRequest.Builder(PREFIXED_FILTER).build((short)0));
    }

    @Test
    public void shouldThrowIfUnknown() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new DescribeAclsRequest.Builder(UNKNOWN_FILTER).build((short)0));
    }

    @Test
    public void shouldRoundTripLiteralV0() {
        DescribeAclsRequest original = new DescribeAclsRequest.Builder(LITERAL_FILTER).build((short)0);
        Struct struct = original.toStruct();
        DescribeAclsRequest result = new DescribeAclsRequest(struct, 0);
        DescribeAclsRequestTest.assertRequestEquals(original, result);
    }

    @Test
    public void shouldRoundTripAnyV0AsLiteral() {
        DescribeAclsRequest original = new DescribeAclsRequest.Builder(ANY_FILTER).build((short)0);
        DescribeAclsRequest expected = new DescribeAclsRequest.Builder(new AclBindingFilter(new ResourcePatternFilter(ANY_FILTER.patternFilter().resourceType(), ANY_FILTER.patternFilter().name(), PatternType.LITERAL), ANY_FILTER.entryFilter())).build((short)0);
        Struct struct = original.toStruct();
        DescribeAclsRequest result = new DescribeAclsRequest(struct, 0);
        DescribeAclsRequestTest.assertRequestEquals(expected, result);
    }

    @Test
    public void shouldRoundTripLiteralV1() {
        DescribeAclsRequest original = new DescribeAclsRequest.Builder(LITERAL_FILTER).build((short)1);
        Struct struct = original.toStruct();
        DescribeAclsRequest result = new DescribeAclsRequest(struct, 1);
        DescribeAclsRequestTest.assertRequestEquals(original, result);
    }

    @Test
    public void shouldRoundTripPrefixedV1() {
        DescribeAclsRequest original = new DescribeAclsRequest.Builder(PREFIXED_FILTER).build((short)1);
        Struct struct = original.toStruct();
        DescribeAclsRequest result = new DescribeAclsRequest(struct, 1);
        DescribeAclsRequestTest.assertRequestEquals(original, result);
    }

    @Test
    public void shouldRoundTripAnyV1() {
        DescribeAclsRequest original = new DescribeAclsRequest.Builder(ANY_FILTER).build((short)1);
        Struct struct = original.toStruct();
        DescribeAclsRequest result = new DescribeAclsRequest(struct, 1);
        DescribeAclsRequestTest.assertRequestEquals(original, result);
    }

    private static void assertRequestEquals(DescribeAclsRequest original, DescribeAclsRequest actual) {
        AclBindingFilter originalFilter = original.filter();
        AclBindingFilter acttualFilter = actual.filter();
        Assert.assertEquals((Object)originalFilter, (Object)acttualFilter);
    }
}

