/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.junit.Assert;
import org.junit.Test;

public class OffsetsForLeaderEpochRequestTest {
    @Test
    public void testForConsumerRequiresVersion3() {
        short version;
        OffsetsForLeaderEpochRequest.Builder builder = OffsetsForLeaderEpochRequest.Builder.forConsumer(Collections.emptyMap());
        for (version = 0; version < 3; version = (short)(version + 1)) {
            short v = version;
            Assert.assertThrows(UnsupportedVersionException.class, () -> builder.build(v));
        }
        for (version = 3; version < ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(); version = (short)(version + 1)) {
            OffsetsForLeaderEpochRequest request = builder.build((short)3);
            Assert.assertEquals((long)-1L, (long)request.replicaId());
        }
    }

    @Test
    public void testDefaultReplicaId() {
        for (short version = 0; version < ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(); version = (short)(version + 1)) {
            int replicaId = 1;
            OffsetsForLeaderEpochRequest.Builder builder = OffsetsForLeaderEpochRequest.Builder.forFollower((short)version, Collections.emptyMap(), (int)replicaId);
            OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)builder.build();
            OffsetsForLeaderEpochRequest parsed = (OffsetsForLeaderEpochRequest)AbstractRequest.parseRequest((ApiKeys)ApiKeys.OFFSET_FOR_LEADER_EPOCH, (short)version, (Struct)request.toStruct());
            if (version < 3) {
                Assert.assertEquals((long)-2L, (long)parsed.replicaId());
                continue;
            }
            Assert.assertEquals((long)replicaId, (long)parsed.replicaId());
        }
    }
}

