/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.utils.CircularIterator;
import org.junit.Assert;
import org.junit.Test;

public class CircularIteratorTest {
    @Test
    public void testNullCollection() {
        Assert.assertThrows(NullPointerException.class, () -> new CircularIterator(null));
    }

    @Test
    public void testEmptyCollection() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new CircularIterator(Collections.emptyList()));
    }

    @Test
    public void testCycleCollection() {
        CircularIterator it = new CircularIterator(Arrays.asList("A", "B", null, "C"));
        Assert.assertEquals((Object)"A", (Object)it.peek());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"A", (Object)it.next());
        Assert.assertEquals((Object)"B", (Object)it.peek());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"B", (Object)it.next());
        Assert.assertEquals(null, (Object)it.peek());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals(null, (Object)it.next());
        Assert.assertEquals((Object)"C", (Object)it.peek());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"C", (Object)it.next());
        Assert.assertEquals((Object)"A", (Object)it.peek());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"A", (Object)it.next());
        Assert.assertEquals((Object)"B", (Object)it.peek());
        Assert.assertEquals((Object)"B", (Object)it.peek());
    }
}

