/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.feature;

import java.util.Map;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class SupportedVersionRangeTest {
    @Test
    public void testFailDueToInvalidParams() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new SupportedVersionRange(0, 0));
        Assert.assertThrows(IllegalArgumentException.class, () -> new SupportedVersionRange(0, 1));
        Assert.assertThrows(IllegalArgumentException.class, () -> new SupportedVersionRange(1, 0));
        Assert.assertThrows(IllegalArgumentException.class, () -> new SupportedVersionRange(2, 1));
    }

    @Test
    public void testFromToMap() {
        SupportedVersionRange versionRange = new SupportedVersionRange(1, 2);
        Assert.assertEquals((long)1L, (long)versionRange.min());
        Assert.assertEquals((long)2L, (long)versionRange.max());
        Map versionRangeMap = versionRange.toMap();
        Assert.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version", (Object)versionRange.min()), Utils.mkEntry((Object)"max_version", (Object)versionRange.max())}), (Object)versionRangeMap);
        SupportedVersionRange newVersionRange = SupportedVersionRange.fromMap((Map)versionRangeMap);
        Assert.assertEquals((long)1L, (long)newVersionRange.min());
        Assert.assertEquals((long)2L, (long)newVersionRange.max());
        Assert.assertEquals((Object)versionRange, (Object)newVersionRange);
    }

    @Test
    public void testFromMapFailure() {
        Map invalidWithBadMinVersion = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version", (Object)0), Utils.mkEntry((Object)"max_version", (Object)1)});
        Assert.assertThrows(IllegalArgumentException.class, () -> SupportedVersionRange.fromMap((Map)invalidWithBadMinVersion));
        Map invalidWithBadMaxVersion = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version", (Object)1), Utils.mkEntry((Object)"max_version", (Object)0)});
        Assert.assertThrows(IllegalArgumentException.class, () -> SupportedVersionRange.fromMap((Map)invalidWithBadMaxVersion));
        Map invalidWithBadMinMaxVersion = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version", (Object)0), Utils.mkEntry((Object)"max_version", (Object)0)});
        Assert.assertThrows(IllegalArgumentException.class, () -> SupportedVersionRange.fromMap((Map)invalidWithBadMinMaxVersion));
        Map invalidWithLowerMaxVersion = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version", (Object)2), Utils.mkEntry((Object)"max_version", (Object)1)});
        Assert.assertThrows(IllegalArgumentException.class, () -> SupportedVersionRange.fromMap((Map)invalidWithLowerMaxVersion));
        Map invalidWithMinKeyMissing = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"max_version", (Object)1)});
        Assert.assertThrows(IllegalArgumentException.class, () -> SupportedVersionRange.fromMap((Map)invalidWithMinKeyMissing));
        Map invalidWithMaxKeyMissing = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version", (Object)1)});
        Assert.assertThrows(IllegalArgumentException.class, () -> SupportedVersionRange.fromMap((Map)invalidWithMaxKeyMissing));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"SupportedVersionRange[min_version:1, max_version:1]", (Object)new SupportedVersionRange(1, 1).toString());
        Assert.assertEquals((Object)"SupportedVersionRange[min_version:1, max_version:2]", (Object)new SupportedVersionRange(1, 2).toString());
    }

    @Test
    public void testEquals() {
        SupportedVersionRange tested = new SupportedVersionRange(1, 1);
        Assert.assertTrue((boolean)tested.equals((Object)tested));
        Assert.assertFalse((boolean)tested.equals((Object)new SupportedVersionRange(1, 2)));
        Assert.assertFalse((boolean)tested.equals(null));
    }

    @Test
    public void testMinMax() {
        SupportedVersionRange versionRange = new SupportedVersionRange(1, 2);
        Assert.assertEquals((long)1L, (long)versionRange.min());
        Assert.assertEquals((long)2L, (long)versionRange.max());
    }
}

