/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.Assert;
import org.junit.Test;

public class DescribeAclsResponseTest {
    private static final short V0 = 0;
    private static final short V1 = 1;
    private static final DescribeAclsResponseData.AclDescription ALLOW_CREATE_ACL = DescribeAclsResponseTest.buildAclDescription("127.0.0.1", "User:ANONYMOUS", AclOperation.CREATE, AclPermissionType.ALLOW);
    private static final DescribeAclsResponseData.AclDescription DENY_READ_ACL = DescribeAclsResponseTest.buildAclDescription("127.0.0.1", "User:ANONYMOUS", AclOperation.READ, AclPermissionType.DENY);
    private static final DescribeAclsResponseData.DescribeAclsResource UNKNOWN_ACL = DescribeAclsResponseTest.buildResource("foo", ResourceType.UNKNOWN, PatternType.LITERAL, Collections.singletonList(DENY_READ_ACL));
    private static final DescribeAclsResponseData.DescribeAclsResource PREFIXED_ACL1 = DescribeAclsResponseTest.buildResource("prefix", ResourceType.GROUP, PatternType.PREFIXED, Collections.singletonList(ALLOW_CREATE_ACL));
    private static final DescribeAclsResponseData.DescribeAclsResource LITERAL_ACL1 = DescribeAclsResponseTest.buildResource("foo", ResourceType.TOPIC, PatternType.LITERAL, Collections.singletonList(ALLOW_CREATE_ACL));
    private static final DescribeAclsResponseData.DescribeAclsResource LITERAL_ACL2 = DescribeAclsResponseTest.buildResource("group", ResourceType.GROUP, PatternType.LITERAL, Collections.singletonList(DENY_READ_ACL));

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowOnV0IfNotLiteral() {
        DescribeAclsResponseTest.buildResponse(10, Errors.NONE, Collections.singletonList(PREFIXED_ACL1)).toStruct((short)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfUnknown() {
        DescribeAclsResponseTest.buildResponse(10, Errors.NONE, Collections.singletonList(UNKNOWN_ACL)).toStruct((short)0);
    }

    @Test
    public void shouldRoundTripV0() {
        List<DescribeAclsResponseData.DescribeAclsResource> resources = Arrays.asList(LITERAL_ACL1, LITERAL_ACL2);
        DescribeAclsResponse original = DescribeAclsResponseTest.buildResponse(10, Errors.NONE, resources);
        Struct struct = original.toStruct((short)0);
        DescribeAclsResponse result = new DescribeAclsResponse(struct, 0);
        DescribeAclsResponseTest.assertResponseEquals(original, result);
        DescribeAclsResponse result2 = DescribeAclsResponseTest.buildResponse(10, Errors.NONE, DescribeAclsResponse.aclsResources((Collection)DescribeAclsResponse.aclBindings(resources)));
        DescribeAclsResponseTest.assertResponseEquals(original, result2);
    }

    @Test
    public void shouldRoundTripV1() {
        List<DescribeAclsResponseData.DescribeAclsResource> resources = Arrays.asList(LITERAL_ACL1, PREFIXED_ACL1);
        DescribeAclsResponse original = DescribeAclsResponseTest.buildResponse(100, Errors.NONE, resources);
        Struct struct = original.toStruct((short)1);
        DescribeAclsResponse result = new DescribeAclsResponse(struct, 1);
        DescribeAclsResponseTest.assertResponseEquals(original, result);
        DescribeAclsResponse result2 = DescribeAclsResponseTest.buildResponse(100, Errors.NONE, DescribeAclsResponse.aclsResources((Collection)DescribeAclsResponse.aclBindings(resources)));
        DescribeAclsResponseTest.assertResponseEquals(original, result2);
    }

    @Test
    public void testAclBindings() {
        AclBinding original = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
        List result = DescribeAclsResponse.aclBindings(Collections.singletonList(LITERAL_ACL1));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)original, result.get(0));
    }

    private static void assertResponseEquals(DescribeAclsResponse original, DescribeAclsResponse actual) {
        HashSet originalBindings = new HashSet(original.acls());
        HashSet actualBindings = new HashSet(actual.acls());
        Assert.assertEquals(originalBindings, actualBindings);
    }

    private static DescribeAclsResponse buildResponse(int throttleTimeMs, Errors error, List<DescribeAclsResponseData.DescribeAclsResource> resources) {
        return new DescribeAclsResponse(new DescribeAclsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setErrorMessage(error.message()).setResources(resources));
    }

    private static DescribeAclsResponseData.DescribeAclsResource buildResource(String name, ResourceType type, PatternType patternType, List<DescribeAclsResponseData.AclDescription> acls) {
        return new DescribeAclsResponseData.DescribeAclsResource().setResourceName(name).setResourceType(type.code()).setPatternType(patternType.code()).setAcls(acls);
    }

    private static DescribeAclsResponseData.AclDescription buildAclDescription(String host, String principal, AclOperation operation, AclPermissionType permission) {
        return new DescribeAclsResponseData.AclDescription().setHost(host).setPrincipal(principal).setOperation(operation.code()).setPermissionType(permission.code());
    }
}

