/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.authorizer;

import java.util.Objects;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.resource.ResourcePattern;

@InterfaceStability.Evolving
public class Action {
    private final ResourcePattern resourcePattern;
    private final AclOperation operation;
    private final int resourceReferenceCount;
    private final boolean logIfAllowed;
    private final boolean logIfDenied;

    public Action(AclOperation operation, ResourcePattern resourcePattern, int resourceReferenceCount, boolean logIfAllowed, boolean logIfDenied) {
        this.operation = operation;
        this.resourcePattern = resourcePattern;
        this.logIfAllowed = logIfAllowed;
        this.logIfDenied = logIfDenied;
        this.resourceReferenceCount = resourceReferenceCount;
    }

    public ResourcePattern resourcePattern() {
        return this.resourcePattern;
    }

    public AclOperation operation() {
        return this.operation;
    }

    public boolean logIfAllowed() {
        return this.logIfAllowed;
    }

    public boolean logIfDenied() {
        return this.logIfDenied;
    }

    public int resourceReferenceCount() {
        return this.resourceReferenceCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action that = (Action)o;
        return Objects.equals(this.resourcePattern, that.resourcePattern) && Objects.equals((Object)this.operation, (Object)that.operation) && this.resourceReferenceCount == that.resourceReferenceCount && this.logIfAllowed == that.logIfAllowed && this.logIfDenied == that.logIfDenied;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourcePattern, this.operation, this.resourceReferenceCount, this.logIfAllowed, this.logIfDenied});
    }

    public String toString() {
        return "Action(, resourcePattern='" + this.resourcePattern + '\'' + ", operation='" + (Object)((Object)this.operation) + '\'' + ", resourceReferenceCount='" + this.resourceReferenceCount + '\'' + ", logIfAllowed='" + this.logIfAllowed + '\'' + ", logIfDenied='" + this.logIfDenied + '\'' + ')';
    }
}

