/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataRequestTest {
    @Test
    public void testEmptyMeansAllTopicsV0() {
        MetadataRequestData data = new MetadataRequestData();
        MetadataRequest parsedRequest = new MetadataRequest(data, 0);
        Assertions.assertTrue((boolean)parsedRequest.isAllTopics());
        Assertions.assertNull((Object)parsedRequest.topics());
    }

    @Test
    public void testEmptyMeansEmptyForVersionsAboveV0() {
        for (int i = 1; i < MetadataRequestData.SCHEMAS.length; ++i) {
            MetadataRequestData data = new MetadataRequestData();
            data.setAllowAutoTopicCreation(true);
            MetadataRequest parsedRequest = new MetadataRequest(data, (short)i);
            Assertions.assertFalse((boolean)parsedRequest.isAllTopics());
            Assertions.assertEquals(Collections.emptyList(), (Object)parsedRequest.topics());
        }
    }

    @Test
    public void testMetadataRequestVersion() {
        MetadataRequest.Builder builder = new MetadataRequest.Builder(Collections.singletonList("topic"), false);
        Assertions.assertEquals((short)ApiKeys.METADATA.oldestVersion(), (short)builder.oldestAllowedVersion());
        Assertions.assertEquals((short)ApiKeys.METADATA.latestVersion(), (short)builder.latestAllowedVersion());
        short version = 5;
        MetadataRequest.Builder builder2 = new MetadataRequest.Builder(Collections.singletonList("topic"), false, version);
        Assertions.assertEquals((short)version, (short)builder2.oldestAllowedVersion());
        Assertions.assertEquals((short)version, (short)builder2.latestAllowedVersion());
        short minVersion = 1;
        short maxVersion = 6;
        MetadataRequest.Builder builder3 = new MetadataRequest.Builder(Collections.singletonList("topic"), false, minVersion, maxVersion);
        Assertions.assertEquals((short)minVersion, (short)builder3.oldestAllowedVersion());
        Assertions.assertEquals((short)maxVersion, (short)builder3.latestAllowedVersion());
    }

    @Test
    public void testTopicIdAndNullTopicNameRequests() {
        List<MetadataRequestData.MetadataRequestTopic> topics = Arrays.asList(new MetadataRequestData.MetadataRequestTopic().setName(null).setTopicId(Uuid.randomUuid()), new MetadataRequestData.MetadataRequestTopic().setName(null), new MetadataRequestData.MetadataRequestTopic().setTopicId(Uuid.randomUuid()), new MetadataRequestData.MetadataRequestTopic().setName("topic").setTopicId(Uuid.randomUuid()));
        List<Short> invalidVersions = Arrays.asList((short)10, (short)11);
        invalidVersions.forEach(version -> topics.forEach(topic -> {
            MetadataRequestData metadataRequestData = new MetadataRequestData().setTopics(Collections.singletonList(topic));
            MetadataRequest.Builder builder = new MetadataRequest.Builder(metadataRequestData);
            Assertions.assertThrows(UnsupportedVersionException.class, () -> builder.build(version.shortValue()));
        }));
    }
}

