/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.DescribeConsumerGroupsHandler;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeConsumerGroupsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final String groupId1 = "group-id1";
    private final String groupId2 = "group-id2";
    private final Set<String> groupIds = new HashSet<String>(Arrays.asList("group-id1", "group-id2"));
    private final Set<CoordinatorKey> keys = this.groupIds.stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet());
    private final Node coordinator = new Node(1, "host", 1234);
    private final Set<TopicPartition> tps = new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 1)));

    @Test
    public void testBuildRequest() {
        DescribeConsumerGroupsHandler handler = new DescribeConsumerGroupsHandler(false, this.logContext);
        DescribeGroupsRequest request = (DescribeGroupsRequest)handler.buildBatchedRequest(1, this.keys).build();
        Assertions.assertEquals((int)2, (int)request.data().groups().size());
        Assertions.assertFalse((boolean)request.data().includeAuthorizedOperations());
        handler = new DescribeConsumerGroupsHandler(true, this.logContext);
        request = (DescribeGroupsRequest)handler.buildBatchedRequest(1, this.keys).build();
        Assertions.assertEquals((int)2, (int)request.data().groups().size());
        Assertions.assertTrue((boolean)request.data().includeAuthorizedOperations());
    }

    @Test
    public void testInvalidBuildRequest() {
        DescribeConsumerGroupsHandler handler = new DescribeConsumerGroupsHandler(false, this.logContext);
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.buildRequest(1, Collections.singleton(CoordinatorKey.byTransactionalId((String)"tId"))));
    }

    @Test
    public void testSuccessfulHandleResponse() {
        List<MemberDescription> members = Collections.singletonList(new MemberDescription("memberId", "clientId", "host", new MemberAssignment(this.tps)));
        ConsumerGroupDescription expected = new ConsumerGroupDescription("group-id1", true, members, "assignor", ConsumerGroupState.STABLE, this.coordinator);
        this.assertCompleted(this.handleWithError(Errors.NONE, ""), expected);
    }

    @Test
    public void testUnmappedHandleResponse() {
        this.assertUnmapped(this.handleWithError(Errors.COORDINATOR_NOT_AVAILABLE, ""));
        this.assertUnmapped(this.handleWithError(Errors.NOT_COORDINATOR, ""));
    }

    @Test
    public void testRetriableHandleResponse() {
        this.assertRetriable(this.handleWithError(Errors.COORDINATOR_LOAD_IN_PROGRESS, ""));
    }

    @Test
    public void testFailedHandleResponse() {
        this.assertFailed(GroupAuthorizationException.class, this.handleWithError(Errors.GROUP_AUTHORIZATION_FAILED, ""));
        this.assertFailed(GroupIdNotFoundException.class, this.handleWithError(Errors.GROUP_ID_NOT_FOUND, ""));
        this.assertFailed(InvalidGroupIdException.class, this.handleWithError(Errors.INVALID_GROUP_ID, ""));
        this.assertFailed(IllegalArgumentException.class, this.handleWithError(Errors.NONE, "custom-protocol"));
    }

    private DescribeGroupsResponse buildResponse(Errors error, String protocolType) {
        DescribeGroupsResponse response = new DescribeGroupsResponse(new DescribeGroupsResponseData().setGroups(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setErrorCode(error.code()).setGroupId("group-id1").setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(protocolType).setProtocolData("assignor").setAuthorizedOperations(Utils.to32BitField(Collections.emptySet())).setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setClientHost("host").setClientId("clientId").setMemberId("memberId").setMemberAssignment(ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(new ArrayList<TopicPartition>(this.tps))).array()))))));
        return response;
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> handleWithError(Errors error, String protocolType) {
        DescribeConsumerGroupsHandler handler = new DescribeConsumerGroupsHandler(true, this.logContext);
        DescribeGroupsResponse response = this.buildResponse(error, protocolType);
        return handler.handleResponse(this.coordinator, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id1")), (AbstractResponse)response);
    }

    private void assertUnmapped(AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(CoordinatorKey.byGroupId((String)"group-id1")), (Object)result.unmappedKeys);
    }

    private void assertRetriable(AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    private void assertCompleted(AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> result, ConsumerGroupDescription expected) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id1");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Assertions.assertEquals((Object)expected, result.completedKeys.get(CoordinatorKey.byGroupId((String)"group-id1")));
    }

    private void assertFailed(Class<? extends Throwable> expectedExceptionType, AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id1");
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Assertions.assertTrue((boolean)expectedExceptionType.isInstance(result.failedKeys.get(key)));
    }
}

