/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.ExponentialBackoff;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExponentialBackoffTest {
    @Test
    public void testExponentialBackoff() {
        long scaleFactor = 100L;
        int ratio = 2;
        long backoffMax = 2000L;
        double jitter = 0.2;
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(scaleFactor, ratio, backoffMax, jitter);
        for (int i = 0; i <= 100; ++i) {
            for (int attempts = 0; attempts <= 10; ++attempts) {
                if (attempts <= 4) {
                    Assertions.assertEquals((double)((double)scaleFactor * Math.pow(ratio, attempts)), (double)exponentialBackoff.backoff((long)attempts), (double)((double)scaleFactor * Math.pow(ratio, attempts) * jitter));
                    continue;
                }
                Assertions.assertTrue(((double)exponentialBackoff.backoff((long)attempts) <= (double)backoffMax * (1.0 + jitter) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testExponentialBackoffWithoutJitter() {
        ExponentialBackoff exponentialBackoff = new ExponentialBackoff(100L, 2, 400L, 0.0);
        Assertions.assertEquals((long)100L, (long)exponentialBackoff.backoff(0L));
        Assertions.assertEquals((long)200L, (long)exponentialBackoff.backoff(1L));
        Assertions.assertEquals((long)400L, (long)exponentialBackoff.backoff(2L));
        Assertions.assertEquals((long)400L, (long)exponentialBackoff.backoff(3L));
    }
}

