/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.admin.AbortTransactionResult;
import org.apache.kafka.clients.admin.AbortTransactionSpec;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AdminClientUnitTestEnv;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.AlterUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ClientMetricsResourceListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeFeaturesOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeProducersOptions;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.DescribeTransactionsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.EndpointType;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FenceProducersResult;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListClientMetricsResourcesResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.ListTransactionsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.ReplicaInfo;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.admin.TransactionDescription;
import org.apache.kafka.clients.admin.TransactionListing;
import org.apache.kafka.clients.admin.TransactionState;
import org.apache.kafka.clients.admin.UnregisterBrokerOptions;
import org.apache.kafka.clients.admin.UnregisterBrokerResult;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LogDirNotFoundException;
import org.apache.kafka.common.errors.MismatchedEndpointTypeException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterReplicaLogDirsResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.GetTelemetrySubscriptionsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListClientMetricsResourcesResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.WriteTxnMarkersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeClientQuotasResponse;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.DescribeProducersResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.DescribeTransactionsRequest;
import org.apache.kafka.common.requests.DescribeTransactionsResponse;
import org.apache.kafka.common.requests.DescribeUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.GetTelemetrySubscriptionsRequest;
import org.apache.kafka.common.requests.GetTelemetrySubscriptionsResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListClientMetricsResourcesRequest;
import org.apache.kafka.common.requests.ListClientMetricsResourcesResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ListTransactionsRequest;
import org.apache.kafka.common.requests.ListTransactionsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=120L)
public class KafkaAdminClientTest {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdminClientTest.class);
    private static final String GROUP_ID = "group-0";
    private static final int THROTTLE = 10;
    private static final AclBinding ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
    private static final AclBinding ACL2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic4", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.DENY));
    private static final AclBindingFilter FILTER1 = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), new AccessControlEntryFilter("User:ANONYMOUS", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter FILTER2 = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter UNKNOWN_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, null, PatternType.LITERAL), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));

    @Test
    public void testDefaultApiTimeoutAndRequestTimeoutConflicts() {
        AdminClientConfig config = KafkaAdminClientTest.newConfMap("default.api.timeout.ms", "500");
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> KafkaAdminClient.createInternal((AdminClientConfig)config, null));
        Assertions.assertTrue((boolean)(exception.getCause() instanceof ConfigException));
    }

    @Test
    public void testParseDescribeClusterResponseWithError() {
        Assertions.assertThrows(MismatchedEndpointTypeException.class, () -> KafkaAdminClient.parseDescribeClusterResponse((DescribeClusterResponseData)new DescribeClusterResponseData().setErrorCode(Errors.MISMATCHED_ENDPOINT_TYPE.code()).setErrorMessage("The request was sent to an endpoint of type BROKER, but we wanted an endpoint of type CONTROLLER")));
    }

    @Test
    public void testParseDescribeClusterResponseWithUnexpectedEndpointType() {
        Assertions.assertThrows(MismatchedEndpointTypeException.class, () -> KafkaAdminClient.parseDescribeClusterResponse((DescribeClusterResponseData)new DescribeClusterResponseData().setEndpointType(EndpointType.BROKER.id())));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testParseSuccessfulDescribeClusterResponse(boolean includeController) {
        Cluster cluster = KafkaAdminClient.parseDescribeClusterResponse((DescribeClusterResponseData)new DescribeClusterResponseData().setControllerId(includeController ? 0 : -1).setEndpointType(EndpointType.CONTROLLER.id()).setClusterId("Ek8tjqq1QBWfnaoyHFZqDg").setBrokers(new DescribeClusterResponseData.DescribeClusterBrokerCollection(Arrays.asList(new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(0).setHost("controller0.com").setPort(9092), new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(1).setHost("controller1.com").setPort(9092), new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(2).setHost("controller2.com").setPort(9092)).iterator())));
        if (includeController) {
            Assertions.assertNotNull((Object)cluster.controller());
            Assertions.assertEquals((int)0, (int)cluster.controller().id());
        } else {
            Assertions.assertNull((Object)cluster.controller());
        }
        Assertions.assertEquals((Object)"Ek8tjqq1QBWfnaoyHFZqDg", (Object)cluster.clusterResource().clusterId());
        Assertions.assertEquals(new HashSet<Node>(Arrays.asList(new Node(0, "controller0.com", 9092), new Node(1, "controller1.com", 9092), new Node(2, "controller2.com", 9092))), new HashSet(cluster.nodes()));
    }

    @Test
    public void testGetOrCreateListValue() {
        HashMap map = new HashMap();
        List fooList = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assertions.assertNotNull((Object)fooList);
        fooList.add("a");
        fooList.add("b");
        List fooList2 = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assertions.assertEquals((Object)fooList, (Object)fooList2);
        Assertions.assertTrue((boolean)fooList2.contains("a"));
        Assertions.assertTrue((boolean)fooList2.contains("b"));
        List barList = KafkaAdminClient.getOrCreateListValue(map, (Object)"bar");
        Assertions.assertNotNull((Object)barList);
        Assertions.assertTrue((boolean)barList.isEmpty());
    }

    @Test
    public void testCalcTimeoutMsRemainingAsInt() {
        Assertions.assertEquals((int)0, (int)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1000L));
        Assertions.assertEquals((int)100, (int)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1100L));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)0L, (long)Long.MAX_VALUE));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)Long.MAX_VALUE, (long)0L));
    }

    @Test
    public void testPrettyPrintException() {
        Assertions.assertEquals((Object)"Null exception.", (Object)KafkaAdminClient.prettyPrintException(null));
        Assertions.assertEquals((Object)"TimeoutException", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException()));
        Assertions.assertEquals((Object)"TimeoutException: The foobar timed out.", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException("The foobar timed out.")));
    }

    private static Map<String, Object> newStrMap(String ... vals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", "localhost:8121");
        map.put("request.timeout.ms", "1000");
        if (vals.length % 2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < vals.length; i += 2) {
            map.put(vals[i], vals[i + 1]);
        }
        return map;
    }

    private static AdminClientConfig newConfMap(String ... vals) {
        return new AdminClientConfig(KafkaAdminClientTest.newStrMap(vals));
    }

    @Test
    public void testGenerateClientId() {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            String id = KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", ""));
            Assertions.assertFalse((boolean)ids.contains(id), (String)("Got duplicate id " + id));
            ids.add(id);
        }
        Assertions.assertEquals((Object)"myCustomId", (Object)KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", "myCustomId")));
    }

    @Test
    public void testMetricsReporterAutoGeneratedClientId() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        MockMetricsReporter mockMetricsReporter = (MockMetricsReporter)admin.metrics.reporters().get(0);
        Assertions.assertEquals((Object)admin.getClientId(), (Object)mockMetricsReporter.clientId);
        Assertions.assertEquals((int)2, (int)admin.metrics.reporters().size());
        admin.close();
    }

    @Test
    public void testDisableJmxReporter() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("auto.include.jmx.reporter", "false");
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        Assertions.assertTrue((boolean)admin.metrics.reporters().isEmpty());
        admin.close();
    }

    @Test
    public void testExplicitlyEnableJmxReporter() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", "org.apache.kafka.common.metrics.JmxReporter");
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        Assertions.assertEquals((int)1, (int)admin.metrics.reporters().size());
        admin.close();
    }

    private static Cluster mockCluster(int numNodes, int controllerIndex) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.put(i, new Node(i, "localhost", 8121 + i));
        }
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(controllerIndex));
    }

    private static Cluster mockBootstrapCluster() {
        return Cluster.bootstrap((List)ClientUtils.parseAndValidateAddresses(Collections.singletonList("localhost:8121"), (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS));
    }

    private static AdminClientUnitTestEnv mockClientEnv(String ... configVals) {
        return new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(3, 0), configVals);
    }

    private static AdminClientUnitTestEnv mockClientEnv(Time time, String ... configVals) {
        return new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0), configVals);
    }

    @Test
    public void testCloseAdminClient() {
        AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);
        Throwable throwable = null;
        if (env != null) {
            if (throwable != null) {
                try {
                    env.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                env.close();
            }
        }
    }

    @Test
    @Timeout(value=10L)
    public void testCloseAdminClientInCallback() throws InterruptedException {
        MockTime time = new MockTime();
        AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));
        ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(1000)));
        KafkaFuture kafkaFuture = result.listings();
        Semaphore callbackCalled = new Semaphore(0);
        kafkaFuture.whenComplete((topicListings, throwable) -> {
            env.close();
            callbackCalled.release();
        });
        time.sleep(2000L);
        callbackCalled.acquire();
    }

    @Test
    public void testAdminClientFailureWhenClosed() {
        MockTime time = new MockTime();
        AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));
        env.adminClient().close();
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all().get();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof IllegalStateException), (String)("Expected an IllegalStateException error, but got " + Utils.stackTrace((Throwable)e)));
    }

    private static OffsetDeleteResponse prepareOffsetDeleteResponse(Errors error) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData().setErrorCode(error.code()).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection()));
    }

    private static OffsetDeleteResponse prepareOffsetDeleteResponse(String topic, int partition, Errors error) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData().setErrorCode(Errors.NONE.code()).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Stream.of(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topic).setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition).setErrorCode(error.code())).iterator()))).collect(Collectors.toList()).iterator())));
    }

    private static OffsetCommitResponse prepareOffsetCommitResponse(TopicPartition tp, Errors error) {
        HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
        responseData.put(tp, error);
        return new OffsetCommitResponse(0, responseData);
    }

    private static CreateTopicsResponse prepareCreateTopicsResponse(String topicName, Errors error) {
        CreateTopicsResponseData data = new CreateTopicsResponseData();
        data.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topicName).setErrorCode(error.code()));
        return new CreateTopicsResponse(data);
    }

    public static CreateTopicsResponse prepareCreateTopicsResponse(int throttleTimeMs, CreateTopicsResponseData.CreatableTopicResult ... topics) {
        CreateTopicsResponseData data = new CreateTopicsResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(new CreateTopicsResponseData.CreatableTopicResultCollection(Arrays.stream(topics).iterator()));
        return new CreateTopicsResponse(data);
    }

    public static CreateTopicsResponseData.CreatableTopicResult creatableTopicResult(String name, Errors error) {
        return new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(error.code());
    }

    public static DeleteTopicsResponse prepareDeleteTopicsResponse(int throttleTimeMs, DeleteTopicsResponseData.DeletableTopicResult ... topics) {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData().setThrottleTimeMs(throttleTimeMs).setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(Arrays.stream(topics).iterator()));
        return new DeleteTopicsResponse(data);
    }

    public static DeleteTopicsResponseData.DeletableTopicResult deletableTopicResult(String topicName, Errors error) {
        return new DeleteTopicsResponseData.DeletableTopicResult().setName(topicName).setErrorCode(error.code());
    }

    public static DeleteTopicsResponseData.DeletableTopicResult deletableTopicResultWithId(Uuid topicId, Errors error) {
        return new DeleteTopicsResponseData.DeletableTopicResult().setTopicId(topicId).setErrorCode(error.code());
    }

    public static CreatePartitionsResponse prepareCreatePartitionsResponse(int throttleTimeMs, CreatePartitionsResponseData.CreatePartitionsTopicResult ... topics) {
        CreatePartitionsResponseData data = new CreatePartitionsResponseData().setThrottleTimeMs(throttleTimeMs).setResults(Arrays.asList(topics));
        return new CreatePartitionsResponse(data);
    }

    public static CreatePartitionsResponseData.CreatePartitionsTopicResult createPartitionsTopicResult(String name, Errors error) {
        return KafkaAdminClientTest.createPartitionsTopicResult(name, error, null);
    }

    public static CreatePartitionsResponseData.CreatePartitionsTopicResult createPartitionsTopicResult(String name, Errors error, String errorMessage) {
        return new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(name).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    private static DeleteTopicsResponse prepareDeleteTopicsResponse(String topicName, Errors error) {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData();
        data.responses().add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setName(topicName).setErrorCode(error.code()));
        return new DeleteTopicsResponse(data);
    }

    private static DeleteTopicsResponse prepareDeleteTopicsResponseWithTopicId(Uuid id, Errors error) {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData();
        data.responses().add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setTopicId(id).setErrorCode(error.code()));
        return new DeleteTopicsResponse(data);
    }

    private static FindCoordinatorResponse prepareFindCoordinatorResponse(Errors error, Node node) {
        return KafkaAdminClientTest.prepareFindCoordinatorResponse(error, GROUP_ID, node);
    }

    private static FindCoordinatorResponse prepareFindCoordinatorResponse(Errors error, String key, Node node) {
        return FindCoordinatorResponse.prepareResponse((Errors)error, (String)key, (Node)node);
    }

    private static FindCoordinatorResponse prepareOldFindCoordinatorResponse(Errors error, Node node) {
        return FindCoordinatorResponse.prepareOldResponse((Errors)error, (Node)node);
    }

    private static FindCoordinatorResponse prepareBatchedFindCoordinatorResponse(Errors error, Node node, Collection<String> groups) {
        FindCoordinatorResponseData data = new FindCoordinatorResponseData();
        List coordinators = groups.stream().map(group -> new FindCoordinatorResponseData.Coordinator().setErrorCode(error.code()).setErrorMessage(error.message()).setKey(group).setHost(node.host()).setPort(node.port()).setNodeId(node.id())).collect(Collectors.toList());
        data.setCoordinators(coordinators);
        return new FindCoordinatorResponse(data);
    }

    private static MetadataResponse prepareMetadataResponse(Cluster cluster, Errors error) {
        return KafkaAdminClientTest.prepareMetadataResponse(cluster, error, error);
    }

    private static MetadataResponse prepareMetadataResponse(Cluster cluster, Errors topicError, Errors partitionError) {
        ArrayList<MetadataResponseData.MetadataResponseTopic> metadata = new ArrayList<MetadataResponseData.MetadataResponseTopic>();
        for (String topic : cluster.topics()) {
            ArrayList<MetadataResponseData.MetadataResponsePartition> pms = new ArrayList<MetadataResponseData.MetadataResponsePartition>();
            for (PartitionInfo pInfo : cluster.availablePartitionsForTopic(topic)) {
                MetadataResponseData.MetadataResponsePartition pm = new MetadataResponseData.MetadataResponsePartition().setErrorCode(partitionError.code()).setPartitionIndex(pInfo.partition()).setLeaderId(pInfo.leader().id()).setLeaderEpoch(234).setReplicaNodes(Arrays.stream(pInfo.replicas()).map(Node::id).collect(Collectors.toList())).setIsrNodes(Arrays.stream(pInfo.inSyncReplicas()).map(Node::id).collect(Collectors.toList())).setOfflineReplicas(Arrays.stream(pInfo.offlineReplicas()).map(Node::id).collect(Collectors.toList()));
                pms.add(pm);
            }
            MetadataResponseData.MetadataResponseTopic tm = new MetadataResponseData.MetadataResponseTopic().setErrorCode(topicError.code()).setName(topic).setIsInternal(false).setPartitions(pms);
            metadata.add(tm);
        }
        return MetadataResponse.prepareResponse((boolean)true, (int)0, (Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), metadata, (int)Integer.MIN_VALUE);
    }

    private static DescribeGroupsResponseData prepareDescribeGroupsResponseData(String groupId, List<String> groupInstances, List<TopicPartition> topicPartitions) {
        ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
        List describedGroupMembers = groupInstances.stream().map(groupInstance -> DescribeGroupsResponse.groupMember((String)"", (String)groupInstance, (String)"clientId0", (String)"clientHost", (byte[])new byte[memberAssignment.remaining()], null)).collect(Collectors.toList());
        DescribeGroupsResponseData data = new DescribeGroupsResponseData();
        data.groups().add(DescribeGroupsResponse.groupMetadata((String)groupId, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", describedGroupMembers, Collections.emptySet()));
        return data;
    }

    private static FeatureMetadata defaultFeatureMetadata() {
        return new FeatureMetadata(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new FinalizedVersionRange(2, 2))}), Optional.of(1L), Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new SupportedVersionRange(1, 5))}));
    }

    private static Features<org.apache.kafka.common.feature.SupportedVersionRange> convertSupportedFeaturesMap(Map<String, SupportedVersionRange> features) {
        HashMap<String, org.apache.kafka.common.feature.SupportedVersionRange> featuresMap = new HashMap<String, org.apache.kafka.common.feature.SupportedVersionRange>();
        for (Map.Entry<String, SupportedVersionRange> entry : features.entrySet()) {
            SupportedVersionRange versionRange = entry.getValue();
            featuresMap.put(entry.getKey(), new org.apache.kafka.common.feature.SupportedVersionRange(versionRange.minVersion(), versionRange.maxVersion()));
        }
        return Features.supportedFeatures(featuresMap);
    }

    private static ApiVersionsResponse prepareApiVersionsResponseForDescribeFeatures(Errors error) {
        if (error == Errors.NONE) {
            return ApiVersionsResponse.createApiVersionsResponse((int)0, (ApiVersionsResponseData.ApiVersionCollection)ApiVersionsResponse.filterApis((RecordVersion)RecordVersion.current(), (ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER), KafkaAdminClientTest.convertSupportedFeaturesMap(KafkaAdminClientTest.defaultFeatureMetadata().supportedFeatures()), Collections.singletonMap("test_feature_1", (short)2), (long)((Long)KafkaAdminClientTest.defaultFeatureMetadata().finalizedFeaturesEpoch().get()), (boolean)false);
        }
        return new ApiVersionsResponse(new ApiVersionsResponseData().setThrottleTimeMs(0).setErrorCode(error.code()));
    }

    private static QuorumInfo defaultQuorumInfo(boolean emptyOptionals) {
        return new QuorumInfo(1, 1L, 1L, Collections.singletonList(new QuorumInfo.ReplicaState(1, 100L, emptyOptionals ? OptionalLong.empty() : OptionalLong.of(1000L), emptyOptionals ? OptionalLong.empty() : OptionalLong.of(1000L))), Collections.singletonList(new QuorumInfo.ReplicaState(1, 100L, emptyOptionals ? OptionalLong.empty() : OptionalLong.of(1000L), emptyOptionals ? OptionalLong.empty() : OptionalLong.of(1000L))));
    }

    private static DescribeQuorumResponse prepareDescribeQuorumResponse(Errors topLevelError, Errors partitionLevelError, Boolean topicCountError, Boolean topicNameError, Boolean partitionCountError, Boolean partitionIndexError, Boolean emptyOptionals) {
        int i;
        String topicName = topicNameError != false ? "RANDOM" : "__cluster_metadata";
        Integer partitionIndex = partitionIndexError != false ? 1 : Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition();
        ArrayList<DescribeQuorumResponseData.TopicData> topics = new ArrayList<DescribeQuorumResponseData.TopicData>();
        ArrayList<DescribeQuorumResponseData.PartitionData> partitions = new ArrayList<DescribeQuorumResponseData.PartitionData>();
        for (i = 0; i < (partitionCountError != false ? 2 : 1); ++i) {
            DescribeQuorumResponseData.ReplicaState replica = new DescribeQuorumResponseData.ReplicaState().setReplicaId(1).setLogEndOffset(100L);
            replica.setLastFetchTimestamp(emptyOptionals != false ? -1L : 1000L);
            replica.setLastCaughtUpTimestamp(emptyOptionals != false ? -1L : 1000L);
            partitions.add(new DescribeQuorumResponseData.PartitionData().setPartitionIndex(partitionIndex.intValue()).setLeaderId(1).setLeaderEpoch(1).setHighWatermark(1L).setCurrentVoters(Collections.singletonList(replica)).setObservers(Collections.singletonList(replica)).setErrorCode(partitionLevelError.code()));
        }
        for (i = 0; i < (topicCountError != false ? 2 : 1); ++i) {
            topics.add(new DescribeQuorumResponseData.TopicData().setTopicName(topicName).setPartitions(partitions));
        }
        return new DescribeQuorumResponse(new DescribeQuorumResponseData().setTopics(topics).setErrorCode(topLevelError.code()));
    }

    @Test
    public void testTimeoutWithoutMetadata() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, KafkaAdminClientTest.mockBootstrapCluster(), KafkaAdminClientTest.newStrMap("request.timeout.ms", "10"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            TestUtils.assertFutureError(future, TimeoutException.class);
        }
    }

    @Test
    public void testConnectionFailureOnMetadataUpdate() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockBootstrapCluster();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster);){
            Cluster discoveredCluster = KafkaAdminClientTest.mockCluster(3, 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, null, true);
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)RequestTestUtils.metadataResponse(discoveredCluster.nodes(), discoveredCluster.clusterResource().clusterId(), 1, Collections.emptyList()));
            env.kafkaClient().prepareResponse(body -> body instanceof CreateTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testUnreachableBootstrapServer() throws Exception {
        Cluster cluster = Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 8121)));
        Map<Node, Long> unreachableNodes = Collections.singletonMap(cluster.nodes().get(0), 200L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster, AdminClientUnitTestEnv.clientConfigs(new String[0]), unreachableNodes);){
            Cluster discoveredCluster = KafkaAdminClientTest.mockCluster(3, 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(body -> body instanceof MetadataRequest, (AbstractResponse)RequestTestUtils.metadataResponse(discoveredCluster.nodes(), discoveredCluster.clusterResource().clusterId(), 1, Collections.emptyList()));
            env.kafkaClient().prepareResponse(body -> body instanceof CreateTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testPropagatedMetadataFetchException() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("bootstrap.servers", "localhost:8121", "request.timeout.ms", "10"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().createPendingAuthenticationError(env.cluster().nodeById(0), TimeUnit.DAYS.toMillis(1L));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            TestUtils.assertFutureError(future, SaslAuthenticationException.class);
        }
    }

    @Test
    public void testCreateTopics() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testCreateTopicsPartialResponse() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("myTopic", "myTopic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            CreateTopicsResult topicsResult = env.adminClient().createTopics(Arrays.asList(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2))), new NewTopic("myTopic2", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000)));
            ((KafkaFuture)topicsResult.values().get("myTopic")).get();
            TestUtils.assertFutureThrows((Future)topicsResult.values().get("myTopic2"), ApiException.class);
        }
    }

    @Test
    public void testCreateTopicsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return body instanceof CreateTopicsRequest;
            }, null, true);
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return body instanceof CreateTopicsRequest;
            }, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting CreateTopics first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry CreateTopics call");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"CreateTopics retry did not await expected backoff");
        }
    }

    @Test
    public void testCreateTopicsHandleNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE), env.cluster().nodeById(1));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testCreateTopicsRetryThrottlingExceptionWhenEnabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.creatableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(0, KafkaAdminClientTest.creatableTopicResult("topic2", Errors.NONE)));
            CreateTopicsResult result = env.adminClient().createTopics(Arrays.asList(new NewTopic("topic1", 1, 1), new NewTopic("topic2", 1, 1), new NewTopic("topic3", 1, 1)), new CreateTopicsOptions().retryOnQuotaViolation(true));
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic2")).get());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testCreateTopicsRetryThrottlingExceptionWhenEnabledUntilRequestTimeOut() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "default.api.timeout.ms", String.valueOf(defaultApiTimeout));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.creatableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            CreateTopicsResult result = env.adminClient().createTopics(Arrays.asList(new NewTopic("topic1", 1, 1), new NewTopic("topic2", 1, 1), new NewTopic("topic3", 1, 1)), new CreateTopicsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting CreateTopics requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next CreateTopics request");
            time.sleep(defaultApiTimeout + 1L);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assertions.assertEquals((int)0, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testCreateTopicsDontRetryThrottlingExceptionWhenDisabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreateTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse(1000, KafkaAdminClientTest.creatableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.creatableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.creatableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            CreateTopicsResult result = env.adminClient().createTopics(Arrays.asList(new NewTopic("topic1", 1, 1), new NewTopic("topic2", 1, 1), new NewTopic("topic3", 1, 1)), new CreateTopicsOptions().retryOnQuotaViolation(false));
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assertions.assertEquals((int)1000, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    private MockClient.RequestMatcher expectCreateTopicsRequestWithTopics(String ... topics) {
        return body -> {
            if (body instanceof CreateTopicsRequest) {
                CreateTopicsRequest request = (CreateTopicsRequest)body;
                for (String topic : topics) {
                    if (request.data().topics().find(topic) != null) continue;
                    return false;
                }
                return topics.length == request.data().topics().size();
            }
            return false;
        };
    }

    @Test
    public void testDeleteTopics() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            Assertions.assertNull((Object)future.get());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.TOPIC_DELETION_DISABLED));
            future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureError(future, TopicDeletionDisabledException.class);
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.UNKNOWN_TOPIC_OR_PARTITION));
            future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureError(future, UnknownTopicOrPartitionException.class);
            Uuid topicId = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponseWithTopicId(topicId, Errors.NONE));
            future = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(topicId)), new DeleteTopicsOptions()).all();
            Assertions.assertNull((Object)future.get());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponseWithTopicId(topicId, Errors.TOPIC_DELETION_DISABLED));
            future = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(topicId)), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureError(future, TopicDeletionDisabledException.class);
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponseWithTopicId(topicId, Errors.UNKNOWN_TOPIC_ID));
            future = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(topicId)), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureError(future, UnknownTopicIdException.class);
        }
    }

    @Test
    public void testDeleteTopicsPartialResponse() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("myTopic", "myOtherTopic"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("myTopic", Errors.NONE)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("myTopic", "myOtherTopic"), new DeleteTopicsOptions());
            ((KafkaFuture)result.topicNameValues().get("myTopic")).get();
            TestUtils.assertFutureThrows((Future)result.topicNameValues().get("myOtherTopic"), ApiException.class);
            Uuid topicId1 = Uuid.randomUuid();
            Uuid topicId2 = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId1, topicId2), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId1, Errors.NONE)));
            DeleteTopicsResult resultIds = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Arrays.asList(topicId1, topicId2)), new DeleteTopicsOptions());
            ((KafkaFuture)resultIds.topicIdValues().get(topicId1)).get();
            TestUtils.assertFutureThrows((Future)resultIds.topicIdValues().get(topicId2), ApiException.class);
        }
    }

    @Test
    public void testDeleteTopicsRetryThrottlingExceptionWhenEnabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(0, KafkaAdminClientTest.deletableTopicResult("topic2", Errors.NONE)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("topic1", "topic2", "topic3"), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            Assertions.assertNull((Object)((KafkaFuture)result.topicNameValues().get("topic1")).get());
            Assertions.assertNull((Object)((KafkaFuture)result.topicNameValues().get("topic2")).get());
            TestUtils.assertFutureThrows((Future)result.topicNameValues().get("topic3"), TopicExistsException.class);
            Uuid topicId1 = Uuid.randomUuid();
            Uuid topicId2 = Uuid.randomUuid();
            Uuid topicId3 = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId1, topicId2, topicId3), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId1, Errors.NONE), KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResultWithId(topicId3, Errors.UNKNOWN_TOPIC_ID)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId2), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId2), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(0, KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.NONE)));
            DeleteTopicsResult resultIds = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Arrays.asList(topicId1, topicId2, topicId3)), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            Assertions.assertNull((Object)((KafkaFuture)resultIds.topicIdValues().get(topicId1)).get());
            Assertions.assertNull((Object)((KafkaFuture)resultIds.topicIdValues().get(topicId2)).get());
            TestUtils.assertFutureThrows((Future)resultIds.topicIdValues().get(topicId3), UnknownTopicIdException.class);
        }
    }

    @Test
    public void testDeleteTopicsRetryThrottlingExceptionWhenEnabledUntilRequestTimeOut() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "default.api.timeout.ms", String.valueOf(defaultApiTimeout));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("topic1", "topic2", "topic3"), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting DeleteTopics requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next DeleteTopics request");
            time.sleep(defaultApiTimeout + 1L);
            Assertions.assertNull((Object)((KafkaFuture)result.topicNameValues().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.topicNameValues().get("topic2"), ThrottlingQuotaExceededException.class);
            Assertions.assertEquals((int)0, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.topicNameValues().get("topic3"), TopicExistsException.class);
            Uuid topicId1 = Uuid.randomUuid();
            Uuid topicId2 = Uuid.randomUuid();
            Uuid topicId3 = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId1, topicId2, topicId3), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId1, Errors.NONE), KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResultWithId(topicId3, Errors.UNKNOWN_TOPIC_ID)));
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId2), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED)));
            DeleteTopicsResult resultIds = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Arrays.asList(topicId1, topicId2, topicId3)), new DeleteTopicsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting DeleteTopics requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next DeleteTopics request");
            time.sleep(defaultApiTimeout + 1L);
            Assertions.assertNull((Object)((KafkaFuture)resultIds.topicIdValues().get(topicId1)).get());
            e = TestUtils.assertFutureThrows((Future)resultIds.topicIdValues().get(topicId2), ThrottlingQuotaExceededException.class);
            Assertions.assertEquals((int)0, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)resultIds.topicIdValues().get(topicId3), UnknownTopicIdException.class);
        }
    }

    @Test
    public void testDeleteTopicsDontRetryThrottlingExceptionWhenDisabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.deletableTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            DeleteTopicsResult result = env.adminClient().deleteTopics(Arrays.asList("topic1", "topic2", "topic3"), new DeleteTopicsOptions().retryOnQuotaViolation(false));
            Assertions.assertNull((Object)((KafkaFuture)result.topicNameValues().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.topicNameValues().get("topic2"), ThrottlingQuotaExceededException.class);
            Assertions.assertEquals((int)1000, (int)e.throttleTimeMs());
            TestUtils.assertFutureError((Future)result.topicNameValues().get("topic3"), TopicExistsException.class);
            Uuid topicId1 = Uuid.randomUuid();
            Uuid topicId2 = Uuid.randomUuid();
            Uuid topicId3 = Uuid.randomUuid();
            env.kafkaClient().prepareResponse(this.expectDeleteTopicsRequestWithTopicIds(topicId1, topicId2, topicId3), (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse(1000, KafkaAdminClientTest.deletableTopicResultWithId(topicId1, Errors.NONE), KafkaAdminClientTest.deletableTopicResultWithId(topicId2, Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.deletableTopicResultWithId(topicId3, Errors.UNKNOWN_TOPIC_ID)));
            DeleteTopicsResult resultIds = env.adminClient().deleteTopics((TopicCollection)TopicCollection.ofTopicIds(Arrays.asList(topicId1, topicId2, topicId3)), new DeleteTopicsOptions().retryOnQuotaViolation(false));
            Assertions.assertNull((Object)((KafkaFuture)resultIds.topicIdValues().get(topicId1)).get());
            e = TestUtils.assertFutureThrows((Future)resultIds.topicIdValues().get(topicId2), ThrottlingQuotaExceededException.class);
            Assertions.assertEquals((int)1000, (int)e.throttleTimeMs());
            TestUtils.assertFutureError((Future)resultIds.topicIdValues().get(topicId3), UnknownTopicIdException.class);
        }
    }

    private MockClient.RequestMatcher expectDeleteTopicsRequestWithTopics(String ... topics) {
        return body -> {
            if (body instanceof DeleteTopicsRequest) {
                DeleteTopicsRequest request = (DeleteTopicsRequest)body;
                return request.topicNames().equals(Arrays.asList(topics));
            }
            return false;
        };
    }

    private MockClient.RequestMatcher expectDeleteTopicsRequestWithTopicIds(Uuid ... topicIds) {
        return body -> {
            if (body instanceof DeleteTopicsRequest) {
                DeleteTopicsRequest request = (DeleteTopicsRequest)body;
                return request.topicIds().equals(Arrays.asList(topicIds));
            }
            return false;
        };
    }

    @Test
    public void testInvalidTopicNames() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            List<String> sillyTopicNames = Arrays.asList("", null);
            Map deleteFutures = env.adminClient().deleteTopics(sillyTopicNames).topicNameValues();
            for (String string : sillyTopicNames) {
                TestUtils.assertFutureError((Future)deleteFutures.get(string), InvalidTopicException.class);
            }
            Assertions.assertEquals((int)0, (int)env.kafkaClient().inFlightRequestCount());
            Map describeFutures = env.adminClient().describeTopics(sillyTopicNames).topicNameValues();
            for (String string : sillyTopicNames) {
                TestUtils.assertFutureError((Future)describeFutures.get(string), InvalidTopicException.class);
            }
            Assertions.assertEquals((int)0, (int)env.kafkaClient().inFlightRequestCount());
            ArrayList<NewTopic> arrayList = new ArrayList<NewTopic>();
            for (String sillyTopicName : sillyTopicNames) {
                arrayList.add(new NewTopic(sillyTopicName, 1, 1));
            }
            Map map = env.adminClient().createTopics(arrayList).values();
            for (String sillyTopicName : sillyTopicNames) {
                TestUtils.assertFutureError((Future)map.get(sillyTopicName), InvalidTopicException.class);
            }
            Assertions.assertEquals((int)0, (int)env.kafkaClient().inFlightRequestCount());
        }
    }

    @Test
    public void testMetadataRetries() throws Exception {
        String topic = "topic";
        Cluster bootstrapCluster = Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9999)));
        Cluster initializedCluster = KafkaAdminClientTest.mockCluster(3, 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, bootstrapCluster, KafkaAdminClientTest.newStrMap("bootstrap.servers", "localhost:9999", "default.api.timeout.ms", "10000000", "retries", "0"));){
            env.kafkaClient().prepareResponse(null, true);
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(initializedCluster.nodes(), initializedCluster.clusterResource().clusterId(), initializedCluster.controller().id(), Collections.emptyList()));
            Node leader = (Node)initializedCluster.nodes().get(0);
            MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition(topic, 0), Optional.of(leader.id()), Optional.of(10), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(initializedCluster.nodes(), initializedCluster.clusterResource().clusterId(), 1, Collections.singletonList(new MetadataResponse.TopicMetadata(Errors.NONE, topic, Uuid.ZERO_UUID, false, Collections.singletonList(partitionMetadata), Integer.MIN_VALUE))));
            DescribeTopicsResult result = env.adminClient().describeTopics(Collections.singleton(topic));
            Map topicDescriptions = (Map)result.allTopicNames().get();
            Assertions.assertEquals((Object)leader, (Object)((TopicPartitionInfo)((TopicDescription)topicDescriptions.get(topic)).partitions().get(0)).leader());
            Assertions.assertNull((Object)((TopicDescription)topicDescriptions.get(topic)).authorizedOperations());
        }
    }

    @Test
    public void testAdminClientApisAuthenticationFailure() {
        Cluster cluster = KafkaAdminClientTest.mockBootstrapCluster();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster, KafkaAdminClientTest.newStrMap("request.timeout.ms", "1000"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().createPendingAuthenticationError((Node)cluster.nodes().get(0), TimeUnit.DAYS.toMillis(1L));
            this.callAdminClientApisAndExpectAnAuthenticationError(env);
            this.callClientQuotasApisAndExpectAnAuthenticationError(env);
        }
    }

    private void callAdminClientApisAndExpectAnAuthenticationError(AdminClientUnitTestEnv env) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all().get();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof AuthenticationException), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
        counts.put("my_topic", NewPartitions.increaseTo((int)3));
        counts.put("other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(2), Arrays.asList(3))));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)env.adminClient().createPartitions(counts).all().get();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof AuthenticationException), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)env.adminClient().createAcls(Arrays.asList(ACL1, ACL2)).all().get();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof AuthenticationException), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Collection cfr_ignored_0 = (Collection)env.adminClient().describeAcls(FILTER1).values().get();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof AuthenticationException), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Collection cfr_ignored_0 = (Collection)env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2)).all().get();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof AuthenticationException), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Map cfr_ignored_0 = (Map)env.adminClient().describeConfigs(Collections.singleton(new ConfigResource(ConfigResource.Type.BROKER, "0"))).all().get();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof AuthenticationException), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
    }

    private void callClientQuotasApisAndExpectAnAuthenticationError(AdminClientUnitTestEnv env) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Map cfr_ignored_0 = (Map)env.adminClient().describeClientQuotas(ClientQuotaFilter.all()).entities().get();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof AuthenticationException), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
        ClientQuotaEntity entity = new ClientQuotaEntity(Collections.singletonMap("user", "user"));
        ClientQuotaAlteration alteration = new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("consumer_byte_rate", Double.valueOf(1000.0))));
        e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)env.adminClient().alterClientQuotas(Arrays.asList(alteration)).all().get();
        });
        Assertions.assertTrue((boolean)(e.getCause() instanceof AuthenticationException), (String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)));
    }

    @Test
    public void testDescribeAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData().setResources(DescribeAclsResponse.aclsResources(Arrays.asList(ACL1, ACL2))), ApiKeys.DESCRIBE_ACLS.latestVersion()));
            KafkaAdminClientTest.assertCollectionIs((Collection)env.adminClient().describeAcls(FILTER1).values().get(), ACL1, ACL2);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData(), ApiKeys.DESCRIBE_ACLS.latestVersion()));
            Assertions.assertTrue((boolean)((Collection)env.adminClient().describeAcls(FILTER2).values().get()).isEmpty());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("Security is disabled"), ApiKeys.DESCRIBE_ACLS.latestVersion()));
            TestUtils.assertFutureError(env.adminClient().describeAcls(FILTER2).values(), SecurityDisabledException.class);
            TestUtils.assertFutureError(env.adminClient().describeAcls(UNKNOWN_FILTER).values(), InvalidRequestException.class);
        }
    }

    @Test
    public void testCreateAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult(), new CreateAclsResponseData.AclCreationResult()))));
            CreateAclsResult results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            for (KafkaFuture future : results.values().values()) {
                future.get();
            }
            results.all().get();
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("Security is disabled"), new CreateAclsResponseData.AclCreationResult()))));
            results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            TestUtils.assertFutureError((Future)results.values().get(ACL1), SecurityDisabledException.class);
            ((KafkaFuture)results.values().get(ACL2)).get();
            TestUtils.assertFutureError(results.all(), SecurityDisabledException.class);
        }
    }

    @Test
    public void testDeleteAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE), DeleteAclsResponse.matchingAcl((AclBinding)ACL2, (ApiError)ApiError.NONE))), new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security"))), ApiKeys.DELETE_ACLS.latestVersion()));
            DeleteAclsResult results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Map filterResults = results.values();
            DeleteAclsResult.FilterResults filter1Results = (DeleteAclsResult.FilterResults)((KafkaFuture)filterResults.get(FILTER1)).get();
            Assertions.assertNull((Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).exception());
            Assertions.assertEquals((Object)ACL1, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).binding());
            Assertions.assertNull((Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).exception());
            Assertions.assertEquals((Object)ACL2, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).binding());
            TestUtils.assertFutureError((Future)filterResults.get(FILTER2), SecurityDisabledException.class);
            TestUtils.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE), new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security").setPermissionType(AclPermissionType.ALLOW.code()).setOperation(AclOperation.ALTER.code()).setResourceType(ResourceType.CLUSTER.code()).setPatternType(FILTER2.patternFilter().patternType().code()))), new DeleteAclsResponseData.DeleteAclsFilterResult())), ApiKeys.DELETE_ACLS.latestVersion()));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Assertions.assertTrue((boolean)((DeleteAclsResult.FilterResults)((KafkaFuture)results.values().get(FILTER2)).get()).values().isEmpty());
            TestUtils.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE))), new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL2, (ApiError)ApiError.NONE))))), ApiKeys.DELETE_ACLS.latestVersion()));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Collection deleted = (Collection)results.all().get();
            KafkaAdminClientTest.assertCollectionIs(deleted, ACL1, ACL2);
        }
    }

    @Test
    public void testElectLeaders() throws Exception {
        TopicPartition topic1 = new TopicPartition("topic", 0);
        TopicPartition topic2 = new TopicPartition("topic", 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            for (ElectionType electionType : ElectionType.values()) {
                env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
                ApiError value = ApiError.fromThrowable((Throwable)new ClusterAuthorizationException(null));
                ArrayList<ElectLeadersResponseData.ReplicaElectionResult> electionResults = new ArrayList<ElectLeadersResponseData.ReplicaElectionResult>();
                ElectLeadersResponseData.ReplicaElectionResult electionResult = new ElectLeadersResponseData.ReplicaElectionResult();
                electionResult.setTopic(topic1.topic());
                ElectLeadersResponseData.PartitionResult partition1Result = new ElectLeadersResponseData.PartitionResult();
                partition1Result.setPartitionId(topic1.partition());
                partition1Result.setErrorCode(value.error().code());
                partition1Result.setErrorMessage(value.message());
                electionResult.partitionResult().add(partition1Result);
                ElectLeadersResponseData.PartitionResult partition2Result = new ElectLeadersResponseData.PartitionResult();
                partition2Result.setPartitionId(topic2.partition());
                partition2Result.setErrorCode(value.error().code());
                partition2Result.setErrorMessage(value.message());
                electionResult.partitionResult().add(partition2Result);
                electionResults.add(electionResult);
                env.kafkaClient().prepareResponse((AbstractResponse)new ElectLeadersResponse(0, Errors.NONE.code(), electionResults, ApiKeys.ELECT_LEADERS.latestVersion()));
                ElectLeadersResult results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)));
                Assertions.assertEquals(((Throwable)((Optional)((Map)results.partitions().get()).get(topic2)).get()).getClass(), ClusterAuthorizationException.class);
                partition1Result.setErrorCode(ApiError.NONE.error().code());
                partition1Result.setErrorMessage(ApiError.NONE.message());
                partition2Result.setErrorCode(ApiError.NONE.error().code());
                partition2Result.setErrorMessage(ApiError.NONE.message());
                env.kafkaClient().prepareResponse((AbstractResponse)new ElectLeadersResponse(0, Errors.NONE.code(), electionResults, ApiKeys.ELECT_LEADERS.latestVersion()));
                results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)));
                Assertions.assertFalse((boolean)((Optional)((Map)results.partitions().get()).get(topic1)).isPresent());
                Assertions.assertFalse((boolean)((Optional)((Map)results.partitions().get()).get(topic2)).isPresent());
                results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)), (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Integer.valueOf(100)));
                TestUtils.assertFutureError(results.partitions(), TimeoutException.class);
            }
        }
    }

    @Test
    public void testDescribeBrokerConfigs() throws Exception {
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        ConfigResource broker1Resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(broker0Resource.name()).setResourceType(broker0Resource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(broker1Resource.name()).setResourceType(broker1Resource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))), env.cluster().nodeById(1));
            Map result = env.adminClient().describeConfigs(Arrays.asList(broker0Resource, broker1Resource)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(broker0Resource, broker1Resource)), result.keySet());
            ((KafkaFuture)result.get(broker0Resource)).get();
            ((KafkaFuture)result.get(broker1Resource)).get();
        }
    }

    @Test
    public void testDescribeBrokerAndLogConfigs() throws Exception {
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        ConfigResource brokerLoggerResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "0");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(brokerResource.name()).setResourceType(brokerResource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(brokerLoggerResource.name()).setResourceType(brokerLoggerResource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))), env.cluster().nodeById(0));
            Map result = env.adminClient().describeConfigs(Arrays.asList(brokerResource, brokerLoggerResource)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(brokerResource, brokerLoggerResource)), result.keySet());
            ((KafkaFuture)result.get(brokerResource)).get();
            ((KafkaFuture)result.get(brokerLoggerResource)).get();
        }
    }

    @Test
    public void testDescribeConfigsPartialResponse() {
        ConfigResource topic = new ConfigResource(ConfigResource.Type.TOPIC, "topic");
        ConfigResource topic2 = new ConfigResource(ConfigResource.Type.TOPIC, "topic2");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(topic.name()).setResourceType(topic.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))));
            Map result = env.adminClient().describeConfigs(Arrays.asList(topic, topic2)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(topic, topic2)), result.keySet());
            result.get(topic);
            TestUtils.assertFutureThrows((Future)result.get(topic2), ApiException.class);
        }
    }

    @Test
    public void testDescribeConfigsUnrequested() throws Exception {
        ConfigResource topic = new ConfigResource(ConfigResource.Type.TOPIC, "topic");
        ConfigResource unrequested = new ConfigResource(ConfigResource.Type.TOPIC, "unrequested");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(topic.name()).setResourceType(topic.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(unrequested.name()).setResourceType(unrequested.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))));
            Map result = env.adminClient().describeConfigs(Arrays.asList(topic)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(topic)), result.keySet());
            Assertions.assertNotNull((Object)((KafkaFuture)result.get(topic)).get());
            Assertions.assertNull(result.get(unrequested));
        }
    }

    @Test
    public void testDescribeClientMetricsConfigs() throws Exception {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "sub1");
        ConfigResource resource1 = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "sub2");
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(new DescribeConfigsResponseData().setResults(Arrays.asList(new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(resource.name()).setResourceType(resource.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList()), new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(resource1.name()).setResourceType(resource1.type().id()).setErrorCode(Errors.NONE.code()).setConfigs(Collections.emptyList())))));
            Map result = env.adminClient().describeConfigs(Arrays.asList(resource, resource1)).values();
            Assertions.assertEquals(new HashSet<ConfigResource>(Arrays.asList(resource, resource1)), result.keySet());
            Assertions.assertNotNull((Object)((KafkaFuture)result.get(resource)).get());
            Assertions.assertNotNull((Object)((KafkaFuture)result.get(resource1)).get());
        }
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, TopicPartition tp, long partitionSize, long offsetLag) {
        return KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, KafkaAdminClientTest.prepareDescribeLogDirsTopics(partitionSize, offsetLag, tp.topic(), tp.partition(), false));
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, TopicPartition tp, long partitionSize, long offsetLag, long totalBytes, long usableBytes) {
        return KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, KafkaAdminClientTest.prepareDescribeLogDirsTopics(partitionSize, offsetLag, tp.topic(), tp.partition(), false), totalBytes, usableBytes);
    }

    private static List<DescribeLogDirsResponseData.DescribeLogDirsTopic> prepareDescribeLogDirsTopics(long partitionSize, long offsetLag, String topic, int partition, boolean isFuture) {
        return Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsTopic().setName(topic).setPartitions(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsPartition().setPartitionIndex(partition).setPartitionSize(partitionSize).setIsFutureKey(isFuture).setOffsetLag(offsetLag))));
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, List<DescribeLogDirsResponseData.DescribeLogDirsTopic> topics) {
        return new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(error.code()).setLogDir(logDir).setTopics(topics))));
    }

    private static DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir, List<DescribeLogDirsResponseData.DescribeLogDirsTopic> topics, long totalBytes, long usableBytes) {
        return new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(error.code()).setLogDir(logDir).setTopics(topics).setTotalBytes(totalBytes).setUsableBytes(usableBytes))));
    }

    private static DescribeLogDirsResponse prepareEmptyDescribeLogDirsResponse(Optional<Errors> error) {
        DescribeLogDirsResponseData data = new DescribeLogDirsResponseData();
        if (error.isPresent()) {
            data.setErrorCode(error.get().code());
        }
        return new DescribeLogDirsResponse(data);
    }

    @Test
    public void testDescribeLogDirs() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        TopicPartition tp = new TopicPartition("topic", 12);
        long partitionSize = 1234567890L;
        long offsetLag = 24L;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(Errors.NONE, logDir, tp, partitionSize, offsetLag), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map descriptions = result.descriptions();
            Assertions.assertEquals(brokers, descriptions.keySet());
            Assertions.assertNotNull(descriptions.get(0));
            KafkaAdminClientTest.assertDescriptionContains((Map)((KafkaFuture)descriptions.get(0)).get(), logDir, tp, partitionSize, offsetLag);
            Map allDescriptions = (Map)result.allDescriptions().get();
            Assertions.assertEquals(brokers, allDescriptions.keySet());
            KafkaAdminClientTest.assertDescriptionContains((Map)allDescriptions.get(0), logDir, tp, partitionSize, offsetLag);
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareEmptyDescribeLogDirsResponse(Optional.empty()), env.cluster().nodeById(0));
            DescribeLogDirsResult errorResult = env.adminClient().describeLogDirs(brokers);
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
                Map cfr_ignored_0 = (Map)errorResult.allDescriptions().get();
            });
            Assertions.assertTrue((boolean)(exception.getCause() instanceof ClusterAuthorizationException));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareEmptyDescribeLogDirsResponse(Optional.of(Errors.UNKNOWN_SERVER_ERROR)), env.cluster().nodeById(0));
            DescribeLogDirsResult errorResult2 = env.adminClient().describeLogDirs(brokers);
            exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
                Map cfr_ignored_0 = (Map)errorResult2.allDescriptions().get();
            });
            Assertions.assertTrue((boolean)(exception.getCause() instanceof UnknownServerException));
        }
    }

    private static void assertDescriptionContains(Map<String, LogDirDescription> descriptionsMap, String logDir, TopicPartition tp, long partitionSize, long offsetLag) {
        KafkaAdminClientTest.assertDescriptionContains(descriptionsMap, logDir, tp, partitionSize, offsetLag, OptionalLong.empty(), OptionalLong.empty());
    }

    private static void assertDescriptionContains(Map<String, LogDirDescription> descriptionsMap, String logDir, TopicPartition tp, long partitionSize, long offsetLag, OptionalLong totalBytes, OptionalLong usableBytes) {
        Assertions.assertNotNull(descriptionsMap);
        Assertions.assertEquals(Collections.singleton(logDir), descriptionsMap.keySet());
        Assertions.assertNull((Object)descriptionsMap.get(logDir).error());
        Map descriptionsReplicaInfos = descriptionsMap.get(logDir).replicaInfos();
        Assertions.assertEquals(Collections.singleton(tp), descriptionsReplicaInfos.keySet());
        Assertions.assertEquals((long)partitionSize, (long)((ReplicaInfo)descriptionsReplicaInfos.get(tp)).size());
        Assertions.assertEquals((long)offsetLag, (long)((ReplicaInfo)descriptionsReplicaInfos.get(tp)).offsetLag());
        Assertions.assertFalse((boolean)((ReplicaInfo)descriptionsReplicaInfos.get(tp)).isFuture());
        Assertions.assertEquals((Object)totalBytes, (Object)descriptionsMap.get(logDir).totalBytes());
        Assertions.assertEquals((Object)usableBytes, (Object)descriptionsMap.get(logDir).usableBytes());
    }

    @Test
    public void testDescribeLogDirsWithVolumeBytes() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        TopicPartition tp = new TopicPartition("topic", 12);
        long partitionSize = 1234567890L;
        long offsetLag = 24L;
        long totalBytes = 123L;
        long usableBytes = 456L;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(Errors.NONE, logDir, tp, partitionSize, offsetLag, totalBytes, usableBytes), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map descriptions = result.descriptions();
            Assertions.assertEquals(brokers, descriptions.keySet());
            Assertions.assertNotNull(descriptions.get(0));
            KafkaAdminClientTest.assertDescriptionContains((Map)((KafkaFuture)descriptions.get(0)).get(), logDir, tp, partitionSize, offsetLag, OptionalLong.of(totalBytes), OptionalLong.of(usableBytes));
            Map allDescriptions = (Map)result.allDescriptions().get();
            Assertions.assertEquals(brokers, allDescriptions.keySet());
            KafkaAdminClientTest.assertDescriptionContains((Map)allDescriptions.get(0), logDir, tp, partitionSize, offsetLag, OptionalLong.of(totalBytes), OptionalLong.of(usableBytes));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareEmptyDescribeLogDirsResponse(Optional.empty()), env.cluster().nodeById(0));
            DescribeLogDirsResult errorResult = env.adminClient().describeLogDirs(brokers);
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
                Map cfr_ignored_0 = (Map)errorResult.allDescriptions().get();
            });
            Assertions.assertTrue((boolean)(exception.getCause() instanceof ClusterAuthorizationException));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareEmptyDescribeLogDirsResponse(Optional.of(Errors.UNKNOWN_SERVER_ERROR)), env.cluster().nodeById(0));
            DescribeLogDirsResult errorResult2 = env.adminClient().describeLogDirs(brokers);
            exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
                Map cfr_ignored_0 = (Map)errorResult2.allDescriptions().get();
            });
            Assertions.assertTrue((boolean)(exception.getCause() instanceof UnknownServerException));
        }
    }

    @Test
    public void testDescribeLogDirsDeprecated() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        TopicPartition tp = new TopicPartition("topic", 12);
        String logDir = "/var/data/kafka";
        Errors error = Errors.NONE;
        int offsetLag = 24;
        long partitionSize = 1234567890L;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, tp, partitionSize, (long)offsetLag), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map deprecatedValues = result.values();
            Assertions.assertEquals(brokers, deprecatedValues.keySet());
            Assertions.assertNotNull(deprecatedValues.get(0));
            KafkaAdminClientTest.assertDescriptionContains((Map)((KafkaFuture)deprecatedValues.get(0)).get(), logDir, tp, error, offsetLag, partitionSize);
            Map deprecatedAll = (Map)result.all().get();
            Assertions.assertEquals(brokers, deprecatedAll.keySet());
            KafkaAdminClientTest.assertDescriptionContains((Map)deprecatedAll.get(0), logDir, tp, error, offsetLag, partitionSize);
        }
    }

    private static void assertDescriptionContains(Map<String, DescribeLogDirsResponse.LogDirInfo> descriptionsMap, String logDir, TopicPartition tp, Errors error, int offsetLag, long partitionSize) {
        Assertions.assertNotNull(descriptionsMap);
        Assertions.assertEquals(Collections.singleton(logDir), descriptionsMap.keySet());
        Assertions.assertEquals((Object)error, (Object)descriptionsMap.get((Object)logDir).error);
        Map allReplicaInfos = descriptionsMap.get((Object)logDir).replicaInfos;
        Assertions.assertEquals(Collections.singleton(tp), allReplicaInfos.keySet());
        Assertions.assertEquals((long)partitionSize, (long)((DescribeLogDirsResponse.ReplicaInfo)allReplicaInfos.get((Object)tp)).size);
        Assertions.assertEquals((long)offsetLag, (long)((DescribeLogDirsResponse.ReplicaInfo)allReplicaInfos.get((Object)tp)).offsetLag);
        Assertions.assertFalse((boolean)((DescribeLogDirsResponse.ReplicaInfo)allReplicaInfos.get((Object)tp)).isFuture);
    }

    @Test
    public void testDescribeLogDirsOfflineDir() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        Errors error = Errors.KAFKA_STORAGE_ERROR;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, Collections.emptyList()), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map descriptions = result.descriptions();
            Assertions.assertEquals(brokers, descriptions.keySet());
            Assertions.assertNotNull(descriptions.get(0));
            Map descriptionsMap = (Map)((KafkaFuture)descriptions.get(0)).get();
            Assertions.assertEquals(Collections.singleton(logDir), descriptionsMap.keySet());
            Assertions.assertEquals(error.exception().getClass(), ((LogDirDescription)descriptionsMap.get(logDir)).error().getClass());
            Assertions.assertEquals(Collections.emptySet(), ((LogDirDescription)descriptionsMap.get(logDir)).replicaInfos().keySet());
            Map allDescriptions = (Map)result.allDescriptions().get();
            Assertions.assertEquals(brokers, allDescriptions.keySet());
            Map allMap = (Map)allDescriptions.get(0);
            Assertions.assertNotNull((Object)allMap);
            Assertions.assertEquals(Collections.singleton(logDir), allMap.keySet());
            Assertions.assertEquals(error.exception().getClass(), ((LogDirDescription)allMap.get(logDir)).error().getClass());
            Assertions.assertEquals(Collections.emptySet(), ((LogDirDescription)allMap.get(logDir)).replicaInfos().keySet());
        }
    }

    @Test
    public void testDescribeLogDirsOfflineDirDeprecated() throws ExecutionException, InterruptedException {
        Set<Integer> brokers = Collections.singleton(0);
        String logDir = "/var/data/kafka";
        Errors error = Errors.KAFKA_STORAGE_ERROR;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareDescribeLogDirsResponse(error, logDir, Collections.emptyList()), env.cluster().nodeById(0));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(brokers);
            Map deprecatedValues = result.values();
            Assertions.assertEquals(brokers, deprecatedValues.keySet());
            Assertions.assertNotNull(deprecatedValues.get(0));
            Map valuesMap = (Map)((KafkaFuture)deprecatedValues.get(0)).get();
            Assertions.assertEquals(Collections.singleton(logDir), valuesMap.keySet());
            Assertions.assertEquals((Object)error, (Object)((DescribeLogDirsResponse.LogDirInfo)valuesMap.get((Object)logDir)).error);
            Assertions.assertEquals(Collections.emptySet(), ((DescribeLogDirsResponse.LogDirInfo)valuesMap.get((Object)logDir)).replicaInfos.keySet());
            Map deprecatedAll = (Map)result.all().get();
            Assertions.assertEquals(brokers, deprecatedAll.keySet());
            Map allMap = (Map)deprecatedAll.get(0);
            Assertions.assertNotNull((Object)allMap);
            Assertions.assertEquals(Collections.singleton(logDir), allMap.keySet());
            Assertions.assertEquals((Object)error, (Object)((DescribeLogDirsResponse.LogDirInfo)allMap.get((Object)logDir)).error);
            Assertions.assertEquals(Collections.emptySet(), ((DescribeLogDirsResponse.LogDirInfo)allMap.get((Object)logDir)).replicaInfos.keySet());
        }
    }

    @Test
    public void testDescribeReplicaLogDirs() throws ExecutionException, InterruptedException {
        TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 12, 1);
        TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic", 12, 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String broker1log0 = "/var/data/kafka0";
            String broker1log1 = "/var/data/kafka1";
            String broker2log0 = "/var/data/kafka2";
            int broker1Log0OffsetLag = 24;
            int broker1Log0PartitionSize = 987654321;
            int broker1Log1PartitionSize = 123456789;
            int broker1Log1OffsetLag = 4321;
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Arrays.asList(KafkaAdminClientTest.prepareDescribeLogDirsResult(tpr1, broker1log0, broker1Log0PartitionSize, broker1Log0OffsetLag, false), KafkaAdminClientTest.prepareDescribeLogDirsResult(tpr1, broker1log1, broker1Log1PartitionSize, broker1Log1OffsetLag, true)))), env.cluster().nodeById(tpr1.brokerId()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareDescribeLogDirsResponse(Errors.KAFKA_STORAGE_ERROR, broker2log0), env.cluster().nodeById(tpr2.brokerId()));
            DescribeReplicaLogDirsResult result = env.adminClient().describeReplicaLogDirs(Arrays.asList(tpr1, tpr2));
            Map values = result.values();
            Assertions.assertEquals(TestUtils.toSet(Arrays.asList(tpr1, tpr2)), values.keySet());
            Assertions.assertNotNull(values.get(tpr1));
            Assertions.assertEquals((Object)broker1log0, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getCurrentReplicaLogDir());
            Assertions.assertEquals((long)broker1Log0OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getCurrentReplicaOffsetLag());
            Assertions.assertEquals((Object)broker1log1, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getFutureReplicaLogDir());
            Assertions.assertEquals((long)broker1Log1OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr1)).get()).getFutureReplicaOffsetLag());
            Assertions.assertNotNull(values.get(tpr2));
            Assertions.assertNull((Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getCurrentReplicaLogDir());
            Assertions.assertEquals((long)-1L, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getCurrentReplicaOffsetLag());
            Assertions.assertNull((Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getFutureReplicaLogDir());
            Assertions.assertEquals((long)-1L, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(tpr2)).get()).getFutureReplicaOffsetLag());
        }
    }

    private static DescribeLogDirsResponseData.DescribeLogDirsResult prepareDescribeLogDirsResult(TopicPartitionReplica tpr, String logDir, int partitionSize, int offsetLag, boolean isFuture) {
        return new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(Errors.NONE.code()).setLogDir(logDir).setTopics(KafkaAdminClientTest.prepareDescribeLogDirsTopics(partitionSize, offsetLag, tpr.topic(), tpr.partition(), isFuture));
    }

    @Test
    public void testDescribeReplicaLogDirsUnexpected() throws ExecutionException, InterruptedException {
        TopicPartitionReplica expected = new TopicPartitionReplica("topic", 12, 1);
        TopicPartitionReplica unexpected = new TopicPartitionReplica("topic", 12, 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String broker1log0 = "/var/data/kafka0";
            String broker1log1 = "/var/data/kafka1";
            int broker1Log0PartitionSize = 987654321;
            int broker1Log0OffsetLag = 24;
            int broker1Log1PartitionSize = 123456789;
            int broker1Log1OffsetLag = 4321;
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Arrays.asList(KafkaAdminClientTest.prepareDescribeLogDirsResult(expected, broker1log0, broker1Log0PartitionSize, broker1Log0OffsetLag, false), KafkaAdminClientTest.prepareDescribeLogDirsResult(unexpected, broker1log1, broker1Log1PartitionSize, broker1Log1OffsetLag, true)))), env.cluster().nodeById(expected.brokerId()));
            DescribeReplicaLogDirsResult result = env.adminClient().describeReplicaLogDirs(Arrays.asList(expected));
            Map values = result.values();
            Assertions.assertEquals(TestUtils.toSet(Arrays.asList(expected)), values.keySet());
            Assertions.assertNotNull(values.get(expected));
            Assertions.assertEquals((Object)broker1log0, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getCurrentReplicaLogDir());
            Assertions.assertEquals((long)broker1Log0OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getCurrentReplicaOffsetLag());
            Assertions.assertEquals((Object)broker1log1, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getFutureReplicaLogDir());
            Assertions.assertEquals((long)broker1Log1OffsetLag, (long)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((KafkaFuture)values.get(expected)).get()).getFutureReplicaOffsetLag());
        }
    }

    @Test
    public void testCreatePartitions() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("my_topic", "other_topic"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("my_topic", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("other_topic", Errors.INVALID_TOPIC_EXCEPTION, "some detailed reason")));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("my_topic", NewPartitions.increaseTo((int)3));
            counts.put("other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(2), Arrays.asList(3))));
            CreatePartitionsResult results = env.adminClient().createPartitions(counts);
            Map values = results.values();
            KafkaFuture myTopicResult = (KafkaFuture)values.get("my_topic");
            myTopicResult.get();
            KafkaFuture otherTopicResult = (KafkaFuture)values.get("other_topic");
            try {
                otherTopicResult.get();
                Assertions.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e0) {
                Assertions.assertTrue((boolean)(e0.getCause() instanceof InvalidTopicException));
                InvalidTopicException e = (InvalidTopicException)e0.getCause();
                Assertions.assertEquals((Object)"some detailed reason", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCreatePartitionsRetryThrottlingExceptionWhenEnabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.createPartitionsTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(0, KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.NONE)));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("topic1", NewPartitions.increaseTo((int)1));
            counts.put("topic2", NewPartitions.increaseTo((int)2));
            counts.put("topic3", NewPartitions.increaseTo((int)3));
            CreatePartitionsResult result = env.adminClient().createPartitions(counts, new CreatePartitionsOptions().retryOnQuotaViolation(true));
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic2")).get());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testCreatePartitionsRetryThrottlingExceptionWhenEnabledUntilRequestTimeOut() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "default.api.timeout.ms", String.valueOf(defaultApiTimeout));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.createPartitionsTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic2"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED)));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("topic1", NewPartitions.increaseTo((int)1));
            counts.put("topic2", NewPartitions.increaseTo((int)2));
            counts.put("topic3", NewPartitions.increaseTo((int)3));
            CreatePartitionsResult result = env.adminClient().createPartitions(counts, new CreatePartitionsOptions().retryOnQuotaViolation(true));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting CreatePartitions requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting next CreatePartitions request");
            time.sleep(defaultApiTimeout + 1L);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assertions.assertEquals((int)0, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    @Test
    public void testCreatePartitionsDontRetryThrottlingExceptionWhenDisabled() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(this.expectCreatePartitionsRequestWithTopics("topic1", "topic2", "topic3"), (AbstractResponse)KafkaAdminClientTest.prepareCreatePartitionsResponse(1000, KafkaAdminClientTest.createPartitionsTopicResult("topic1", Errors.NONE), KafkaAdminClientTest.createPartitionsTopicResult("topic2", Errors.THROTTLING_QUOTA_EXCEEDED), KafkaAdminClientTest.createPartitionsTopicResult("topic3", Errors.TOPIC_ALREADY_EXISTS)));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("topic1", NewPartitions.increaseTo((int)1));
            counts.put("topic2", NewPartitions.increaseTo((int)2));
            counts.put("topic3", NewPartitions.increaseTo((int)3));
            CreatePartitionsResult result = env.adminClient().createPartitions(counts, new CreatePartitionsOptions().retryOnQuotaViolation(false));
            Assertions.assertNull((Object)((KafkaFuture)result.values().get("topic1")).get());
            ThrottlingQuotaExceededException e = TestUtils.assertFutureThrows((Future)result.values().get("topic2"), ThrottlingQuotaExceededException.class);
            Assertions.assertEquals((int)1000, (int)e.throttleTimeMs());
            TestUtils.assertFutureThrows((Future)result.values().get("topic3"), TopicExistsException.class);
        }
    }

    private MockClient.RequestMatcher expectCreatePartitionsRequestWithTopics(String ... topics) {
        return body -> {
            if (body instanceof CreatePartitionsRequest) {
                CreatePartitionsRequest request = (CreatePartitionsRequest)body;
                for (String topic : topics) {
                    if (request.data().topics().find(topic) != null) continue;
                    return false;
                }
                return topics.length == request.data().topics().size();
            }
            return false;
        };
    }

    @Test
    public void testDeleteRecordsTopicAuthorizationError() {
        String topic = "foo";
        TopicPartition partition = new TopicPartition(topic, 0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
            topics.add(new MetadataResponse.TopicMetadata(Errors.TOPIC_AUTHORIZATION_FAILED, topic, false, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), topics));
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(partition, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            TestUtils.assertFutureThrows((Future)results.lowWatermarks().get(partition), TopicAuthorizationException.class);
        }
    }

    @Test
    public void testDeleteRecordsMultipleSends() throws Exception {
        String topic = "foo";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));){
            List nodes = env.cluster().nodes();
            ArrayList<MetadataResponse.PartitionMetadata> partitionMetadata = new ArrayList<MetadataResponse.PartitionMetadata>();
            partitionMetadata.add(new MetadataResponse.PartitionMetadata(Errors.NONE, tp0, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            partitionMetadata.add(new MetadataResponse.PartitionMetadata(Errors.NONE, tp1, Optional.of(((Node)nodes.get(1)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(1)).id()), Collections.singletonList(((Node)nodes.get(1)).id()), Collections.emptyList()));
            ArrayList<MetadataResponse.TopicMetadata> topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
            topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, topic, false, partitionMetadata));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), topicMetadata));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DeleteRecordsResponse(new DeleteRecordsResponseData().setTopics(new DeleteRecordsResponseData.DeleteRecordsTopicResultCollection(Collections.singletonList(new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(tp0.topic()).setPartitions(new DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection(Collections.singletonList(new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(tp0.partition()).setErrorCode(Errors.NONE.code()).setLowWatermark(3L)).iterator()))).iterator()))), (Node)nodes.get(0));
            env.kafkaClient().disconnect(((Node)nodes.get(1)).idString());
            env.kafkaClient().createPendingAuthenticationError((Node)nodes.get(1), 100L);
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(tp0, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(tp1, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            Assertions.assertEquals((long)3L, (long)((DeletedRecords)((KafkaFuture)results.lowWatermarks().get(tp0)).get()).lowWatermark());
            TestUtils.assertFutureThrows((Future)results.lowWatermarks().get(tp1), AuthenticationException.class);
        }
    }

    @Test
    public void testDeleteRecords() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
        partitionInfos.add(new PartitionInfo("my_topic", 0, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 1, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 2, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 3, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), partitionInfos, Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
        TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
        TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
        TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.LEADER_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.UNKNOWN_TOPIC_OR_PARTITION));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            DeleteRecordsResponseData m = new DeleteRecordsResponseData();
            m.topics().add((ImplicitLinkedHashCollection.Element)new DeleteRecordsResponseData.DeleteRecordsTopicResult().setName(myTopicPartition0.topic()).setPartitions(new DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection(Arrays.asList(new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition0.partition()).setLowWatermark(3L).setErrorCode(Errors.NONE.code()), new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition1.partition()).setLowWatermark(-1L).setErrorCode(Errors.OFFSET_OUT_OF_RANGE.code()), new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(myTopicPartition2.partition()).setLowWatermark(-1L).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code())).iterator())));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteRecordsResponse(m));
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(myTopicPartition0, RecordsToDelete.beforeOffset((long)3L));
            recordsToDelete.put(myTopicPartition1, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition2, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition3, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            Map values = results.lowWatermarks();
            KafkaFuture myTopicPartition0Result = (KafkaFuture)values.get(myTopicPartition0);
            long myTopicPartition0lowWatermark = ((DeletedRecords)myTopicPartition0Result.get()).lowWatermark();
            Assertions.assertEquals((long)3L, (long)myTopicPartition0lowWatermark);
            KafkaFuture myTopicPartition1Result = (KafkaFuture)values.get(myTopicPartition1);
            try {
                myTopicPartition1Result.get();
                Assertions.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e0) {
                Assertions.assertTrue((boolean)(e0.getCause() instanceof OffsetOutOfRangeException));
            }
            KafkaFuture myTopicPartition2Result = (KafkaFuture)values.get(myTopicPartition2);
            try {
                myTopicPartition2Result.get();
                Assertions.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assertions.assertTrue((boolean)(e1.getCause() instanceof TopicAuthorizationException));
            }
            KafkaFuture myTopicPartition3Result = (KafkaFuture)values.get(myTopicPartition3);
            try {
                myTopicPartition3Result.get();
                Assertions.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assertions.assertTrue((boolean)(e1.getCause() instanceof ApiException));
            }
        }
    }

    @Test
    public void testDescribeTopicsByIds() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            DescribeTopicsResult result;
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            Uuid topicId = Uuid.randomUuid();
            String topicName = "test-topic";
            Node leader = (Node)env.cluster().nodes().get(0);
            MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition(topicName, 0), Optional.of(leader.id()), Optional.of(10), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), Collections.singletonList(new MetadataResponse.TopicMetadata(Errors.NONE, topicName, topicId, false, Collections.singletonList(partitionMetadata), Integer.MIN_VALUE))));
            TopicCollection.TopicIdCollection topicIds = TopicCollection.ofTopicIds(Collections.singletonList(topicId));
            try {
                DescribeTopicsResult result2 = env.adminClient().describeTopics((TopicCollection)topicIds);
                Map allTopicIds = (Map)result2.allTopicIds().get();
                Assertions.assertEquals((Object)topicName, (Object)((TopicDescription)allTopicIds.get(topicId)).name());
            }
            catch (Exception e) {
                Assertions.fail((String)"describe with valid topicId should not fail", (Throwable)e);
            }
            Uuid nonExistID = Uuid.randomUuid();
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), Collections.emptyList()));
            try {
                result = env.adminClient().describeTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(nonExistID)));
                TestUtils.assertFutureError(result.allTopicIds(), InvalidTopicException.class);
                result.allTopicIds().get();
                Assertions.fail((String)"describe with non-exist topic ID should throw exception");
            }
            catch (Exception e) {
                Assertions.assertEquals((Object)String.format("org.apache.kafka.common.errors.InvalidTopicException: TopicId %s not found.", nonExistID), (Object)e.getMessage());
            }
            try {
                result = env.adminClient().describeTopics((TopicCollection)TopicCollection.ofTopicIds(Collections.singletonList(Uuid.ZERO_UUID)));
                TestUtils.assertFutureError(result.allTopicIds(), InvalidTopicException.class);
                result.allTopicIds().get();
                Assertions.fail((String)"describe with Uuid.ZERO_UUID should throw exception");
            }
            catch (Exception e) {
                Assertions.assertEquals((Object)"The given topic id 'AAAAAAAAAAAAAAAAAAAAAA' cannot be represented in a request.", (Object)e.getCause().getMessage());
            }
        }
    }

    @Test
    public void testDescribeCluster() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Integer.MIN_VALUE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareDescribeClusterResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 3, 1 << AclOperation.DESCRIBE.code() | 1 << AclOperation.ALTER.code()));
            DescribeClusterResult result = env.adminClient().describeCluster();
            Assertions.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result.clusterId().get());
            Assertions.assertEquals(new HashSet(env.cluster().nodes()), new HashSet((Collection)result.nodes().get()));
            Assertions.assertEquals((int)2, (int)((Node)result.controller().get()).id());
            Assertions.assertNull((Object)result.authorizedOperations().get());
            DescribeClusterResult result2 = env.adminClient().describeCluster();
            Assertions.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result2.clusterId().get());
            Assertions.assertEquals(new HashSet(env.cluster().nodes()), new HashSet((Collection)result2.nodes().get()));
            Assertions.assertEquals((int)3, (int)((Node)result2.controller().get()).id());
            Assertions.assertEquals(new HashSet<AclOperation>(Arrays.asList(AclOperation.DESCRIBE, AclOperation.ALTER)), (Object)result2.authorizedOperations().get());
        }
    }

    @Test
    public void testDescribeClusterHandleError() {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String errorMessage = "my error";
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeClusterResponse(new DescribeClusterResponseData().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage(errorMessage)));
            DescribeClusterResult result = env.adminClient().describeCluster();
            TestUtils.assertFutureThrows(result.clusterId(), InvalidRequestException.class, errorMessage);
            TestUtils.assertFutureThrows(result.controller(), InvalidRequestException.class, errorMessage);
            TestUtils.assertFutureThrows(result.nodes(), InvalidRequestException.class, errorMessage);
            TestUtils.assertFutureThrows(result.authorizedOperations(), InvalidRequestException.class, errorMessage);
        }
    }

    private static DescribeClusterResponse prepareDescribeClusterResponse(int throttleTimeMs, Collection<Node> brokers, String clusterId, int controllerId, int clusterAuthorizedOperations) {
        DescribeClusterResponseData data = new DescribeClusterResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(throttleTimeMs).setControllerId(controllerId).setClusterId(clusterId).setClusterAuthorizedOperations(clusterAuthorizedOperations);
        brokers.forEach(broker -> data.brokers().add((ImplicitLinkedHashCollection.Element)new DescribeClusterResponseData.DescribeClusterBroker().setHost(broker.host()).setPort(broker.port()).setBrokerId(broker.id()).setRack(broker.rack())));
        return new DescribeClusterResponse(data);
    }

    @Test
    public void testDescribeClusterFailBack() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof DescribeClusterRequest);
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(0, env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 2, Collections.emptyList(), Integer.MIN_VALUE, ApiKeys.METADATA.latestVersion()));
            DescribeClusterResult result = env.adminClient().describeCluster();
            Assertions.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result.clusterId().get());
            Assertions.assertEquals(new HashSet(env.cluster().nodes()), new HashSet((Collection)result.nodes().get()));
            Assertions.assertEquals((int)2, (int)((Node)result.controller().get()).id());
            Assertions.assertNull((Object)result.authorizedOperations().get());
        }
    }

    @Test
    public void testListConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(Collections.emptyList(), env.cluster().clusterResource().clusterId(), -1, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), env.cluster().controller().id(), Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-1").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-2").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-3").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-3").setProtocolType("connector").setGroupState("Stable")))), env.cluster().nodeById(2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(3));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups();
            TestUtils.assertFutureError(result.all(), UnknownServerException.class);
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)3, (int)listings.size());
            HashSet<String> groupIds = new HashSet<String>();
            for (ConsumerGroupListing listing : listings) {
                groupIds.add(listing.groupId());
                Assertions.assertTrue((boolean)listing.state().isPresent());
            }
            Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"group-1", "group-2", "group-3"}), groupIds);
            Assertions.assertEquals((int)1, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsMetadataFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(Collections.emptyList(), env.cluster().clusterResource().clusterId(), -1, Collections.emptyList()));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups();
            TestUtils.assertFutureError(result.all(), KafkaException.class);
        }
    }

    @Test
    public void testListConsumerGroupsWithStates() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer").setGroupState("Stable"), new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setGroupState("Empty")))), env.cluster().nodeById(0));
            ListConsumerGroupsOptions options = new ListConsumerGroupsOptions();
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups(options);
            Collection listings = (Collection)result.valid().get();
            Assertions.assertEquals((int)2, (int)listings.size());
            ArrayList<ConsumerGroupListing> expected = new ArrayList<ConsumerGroupListing>();
            expected.add(new ConsumerGroupListing("group-2", true, Optional.of(ConsumerGroupState.EMPTY)));
            expected.add(new ConsumerGroupListing("group-1", false, Optional.of(ConsumerGroupState.STABLE)));
            Assertions.assertEquals(expected, (Object)listings);
            Assertions.assertEquals((int)0, (int)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsWithStatesOlderBrokerVersion() throws Exception {
        ApiVersionsResponseData.ApiVersion listGroupV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.LIST_GROUPS.id).setMinVersion((short)0).setMaxVersion((short)3);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Collections.singletonList(listGroupV3)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Collections.singletonList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer")))), env.cluster().nodeById(0));
            ListConsumerGroupsOptions options = new ListConsumerGroupsOptions();
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups(options);
            Collection listing = (Collection)result.all().get();
            Assertions.assertEquals((int)1, (int)listing.size());
            List<ConsumerGroupListing> expected = Collections.singletonList(new ConsumerGroupListing("group-1", false, Optional.empty()));
            Assertions.assertEquals(expected, (Object)listing);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(env.cluster(), Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(body -> body instanceof ListGroupsRequest);
            options = new ListConsumerGroupsOptions().inStates(Collections.singleton(ConsumerGroupState.STABLE));
            result = env.adminClient().listConsumerGroups(options);
            TestUtils.assertFutureThrows(result.all(), UnsupportedVersionException.class);
        }
    }

    @Test
    public void testOffsetCommitNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("foo", 0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testOffsetCommitWithMultipleErrors() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition foo0 = new TopicPartition("foo", 0);
            TopicPartition foo1 = new TopicPartition("foo", 1);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
            responseData.put(foo0, Errors.NONE);
            responseData.put(foo1, Errors.UNKNOWN_TOPIC_OR_PARTITION);
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetCommitResponse(0, responseData));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(foo0, new OffsetAndMetadata(123L));
            offsets.put(foo1, new OffsetAndMetadata(456L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result.partitionResult(foo0).get());
            TestUtils.assertFutureError(result.partitionResult(foo1), UnknownTopicOrPartitionException.class);
            TestUtils.assertFutureError(result.all(), UnknownTopicOrPartitionException.class);
        }
    }

    @Test
    public void testOffsetCommitRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            TopicPartition tp1 = new TopicPartition("foo", 0);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            KafkaFuture future = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting CommitOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry CommitOffsets call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"CommitOffsets retry did not await expected backoff");
        }
    }

    @Test
    public void testDescribeConsumerGroupNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID));
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testDescribeConsumerGroupRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DescribeGroupsResponse(data));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Collections.emptyList(), Collections.emptySet()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DescribeGroupsResponse(data));
            KafkaFuture future = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID)).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DescribeConsumerGroup first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DescribeConsumerGroup call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"DescribeConsumerGroup retry did not await expected backoff!");
        }
    }

    @Test
    public void testDescribeConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.COORDINATOR_LOAD_IN_PROGRESS, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.COORDINATOR_NOT_AVAILABLE, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            topicPartitions.add(0, myTopicPartition0);
            topicPartitions.add(1, myTopicPartition1);
            topicPartitions.add(2, myTopicPartition2);
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData.DescribedGroupMember memberOne = DescribeGroupsResponse.groupMember((String)"0", (String)"instance1", (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null);
            DescribeGroupsResponseData.DescribedGroupMember memberTwo = DescribeGroupsResponse.groupMember((String)"1", (String)"instance2", (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null);
            ArrayList<MemberDescription> expectedMemberDescriptions = new ArrayList<MemberDescription>();
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberOne, new MemberAssignment(new HashSet(topicPartitions))));
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberTwo, new MemberAssignment(new HashSet(topicPartitions))));
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Arrays.asList(memberOne, memberTwo), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID));
            ConsumerGroupDescription groupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            Assertions.assertEquals((int)1, (int)result.describedGroups().size());
            Assertions.assertEquals((Object)GROUP_ID, (Object)groupDescription.groupId());
            Assertions.assertEquals((int)2, (int)groupDescription.members().size());
            Assertions.assertEquals(expectedMemberDescriptions, (Object)groupDescription.members());
        }
    }

    @Test
    public void testDescribeMultipleConsumerGroups() {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            topicPartitions.add(0, myTopicPartition0);
            topicPartitions.add(1, myTopicPartition1);
            topicPartitions.add(2, myTopicPartition2);
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData group0Data = new DescribeGroupsResponseData();
            group0Data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Arrays.asList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null), DescribeGroupsResponse.groupMember((String)"1", null, (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null)), Collections.emptySet()));
            DescribeGroupsResponseData groupConnectData = new DescribeGroupsResponseData();
            group0Data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-connect-0", (Errors)Errors.NONE, (String)"", (String)"connect", (String)"", Arrays.asList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null), DescribeGroupsResponse.groupMember((String)"1", null, (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null)), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(group0Data));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(groupConnectData));
            HashSet<String> groups = new HashSet<String>();
            groups.add(GROUP_ID);
            groups.add("group-connect-0");
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(groups);
            Assertions.assertEquals((int)2, (int)result.describedGroups().size());
            Assertions.assertEquals(groups, result.describedGroups().keySet());
        }
    }

    @Test
    public void testDescribeConsumerGroupsWithAuthorizedOperationsOmitted() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Collections.emptyList(), (int)Integer.MIN_VALUE));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID));
            ConsumerGroupDescription groupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get(GROUP_ID)).get();
            Assertions.assertNull((Object)groupDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeNonConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)GROUP_ID, (Errors)Errors.NONE, (String)"", (String)"non-consumer", (String)"", Arrays.asList(new DescribeGroupsResponseData.DescribedGroupMember[0]), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList(GROUP_ID));
            TestUtils.assertFutureError((Future)result.describedGroups().get(GROUP_ID), IllegalArgumentException.class);
        }
    }

    @Test
    public void testListConsumerGroupOffsetsOptionsWithUnbatchedApi() throws Exception {
        this.verifyListConsumerGroupOffsetsOptions(false);
    }

    @Test
    public void testListConsumerGroupOffsetsOptionsWithBatchedApi() throws Exception {
        this.verifyListConsumerGroupOffsetsOptions(true);
    }

    private void verifyListConsumerGroupOffsetsOptions(boolean batchedApi) throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            List<TopicPartition> partitions = Collections.singletonList(new TopicPartition("A", 0));
            ListConsumerGroupOffsetsOptions options = (ListConsumerGroupOffsetsOptions)new ListConsumerGroupOffsetsOptions().requireStable(true).timeoutMs(Integer.valueOf(300));
            if (batchedApi) {
                ListConsumerGroupOffsetsSpec groupSpec = new ListConsumerGroupOffsetsSpec().topicPartitions(partitions);
                env.adminClient().listConsumerGroupOffsets(Collections.singletonMap(GROUP_ID, groupSpec), options);
            } else {
                env.adminClient().listConsumerGroupOffsets(GROUP_ID, options.topicPartitions(partitions));
            }
            MockClient mockClient = env.kafkaClient();
            this.waitForRequest(mockClient, ApiKeys.OFFSET_FETCH);
            ClientRequest clientRequest = mockClient.requests().peek();
            Assertions.assertNotNull((Object)clientRequest);
            Assertions.assertEquals((int)300, (int)clientRequest.requestTimeoutMs());
            OffsetFetchRequestData data = ((OffsetFetchRequest.Builder)clientRequest.requestBuilder()).data;
            Assertions.assertTrue((boolean)data.requireStable());
            Assertions.assertEquals(Collections.singletonList(GROUP_ID), data.groups().stream().map(OffsetFetchRequestData.OffsetFetchRequestGroup::groupId).collect(Collectors.toList()));
            Assertions.assertEquals(Collections.singletonList("A"), ((OffsetFetchRequestData.OffsetFetchRequestGroup)data.groups().get(0)).topics().stream().map(OffsetFetchRequestData.OffsetFetchRequestTopics::name).collect(Collectors.toList()));
            Assertions.assertEquals(Collections.singletonList(0), (Object)((OffsetFetchRequestData.OffsetFetchRequestTopics)((OffsetFetchRequestData.OffsetFetchRequestGroup)data.groups().get(0)).topics().get(0)).partitionIndexes());
        }
    }

    @Test
    public void testListConsumerGroupOffsetsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.NOT_COORDINATOR, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(GROUP_ID);
            TestUtils.assertFutureError(result.partitionsToOffsetAndMetadata(), TimeoutException.class);
        }
    }

    @Test
    public void testListConsumerGroupOffsetsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)this.offsetFetchResponse(Errors.NOT_COORDINATOR, Collections.emptyMap()));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)this.offsetFetchResponse(Errors.NONE, Collections.emptyMap()));
            KafkaFuture future = env.adminClient().listConsumerGroupOffsets(GROUP_ID).partitionsToOffsetAndMetadata();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting ListConsumerGroupOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry ListConsumerGroupOffsets call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"ListConsumerGroupOffsets retry did not await expected backoff!");
        }
    }

    @Test
    public void testListConsumerGroupOffsetsRetriableErrors() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.NOT_COORDINATOR, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.COORDINATOR_NOT_AVAILABLE, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.NONE, Collections.emptyMap()));
            ListConsumerGroupOffsetsResult errorResult1 = env.adminClient().listConsumerGroupOffsets(GROUP_ID);
            Assertions.assertEquals(Collections.emptyMap(), (Object)errorResult1.partitionsToOffsetAndMetadata().get());
        }
    }

    @Test
    public void testListConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND, Errors.UNKNOWN_MEMBER_ID, Errors.STALE_MEMBER_EPOCH);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(error, Collections.emptyMap()));
                ListConsumerGroupOffsetsResult errorResult = env.adminClient().listConsumerGroupOffsets(GROUP_ID);
                TestUtils.assertFutureError(errorResult.partitionsToOffsetAndMetadata(), error.exception().getClass());
            }
        }
    }

    @Test
    public void testListConsumerGroupOffsets() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.NOT_COORDINATOR, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.COORDINATOR_NOT_AVAILABLE, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
            HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
            responseData.put(myTopicPartition0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", Errors.NONE));
            responseData.put(myTopicPartition1, new OffsetFetchResponse.PartitionData(0L, Optional.empty(), "", Errors.NONE));
            responseData.put(myTopicPartition2, new OffsetFetchResponse.PartitionData(20L, Optional.empty(), "", Errors.NONE));
            responseData.put(myTopicPartition3, new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.NONE));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.NONE, responseData));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(GROUP_ID);
            Map partitionToOffsetAndMetadata = (Map)result.partitionsToOffsetAndMetadata().get();
            Assertions.assertEquals((int)4, (int)partitionToOffsetAndMetadata.size());
            Assertions.assertEquals((long)10L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition0)).offset());
            Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition1)).offset());
            Assertions.assertEquals((long)20L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition2)).offset());
            Assertions.assertTrue((boolean)partitionToOffsetAndMetadata.containsKey(myTopicPartition3));
            Assertions.assertNull(partitionToOffsetAndMetadata.get(myTopicPartition3));
        }
    }

    @Test
    public void testBatchedListConsumerGroupOffsets() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        MockTime time = new MockTime();
        Map<String, ListConsumerGroupOffsetsSpec> groupSpecs = this.batchedListConsumerGroupOffsetsSpec();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareBatchedFindCoordinatorResponse(Errors.NONE, env.cluster().controller(), groupSpecs.keySet()));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(groupSpecs, new ListConsumerGroupOffsetsOptions());
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, true, Errors.NONE);
            this.verifyListOffsetsForMultipleGroups(groupSpecs, result);
        }
    }

    @Test
    public void testBatchedListConsumerGroupOffsetsWithNoFindCoordinatorBatching() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        MockTime time = new MockTime();
        Map<String, ListConsumerGroupOffsetsSpec> groupSpecs = this.batchedListConsumerGroupOffsetsSpec();
        ApiVersionsResponseData.ApiVersion findCoordinatorV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FIND_COORDINATOR.id).setMinVersion((short)0).setMaxVersion((short)3);
        ApiVersionsResponseData.ApiVersion offsetFetchV7 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.OFFSET_FETCH.id).setMinVersion((short)0).setMaxVersion((short)7);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Arrays.asList(findCoordinatorV3, offsetFetchV7)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(groupSpecs);
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.COORDINATOR_LOAD_IN_PROGRESS);
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.verifyListOffsetsForMultipleGroups(groupSpecs, result);
        }
    }

    @Test
    public void testBatchedListConsumerGroupOffsetsWithNoOffsetFetchBatching() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(1, 0);
        MockTime time = new MockTime();
        Map<String, ListConsumerGroupOffsetsSpec> groupSpecs = this.batchedListConsumerGroupOffsetsSpec();
        ApiVersionsResponseData.ApiVersion offsetFetchV7 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.OFFSET_FETCH.id).setMinVersion((short)0).setMaxVersion((short)7);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Collections.singleton(offsetFetchV7)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareBatchedFindCoordinatorResponse(Errors.NONE, env.cluster().controller(), groupSpecs.keySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)this.offsetFetchResponse(Errors.COORDINATOR_NOT_AVAILABLE, Collections.emptyMap()));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets(groupSpecs);
            this.sendFindCoordinatorResponse(env.kafkaClient(), env.cluster().controller());
            this.sendFindCoordinatorResponse(env.kafkaClient(), env.cluster().controller());
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.sendOffsetFetchResponse(env.kafkaClient(), groupSpecs, false, Errors.NONE);
            this.verifyListOffsetsForMultipleGroups(groupSpecs, result);
        }
    }

    private Map<String, ListConsumerGroupOffsetsSpec> batchedListConsumerGroupOffsetsSpec() {
        Set<TopicPartition> groupAPartitions = Collections.singleton(new TopicPartition("A", 1));
        Set<TopicPartition> groupBPartitions = Collections.singleton(new TopicPartition("B", 2));
        ListConsumerGroupOffsetsSpec groupASpec = new ListConsumerGroupOffsetsSpec().topicPartitions(groupAPartitions);
        ListConsumerGroupOffsetsSpec groupBSpec = new ListConsumerGroupOffsetsSpec().topicPartitions(groupBPartitions);
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"groupA", (Object)groupASpec), Utils.mkEntry((Object)"groupB", (Object)groupBSpec)});
    }

    private void waitForRequest(MockClient mockClient, ApiKeys apiKeys) throws Exception {
        TestUtils.waitForCondition(() -> {
            ClientRequest clientRequest = mockClient.requests().peek();
            return clientRequest != null && clientRequest.apiKey() == apiKeys;
        }, "Failed awaiting " + apiKeys + " request");
    }

    private void sendFindCoordinatorResponse(MockClient mockClient, Node coordinator) throws Exception {
        this.waitForRequest(mockClient, ApiKeys.FIND_COORDINATOR);
        ClientRequest clientRequest = mockClient.requests().peek();
        FindCoordinatorRequestData data = ((FindCoordinatorRequest.Builder)clientRequest.requestBuilder()).data();
        mockClient.respond((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, data.key(), coordinator));
    }

    private void sendOffsetFetchResponse(MockClient mockClient, Map<String, ListConsumerGroupOffsetsSpec> groupSpecs, boolean batched, Errors error) throws Exception {
        this.waitForRequest(mockClient, ApiKeys.OFFSET_FETCH);
        ClientRequest clientRequest = mockClient.requests().peek();
        OffsetFetchRequestData data = ((OffsetFetchRequest.Builder)clientRequest.requestBuilder()).data;
        HashMap results = new HashMap();
        HashMap errors = new HashMap();
        data.groups().forEach(group -> {
            HashMap<TopicPartition, OffsetFetchResponse.PartitionData> partitionResults = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
            for (TopicPartition tp : ((ListConsumerGroupOffsetsSpec)groupSpecs.get(group.groupId())).topicPartitions()) {
                partitionResults.put(tp, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", Errors.NONE));
            }
            results.put(group.groupId(), partitionResults);
            errors.put(group.groupId(), error);
        });
        if (!batched) {
            Assertions.assertEquals((int)1, (int)data.groups().size());
            mockClient.respond((AbstractResponse)new OffsetFetchResponse(10, error, (Map)results.values().iterator().next()));
        } else {
            mockClient.respond((AbstractResponse)new OffsetFetchResponse(10, errors, results));
        }
    }

    private void verifyListOffsetsForMultipleGroups(Map<String, ListConsumerGroupOffsetsSpec> groupSpecs, ListConsumerGroupOffsetsResult result) throws Exception {
        Assertions.assertEquals((int)groupSpecs.size(), (int)((Map)result.all().get(10L, TimeUnit.SECONDS)).size());
        for (Map.Entry<String, ListConsumerGroupOffsetsSpec> entry : groupSpecs.entrySet()) {
            Assertions.assertEquals((Object)entry.getValue().topicPartitions(), ((Map)result.partitionsToOffsetAndMetadata(entry.getKey()).get()).keySet());
        }
    }

    @Test
    public void testDeleteConsumerGroupsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        List<String> groupIds = Collections.singletonList("groupId");
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteConsumerGroupsResult result = env.adminClient().deleteConsumerGroups(groupIds);
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testDeleteConsumerGroupsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        List<String> groupIds = Collections.singletonList(GROUP_ID);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(GROUP_ID).setErrorCode(Errors.NOT_COORDINATOR.code()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(GROUP_ID).setErrorCode(Errors.NONE.code()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            KafkaFuture future = env.adminClient().deleteConsumerGroups(groupIds).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DeleteConsumerGroups first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DeleteConsumerGroups call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"DeleteConsumerGroups retry did not await expected backoff!");
        }
    }

    @Test
    public void testDeleteConsumerGroupsWithOlderBroker() throws Exception {
        List<String> groupIds = Collections.singletonList("groupId");
        ApiVersionsResponseData.ApiVersion findCoordinatorV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FIND_COORDINATOR.id).setMinVersion((short)0).setMaxVersion((short)3);
        ApiVersionsResponseData.ApiVersion describeGroups = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.DESCRIBE_GROUPS.id).setMinVersion((short)0).setMaxVersion(ApiKeys.DELETE_GROUPS.latestVersion());
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Arrays.asList(findCoordinatorV3, describeGroups)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteConsumerGroupsResult result = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture results = (KafkaFuture)result.deletedGroups().get("groupId");
            Assertions.assertNull((Object)results.get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteConsumerGroupsResult errorResult = env.adminClient().deleteConsumerGroups(groupIds);
            TestUtils.assertFutureError((Future)errorResult.deletedGroups().get("groupId"), GroupAuthorizationException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection errorResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            errorResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(errorResponse)));
            DeleteGroupsResponseData.DeletableGroupResultCollection coordinatorMoved = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            coordinatorMoved.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(coordinatorMoved)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            coordinatorMoved = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            coordinatorMoved.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(coordinatorMoved)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            errorResult = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture errorResults = (KafkaFuture)errorResult.deletedGroups().get("groupId");
            Assertions.assertNull((Object)errorResults.get());
        }
    }

    @Test
    public void testDeleteMultipleConsumerGroupsWithOlderBroker() throws Exception {
        List<String> groupIds = Arrays.asList("group1", "group2");
        ApiVersionsResponseData.ApiVersion findCoordinatorV3 = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.FIND_COORDINATOR.id).setMinVersion((short)0).setMaxVersion((short)3);
        ApiVersionsResponseData.ApiVersion describeGroups = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.DESCRIBE_GROUPS.id).setMinVersion((short)0).setMaxVersion(ApiKeys.DELETE_GROUPS.latestVersion());
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            int i;
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create(Arrays.asList(findCoordinatorV3, describeGroups)));
            env.kafkaClient().prepareResponse(null);
            for (i = 0; i < groupIds.size(); ++i) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            }
            for (i = 0; i < groupIds.size(); ++i) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOldFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            }
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group1").setErrorCode(Errors.NONE.code()));
            validResponse.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group2").setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteConsumerGroupsResult result = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture results = (KafkaFuture)result.deletedGroups().get("group1");
            Assertions.assertNull((Object)results.get(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            TopicPartition tp1 = new TopicPartition("foo", 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteConsumerGroupOffsetsResult result = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            TopicPartition tp1 = new TopicPartition("foo", 0);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            KafkaFuture future = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet())).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting DeleteConsumerGroupOffsets first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry DeleteConsumerGroupOffsets call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"DeleteConsumerGroupOffsets retry did not await expected backoff!");
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsets() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetDeleteResponse(new OffsetDeleteResponseData().setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Stream.of(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("foo").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code())).iterator())), new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("bar").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code())).iterator()))).collect(Collectors.toList()).iterator()))));
            DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1, tp2).collect(Collectors.toSet()));
            Assertions.assertNull((Object)errorResult.partitionResult(tp1).get());
            TestUtils.assertFutureError(errorResult.all(), GroupSubscribedToTopicException.class);
            TestUtils.assertFutureError(errorResult.partitionResult(tp2), GroupSubscribedToTopicException.class);
            Assertions.assertThrows(IllegalArgumentException.class, () -> errorResult.partitionResult(tp3));
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteConsumerGroupOffsetsResult errorResult1 = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            Assertions.assertNull((Object)errorResult1.all().get());
            Assertions.assertNull((Object)errorResult1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(error));
                DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
                TestUtils.assertFutureError(errorResult.all(), error.exception().getClass());
                TestUtils.assertFutureError(errorResult.partitionResult(tp1), error.exception().getClass());
            }
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteConsumerGroupOffsetsResult result = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets(GROUP_ID, Stream.of(tp1).collect(Collectors.toSet()));
            TestUtils.assertFutureError(errorResult.all(), GroupAuthorizationException.class);
            TestUtils.assertFutureError(errorResult.partitionResult(tp1), GroupAuthorizationException.class);
        }
    }

    @Test
    public void testIncrementalAlterConfigs() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            IncrementalAlterConfigsResponseData responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage("authorization error"));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("metric1").setResourceType(ConfigResource.Type.CLIENT_METRICS.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Subscription is not allowed"));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("topic1").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Config value append is not allowed for config"));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "");
            ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "topic1");
            ConfigResource metricResource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "metric1");
            AlterConfigOp alterConfigOp1 = new AlterConfigOp(new ConfigEntry("log.segment.bytes", "1073741"), AlterConfigOp.OpType.SET);
            AlterConfigOp alterConfigOp2 = new AlterConfigOp(new ConfigEntry("compression.type", "gzip"), AlterConfigOp.OpType.APPEND);
            AlterConfigOp alterConfigOp3 = new AlterConfigOp(new ConfigEntry("interval.ms", "1000"), AlterConfigOp.OpType.APPEND);
            HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
            configs.put(brokerResource, Collections.singletonList(alterConfigOp1));
            configs.put(topicResource, Collections.singletonList(alterConfigOp2));
            configs.put(metricResource, Collections.singletonList(alterConfigOp3));
            AlterConfigsResult result = env.adminClient().incrementalAlterConfigs(configs);
            TestUtils.assertFutureError((Future)result.values().get(brokerResource), ClusterAuthorizationException.class);
            TestUtils.assertFutureError((Future)result.values().get(topicResource), InvalidRequestException.class);
            TestUtils.assertFutureError((Future)result.values().get(metricResource), InvalidRequestException.class);
            responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(ApiError.NONE.message()));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("metric1").setResourceType(ConfigResource.Type.CLIENT_METRICS.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(ApiError.NONE.message()));
            HashMap<ConfigResource, List<AlterConfigOp>> successConfig = new HashMap<ConfigResource, List<AlterConfigOp>>();
            successConfig.put(brokerResource, Collections.singletonList(alterConfigOp1));
            successConfig.put(metricResource, Collections.singletonList(alterConfigOp3));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            env.adminClient().incrementalAlterConfigs(successConfig).all().get();
        }
    }

    @Test
    public void testRemoveMembersFromGroupNumRetries() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            List<MemberToRemove> membersToRemove = Arrays.asList(new MemberToRemove("instance-1"), new MemberToRemove("instance-2"));
            RemoveMembersFromConsumerGroupResult result = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureError(result.all(), TimeoutException.class);
        }
    }

    @Test
    public void testRemoveMembersFromGroupRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())));
            mockClient.prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            LeaveGroupResponseData.MemberResponse responseOne = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return true;
            }, (AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(responseOne))));
            List<MemberToRemove> membersToRemove = Collections.singletonList(new MemberToRemove("instance-1"));
            KafkaFuture future = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove)).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting RemoveMembersFromGroup first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry RemoveMembersFromGroup call on first failure");
            long lowerBoundBackoffMs = (long)((double)retryBackoff * 0.8);
            long upperBoundBackoffMs = (long)((double)(retryBackoff * 2) * 1.2);
            time.sleep(upperBoundBackoffMs);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assertions.assertEquals((float)retryBackoff, (float)actualRetryBackoff, (float)(upperBoundBackoffMs - lowerBoundBackoffMs), (String)"RemoveMembersFromGroup retry did not await expected backoff!");
        }
    }

    @Test
    public void testRemoveMembersFromGroupRetriableErrors() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            LeaveGroupResponseData.MemberResponse memberResponse = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(memberResponse))));
            MemberToRemove memberToRemove = new MemberToRemove("instance-1");
            List<MemberToRemove> membersToRemove = Collections.singletonList(memberToRemove);
            RemoveMembersFromConsumerGroupResult result = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.memberResult(memberToRemove).get());
        }
    }

    @Test
    public void testRemoveMembersFromGroupNonRetriableErrors() throws Exception {
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(error.code())));
                MemberToRemove memberToRemove = new MemberToRemove("instance-1");
                List<MemberToRemove> membersToRemove = Collections.singletonList(memberToRemove);
                RemoveMembersFromConsumerGroupResult result = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
                TestUtils.assertFutureError(result.all(), error.exception().getClass());
                TestUtils.assertFutureError(result.memberResult(memberToRemove), error.exception().getClass());
            }
        }
    }

    @Test
    public void testRemoveMembersFromGroup() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String instanceOne = "instance-1";
            String instanceTwo = "instance-2";
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code())));
            List<MemberToRemove> membersToRemove = Arrays.asList(new MemberToRemove("instance-1"), new MemberToRemove("instance-2"));
            RemoveMembersFromConsumerGroupResult unknownErrorResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            MemberToRemove memberOne = new MemberToRemove("instance-1");
            MemberToRemove memberTwo = new MemberToRemove("instance-2");
            TestUtils.assertFutureError(unknownErrorResult.memberResult(memberOne), UnknownServerException.class);
            TestUtils.assertFutureError(unknownErrorResult.memberResult(memberTwo), UnknownServerException.class);
            LeaveGroupResponseData.MemberResponse responseOne = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
            LeaveGroupResponseData.MemberResponse responseTwo = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-2").setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseOne, responseTwo))));
            RemoveMembersFromConsumerGroupResult memberLevelErrorResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureError(memberLevelErrorResult.all(), UnknownMemberIdException.class);
            TestUtils.assertFutureError(memberLevelErrorResult.memberResult(memberOne), UnknownMemberIdException.class);
            Assertions.assertNull((Object)memberLevelErrorResult.memberResult(memberTwo).get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(responseTwo))));
            RemoveMembersFromConsumerGroupResult missingMemberResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureError(missingMemberResult.all(), IllegalArgumentException.class);
            TestUtils.assertFutureError(missingMemberResult.memberResult(memberOne), IllegalArgumentException.class);
            Assertions.assertNull((Object)missingMemberResult.memberResult(memberTwo).get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseTwo, new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code())))));
            RemoveMembersFromConsumerGroupResult noErrorResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            Assertions.assertNull((Object)noErrorResult.all().get());
            Assertions.assertNull((Object)noErrorResult.memberResult(memberOne).get());
            Assertions.assertNull((Object)noErrorResult.memberResult(memberTwo).get());
            List<TopicPartition> topicPartitions = Arrays.asList(1, 2, 3).stream().map(partition -> new TopicPartition("my_topic", partition.intValue())).collect(Collectors.toList());
            DescribeGroupsResponseData data = KafkaAdminClientTest.prepareDescribeGroupsResponseData(GROUP_ID, Arrays.asList("instance-1", "instance-2"), topicPartitions);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseOne, responseTwo))));
            RemoveMembersFromConsumerGroupResult partialFailureResults = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions());
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
                Void cfr_ignored_0 = (Void)partialFailureResults.all().get();
            });
            Assertions.assertTrue((boolean)(exception.getCause() instanceof KafkaException));
            Assertions.assertTrue((boolean)(exception.getCause().getCause() instanceof UnknownMemberIdException));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseTwo, new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code())))));
            RemoveMembersFromConsumerGroupResult successResult = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, new RemoveMembersFromConsumerGroupOptions());
            Assertions.assertNull((Object)successResult.all().get());
        }
    }

    private void testRemoveMembersFromGroup(String reason, String expectedReason) throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, cluster);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse(body -> {
                if (!(body instanceof LeaveGroupRequest)) {
                    return false;
                }
                LeaveGroupRequestData leaveGroupRequest = ((LeaveGroupRequest)body).data();
                return leaveGroupRequest.members().stream().allMatch(member -> member.reason().equals(expectedReason));
            }, (AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1"), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-2")))));
            MemberToRemove memberToRemove1 = new MemberToRemove("instance-1");
            MemberToRemove memberToRemove2 = new MemberToRemove("instance-2");
            RemoveMembersFromConsumerGroupOptions options = new RemoveMembersFromConsumerGroupOptions(Arrays.asList(memberToRemove1, memberToRemove2));
            options.reason(reason);
            RemoveMembersFromConsumerGroupResult result = env.adminClient().removeMembersFromConsumerGroup(GROUP_ID, options);
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.memberResult(memberToRemove1).get());
            Assertions.assertNull((Object)result.memberResult(memberToRemove2).get());
        }
    }

    @Test
    public void testRemoveMembersFromGroupReason() throws Exception {
        this.testRemoveMembersFromGroup("testing remove members reason", "testing remove members reason");
    }

    @Test
    public void testRemoveMembersFromGroupTruncatesReason() throws Exception {
        String reason = "Very looooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooong reason that is 271 characters long to make sure that length limit logic handles the scenario nicely";
        String truncatedReason = "Very looooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooong reason that is 271 characters long to make sure that length limit logic handles the scenario nicely".substring(0, 255);
        this.testRemoveMembersFromGroup("Very looooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooong reason that is 271 characters long to make sure that length limit logic handles the scenario nicely", truncatedReason);
    }

    @Test
    public void testRemoveMembersFromGroupDefaultReason() throws Exception {
        this.testRemoveMembersFromGroup(null, "member was removed by an admin");
        this.testRemoveMembersFromGroup("", "member was removed by an admin");
    }

    @Test
    public void testAlterPartitionReassignments() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("A", 0);
            TopicPartition tp2 = new TopicPartition("B", 0);
            HashMap reassignments = new HashMap();
            reassignments.put(tp1, Optional.empty());
            reassignments.put(tp2, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            AlterPartitionReassignmentsResponseData responseData1 = new AlterPartitionReassignmentsResponseData();
            AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse normalPartitionResponse = new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0);
            responseData1.setResponses(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(responseData1));
            AlterPartitionReassignmentsResult result1 = env.adminClient().alterPartitionReassignments(reassignments);
            KafkaFuture future1 = result1.all();
            Future future2 = (Future)result1.values().get(tp1);
            TestUtils.assertFutureError(future1, UnknownServerException.class);
            TestUtils.assertFutureError(future2, UnknownServerException.class);
            AlterPartitionReassignmentsResponseData controllerErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage(Errors.NOT_CONTROLLER.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            MetadataResponse controllerNodeResponse = RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList());
            AlterPartitionReassignmentsResponseData normalResponse = new AlterPartitionReassignmentsResponseData().setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(controllerErrResponseData));
            env.kafkaClient().prepareResponse((AbstractResponse)controllerNodeResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(normalResponse));
            AlterPartitionReassignmentsResult controllerErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            controllerErrResult.all().get();
            ((KafkaFuture)controllerErrResult.values().get(tp1)).get();
            ((KafkaFuture)controllerErrResult.values().get(tp2)).get();
            AlterPartitionReassignmentsResponseData partitionLevelErrData = new AlterPartitionReassignmentsResponseData().setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0).setErrorMessage(Errors.INVALID_REPLICA_ASSIGNMENT.message()).setErrorCode(Errors.INVALID_REPLICA_ASSIGNMENT.code()))), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(partitionLevelErrData));
            AlterPartitionReassignmentsResult partitionLevelErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            TestUtils.assertFutureError((Future)partitionLevelErrResult.values().get(tp1), Errors.INVALID_REPLICA_ASSIGNMENT.exception().getClass());
            ((KafkaFuture)partitionLevelErrResult.values().get(tp2)).get();
            String errorMessage = "this is custom error message";
            AlterPartitionReassignmentsResponseData topLevelErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(errorMessage).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(topLevelErrResponseData));
            AlterPartitionReassignmentsResult topLevelErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            Assertions.assertEquals((Object)errorMessage, (Object)((ApiException)TestUtils.assertFutureThrows(topLevelErrResult.all(), Errors.CLUSTER_AUTHORIZATION_FAILED.exception().getClass())).getMessage());
            Assertions.assertEquals((Object)errorMessage, (Object)((ApiException)TestUtils.assertFutureThrows((Future)topLevelErrResult.values().get(tp1), Errors.CLUSTER_AUTHORIZATION_FAILED.exception().getClass())).getMessage());
            Assertions.assertEquals((Object)errorMessage, (Object)((ApiException)TestUtils.assertFutureThrows((Future)topLevelErrResult.values().get(tp2), Errors.CLUSTER_AUTHORIZATION_FAILED.exception().getClass())).getMessage());
            TopicPartition invalidTopicTP = new TopicPartition("", 0);
            TopicPartition invalidPartitionTP = new TopicPartition("ABC", -1);
            HashMap<TopicPartition, Optional<NewPartitionReassignment>> invalidTopicReassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
            invalidTopicReassignments.put(invalidPartitionTP, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            invalidTopicReassignments.put(invalidTopicTP, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            invalidTopicReassignments.put(tp1, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            AlterPartitionReassignmentsResponseData singlePartResponseData = new AlterPartitionReassignmentsResponseData().setResponses(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(singlePartResponseData));
            AlterPartitionReassignmentsResult unrepresentableTopicResult = env.adminClient().alterPartitionReassignments(invalidTopicReassignments);
            TestUtils.assertFutureError((Future)unrepresentableTopicResult.values().get(invalidTopicTP), InvalidTopicException.class);
            TestUtils.assertFutureError((Future)unrepresentableTopicResult.values().get(invalidPartitionTP), InvalidTopicException.class);
            ((KafkaFuture)unrepresentableTopicResult.values().get(tp1)).get();
            AlterPartitionReassignmentsResponseData noErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.NONE.code()).setErrorMessage(Errors.NONE.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(noErrResponseData));
            AlterPartitionReassignmentsResult noErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            noErrResult.all().get();
            ((KafkaFuture)noErrResult.values().get(tp1)).get();
            ((KafkaFuture)noErrResult.values().get(tp2)).get();
        }
    }

    @Test
    public void testListPartitionReassignments() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("A", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp1PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setRemovingReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Arrays.asList(4, 5, 6)).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp1Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("A").setPartitions(Collections.singletonList(tp1PartitionReassignment));
            TopicPartition tp2 = new TopicPartition("B", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp2PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setRemovingReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Arrays.asList(4, 5, 6)).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp2Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("B").setPartitions(Collections.singletonList(tp2PartitionReassignment));
            ListPartitionReassignmentsResponseData notControllerData = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage(Errors.NOT_CONTROLLER.message());
            MetadataResponse controllerNodeResponse = RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList());
            ListPartitionReassignmentsResponseData reassignmentsData = new ListPartitionReassignmentsResponseData().setTopics(Arrays.asList(tp1Reassignment, tp2Reassignment));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(notControllerData));
            env.kafkaClient().prepareResponse((AbstractResponse)controllerNodeResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(reassignmentsData));
            ListPartitionReassignmentsResult noControllerResult = env.adminClient().listPartitionReassignments();
            noControllerResult.reassignments().get();
            ListPartitionReassignmentsResponseData unknownTpData = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message());
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(unknownTpData));
            ListPartitionReassignmentsResult unknownTpResult = env.adminClient().listPartitionReassignments(new HashSet<TopicPartition>(Arrays.asList(tp1, tp2)));
            TestUtils.assertFutureError(unknownTpResult.reassignments(), UnknownTopicOrPartitionException.class);
            ListPartitionReassignmentsResponseData responseData = new ListPartitionReassignmentsResponseData().setTopics(Arrays.asList(tp1Reassignment, tp2Reassignment));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(responseData));
            ListPartitionReassignmentsResult responseResult = env.adminClient().listPartitionReassignments();
            Map reassignments = (Map)responseResult.reassignments().get();
            PartitionReassignment tp1Result = (PartitionReassignment)reassignments.get(tp1);
            Assertions.assertEquals((Object)tp1PartitionReassignment.addingReplicas(), (Object)tp1Result.addingReplicas());
            Assertions.assertEquals((Object)tp1PartitionReassignment.removingReplicas(), (Object)tp1Result.removingReplicas());
            Assertions.assertEquals((Object)tp1PartitionReassignment.replicas(), (Object)tp1Result.replicas());
            Assertions.assertEquals((Object)tp1PartitionReassignment.replicas(), (Object)tp1Result.replicas());
            PartitionReassignment tp2Result = (PartitionReassignment)reassignments.get(tp2);
            Assertions.assertEquals((Object)tp2PartitionReassignment.addingReplicas(), (Object)tp2Result.addingReplicas());
            Assertions.assertEquals((Object)tp2PartitionReassignment.removingReplicas(), (Object)tp2Result.removingReplicas());
            Assertions.assertEquals((Object)tp2PartitionReassignment.replicas(), (Object)tp2Result.replicas());
            Assertions.assertEquals((Object)tp2PartitionReassignment.replicas(), (Object)tp2Result.replicas());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsets() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
            responseData.put(tp1, Errors.NONE);
            responseData.put(tp2, Errors.NONE);
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetCommitResponse(0, responseData));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            offsets.put(tp2, new OffsetAndMetadata(456L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(tp1).get());
            Assertions.assertNull((Object)result.partitionResult(tp2).get());
            TestUtils.assertFutureError(result.partitionResult(tp3), IllegalArgumentException.class);
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.REBALANCE_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result1 = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result1.all().get());
            Assertions.assertNull((Object)result1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND, Errors.STALE_MEMBER_EPOCH);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, error));
                HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
                offsets.put(tp1, new OffsetAndMetadata(123L));
                AlterConsumerGroupOffsetsResult errorResult = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
                TestUtils.assertFutureError(errorResult.all(), error.exception().getClass());
                TestUtils.assertFutureError(errorResult.partitionResult(tp1), error.exception().getClass());
            }
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult errorResult = env.adminClient().alterConsumerGroupOffsets(GROUP_ID, offsets);
            TestUtils.assertFutureError(errorResult.all(), GroupAuthorizationException.class);
            TestUtils.assertFutureError(errorResult.partitionResult(tp1), GroupAuthorizationException.class);
        }
    }

    @Test
    public void testListOffsets() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("bar", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("baz", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("qux", 0, node0, new Node[]{node0}, new Node[]{node0}));
        Cluster cluster = new Cluster("mockClusterId", Arrays.asList(node0), pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("bar", 0);
        TopicPartition tp2 = new TopicPartition("baz", 0);
        TopicPartition tp3 = new TopicPartition("qux", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)123L, (int)321);
            ListOffsetsResponseData.ListOffsetsTopicResponse t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)234L, (int)432);
            ListOffsetsResponseData.ListOffsetsTopicResponse t2 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp2, (Errors)Errors.NONE, (long)123456789L, (long)345L, (int)543);
            ListOffsetsResponseData.ListOffsetsTopicResponse t3 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp3, (Errors)Errors.NONE, (long)234567890L, (long)456L, (int)654);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0, t1, t2, t3));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetsResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.earliest());
            partitions.put(tp2, OffsetSpec.forTimestamp((long)System.currentTimeMillis()));
            partitions.put(tp3, OffsetSpec.maxTimestamp());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)321, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assertions.assertEquals((long)234L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assertions.assertEquals((int)432, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
            Assertions.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).offset());
            Assertions.assertEquals((int)543, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).leaderEpoch().get()));
            Assertions.assertEquals((long)123456789L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).timestamp());
            Assertions.assertEquals((long)456L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).offset());
            Assertions.assertEquals((int)654, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).leaderEpoch().get()));
            Assertions.assertEquals((long)234567890L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).timestamp());
            Assertions.assertEquals(offsets.get(tp0), (Object)result.partitionResult(tp0).get());
            Assertions.assertEquals(offsets.get(tp1), (Object)result.partitionResult(tp1).get());
            Assertions.assertEquals(offsets.get(tp2), (Object)result.partitionResult(tp2).get());
            Assertions.assertEquals(offsets.get(tp3), (Object)result.partitionResult(tp3).get());
            try {
                result.partitionResult(new TopicPartition("unknown", 0)).get();
                Assertions.fail((String)"should have thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testListOffsetsRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("foo", 1, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("bar", 0, node1, new Node[]{node1, node0}, new Node[]{node1, node0}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.LEADER_NOT_AVAILABLE, (long)-1L, (long)123L, (int)321);
            ListOffsetsResponseData.ListOffsetsTopicResponse t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)987L, (int)789);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0, t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            ListOffsetsResponseData.ListOffsetsTopicResponse t2 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp2, (Errors)Errors.NONE, (long)-1L, (long)456L, (int)654);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node1);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            partitions.put(tp2, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)543, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assertions.assertEquals((long)987L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assertions.assertEquals((int)789, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
            Assertions.assertEquals((long)456L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).offset());
            Assertions.assertEquals((int)654, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).timestamp());
        }
    }

    @Test
    public void testListOffsetsNonRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.TOPIC_AUTHORIZATION_FAILED, (long)-1L, (long)-1L, (int)-1);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetsResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            TestUtils.assertFutureError(result.all(), TopicAuthorizationException.class);
        }
    }

    @Test
    public void testListOffsetsMaxTimestampUnsupportedSingleOffsetSpec() {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        Cluster cluster = new Cluster("mockClusterId", nodes, Collections.singleton(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node})), Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.LIST_OFFSETS.id, (short)0, (short)6));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListOffsetsRequest);
            ListOffsetsResult result = env.adminClient().listOffsets(Collections.singletonMap(tp0, OffsetSpec.maxTimestamp()));
            TestUtils.assertFutureThrows(result.all(), UnsupportedVersionException.class);
        }
    }

    @Test
    public void testListOffsetsMaxTimestampUnsupportedMultipleOffsetSpec() throws Exception {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        pInfos.add(new PartitionInfo("foo", 1, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        final TopicPartition tp0 = new TopicPartition("foo", 0);
        final TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.LIST_OFFSETS.id, (short)0, (short)6));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListOffsetsRequest);
            ListOffsetsResponseData.ListOffsetsTopicResponse topicResponse = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(topicResponse));
            env.kafkaClient().prepareResponseFrom(request -> request instanceof ListOffsetsRequest && ((ListOffsetsRequest)request).topics().stream().flatMap(t -> t.partitions().stream()).noneMatch(p -> p.timestamp() == -3L), (AbstractResponse)new ListOffsetsResponse(responseData), node);
            ListOffsetsResult result = env.adminClient().listOffsets((Map)new HashMap<TopicPartition, OffsetSpec>(){
                {
                    this.put(tp0, OffsetSpec.maxTimestamp());
                    this.put(tp1, OffsetSpec.latest());
                }
            });
            TestUtils.assertFutureThrows(result.partitionResult(tp0), UnsupportedVersionException.class);
            ListOffsetsResult.ListOffsetsResultInfo tp1Offset = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp1).get();
            Assertions.assertEquals((long)345L, (long)tp1Offset.offset());
            Assertions.assertEquals((int)543, (int)((Integer)tp1Offset.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp1Offset.timestamp());
        }
    }

    @Test
    public void testListOffsetsHandlesFulfillmentTimeouts() throws Exception {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        pInfos.add(new PartitionInfo("foo", 1, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        final TopicPartition tp0 = new TopicPartition("foo", 0);
        final TopicPartition tp1 = new TopicPartition("foo", 1);
        int numRetries = 2;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", Integer.toString(numRetries));){
            ListOffsetsResponseData.ListOffsetsTopicResponse tp0ErrorResponse = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.REQUEST_TIMED_OUT, (long)-1L, (long)-1L, (int)-1);
            ListOffsetsResponseData.ListOffsetsTopicResponse tp1Response = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData responseDataWithError = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(tp0ErrorResponse, tp1Response));
            ListOffsetsResponseData.ListOffsetsTopicResponse tp0Response = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)789L, (int)987);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(tp0Response, tp1Response));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            for (int i = 0; i < numRetries + 1; ++i) {
                env.kafkaClient().prepareResponseFrom(request -> request instanceof ListOffsetsRequest, (AbstractResponse)new ListOffsetsResponse(responseDataWithError), node);
            }
            ListOffsetsResult result = env.adminClient().listOffsets((Map)new HashMap<TopicPartition, OffsetSpec>(){
                {
                    this.put(tp0, OffsetSpec.latest());
                    this.put(tp1, OffsetSpec.latest());
                }
            });
            TestUtils.assertFutureThrows(result.partitionResult(tp0), TimeoutException.class);
            ListOffsetsResult.ListOffsetsResultInfo tp1Result = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp1).get();
            Assertions.assertEquals((long)345L, (long)tp1Result.offset());
            Assertions.assertEquals((int)543, (int)((Integer)tp1Result.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp1Result.timestamp());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            for (int i = 0; i < numRetries; ++i) {
                env.kafkaClient().prepareResponseFrom(request -> request instanceof ListOffsetsRequest, (AbstractResponse)new ListOffsetsResponse(responseDataWithError), node);
            }
            env.kafkaClient().prepareResponseFrom(request -> request instanceof ListOffsetsRequest, (AbstractResponse)new ListOffsetsResponse(responseData), node);
            result = env.adminClient().listOffsets((Map)new HashMap<TopicPartition, OffsetSpec>(){
                {
                    this.put(tp0, OffsetSpec.latest());
                    this.put(tp1, OffsetSpec.latest());
                }
            });
            ListOffsetsResult.ListOffsetsResultInfo tp0Result = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp0).get();
            Assertions.assertEquals((long)789L, (long)tp0Result.offset());
            Assertions.assertEquals((int)987, (int)((Integer)tp0Result.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp0Result.timestamp());
            tp1Result = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp1).get();
            Assertions.assertEquals((long)345L, (long)tp1Result.offset());
            Assertions.assertEquals((int)543, (int)((Integer)tp1Result.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp1Result.timestamp());
        }
    }

    @Test
    public void testListOffsetsUnsupportedNonMaxTimestamp() {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.LIST_OFFSETS.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            env.kafkaClient().prepareUnsupportedVersionResponse(request -> request instanceof ListOffsetsRequest);
            ListOffsetsResult result = env.adminClient().listOffsets(Collections.singletonMap(tp0, OffsetSpec.latest()));
            TestUtils.assertFutureThrows(result.partitionResult(tp0), UnsupportedVersionException.class);
        }
    }

    @Test
    public void testListOffsetsNonMaxTimestampDowngradedImmediately() throws Exception {
        Node node = new Node(0, "localhost", 8120);
        List<Node> nodes = Collections.singletonList(node);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node, new Node[]{node}, new Node[]{node}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.LIST_OFFSETS.id, (short)0, (short)6));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)123L, (int)321);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponse(request -> request instanceof ListOffsetsRequest, (AbstractResponse)new ListOffsetsResponse(responseData));
            ListOffsetsResult result = env.adminClient().listOffsets(Collections.singletonMap(tp0, OffsetSpec.latest()));
            ListOffsetsResult.ListOffsetsResultInfo tp0Offset = (ListOffsetsResult.ListOffsetsResultInfo)result.partitionResult(tp0).get();
            Assertions.assertEquals((long)123L, (long)tp0Offset.offset());
            Assertions.assertEquals((int)321, (int)((Integer)tp0Offset.leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)tp0Offset.timestamp());
        }
    }

    private Map<String, FeatureUpdate> makeTestFeatureUpdates() {
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new FeatureUpdate(2, FeatureUpdate.UpgradeType.UPGRADE)), Utils.mkEntry((Object)"test_feature_2", (Object)new FeatureUpdate(3, FeatureUpdate.UpgradeType.SAFE_DOWNGRADE))});
    }

    private Map<String, ApiError> makeTestFeatureUpdateErrors(Map<String, FeatureUpdate> updates, Errors error) {
        HashMap<String, ApiError> errors = new HashMap<String, ApiError>();
        for (Map.Entry<String, FeatureUpdate> entry : updates.entrySet()) {
            errors.put(entry.getKey(), new ApiError(error));
        }
        return errors;
    }

    private void testUpdateFeatures(Map<String, FeatureUpdate> featureUpdates, ApiError topLevelError, Map<String, ApiError> featureUpdateErrors) throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(body -> body instanceof UpdateFeaturesRequest, (AbstractResponse)UpdateFeaturesResponse.createWithErrors((ApiError)topLevelError, featureUpdateErrors, (int)0));
            Map futures = env.adminClient().updateFeatures(featureUpdates, (UpdateFeaturesOptions)new UpdateFeaturesOptions().timeoutMs(Integer.valueOf(10000))).values();
            for (Map.Entry entry : futures.entrySet()) {
                ExecutionException e;
                KafkaFuture future = (KafkaFuture)entry.getValue();
                ApiError error = featureUpdateErrors.get(entry.getKey());
                if (topLevelError.error() == Errors.NONE) {
                    Assertions.assertNotNull((Object)error);
                    if (error.error() == Errors.NONE) {
                        future.get();
                        continue;
                    }
                    e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)future).get());
                    Assertions.assertEquals(e.getCause().getClass(), error.exception().getClass());
                    continue;
                }
                e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)future).get());
                Assertions.assertEquals(e.getCause().getClass(), topLevelError.exception().getClass());
            }
        }
    }

    @Test
    public void testUpdateFeaturesDuringSuccess() throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        this.testUpdateFeatures(updates, ApiError.NONE, this.makeTestFeatureUpdateErrors(updates, Errors.NONE));
    }

    @Test
    public void testUpdateFeaturesTopLevelError() throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        this.testUpdateFeatures(updates, new ApiError(Errors.INVALID_REQUEST), new HashMap<String, ApiError>());
    }

    @Test
    public void testUpdateFeaturesInvalidRequestError() throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        this.testUpdateFeatures(updates, ApiError.NONE, this.makeTestFeatureUpdateErrors(updates, Errors.INVALID_REQUEST));
    }

    @Test
    public void testUpdateFeaturesUpdateFailedError() throws Exception {
        Map<String, FeatureUpdate> updates = this.makeTestFeatureUpdates();
        this.testUpdateFeatures(updates, ApiError.NONE, this.makeTestFeatureUpdateErrors(updates, Errors.FEATURE_UPDATE_FAILED));
    }

    @Test
    public void testUpdateFeaturesPartialSuccess() throws Exception {
        Map<String, ApiError> errors = this.makeTestFeatureUpdateErrors(this.makeTestFeatureUpdates(), Errors.NONE);
        errors.put("test_feature_2", new ApiError(Errors.INVALID_REQUEST));
        this.testUpdateFeatures(this.makeTestFeatureUpdates(), ApiError.NONE, errors);
    }

    @Test
    public void testUpdateFeaturesHandleNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponseFrom(request -> request instanceof UpdateFeaturesRequest, (AbstractResponse)UpdateFeaturesResponse.createWithErrors((ApiError)new ApiError(Errors.NOT_CONTROLLER), (Map)Utils.mkMap((Map.Entry[])new Map.Entry[0]), (int)0), env.cluster().nodeById(0));
            boolean controllerId = true;
            env.kafkaClient().prepareResponse((AbstractResponse)RequestTestUtils.metadataResponse(env.cluster().nodes(), env.cluster().clusterResource().clusterId(), 1, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom(request -> request instanceof UpdateFeaturesRequest, (AbstractResponse)UpdateFeaturesResponse.createWithErrors((ApiError)ApiError.NONE, (Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)ApiError.NONE), Utils.mkEntry((Object)"test_feature_2", (Object)ApiError.NONE)}), (int)0), env.cluster().nodeById(1));
            KafkaFuture future = env.adminClient().updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test_feature_1", (Object)new FeatureUpdate(2, FeatureUpdate.UpgradeType.UPGRADE)), Utils.mkEntry((Object)"test_feature_2", (Object)new FeatureUpdate(3, FeatureUpdate.UpgradeType.SAFE_DOWNGRADE))}), (UpdateFeaturesOptions)new UpdateFeaturesOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testUpdateFeaturesShouldFailRequestForEmptyUpdates() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> env.adminClient().updateFeatures(new HashMap(), new UpdateFeaturesOptions()));
        }
    }

    @Test
    public void testUpdateFeaturesShouldFailRequestForInvalidFeatureName() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> env.adminClient().updateFeatures(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature", (Object)new FeatureUpdate(2, FeatureUpdate.UpgradeType.UPGRADE)), Utils.mkEntry((Object)"", (Object)new FeatureUpdate(2, FeatureUpdate.UpgradeType.UPGRADE))}), new UpdateFeaturesOptions()));
        }
    }

    @Test
    public void testUpdateFeaturesShouldFailRequestInClientWhenDowngradeFlagIsNotSetDuringDeletion() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FeatureUpdate(0, FeatureUpdate.UpgradeType.UPGRADE));
    }

    @Test
    public void testDescribeFeaturesSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(body -> body instanceof ApiVersionsRequest, (AbstractResponse)KafkaAdminClientTest.prepareApiVersionsResponseForDescribeFeatures(Errors.NONE));
            KafkaFuture future = env.adminClient().describeFeatures((DescribeFeaturesOptions)new DescribeFeaturesOptions().timeoutMs(Integer.valueOf(10000))).featureMetadata();
            FeatureMetadata metadata = (FeatureMetadata)future.get();
            Assertions.assertEquals((Object)KafkaAdminClientTest.defaultFeatureMetadata(), (Object)metadata);
        }
    }

    @Test
    public void testDescribeFeaturesFailure() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(body -> body instanceof ApiVersionsRequest, (AbstractResponse)KafkaAdminClientTest.prepareApiVersionsResponseForDescribeFeatures(Errors.INVALID_REQUEST));
            DescribeFeaturesOptions options = new DescribeFeaturesOptions();
            options.timeoutMs(Integer.valueOf(10000));
            KafkaFuture future = env.adminClient().describeFeatures(options).featureMetadata();
            ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)future).get());
            Assertions.assertEquals(e.getCause().getClass(), Errors.INVALID_REQUEST.exception().getClass());
        }
    }

    @Test
    public void testDescribeMetadataQuorumSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.DESCRIBE_QUORUM.id, (short)ApiKeys.DESCRIBE_QUORUM.oldestVersion(), (short)ApiKeys.DESCRIBE_QUORUM.latestVersion()));
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, false, false, false));
            KafkaFuture future = env.adminClient().describeMetadataQuorum().quorumInfo();
            QuorumInfo quorumInfo = (QuorumInfo)future.get();
            Assertions.assertEquals((Object)KafkaAdminClientTest.defaultQuorumInfo(false), (Object)quorumInfo);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, false, false, true));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            quorumInfo = (QuorumInfo)future.get();
            Assertions.assertEquals((Object)KafkaAdminClientTest.defaultQuorumInfo(true), (Object)quorumInfo);
        }
    }

    @Test
    public void testDescribeMetadataQuorumRetriableError() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.DESCRIBE_QUORUM.id, (short)ApiKeys.DESCRIBE_QUORUM.oldestVersion(), (short)ApiKeys.DESCRIBE_QUORUM.latestVersion()));
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NOT_LEADER_OR_FOLLOWER, false, false, false, false, false));
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, false, false, false));
            KafkaFuture future = env.adminClient().describeMetadataQuorum().quorumInfo();
            QuorumInfo quorumInfo = (QuorumInfo)future.get();
            Assertions.assertEquals((Object)KafkaAdminClientTest.defaultQuorumInfo(false), (Object)quorumInfo);
        }
    }

    @Test
    public void testDescribeMetadataQuorumFailure() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.DESCRIBE_QUORUM.id, (short)ApiKeys.DESCRIBE_QUORUM.oldestVersion(), (short)ApiKeys.DESCRIBE_QUORUM.latestVersion()));
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.INVALID_REQUEST, Errors.NONE, false, false, false, false, false));
            KafkaFuture future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(future, InvalidRequestException.class);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, true, false, false, false, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(future, UnknownServerException.class);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, true, false, false, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(future, UnknownServerException.class);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, true, false, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(future, UnknownServerException.class);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, false, false, false, true, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(future, UnknownServerException.class);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.INVALID_REQUEST, false, false, false, false, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(future, InvalidRequestException.class);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.NONE, Errors.NONE, true, true, true, true, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(future, UnknownServerException.class);
            env.kafkaClient().prepareResponse(body -> body instanceof DescribeQuorumRequest, (AbstractResponse)KafkaAdminClientTest.prepareDescribeQuorumResponse(Errors.INVALID_REQUEST, Errors.INVALID_REQUEST, true, true, true, true, false));
            future = env.adminClient().describeMetadataQuorum().quorumInfo();
            TestUtils.assertFutureThrows(future, Errors.INVALID_REQUEST.exception().getClass());
        }
    }

    @Test
    public void testListOffsetsMetadataRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("foo", 1, node1, new Node[]{node1}, new Node[]{node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.LEADER_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE, Errors.UNKNOWN_TOPIC_OR_PARTITION));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            ListOffsetsResponseData.ListOffsetsTopicResponse t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-1L, (long)789L, (int)987);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node1);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)543, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assertions.assertEquals((long)789L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assertions.assertEquals((int)987, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
        }
    }

    @Test
    public void testListOffsetsWithMultiplePartitionsLeaderChange() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        Node node2 = new Node(2, "localhost", 8122);
        List<Node> nodes = Arrays.asList(node0, node1, node2);
        PartitionInfo oldPInfo1 = new PartitionInfo("foo", 0, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        PartitionInfo oldPnfo2 = new PartitionInfo("foo", 1, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        List<PartitionInfo> oldPInfos = Arrays.asList(oldPInfo1, oldPnfo2);
        Cluster oldCluster = new Cluster("mockClusterId", nodes, oldPInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(oldCluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(oldCluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NOT_LEADER_OR_FOLLOWER, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData.ListOffsetsTopicResponse t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.LEADER_NOT_AVAILABLE, (long)-2L, (long)123L, (int)456);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0, t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            PartitionInfo newPInfo1 = new PartitionInfo("foo", 0, node1, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            PartitionInfo newPInfo2 = new PartitionInfo("foo", 1, node2, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            List<PartitionInfo> newPInfos = Arrays.asList(newPInfo1, newPInfo2);
            Cluster newCluster = new Cluster("mockClusterId", nodes, newPInfos, Collections.emptySet(), Collections.emptySet(), node0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(newCluster, Errors.NONE));
            t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-1L, (long)345L, (int)543);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node1);
            t1 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp1, (Errors)Errors.NONE, (long)-2L, (long)123L, (int)456);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node2);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)543, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assertions.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assertions.assertEquals((int)456, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()));
            Assertions.assertEquals((long)-2L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
        }
    }

    @Test
    public void testListOffsetsWithLeaderChange() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        Node node2 = new Node(2, "localhost", 8122);
        List<Node> nodes = Arrays.asList(node0, node1, node2);
        PartitionInfo oldPartitionInfo = new PartitionInfo("foo", 0, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        Cluster oldCluster = new Cluster("mockClusterId", nodes, Collections.singletonList(oldPartitionInfo), Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(oldCluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(oldCluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NOT_LEADER_OR_FOLLOWER, (long)-1L, (long)345L, (int)543);
            ListOffsetsResponseData responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node0);
            PartitionInfo newPartitionInfo = new PartitionInfo("foo", 0, node1, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            Cluster newCluster = new Cluster("mockClusterId", nodes, Collections.singletonList(newPartitionInfo), Collections.emptySet(), Collections.emptySet(), node0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(newCluster, Errors.NONE));
            t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-2L, (long)123L, (int)456);
            responseData = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(responseData), node1);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assertions.assertFalse((boolean)offsets.isEmpty());
            Assertions.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assertions.assertEquals((int)456, (int)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()));
            Assertions.assertEquals((long)-2L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"listOffsetsMetadataNonRetriableErrors"})
    public void testListOffsetsMetadataNonRetriableErrors(Errors topicMetadataError, Errors partitionMetadataError, Class<? extends Throwable> expectedFailure) throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp1 = new TopicPartition("foo", 0);
        MetadataResponse preparedResponse = KafkaAdminClientTest.prepareMetadataResponse(cluster, topicMetadataError, partitionMetadataError);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)preparedResponse);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            TestUtils.assertFutureError(result.all(), expectedFailure);
        }
    }

    private static Stream<Arguments> listOffsetsMetadataNonRetriableErrors() {
        return Stream.of(Arguments.of((Object[])new Object[]{Errors.TOPIC_AUTHORIZATION_FAILED, Errors.TOPIC_AUTHORIZATION_FAILED, TopicAuthorizationException.class}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.NONE, UnknownTopicOrPartitionException.class}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.UNKNOWN_TOPIC_OR_PARTITION, UnknownTopicOrPartitionException.class}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.LEADER_NOT_AVAILABLE, UnknownTopicOrPartitionException.class}));
    }

    @Test
    public void testListOffsetsPartialResponse() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("foo", 1, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListOffsetsResponseData.ListOffsetsTopicResponse t0 = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp0, (Errors)Errors.NONE, (long)-2L, (long)123L, (int)456);
            ListOffsetsResponseData data = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Arrays.asList(t0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetsResponse(data), node0);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Assertions.assertNotNull((Object)result.partitionResult(tp0).get());
            TestUtils.assertFutureThrows(result.partitionResult(tp1), ApiException.class);
            TestUtils.assertFutureThrows(result.all(), ApiException.class);
        }
    }

    @Test
    public void testGetSubLevelError() {
        List<LeaveGroupRequestData.MemberIdentity> memberIdentities = Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("instance-0"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("instance-1"));
        HashMap<LeaveGroupRequestData.MemberIdentity, Errors> errorsMap = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
        errorsMap.put(memberIdentities.get(0), Errors.NONE);
        errorsMap.put(memberIdentities.get(1), Errors.FENCED_INSTANCE_ID);
        Assertions.assertEquals(IllegalArgumentException.class, KafkaAdminClient.getSubLevelError(errorsMap, (Object)new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("non-exist-id"), (String)"For unit test").getClass());
        Assertions.assertNull((Object)KafkaAdminClient.getSubLevelError(errorsMap, (Object)memberIdentities.get(0), (String)"For unit test"));
        Assertions.assertEquals(FencedInstanceIdException.class, KafkaAdminClient.getSubLevelError(errorsMap, (Object)memberIdentities.get(1), (String)"For unit test").getClass());
    }

    @Test
    public void testSuccessfulRetryAfterRequestTimeout() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Arrays.asList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int requestTimeoutMs = 1000;
        int retryBackoffMs = 100;
        int apiTimeoutMs = 3000;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "retry.backoff.max.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(1000));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(3000)));
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(1001L);
            TestUtils.waitForCondition(() -> !env.kafkaClient().hasInFlightRequests(), "Timed out waiting for inFlightRequests to be timed out");
            time.sleep(101L);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Failed to retry Metadata request");
            env.kafkaClient().respond((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            Assertions.assertEquals((int)1, (int)((Collection)result.listings().get()).size());
            Assertions.assertEquals((Object)"foo", (Object)((TopicListing)((Collection)result.listings().get()).iterator().next()).name());
        }
    }

    @Test
    public void testDefaultApiTimeout() throws Exception {
        this.testApiTimeout(1500, 3000, OptionalInt.empty());
    }

    @Test
    public void testDefaultApiTimeoutOverride() throws Exception {
        this.testApiTimeout(1500, 10000, OptionalInt.of(3000));
    }

    private void testApiTimeout(int requestTimeoutMs, int defaultApiTimeoutMs, OptionalInt overrideApiTimeoutMs) throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Arrays.asList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int retryBackoffMs = 100;
        int effectiveTimeoutMs = overrideApiTimeoutMs.orElse(defaultApiTimeoutMs);
        Assertions.assertEquals((int)(2 * requestTimeoutMs), (int)effectiveTimeoutMs, (String)"This test expects the effective timeout to be twice the request timeout");
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(requestTimeoutMs), "default.api.timeout.ms", String.valueOf(defaultApiTimeoutMs));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsOptions options = new ListTopicsOptions();
            overrideApiTimeoutMs.ifPresent(arg_0 -> ((ListTopicsOptions)options).timeoutMs(arg_0));
            ListTopicsResult result = env.adminClient().listTopics(options);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(requestTimeoutMs + 1);
            TestUtils.waitForCondition(() -> !env.kafkaClient().hasInFlightRequests(), "Timed out waiting for inFlightRequests to be timed out");
            TestUtils.waitForCondition(() -> {
                boolean hasInflightRequests = env.kafkaClient().hasInFlightRequests();
                if (!hasInflightRequests) {
                    time.sleep(100L);
                }
                return hasInflightRequests;
            }, "Timed out waiting for Metadata request to be sent");
            time.sleep(requestTimeoutMs + 1);
            TestUtils.assertFutureThrows(result.future, TimeoutException.class);
        }
    }

    @Test
    public void testRequestTimeoutExceedingDefaultApiTimeout() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Arrays.asList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int retryBackoffMs = 100;
        int requestTimeoutMs = 120000;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(120000));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsOptions options = new ListTopicsOptions();
            ListTopicsResult result = env.adminClient().listTopics(options);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(60001L);
            Assertions.assertTrue((boolean)env.kafkaClient().hasInFlightRequests());
            time.sleep(60000L);
            TestUtils.assertFutureThrows(result.future, TimeoutException.class);
        }
    }

    private ClientQuotaEntity newClientQuotaEntity(String ... args) {
        Assertions.assertEquals((int)0, (int)(args.length % 2));
        HashMap<String, String> entityMap = new HashMap<String, String>(args.length / 2);
        for (int index = 0; index < args.length; index += 2) {
            entityMap.put(args[index], args[index + 1]);
        }
        return new ClientQuotaEntity(entityMap);
    }

    @Test
    public void testDescribeClientQuotas() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String value = "value";
            HashMap<ClientQuotaEntity, Map<String, Double>> responseData = new HashMap<ClientQuotaEntity, Map<String, Double>>();
            ClientQuotaEntity entity1 = this.newClientQuotaEntity("user", "user-1", "client-id", "value");
            ClientQuotaEntity entity2 = this.newClientQuotaEntity("user", "user-2", "client-id", "value");
            responseData.put(entity1, Collections.singletonMap("consumer_byte_rate", 10000.0));
            responseData.put(entity2, Collections.singletonMap("producer_byte_rate", 20000.0));
            env.kafkaClient().prepareResponse((AbstractResponse)DescribeClientQuotasResponse.fromQuotaEntities(responseData, (int)0));
            ClientQuotaFilter filter = ClientQuotaFilter.contains(Arrays.asList(ClientQuotaFilterComponent.ofEntity((String)"user", (String)"value")));
            DescribeClientQuotasResult result = env.adminClient().describeClientQuotas(filter);
            Map resultData = (Map)result.entities().get();
            Assertions.assertEquals((int)resultData.size(), (int)2);
            Assertions.assertTrue((boolean)resultData.containsKey(entity1));
            Map config1 = (Map)resultData.get(entity1);
            Assertions.assertEquals((int)config1.size(), (int)1);
            Assertions.assertEquals((double)((Double)config1.get("consumer_byte_rate")), (double)10000.0, (double)1.0E-6);
            Assertions.assertTrue((boolean)resultData.containsKey(entity2));
            Map config2 = (Map)resultData.get(entity2);
            Assertions.assertEquals((int)config2.size(), (int)1);
            Assertions.assertEquals((double)((Double)config2.get("producer_byte_rate")), (double)20000.0, (double)1.0E-6);
        }
    }

    @Test
    public void testEqualsOfClientQuotaFilterComponent() {
        Assertions.assertEquals((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"));
        Assertions.assertEquals((Object)ClientQuotaFilterComponent.ofEntityType((String)"user"), (Object)ClientQuotaFilterComponent.ofEntityType((String)"user"));
        Assertions.assertNotEquals((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"), (Object)ClientQuotaFilterComponent.ofEntityType((String)"user"));
        Assertions.assertEquals((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"), (Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"));
        Assertions.assertNotEquals((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"), (Object)ClientQuotaFilterComponent.ofDefaultEntity((String)"user"));
        Assertions.assertNotEquals((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"user"), (Object)ClientQuotaFilterComponent.ofEntityType((String)"user"));
    }

    @Test
    public void testAlterClientQuotas() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ClientQuotaEntity goodEntity = this.newClientQuotaEntity("user", "user-1");
            ClientQuotaEntity unauthorizedEntity = this.newClientQuotaEntity("user", "user-0");
            ClientQuotaEntity invalidEntity = this.newClientQuotaEntity("", "user-0");
            HashMap<ClientQuotaEntity, ApiError> responseData = new HashMap<ClientQuotaEntity, ApiError>(2);
            responseData.put(goodEntity, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, "Authorization failed"));
            responseData.put(unauthorizedEntity, new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED, "Authorization failed"));
            responseData.put(invalidEntity, new ApiError(Errors.INVALID_REQUEST, "Invalid quota entity"));
            env.kafkaClient().prepareResponse((AbstractResponse)AlterClientQuotasResponse.fromQuotaEntities(responseData, (int)0));
            ArrayList<ClientQuotaAlteration> entries = new ArrayList<ClientQuotaAlteration>(3);
            entries.add(new ClientQuotaAlteration(goodEntity, Collections.singleton(new ClientQuotaAlteration.Op("consumer_byte_rate", Double.valueOf(10000.0)))));
            entries.add(new ClientQuotaAlteration(unauthorizedEntity, Collections.singleton(new ClientQuotaAlteration.Op("producer_byte_rate", Double.valueOf(10000.0)))));
            entries.add(new ClientQuotaAlteration(invalidEntity, Collections.singleton(new ClientQuotaAlteration.Op("producer_byte_rate", Double.valueOf(100.0)))));
            AlterClientQuotasResult result = env.adminClient().alterClientQuotas(entries);
            result.values().get(goodEntity);
            TestUtils.assertFutureError((Future)result.values().get(unauthorizedEntity), ClusterAuthorizationException.class);
            TestUtils.assertFutureError((Future)result.values().get(invalidEntity), InvalidRequestException.class);
        }
    }

    @Test
    public void testAlterReplicaLogDirsSuccess() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 0);
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(1), Errors.NONE, 0);
            TopicPartitionReplica tpr0 = new TopicPartitionReplica("topic", 0, 0);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 0, 1);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr0, "/data0");
            logDirs.put(tpr1, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr0)).get());
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr1)).get());
        }
    }

    @Test
    public void testAlterReplicaLogDirsLogDirNotFound() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 0);
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(1), Errors.LOG_DIR_NOT_FOUND, 0);
            TopicPartitionReplica tpr0 = new TopicPartitionReplica("topic", 0, 0);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 0, 1);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr0, "/data0");
            logDirs.put(tpr1, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr0)).get());
            TestUtils.assertFutureError((Future)result.values().get(tpr1), LogDirNotFoundException.class);
        }
    }

    @Test
    public void testAlterReplicaLogDirsUnrequested() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 1, 2);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 1, 0);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr1, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr1)).get());
        }
    }

    @Test
    public void testAlterReplicaLogDirsPartialResponse() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            this.createAlterLogDirsResponse(env, env.cluster().nodeById(0), Errors.NONE, 1);
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 1, 0);
            TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic", 2, 0);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr1, "/data1");
            logDirs.put(tpr2, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr1)).get());
            TestUtils.assertFutureThrows((Future)result.values().get(tpr2), ApiException.class);
        }
    }

    @Test
    public void testAlterReplicaLogDirsPartialFailure() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "retries", "0");){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareAlterLogDirsResponse(Errors.NONE, "topic", 2), env.cluster().nodeById(1));
            TopicPartitionReplica tpr1 = new TopicPartitionReplica("topic", 1, 0);
            TopicPartitionReplica tpr2 = new TopicPartitionReplica("topic", 2, 1);
            HashMap<TopicPartitionReplica, String> logDirs = new HashMap<TopicPartitionReplica, String>();
            logDirs.put(tpr1, "/data1");
            logDirs.put(tpr2, "/data1");
            AlterReplicaLogDirsResult result = env.adminClient().alterReplicaLogDirs(logDirs);
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting request");
            time.sleep(defaultApiTimeout + 1L);
            TestUtils.assertFutureThrows((Future)result.values().get(tpr1), ApiException.class);
            Assertions.assertNull((Object)((KafkaFuture)result.values().get(tpr2)).get());
        }
    }

    @Test
    public void testDescribeUserScramCredentials() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String user0Name = "user0";
            ScramMechanism user0ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            int user0Iterations0 = 4096;
            ScramMechanism user0ScramMechanism1 = ScramMechanism.SCRAM_SHA_512;
            int user0Iterations1 = 8192;
            DescribeUserScramCredentialsResponseData.CredentialInfo user0CredentialInfo0 = new DescribeUserScramCredentialsResponseData.CredentialInfo();
            user0CredentialInfo0.setMechanism(user0ScramMechanism0.type());
            user0CredentialInfo0.setIterations(4096);
            DescribeUserScramCredentialsResponseData.CredentialInfo user0CredentialInfo1 = new DescribeUserScramCredentialsResponseData.CredentialInfo();
            user0CredentialInfo1.setMechanism(user0ScramMechanism1.type());
            user0CredentialInfo1.setIterations(8192);
            String user1Name = "user1";
            ScramMechanism user1ScramMechanism = ScramMechanism.SCRAM_SHA_256;
            int user1Iterations = 4096;
            DescribeUserScramCredentialsResponseData.CredentialInfo user1CredentialInfo = new DescribeUserScramCredentialsResponseData.CredentialInfo();
            user1CredentialInfo.setMechanism(user1ScramMechanism.type());
            user1CredentialInfo.setIterations(4096);
            DescribeUserScramCredentialsResponseData responseData = new DescribeUserScramCredentialsResponseData();
            responseData.setResults(Arrays.asList(new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser("user0").setCredentialInfos(Arrays.asList(user0CredentialInfo0, user0CredentialInfo1)), new DescribeUserScramCredentialsResponseData.DescribeUserScramCredentialsResult().setUser("user1").setCredentialInfos(Collections.singletonList(user1CredentialInfo))));
            DescribeUserScramCredentialsResponse response = new DescribeUserScramCredentialsResponse(responseData);
            HashSet<String> usersRequestedSet = new HashSet<String>();
            usersRequestedSet.add("user0");
            usersRequestedSet.add("user1");
            for (List users : Arrays.asList(null, new ArrayList(), Arrays.asList("user0", null, "user1"))) {
                env.kafkaClient().prepareResponse((AbstractResponse)response);
                DescribeUserScramCredentialsResult result = env.adminClient().describeUserScramCredentials(users);
                Map descriptionResults = (Map)result.all().get();
                KafkaFuture user0DescriptionFuture = result.description("user0");
                KafkaFuture user1DescriptionFuture = result.description("user1");
                HashSet usersDescribedFromUsersSet = new HashSet((Collection)result.users().get());
                Assertions.assertEquals(usersRequestedSet, usersDescribedFromUsersSet);
                Set usersDescribedFromMapKeySet = descriptionResults.keySet();
                Assertions.assertEquals(usersRequestedSet, usersDescribedFromMapKeySet);
                UserScramCredentialsDescription userScramCredentialsDescription0 = (UserScramCredentialsDescription)descriptionResults.get("user0");
                Assertions.assertEquals((Object)"user0", (Object)userScramCredentialsDescription0.name());
                Assertions.assertEquals((int)2, (int)userScramCredentialsDescription0.credentialInfos().size());
                Assertions.assertEquals((Object)user0ScramMechanism0, (Object)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(0)).mechanism());
                Assertions.assertEquals((int)4096, (int)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(0)).iterations());
                Assertions.assertEquals((Object)user0ScramMechanism1, (Object)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(1)).mechanism());
                Assertions.assertEquals((int)8192, (int)((ScramCredentialInfo)userScramCredentialsDescription0.credentialInfos().get(1)).iterations());
                Assertions.assertEquals((Object)userScramCredentialsDescription0, (Object)user0DescriptionFuture.get());
                UserScramCredentialsDescription userScramCredentialsDescription1 = (UserScramCredentialsDescription)descriptionResults.get("user1");
                Assertions.assertEquals((Object)"user1", (Object)userScramCredentialsDescription1.name());
                Assertions.assertEquals((int)1, (int)userScramCredentialsDescription1.credentialInfos().size());
                Assertions.assertEquals((Object)user1ScramMechanism, (Object)((ScramCredentialInfo)userScramCredentialsDescription1.credentialInfos().get(0)).mechanism());
                Assertions.assertEquals((int)4096, (int)((ScramCredentialInfo)userScramCredentialsDescription1.credentialInfos().get(0)).iterations());
                Assertions.assertEquals((Object)userScramCredentialsDescription1, (Object)user1DescriptionFuture.get());
            }
        }
    }

    @Test
    public void testAlterUserScramCredentialsUnknownMechanism() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String user0Name = "user0";
            ScramMechanism user0ScramMechanism0 = ScramMechanism.UNKNOWN;
            String user1Name = "user1";
            ScramMechanism user1ScramMechanism0 = ScramMechanism.UNKNOWN;
            String user2Name = "user2";
            ScramMechanism user2ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            AlterUserScramCredentialsResponseData responseData = new AlterUserScramCredentialsResponseData();
            responseData.setResults(Arrays.asList(new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser("user2")));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterUserScramCredentialsResponse(responseData));
            AlterUserScramCredentialsResult result = env.adminClient().alterUserScramCredentials(Arrays.asList(new UserScramCredentialDeletion("user0", user0ScramMechanism0), new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(user1ScramMechanism0, 8192), "password"), new UserScramCredentialUpsertion("user2", new ScramCredentialInfo(user2ScramMechanism0, 4096), "password")));
            Map resultData = result.values();
            Assertions.assertEquals((int)3, (int)resultData.size());
            Arrays.asList("user0", "user1").stream().forEach(u -> {
                Assertions.assertTrue((boolean)resultData.containsKey(u));
                try {
                    ((KafkaFuture)resultData.get(u)).get();
                    Assertions.fail((String)("Expected request for user " + u + " to complete exceptionally, but it did not"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            Assertions.assertTrue((boolean)resultData.containsKey("user2"));
            try {
                ((KafkaFuture)resultData.get("user2")).get();
            }
            catch (Exception e) {
                Assertions.fail((String)"Expected request for user user2 to NOT complete excdptionally, but it did");
            }
            try {
                result.all().get();
                Assertions.fail((String)"Expected 'result.all().get()' to throw an exception since at least one user failed, but it did not");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAlterUserScramCredentials() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            String user0Name = "user0";
            ScramMechanism user0ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            ScramMechanism user0ScramMechanism1 = ScramMechanism.SCRAM_SHA_512;
            String user1Name = "user1";
            ScramMechanism user1ScramMechanism0 = ScramMechanism.SCRAM_SHA_256;
            String user2Name = "user2";
            ScramMechanism user2ScramMechanism0 = ScramMechanism.SCRAM_SHA_512;
            AlterUserScramCredentialsResponseData responseData = new AlterUserScramCredentialsResponseData();
            responseData.setResults(Arrays.asList("user0", "user1", "user2").stream().map(u -> new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser(u).setErrorCode(Errors.NONE.code())).collect(Collectors.toList()));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterUserScramCredentialsResponse(responseData));
            AlterUserScramCredentialsResult result = env.adminClient().alterUserScramCredentials(Arrays.asList(new UserScramCredentialDeletion("user0", user0ScramMechanism0), new UserScramCredentialUpsertion("user0", new ScramCredentialInfo(user0ScramMechanism1, 8192), "password"), new UserScramCredentialUpsertion("user1", new ScramCredentialInfo(user1ScramMechanism0, 8192), "password"), new UserScramCredentialDeletion("user2", user2ScramMechanism0)));
            Map resultData = result.values();
            Assertions.assertEquals((int)3, (int)resultData.size());
            Arrays.asList("user0", "user1", "user2").stream().forEach(u -> {
                Assertions.assertTrue((boolean)resultData.containsKey(u));
                Assertions.assertFalse((boolean)((KafkaFuture)resultData.get(u)).isCompletedExceptionally());
            });
        }
    }

    private void createAlterLogDirsResponse(AdminClientUnitTestEnv env, Node node, Errors error, int ... partitions) {
        env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareAlterLogDirsResponse(error, "topic", partitions), node);
    }

    private AlterReplicaLogDirsResponse prepareAlterLogDirsResponse(Errors error, String topic, int ... partitions) {
        return new AlterReplicaLogDirsResponse(new AlterReplicaLogDirsResponseData().setResults(Collections.singletonList(new AlterReplicaLogDirsResponseData.AlterReplicaLogDirTopicResult().setTopicName(topic).setPartitions(Arrays.stream(partitions).boxed().map(partitionId -> new AlterReplicaLogDirsResponseData.AlterReplicaLogDirPartitionResult().setPartitionIndex(partitionId.intValue()).setErrorCode(error.code())).collect(Collectors.toList())))));
    }

    @Test
    public void testDescribeLogDirsPartialFailure() throws Exception {
        long defaultApiTimeout = 60000L;
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, "retries", "0");){
            env.kafkaClient().prepareResponseFrom((AbstractResponse)this.prepareDescribeLogDirsResponse(Errors.NONE, "/data"), env.cluster().nodeById(1));
            DescribeLogDirsResult result = env.adminClient().describeLogDirs(Arrays.asList(0, 1));
            TestUtils.waitForCondition(() -> env.kafkaClient().numAwaitingResponses() == 0, "Failed awaiting requests");
            TestUtils.waitForCondition(() -> env.kafkaClient().inFlightRequestCount() == 1, "Failed awaiting request");
            time.sleep(defaultApiTimeout + 1L);
            TestUtils.assertFutureThrows((Future)result.descriptions().get(0), ApiException.class);
            Assertions.assertNotNull((Object)((KafkaFuture)result.descriptions().get(1)).get());
        }
    }

    @Test
    public void testUnregisterBrokerSuccess() throws InterruptedException, ExecutionException {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.NONE, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            result.all().get();
        }
    }

    @Test
    public void testUnregisterBrokerFailure() {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.UNKNOWN_SERVER_ERROR, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(result.all(), Errors.UNKNOWN_SERVER_ERROR.exception().getClass());
        }
    }

    @Test
    public void testUnregisterBrokerTimeoutAndSuccessRetry() throws ExecutionException, InterruptedException {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.REQUEST_TIMED_OUT, 0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.NONE, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            result.all().get();
        }
    }

    @Test
    public void testUnregisterBrokerTimeoutAndFailureRetry() {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.REQUEST_TIMED_OUT, 0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.UNKNOWN_SERVER_ERROR, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(result.all(), Errors.UNKNOWN_SERVER_ERROR.exception().getClass());
        }
    }

    @Test
    public void testUnregisterBrokerTimeoutMaxRetry() {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(Time.SYSTEM, "retries", "1");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.REQUEST_TIMED_OUT, 0));
            env.kafkaClient().prepareResponse((AbstractResponse)this.prepareUnregisterBrokerResponse(Errors.REQUEST_TIMED_OUT, 0));
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId);
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(result.all(), Errors.REQUEST_TIMED_OUT.exception().getClass());
        }
    }

    @Test
    public void testUnregisterBrokerTimeoutMaxWait() {
        int nodeId = 1;
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.UNREGISTER_BROKER.id, (short)0, (short)0));
            UnregisterBrokerOptions options = new UnregisterBrokerOptions();
            options.timeoutMs = 10;
            UnregisterBrokerResult result = env.adminClient().unregisterBroker(nodeId, options);
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(result.all(), Errors.REQUEST_TIMED_OUT.exception().getClass());
        }
    }

    @Test
    public void testDescribeProducers() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            TopicPartition topicPartition = new TopicPartition("foo", 0);
            Node leader = (Node)env.cluster().nodes().iterator().next();
            this.expectMetadataRequest(env, topicPartition, leader);
            List<ProducerState> expected = Arrays.asList(new ProducerState(12345L, 15, 30, env.time().milliseconds(), OptionalInt.of(99), OptionalLong.empty()), new ProducerState(12345L, 15, 30, env.time().milliseconds(), OptionalInt.empty(), OptionalLong.of(23423L)));
            DescribeProducersResponse response = this.buildDescribeProducersResponse(topicPartition, expected);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof DescribeProducersRequest, (AbstractResponse)response, leader);
            DescribeProducersResult result = env.adminClient().describeProducers(Collections.singleton(topicPartition));
            KafkaFuture partitionFuture = result.partitionResult(topicPartition);
            Assertions.assertEquals(new HashSet<ProducerState>(expected), new HashSet(((DescribeProducersResult.PartitionProducerState)partitionFuture.get()).activeProducers()));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDescribeProducersTimeout(boolean timeoutInMetadataLookup) throws Exception {
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(time, new String[0]);){
            TopicPartition topicPartition = new TopicPartition("foo", 0);
            int requestTimeoutMs = 15000;
            if (!timeoutInMetadataLookup) {
                Node leader = (Node)env.cluster().nodes().iterator().next();
                this.expectMetadataRequest(env, topicPartition, leader);
            }
            DescribeProducersOptions options = (DescribeProducersOptions)new DescribeProducersOptions().timeoutMs(Integer.valueOf(requestTimeoutMs));
            DescribeProducersResult result = env.adminClient().describeProducers(Collections.singleton(topicPartition), options);
            Assertions.assertFalse((boolean)result.all().isDone());
            time.sleep(requestTimeoutMs);
            TestUtils.waitForCondition(() -> result.all().isDone(), "Future failed to timeout after expiration of timeout");
            Assertions.assertTrue((boolean)result.all().isCompletedExceptionally());
            TestUtils.assertFutureThrows(result.all(), TimeoutException.class);
            Assertions.assertFalse((boolean)env.kafkaClient().hasInFlightRequests());
        }
    }

    @Test
    public void testDescribeProducersRetryAfterDisconnect() throws Exception {
        MockTime time = new MockTime();
        int retryBackoffMs = 100;
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        Map<String, Object> configOverride = KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoffMs);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, configOverride);){
            TopicPartition topicPartition = new TopicPartition("foo", 0);
            Iterator nodeIterator = env.cluster().nodes().iterator();
            Node initialLeader = (Node)nodeIterator.next();
            this.expectMetadataRequest(env, topicPartition, initialLeader);
            List<ProducerState> expected = Arrays.asList(new ProducerState(12345L, 15, 30, env.time().milliseconds(), OptionalInt.of(99), OptionalLong.empty()), new ProducerState(12345L, 15, 30, env.time().milliseconds(), OptionalInt.empty(), OptionalLong.of(23423L)));
            DescribeProducersResponse response = this.buildDescribeProducersResponse(topicPartition, expected);
            env.kafkaClient().prepareResponseFrom(request -> {
                env.time().sleep((long)retryBackoffMs);
                return request instanceof DescribeProducersRequest;
            }, (AbstractResponse)response, initialLeader, true);
            Node retryLeader = (Node)nodeIterator.next();
            this.expectMetadataRequest(env, topicPartition, retryLeader);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof DescribeProducersRequest, (AbstractResponse)response, retryLeader);
            DescribeProducersResult result = env.adminClient().describeProducers(Collections.singleton(topicPartition));
            KafkaFuture partitionFuture = result.partitionResult(topicPartition);
            Assertions.assertEquals(new HashSet<ProducerState>(expected), new HashSet(((DescribeProducersResult.PartitionProducerState)partitionFuture.get()).activeProducers()));
        }
    }

    @Test
    public void testDescribeTransactions() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String transactionalId = "foo";
            Node coordinator = (Node)env.cluster().nodes().iterator().next();
            TransactionDescription expected = new TransactionDescription(coordinator.id(), TransactionState.COMPLETE_COMMIT, 12345L, 15, 10000L, OptionalLong.empty(), Collections.emptySet());
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, transactionalId, coordinator));
            env.kafkaClient().prepareResponseFrom(request -> request instanceof DescribeTransactionsRequest, (AbstractResponse)new DescribeTransactionsResponse(new DescribeTransactionsResponseData().setTransactionStates(Collections.singletonList(new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NONE.code()).setProducerEpoch((short)expected.producerEpoch()).setProducerId(expected.producerId()).setTransactionalId(transactionalId).setTransactionTimeoutMs(10000).setTransactionStartTimeMs(-1L).setTransactionState(expected.state().toString())))), coordinator);
            DescribeTransactionsResult result = env.adminClient().describeTransactions(Collections.singleton(transactionalId));
            KafkaFuture future = result.description(transactionalId);
            Assertions.assertEquals((Object)expected, (Object)future.get());
        }
    }

    @Test
    public void testRetryDescribeTransactionsAfterNotCoordinatorError() throws Exception {
        MockTime time = new MockTime();
        int retryBackoffMs = 100;
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        Map<String, Object> configOverride = KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoffMs);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, configOverride);){
            String transactionalId = "foo";
            Iterator nodeIterator = env.cluster().nodes().iterator();
            Node coordinator1 = (Node)nodeIterator.next();
            Node coordinator2 = (Node)nodeIterator.next();
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)new FindCoordinatorResponse(new FindCoordinatorResponseData().setCoordinators(Arrays.asList(new FindCoordinatorResponseData.Coordinator().setKey(transactionalId).setErrorCode(Errors.NONE.code()).setNodeId(coordinator1.id()).setHost(coordinator1.host()).setPort(coordinator1.port())))));
            env.kafkaClient().prepareResponseFrom(request -> {
                if (!(request instanceof DescribeTransactionsRequest)) {
                    return false;
                }
                time.sleep(retryBackoffMs);
                return true;
            }, (AbstractResponse)new DescribeTransactionsResponse(new DescribeTransactionsResponseData().setTransactionStates(Collections.singletonList(new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NOT_COORDINATOR.code()).setTransactionalId(transactionalId)))), coordinator1);
            env.kafkaClient().prepareResponse(request -> request instanceof FindCoordinatorRequest, (AbstractResponse)new FindCoordinatorResponse(new FindCoordinatorResponseData().setCoordinators(Arrays.asList(new FindCoordinatorResponseData.Coordinator().setKey(transactionalId).setErrorCode(Errors.NONE.code()).setNodeId(coordinator2.id()).setHost(coordinator2.host()).setPort(coordinator2.port())))));
            TransactionDescription expected = new TransactionDescription(coordinator2.id(), TransactionState.COMPLETE_COMMIT, 12345L, 15, 10000L, OptionalLong.empty(), Collections.emptySet());
            env.kafkaClient().prepareResponseFrom(request -> request instanceof DescribeTransactionsRequest, (AbstractResponse)new DescribeTransactionsResponse(new DescribeTransactionsResponseData().setTransactionStates(Collections.singletonList(new DescribeTransactionsResponseData.TransactionState().setErrorCode(Errors.NONE.code()).setProducerEpoch((short)expected.producerEpoch()).setProducerId(expected.producerId()).setTransactionalId(transactionalId).setTransactionTimeoutMs(10000).setTransactionStartTimeMs(-1L).setTransactionState(expected.state().toString())))), coordinator2);
            DescribeTransactionsResult result = env.adminClient().describeTransactions(Collections.singleton(transactionalId));
            KafkaFuture future = result.description(transactionalId);
            Assertions.assertEquals((Object)expected, (Object)future.get());
        }
    }

    @Test
    public void testAbortTransaction() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            TopicPartition topicPartition = new TopicPartition("foo", 13);
            AbortTransactionSpec abortSpec = new AbortTransactionSpec(topicPartition, 12345L, 15, 200);
            Node leader = (Node)env.cluster().nodes().iterator().next();
            this.expectMetadataRequest(env, topicPartition, leader);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof WriteTxnMarkersRequest, (AbstractResponse)this.writeTxnMarkersResponse(abortSpec, Errors.NONE), leader);
            AbortTransactionResult result = env.adminClient().abortTransaction(abortSpec);
            Assertions.assertNull((Object)result.all().get());
        }
    }

    @Test
    public void testAbortTransactionFindLeaderAfterDisconnect() throws Exception {
        MockTime time = new MockTime();
        int retryBackoffMs = 100;
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        Map<String, Object> configOverride = KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoffMs);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, configOverride);){
            TopicPartition topicPartition = new TopicPartition("foo", 13);
            AbortTransactionSpec abortSpec = new AbortTransactionSpec(topicPartition, 12345L, 15, 200);
            Iterator nodeIterator = env.cluster().nodes().iterator();
            Node firstLeader = (Node)nodeIterator.next();
            this.expectMetadataRequest(env, topicPartition, firstLeader);
            WriteTxnMarkersResponse response = this.writeTxnMarkersResponse(abortSpec, Errors.NONE);
            env.kafkaClient().prepareResponseFrom(request -> {
                time.sleep(retryBackoffMs);
                return request instanceof WriteTxnMarkersRequest;
            }, (AbstractResponse)response, firstLeader, true);
            Node retryLeader = (Node)nodeIterator.next();
            this.expectMetadataRequest(env, topicPartition, retryLeader);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof WriteTxnMarkersRequest, (AbstractResponse)response, retryLeader);
            AbortTransactionResult result = env.adminClient().abortTransaction(abortSpec);
            Assertions.assertNull((Object)result.all().get());
        }
    }

    @Test
    public void testListTransactions() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
            env.cluster().nodes().forEach(node -> brokers.add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setHost(node.host()).setNodeId(node.id()).setPort(node.port()).setRack(node.rack())));
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)new MetadataResponse(new MetadataResponseData().setBrokers(brokers), 12));
            List<TransactionListing> expected = Arrays.asList(new TransactionListing("foo", 12345L, TransactionState.ONGOING), new TransactionListing("bar", 98765L, TransactionState.PREPARE_ABORT), new TransactionListing("baz", 13579L, TransactionState.COMPLETE_COMMIT));
            Assertions.assertEquals((Object)Utils.mkSet((Object[])new Integer[]{0, 1, 2}), env.cluster().nodes().stream().map(Node::id).collect(Collectors.toSet()));
            env.cluster().nodes().forEach(node -> {
                ListTransactionsResponseData response = new ListTransactionsResponseData().setErrorCode(Errors.NONE.code());
                TransactionListing listing = (TransactionListing)expected.get(node.id());
                response.transactionStates().add(new ListTransactionsResponseData.TransactionState().setTransactionalId(listing.transactionalId()).setProducerId(listing.producerId()).setTransactionState(listing.state().toString()));
                env.kafkaClient().prepareResponseFrom(request -> request instanceof ListTransactionsRequest, (AbstractResponse)new ListTransactionsResponse(response), (Node)node);
            });
            ListTransactionsResult result = env.adminClient().listTransactions();
            Assertions.assertEquals(new HashSet<TransactionListing>(expected), new HashSet((Collection)result.all().get()));
        }
    }

    private WriteTxnMarkersResponse writeTxnMarkersResponse(AbortTransactionSpec abortSpec, Errors error) {
        WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult partitionResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerPartitionResult().setPartitionIndex(abortSpec.topicPartition().partition()).setErrorCode(error.code());
        WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult topicResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerTopicResult().setName(abortSpec.topicPartition().topic());
        topicResponse.partitions().add(partitionResponse);
        WriteTxnMarkersResponseData.WritableTxnMarkerResult markerResponse = new WriteTxnMarkersResponseData.WritableTxnMarkerResult().setProducerId(abortSpec.producerId());
        markerResponse.topics().add(topicResponse);
        WriteTxnMarkersResponseData response = new WriteTxnMarkersResponseData();
        response.markers().add(markerResponse);
        return new WriteTxnMarkersResponse(response);
    }

    private DescribeProducersResponse buildDescribeProducersResponse(TopicPartition topicPartition, List<ProducerState> producerStates) {
        DescribeProducersResponseData response = new DescribeProducersResponseData();
        DescribeProducersResponseData.TopicResponse topicResponse = new DescribeProducersResponseData.TopicResponse().setName(topicPartition.topic());
        response.topics().add(topicResponse);
        DescribeProducersResponseData.PartitionResponse partitionResponse = new DescribeProducersResponseData.PartitionResponse().setPartitionIndex(topicPartition.partition()).setErrorCode(Errors.NONE.code());
        topicResponse.partitions().add(partitionResponse);
        partitionResponse.setActiveProducers(producerStates.stream().map(producerState -> new DescribeProducersResponseData.ProducerState().setProducerId(producerState.producerId()).setProducerEpoch(producerState.producerEpoch()).setCoordinatorEpoch(producerState.coordinatorEpoch().orElse(-1)).setLastSequence(producerState.lastSequence()).setLastTimestamp(producerState.lastTimestamp()).setCurrentTxnStartOffset(producerState.currentTransactionStartOffset().orElse(-1L))).collect(Collectors.toList()));
        return new DescribeProducersResponse(response);
    }

    private void expectMetadataRequest(AdminClientUnitTestEnv env, TopicPartition topicPartition, Node leader) {
        MetadataResponseData.MetadataResponseTopicCollection responseTopics = new MetadataResponseData.MetadataResponseTopicCollection();
        MetadataResponseData.MetadataResponseTopic responseTopic = new MetadataResponseData.MetadataResponseTopic().setName(topicPartition.topic()).setErrorCode(Errors.NONE.code());
        responseTopics.add((ImplicitLinkedHashCollection.Element)responseTopic);
        MetadataResponseData.MetadataResponsePartition responsePartition = new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NONE.code()).setPartitionIndex(topicPartition.partition()).setLeaderId(leader.id()).setReplicaNodes(Collections.singletonList(leader.id())).setIsrNodes(Collections.singletonList(leader.id()));
        responseTopic.partitions().add(responsePartition);
        env.kafkaClient().prepareResponse(request -> {
            if (!(request instanceof MetadataRequest)) {
                return false;
            }
            MetadataRequest metadataRequest = (MetadataRequest)request;
            return metadataRequest.topics().equals(Collections.singletonList(topicPartition.topic()));
        }, (AbstractResponse)new MetadataResponse(new MetadataResponseData().setTopics(responseTopics), 12));
    }

    @Test
    public void testClientSideTimeoutAfterFailureToSend() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        CompletableFuture<String> disconnectFuture = new CompletableFuture<String>();
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, KafkaAdminClientTest.newStrMap("request.timeout.ms", "1", "default.api.timeout.ms", "100000", "retry.backoff.ms", "1"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Node node2 : cluster.nodes()) {
                env.kafkaClient().delayReady(node2, 100L);
            }
            CountDownLatch readyLatch = new CountDownLatch(2);
            env.kafkaClient().setDisconnectFuture(disconnectFuture);
            env.kafkaClient().setReadyCallback(node -> readyLatch.countDown());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            ListTopicsResult result = env.adminClient().listTopics();
            readyLatch.await(15000L, TimeUnit.MILLISECONDS);
            log.debug("Advancing clock by 25 ms to trigger client-side disconnect.");
            time.sleep(25L);
            disconnectFuture.get();
            log.debug("Enabling nodes to send requests again.");
            for (Node node3 : cluster.nodes()) {
                env.kafkaClient().delayReady(node3, 0L);
            }
            time.sleep(5L);
            log.info("Waiting for result.");
            Assertions.assertEquals((int)0, (int)((Collection)result.listings().get()).size());
        }
    }

    @Test
    public void testClientSideTimeoutAfterFailureToReceiveResponse() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        CompletableFuture<String> disconnectFuture = new CompletableFuture<String>();
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, KafkaAdminClientTest.newStrMap("request.timeout.ms", "1", "default.api.timeout.ms", "100000", "retry.backoff.ms", "0"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().setDisconnectFuture(disconnectFuture);
            ListTopicsResult result = env.adminClient().listTopics();
            TestUtils.waitForCondition(() -> {
                time.sleep(1L);
                return disconnectFuture.isDone();
            }, 5000L, 1L, () -> "Timed out waiting for expected disconnect");
            Assertions.assertFalse((boolean)disconnectFuture.isCompletedExceptionally());
            Assertions.assertFalse((boolean)result.future.isDone());
            TestUtils.waitForCondition(env.kafkaClient()::hasInFlightRequests, "Timed out waiting for retry");
            env.kafkaClient().respond((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            Assertions.assertEquals((int)0, (int)((Collection)result.listings().get()).size());
        }
    }

    @Test
    public void testFenceProducers() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String transactionalId = "copyCat";
            Node transactionCoordinator = (Node)env.cluster().nodes().iterator().next();
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, transactionalId, transactionCoordinator));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, transactionalId, transactionCoordinator));
            env.kafkaClient().prepareResponseFrom(request -> request instanceof InitProducerIdRequest, (AbstractResponse)new InitProducerIdResponse(new InitProducerIdResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())), transactionCoordinator);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof InitProducerIdRequest, (AbstractResponse)new InitProducerIdResponse(new InitProducerIdResponseData().setErrorCode(Errors.NOT_COORDINATOR.code())), transactionCoordinator);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, transactionalId, transactionCoordinator));
            InitProducerIdResponseData initProducerIdResponseData = new InitProducerIdResponseData().setProducerId(4761L).setProducerEpoch((short)489);
            env.kafkaClient().prepareResponseFrom(request -> request instanceof InitProducerIdRequest, (AbstractResponse)new InitProducerIdResponse(initProducerIdResponseData), transactionCoordinator);
            FenceProducersResult result = env.adminClient().fenceProducers(Collections.singleton(transactionalId));
            Assertions.assertNull((Object)result.all().get());
            Assertions.assertEquals((long)4761L, (Long)((Long)result.producerId(transactionalId).get()));
            Assertions.assertEquals((short)489, (Short)((Short)result.epochId(transactionalId).get()));
        }
    }

    @Test
    public void testClientInstanceId() {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            Uuid expected = Uuid.randomUuid();
            GetTelemetrySubscriptionsResponseData responseData = new GetTelemetrySubscriptionsResponseData().setClientInstanceId(expected).setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse(request -> request instanceof GetTelemetrySubscriptionsRequest, (AbstractResponse)new GetTelemetrySubscriptionsResponse(responseData));
            Uuid result = env.adminClient().clientInstanceId(Duration.ofMillis(10L));
            Assertions.assertEquals((Object)expected, (Object)result);
        }
    }

    @Test
    public void testClientInstanceIdInvalidTimeout() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> admin.clientInstanceId(Duration.ofMillis(-1L)));
        Assertions.assertEquals((Object)"The timeout cannot be negative.", (Object)exception.getMessage());
        admin.close();
    }

    @Test
    public void testClientInstanceIdNoTelemetryReporterRegistered() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("enable.metrics.push", "false");
        KafkaAdminClient admin = (KafkaAdminClient)AdminClient.create((Properties)props);
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> admin.clientInstanceId(Duration.ofMillis(0L)));
        Assertions.assertEquals((Object)"Telemetry is not enabled. Set config `enable.metrics.push` to `true`.", (Object)exception.getMessage());
        admin.close();
    }

    private UnregisterBrokerResponse prepareUnregisterBrokerResponse(Errors error, int throttleTimeMs) {
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setErrorCode(error.code()).setErrorMessage(error.message()).setThrottleTimeMs(throttleTimeMs));
    }

    private DescribeLogDirsResponse prepareDescribeLogDirsResponse(Errors error, String logDir) {
        return new DescribeLogDirsResponse(new DescribeLogDirsResponseData().setResults(Collections.singletonList(new DescribeLogDirsResponseData.DescribeLogDirsResult().setErrorCode(error.code()).setLogDir(logDir))));
    }

    private OffsetFetchResponse offsetFetchResponse(Errors error, Map<TopicPartition, OffsetFetchResponse.PartitionData> responseData) {
        return new OffsetFetchResponse(10, Collections.singletonMap(GROUP_ID, error), Collections.singletonMap(GROUP_ID, responseData));
    }

    private static MemberDescription convertToMemberDescriptions(DescribeGroupsResponseData.DescribedGroupMember member, MemberAssignment assignment) {
        return new MemberDescription(member.memberId(), Optional.ofNullable(member.groupInstanceId()), member.clientId(), member.clientHost(), assignment);
    }

    @Test
    public void testListClientMetricsResources() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            List<ClientMetricsResourceListing> expected = Arrays.asList(new ClientMetricsResourceListing("one"), new ClientMetricsResourceListing("two"));
            ListClientMetricsResourcesResponseData responseData = new ListClientMetricsResourcesResponseData().setErrorCode(Errors.NONE.code());
            responseData.clientMetricsResources().add(new ListClientMetricsResourcesResponseData.ClientMetricsResource().setName("one"));
            responseData.clientMetricsResources().add(new ListClientMetricsResourcesResponseData.ClientMetricsResource().setName("two"));
            env.kafkaClient().prepareResponse(request -> request instanceof ListClientMetricsResourcesRequest, (AbstractResponse)new ListClientMetricsResourcesResponse(responseData));
            ListClientMetricsResourcesResult result = env.adminClient().listClientMetricsResources();
            Assertions.assertEquals(new HashSet<ClientMetricsResourceListing>(expected), new HashSet((Collection)result.all().get()));
        }
    }

    @Test
    public void testListClientMetricsResourcesEmpty() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            List expected = Collections.emptyList();
            ListClientMetricsResourcesResponseData responseData = new ListClientMetricsResourcesResponseData().setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse(request -> request instanceof ListClientMetricsResourcesRequest, (AbstractResponse)new ListClientMetricsResourcesResponse(responseData));
            ListClientMetricsResourcesResult result = env.adminClient().listClientMetricsResources();
            Assertions.assertEquals(new HashSet(expected), new HashSet((Collection)result.all().get()));
        }
    }

    @Test
    public void testListClientMetricsResourcesNotSupported() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().prepareResponse(request -> request instanceof ListClientMetricsResourcesRequest, (AbstractResponse)KafkaAdminClientTest.prepareListClientMetricsResourcesResponse(Errors.UNSUPPORTED_VERSION));
            ListClientMetricsResourcesResult result = env.adminClient().listClientMetricsResources();
            Assertions.assertNotNull((Object)result.all());
            TestUtils.assertFutureThrows(result.all(), Errors.UNSUPPORTED_VERSION.exception().getClass());
        }
    }

    private static ListClientMetricsResourcesResponse prepareListClientMetricsResourcesResponse(Errors error) {
        return new ListClientMetricsResourcesResponse(new ListClientMetricsResourcesResponseData().setErrorCode(error.code()));
    }

    @SafeVarargs
    private static <T> void assertCollectionIs(Collection<T> collection, T ... elements) {
        for (T element : elements) {
            Assertions.assertTrue((boolean)collection.contains(element), (String)("Did not find " + element));
        }
        Assertions.assertEquals((int)elements.length, (int)collection.size(), (String)"There are unexpected extra elements in the collection.");
    }

    public static KafkaAdminClient createInternal(AdminClientConfig config, KafkaAdminClient.TimeoutProcessorFactory timeoutProcessorFactory) {
        return KafkaAdminClient.createInternal((AdminClientConfig)config, (KafkaAdminClient.TimeoutProcessorFactory)timeoutProcessorFactory);
    }

    public static class FailureInjectingTimeoutProcessorFactory
    extends KafkaAdminClient.TimeoutProcessorFactory {
        private int numTries = 0;
        private int failuresInjected = 0;

        public KafkaAdminClient.TimeoutProcessor create(long now) {
            return new FailureInjectingTimeoutProcessor(now);
        }

        synchronized boolean shouldInjectFailure() {
            ++this.numTries;
            if (this.numTries == 1) {
                ++this.failuresInjected;
                return true;
            }
            return false;
        }

        public synchronized int failuresInjected() {
            return this.failuresInjected;
        }

        public final class FailureInjectingTimeoutProcessor
        extends KafkaAdminClient.TimeoutProcessor {
            public FailureInjectingTimeoutProcessor(long now) {
                super(now);
            }

            boolean callHasExpired(KafkaAdminClient.Call call) {
                if (!call.isInternal() && FailureInjectingTimeoutProcessorFactory.this.shouldInjectFailure()) {
                    log.debug("Injecting timeout for {}.", (Object)call);
                    return true;
                }
                boolean ret = super.callHasExpired(call);
                log.debug("callHasExpired({}) = {}", (Object)call, (Object)ret);
                return ret;
            }
        }
    }
}

