/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.SimpleRecordsMessageData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecordsSerdeTest {
    @Test
    public void testSerdeRecords() {
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes()), new SimpleRecord("bar".getBytes())});
        SimpleRecordsMessageData message = new SimpleRecordsMessageData().setTopic("foo").setRecordSet((BaseRecords)records);
        this.testAllRoundTrips(message);
    }

    @Test
    public void testSerdeNullRecords() {
        SimpleRecordsMessageData message = new SimpleRecordsMessageData().setTopic("foo");
        Assertions.assertNull((Object)message.recordSet());
        this.testAllRoundTrips(message);
    }

    @Test
    public void testSerdeEmptyRecords() {
        SimpleRecordsMessageData message = new SimpleRecordsMessageData().setTopic("foo").setRecordSet((BaseRecords)MemoryRecords.EMPTY);
        this.testAllRoundTrips(message);
    }

    private void testAllRoundTrips(SimpleRecordsMessageData message) {
        for (short version = 0; version <= 1; version = (short)(version + 1)) {
            this.testRoundTrip(message, version);
        }
    }

    private void testRoundTrip(SimpleRecordsMessageData message, short version) {
        ByteBuffer buf = MessageUtil.toByteBuffer((Message)message, (short)version);
        SimpleRecordsMessageData message2 = this.deserialize(buf.duplicate(), version);
        Assertions.assertEquals((Object)message, (Object)message2);
        Assertions.assertEquals((int)message.hashCode(), (int)message2.hashCode());
    }

    private SimpleRecordsMessageData deserialize(ByteBuffer buffer, short version) {
        ByteBufferAccessor readable = new ByteBufferAccessor(buffer);
        return new SimpleRecordsMessageData((Readable)readable, version);
    }
}

