/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.cache;

import org.apache.kafka.common.cache.LRUCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LRUCacheTest {
    @Test
    public void testPutGet() {
        LRUCache cache = new LRUCache(4);
        cache.put((Object)"a", (Object)"b");
        cache.put((Object)"c", (Object)"d");
        cache.put((Object)"e", (Object)"f");
        cache.put((Object)"g", (Object)"h");
        Assertions.assertEquals((long)4L, (long)cache.size());
        Assertions.assertEquals((Object)"b", (Object)cache.get((Object)"a"));
        Assertions.assertEquals((Object)"d", (Object)cache.get((Object)"c"));
        Assertions.assertEquals((Object)"f", (Object)cache.get((Object)"e"));
        Assertions.assertEquals((Object)"h", (Object)cache.get((Object)"g"));
    }

    @Test
    public void testRemove() {
        LRUCache cache = new LRUCache(4);
        cache.put((Object)"a", (Object)"b");
        cache.put((Object)"c", (Object)"d");
        cache.put((Object)"e", (Object)"f");
        Assertions.assertEquals((long)3L, (long)cache.size());
        Assertions.assertTrue((boolean)cache.remove((Object)"a"));
        Assertions.assertEquals((long)2L, (long)cache.size());
        Assertions.assertNull((Object)cache.get((Object)"a"));
        Assertions.assertEquals((Object)"d", (Object)cache.get((Object)"c"));
        Assertions.assertEquals((Object)"f", (Object)cache.get((Object)"e"));
        Assertions.assertFalse((boolean)cache.remove((Object)"key-does-not-exist"));
        Assertions.assertTrue((boolean)cache.remove((Object)"c"));
        Assertions.assertEquals((long)1L, (long)cache.size());
        Assertions.assertNull((Object)cache.get((Object)"c"));
        Assertions.assertEquals((Object)"f", (Object)cache.get((Object)"e"));
        Assertions.assertTrue((boolean)cache.remove((Object)"e"));
        Assertions.assertEquals((long)0L, (long)cache.size());
        Assertions.assertNull((Object)cache.get((Object)"e"));
    }

    @Test
    public void testEviction() {
        LRUCache cache = new LRUCache(2);
        cache.put((Object)"a", (Object)"b");
        cache.put((Object)"c", (Object)"d");
        Assertions.assertEquals((long)2L, (long)cache.size());
        cache.put((Object)"e", (Object)"f");
        Assertions.assertEquals((long)2L, (long)cache.size());
        Assertions.assertNull((Object)cache.get((Object)"a"));
        Assertions.assertEquals((Object)"d", (Object)cache.get((Object)"c"));
        Assertions.assertEquals((Object)"f", (Object)cache.get((Object)"e"));
        cache.get((Object)"c");
        cache.put((Object)"g", (Object)"h");
        Assertions.assertEquals((long)2L, (long)cache.size());
        Assertions.assertNull((Object)cache.get((Object)"e"));
        Assertions.assertEquals((Object)"d", (Object)cache.get((Object)"c"));
        Assertions.assertEquals((Object)"h", (Object)cache.get((Object)"g"));
    }
}

