/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class AssignmentChangeApplicationEvent
extends ApplicationEvent {
    private final Map<TopicPartition, OffsetAndMetadata> offsets;
    private final long currentTimeMs;

    public AssignmentChangeApplicationEvent(Map<TopicPartition, OffsetAndMetadata> offsets, long currentTimeMs) {
        super(ApplicationEvent.Type.ASSIGNMENT_CHANGE);
        this.offsets = Collections.unmodifiableMap(offsets);
        this.currentTimeMs = currentTimeMs;
    }

    public Map<TopicPartition, OffsetAndMetadata> offsets() {
        return this.offsets;
    }

    public long currentTimeMs() {
        return this.currentTimeMs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AssignmentChangeApplicationEvent that = (AssignmentChangeApplicationEvent)o;
        if (this.currentTimeMs != that.currentTimeMs) {
            return false;
        }
        return this.offsets.equals(that.offsets);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.offsets.hashCode();
        result = 31 * result + (int)(this.currentTimeMs ^ this.currentTimeMs >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "AssignmentChangeApplicationEvent{" + this.toStringBase() + ", offsets=" + this.offsets + ", currentTimeMs=" + this.currentTimeMs + '}';
    }
}

