/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommonClientConfigsTest {
    @Test
    public void testExponentialBackoffDefaults() {
        TestConfig defaultConf = new TestConfig(Collections.emptyMap());
        Assertions.assertEquals((Long)50L, (Long)defaultConf.getLong("reconnect.backoff.ms"));
        Assertions.assertEquals((Long)1000L, (Long)defaultConf.getLong("reconnect.backoff.max.ms"));
        TestConfig bothSetConfig = new TestConfig(new HashMap<String, Object>(){
            {
                this.put("reconnect.backoff.ms", "123");
                this.put("reconnect.backoff.max.ms", "12345");
            }
        });
        Assertions.assertEquals((Long)123L, (Long)bothSetConfig.getLong("reconnect.backoff.ms"));
        Assertions.assertEquals((Long)12345L, (Long)bothSetConfig.getLong("reconnect.backoff.max.ms"));
        TestConfig reconnectBackoffSetConf = new TestConfig(new HashMap<String, Object>(){
            {
                this.put("reconnect.backoff.ms", "123");
            }
        });
        Assertions.assertEquals((Long)123L, (Long)reconnectBackoffSetConf.getLong("reconnect.backoff.ms"));
        Assertions.assertEquals((Long)123L, (Long)reconnectBackoffSetConf.getLong("reconnect.backoff.max.ms"));
    }

    @Test
    public void testInvalidSaslMechanism() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        configs.put("sasl.mechanism", null);
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new TestConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("sasl.mechanism"));
        configs.put("sasl.mechanism", "");
        ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new TestConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("sasl.mechanism"));
    }

    @Test
    public void testMetricsReporters() {
        TestConfig config = new TestConfig(Collections.emptyMap());
        List reporters = CommonClientConfigs.metricsReporters((String)"clientId", (AbstractConfig)config);
        Assertions.assertEquals((int)1, (int)reporters.size());
        Assertions.assertInstanceOf(JmxReporter.class, reporters.get(0));
        config = new TestConfig(Collections.singletonMap("auto.include.jmx.reporter", "false"));
        reporters = CommonClientConfigs.metricsReporters((String)"clientId", (AbstractConfig)config);
        Assertions.assertTrue((boolean)reporters.isEmpty());
        config = new TestConfig(Collections.singletonMap("metric.reporters", JmxReporter.class.getName()));
        reporters = CommonClientConfigs.metricsReporters((String)"clientId", (AbstractConfig)config);
        Assertions.assertEquals((int)1, (int)reporters.size());
        Assertions.assertInstanceOf(JmxReporter.class, reporters.get(0));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("metric.reporters", JmxReporter.class.getName() + "," + MyJmxReporter.class.getName());
        config = new TestConfig(props);
        reporters = CommonClientConfigs.metricsReporters((String)"clientId", (AbstractConfig)config);
        Assertions.assertEquals((int)2, (int)reporters.size());
    }

    public static class MyJmxReporter
    extends JmxReporter {
    }

    private static class TestConfig
    extends AbstractConfig {
        private static final ConfigDef CONFIG = new ConfigDef().define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)50L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)1000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])Utils.enumOptions(SecurityProtocol.class)), ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).define("sasl.mechanism", ConfigDef.Type.STRING, (Object)"GSSAPI", ConfigDef.Importance.MEDIUM, "SASL mechanism used for client connections. This may be any mechanism for which a security provider is available. GSSAPI is the default mechanism.").define("metric.reporters", ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.").define("auto.include.jmx.reporter", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Deprecated. Whether to automatically include JmxReporter even if it's not listed in <code>metric.reporters</code>. This configuration will be removed in Kafka 4.0, users should instead include <code>org.apache.kafka.common.metrics.JmxReporter</code> in <code>metric.reporters</code> in order to enable the JmxReporter.");

        protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
            CommonClientConfigs.postValidateSaslMechanismConfig((AbstractConfig)this);
            return CommonClientConfigs.postProcessReconnectBackoffConfigs((AbstractConfig)this, parsedValues);
        }

        public TestConfig(Map<?, ?> props) {
            super(CONFIG, props);
        }
    }
}

