/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.kafka.clients.consumer.internals.events.CompletableEventReaper;
import org.apache.kafka.clients.consumer.internals.events.PollEvent;
import org.apache.kafka.clients.consumer.internals.metrics.AsyncConsumerMetrics;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ApplicationEventHandlerTest {
    private final Time time = new MockTime();
    private final BlockingQueue<ApplicationEvent> applicationEventsQueue = new LinkedBlockingQueue<ApplicationEvent>();
    private final ApplicationEventProcessor applicationEventProcessor = (ApplicationEventProcessor)Mockito.mock(ApplicationEventProcessor.class);
    private final NetworkClientDelegate networkClientDelegate = (NetworkClientDelegate)Mockito.mock(NetworkClientDelegate.class);
    private final RequestManagers requestManagers = (RequestManagers)Mockito.mock(RequestManagers.class);
    private final CompletableEventReaper applicationEventReaper = (CompletableEventReaper)Mockito.mock(CompletableEventReaper.class);

    @Test
    public void testRecordApplicationEventQueueSize() {
        try (Metrics metrics = new Metrics();
             AsyncConsumerMetrics asyncConsumerMetrics = (AsyncConsumerMetrics)Mockito.spy((Object)new AsyncConsumerMetrics(metrics));
             ApplicationEventHandler applicationEventHandler = new ApplicationEventHandler(new LogContext(), this.time, this.applicationEventsQueue, this.applicationEventReaper, () -> this.applicationEventProcessor, () -> this.networkClientDelegate, () -> this.requestManagers, asyncConsumerMetrics);){
            applicationEventHandler.add((ApplicationEvent)new PollEvent(this.time.milliseconds()));
            ((AsyncConsumerMetrics)Mockito.verify((Object)asyncConsumerMetrics)).recordApplicationEventQueueSize(1);
        }
    }
}

