/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.BaseHeartbeatThread;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BaseHeartbeatThreadTest {
    @Test
    public void testIsEnabled() {
        try (BaseHeartbeatThread baseHeartbeatThread = new BaseHeartbeatThread("test", true);){
            Assertions.assertFalse((boolean)baseHeartbeatThread.isEnabled());
            baseHeartbeatThread.enable();
            Assertions.assertTrue((boolean)baseHeartbeatThread.isEnabled());
            baseHeartbeatThread.disable();
            Assertions.assertFalse((boolean)baseHeartbeatThread.isEnabled());
        }
    }

    @Test
    public void testIsFailed() {
        try (BaseHeartbeatThread baseHeartbeatThread = new BaseHeartbeatThread("test", true);){
            Assertions.assertFalse((boolean)baseHeartbeatThread.isFailed());
            Assertions.assertNull((Object)baseHeartbeatThread.failureCause());
            FencedInstanceIdException exception = new FencedInstanceIdException("test");
            baseHeartbeatThread.setFailureCause((RuntimeException)exception);
            Assertions.assertTrue((boolean)baseHeartbeatThread.isFailed());
            Assertions.assertEquals((Object)exception, (Object)baseHeartbeatThread.failureCause());
        }
    }

    @Test
    public void testIsClosed() {
        try (BaseHeartbeatThread baseHeartbeatThread = new BaseHeartbeatThread("test", true);){
            Assertions.assertFalse((boolean)baseHeartbeatThread.isClosed());
            baseHeartbeatThread.close();
            Assertions.assertTrue((boolean)baseHeartbeatThread.isClosed());
        }
    }
}

