/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.CloseOptions;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.AbstractMembershipManager;
import org.apache.kafka.clients.consumer.internals.AsyncKafkaConsumer;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMembershipManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerInvoker;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerMethodName;
import org.apache.kafka.clients.consumer.internals.CounterConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.MockRebalanceListener;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.Utils;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackCompletedEvent;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackNeededEvent;
import org.apache.kafka.clients.consumer.internals.metrics.AsyncConsumerMetrics;
import org.apache.kafka.clients.consumer.internals.metrics.ConsumerRebalanceMetricsManager;
import org.apache.kafka.clients.consumer.internals.metrics.RebalanceCallbackMetricsManager;
import org.apache.kafka.clients.consumer.internals.metrics.RebalanceMetricsManager;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConsumerMembershipManagerTest {
    private static final String GROUP_ID = "test-group";
    private static final int REBALANCE_TIMEOUT = 100;
    private static final int MEMBER_EPOCH = 1;
    private static final LogContext LOG_CONTEXT = new LogContext();
    private SubscriptionState subscriptionState;
    private ConsumerMetadata metadata;
    private CommitRequestManager commitRequestManager;
    private BlockingQueue<BackgroundEvent> backgroundEventQueue;
    private BackgroundEventHandler backgroundEventHandler;
    private Time time;
    private Metrics metrics;
    private ConsumerRebalanceMetricsManager rebalanceMetricsManager;

    @BeforeEach
    public void setup() {
        this.metadata = (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class);
        this.subscriptionState = (SubscriptionState)Mockito.mock(SubscriptionState.class);
        this.commitRequestManager = (CommitRequestManager)Mockito.mock(CommitRequestManager.class);
        this.backgroundEventQueue = new LinkedBlockingQueue<BackgroundEvent>();
        this.time = new MockTime(0L);
        this.backgroundEventHandler = new BackgroundEventHandler(this.backgroundEventQueue, this.time, (AsyncConsumerMetrics)Mockito.mock(AsyncConsumerMetrics.class));
        this.metrics = new Metrics(this.time);
        this.rebalanceMetricsManager = new ConsumerRebalanceMetricsManager(this.metrics);
        Mockito.when((Object)this.commitRequestManager.maybeAutoCommitSyncBeforeRebalance(ArgumentMatchers.anyLong())).thenReturn(CompletableFuture.completedFuture(null));
    }

    private ConsumerMembershipManager createMembershipManagerJoiningGroup() {
        return this.createMembershipManagerJoiningGroup(null);
    }

    private ConsumerMembershipManager createMembershipManagerJoiningGroup(String groupInstanceId) {
        ConsumerMembershipManager manager = this.createMembershipManager(groupInstanceId);
        manager.transitionToJoining();
        return manager;
    }

    private ConsumerMembershipManager createMembershipManager(String groupInstanceId) {
        ConsumerMembershipManager manager = (ConsumerMembershipManager)Mockito.spy((Object)new ConsumerMembershipManager(GROUP_ID, Optional.ofNullable(groupInstanceId), Optional.empty(), 100, Optional.empty(), this.subscriptionState, this.commitRequestManager, this.metadata, LOG_CONTEXT, this.backgroundEventHandler, this.time, (RebalanceMetricsManager)this.rebalanceMetricsManager, true));
        this.assertMemberIdIsGenerated(manager.memberId());
        return manager;
    }

    private ConsumerMembershipManager createMembershipManagerJoiningGroup(String groupInstanceId, String serverAssignor, String rackId) {
        ConsumerMembershipManager manager = (ConsumerMembershipManager)Mockito.spy((Object)new ConsumerMembershipManager(GROUP_ID, Optional.ofNullable(groupInstanceId), Optional.ofNullable(rackId), 100, Optional.ofNullable(serverAssignor), this.subscriptionState, this.commitRequestManager, this.metadata, LOG_CONTEXT, this.backgroundEventHandler, this.time, (RebalanceMetricsManager)this.rebalanceMetricsManager, true));
        this.assertMemberIdIsGenerated(manager.memberId());
        manager.transitionToJoining();
        return manager;
    }

    @Test
    public void testMembershipManagerServerAssignor() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals(Optional.empty(), (Object)membershipManager.serverAssignor());
        membershipManager = this.createMembershipManagerJoiningGroup("instance1", "Uniform", null);
        Assertions.assertEquals(Optional.of("Uniform"), (Object)membershipManager.serverAssignor());
    }

    @Test
    public void testMembershipManagerRackId() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals(Optional.empty(), (Object)membershipManager.rackId());
        membershipManager = this.createMembershipManagerJoiningGroup(null, null, "rack1");
        Assertions.assertEquals(Optional.of("rack1"), (Object)membershipManager.rackId());
    }

    @Test
    public void testMembershipManagerInitSupportsEmptyGroupInstanceId() {
        this.createMembershipManagerJoiningGroup();
    }

    @Test
    public void testReconcilingWhenReceivingAssignmentFoundInMetadata() {
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testTransitionToReconcilingIfEmptyAssignmentReceived() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        ConsumerGroupHeartbeatResponse responseWithoutAssignment = this.createConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(responseWithoutAssignment);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        ConsumerGroupHeartbeatResponse responseWithAssignment = this.createConsumerGroupHeartbeatResponse(this.createAssignment(true), membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(responseWithAssignment);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
    }

    @Test
    public void testMemberIdAndEpochResetOnFencedMembers() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        String originalMemberId = membershipManager.memberId();
        Assertions.assertNotNull((Object)originalMemberId);
        Assertions.assertFalse((boolean)originalMemberId.isEmpty());
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
        this.mockMemberHasAutoAssignedPartition();
        membershipManager.transitionToFenced();
        Assertions.assertEquals((int)0, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testTransitionToFatal() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState(null);
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
    }

    @Test
    public void testTransitionToFailedWhenTryingToJoin() {
        ConsumerMembershipManager membershipManager = new ConsumerMembershipManager(GROUP_ID, Optional.empty(), Optional.empty(), 100, Optional.empty(), this.subscriptionState, this.commitRequestManager, this.metadata, LOG_CONTEXT, this.backgroundEventHandler, this.time, (RebalanceMetricsManager)this.rebalanceMetricsManager, true);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.transitionToJoining();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFencingWhenStateIsStable() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testListenersGetNotifiedOnTransitionsToFatal() {
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty());
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        this.mockStableMember(membershipManager);
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(1), membershipManager.memberId);
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.empty(), membershipManager.memberId);
    }

    @Test
    public void testListenersGetNotifiedOnTransitionsToLeavingGroup() {
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty());
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        this.mockStableMember(membershipManager);
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(1), membershipManager.memberId);
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.empty(), membershipManager.memberId);
    }

    @Test
    public void testListenersGetNotifiedOfMemberEpochUpdatesOnlyIfItChanges() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        String memberId = membershipManager.memberId();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        int epoch = 5;
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(memberId).setMemberEpoch(epoch)));
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(epoch), memberId);
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(memberId).setMemberEpoch(epoch)));
        ((MemberStateListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onMemberEpochUpdated((Optional)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    private void mockStableMember(ConsumerMembershipManager membershipManager) {
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        membershipManager.maybeReconcile(true);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testFencingWhenStateIsReconciling() {
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testFencingWhenStateIsPrepareLeaving() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        ConsumerRebalanceListenerCallbackCompletedEvent callbackEvent = this.mockPrepareLeavingStuckOnUserCallback(membershipManager, invoker);
        Assertions.assertEquals((Object)MemberState.PREPARE_LEAVING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.transitionToFenced();
        this.testFenceIsNoOp(membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        this.completeCallback(callbackEvent, membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager)).notifyEpochChange(Optional.empty());
        Assertions.assertTrue((boolean)membershipManager.shouldSkipHeartbeat());
    }

    @Test
    public void testFencingWhenStateIsPrepareLeavingCompletesTheLeaveOperation() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockPrepareLeaving(new TopicPartition("topic1", 0));
        CompletableFuture leaveOperation = membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.PREPARE_LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveOperation.isDone());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.transitionToFenced();
        this.testFenceIsNoOp(membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)leaveOperation.isDone(), (String)"Fenced member should complete the ongoing leave operation");
    }

    @Test
    public void testNewAssignmentIgnoredWhenStateIsPrepareLeaving() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        ConsumerRebalanceListenerCallbackCompletedEvent callbackEvent = this.mockPrepareLeavingStuckOnUserCallback(membershipManager, invoker);
        Assertions.assertEquals((Object)MemberState.PREPARE_LEAVING, (Object)membershipManager.state());
        Uuid topicId = Uuid.randomUuid();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, "topic1", Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        Assertions.assertEquals((Object)MemberState.PREPARE_LEAVING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        this.completeCallback(callbackEvent, membershipManager);
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
    }

    @Test
    public void testFencingWhenStateIsLeaving() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveOperation = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.transitionToFenced();
        this.testFenceIsNoOp(membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state(), (String)"Member should transition from LEAVING to UNSUBSCRIBED when getting fenced (it does not need to send leave request if fenced");
        Assertions.assertTrue((boolean)leaveOperation.isDone(), (String)"Fenced member should complete the ongoing leave operation");
    }

    private void assertTransitionToUnsubscribeOnHBSentAndWaitForResponseToCompleteLeave(ConsumerMembershipManager membershipManager, CompletableFuture<Void> sendLeave) {
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertFalse((boolean)sendLeave.isDone(), (String)"Send leave operation should not complete until a response is received");
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData.Assignment(), membershipManager.memberId()));
        Assertions.assertFalse((boolean)sendLeave.isDone(), (String)"Send leave operation should not complete until a leave response is received");
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupLeaveResponse(membershipManager.memberId()));
        this.assertSendLeaveCompleted(membershipManager, sendLeave);
    }

    @Test
    public void testLeaveGroupEpoch() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState("instance1");
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-2, (int)membershipManager.memberEpoch());
        membershipManager = this.createMemberInStableState(null);
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testLeaveGroupEpochOnClose() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState("instance1");
        this.mockLeaveGroup();
        membershipManager.leaveGroupOnClose(CloseOptions.GroupMembershipOperation.DEFAULT);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-2, (int)membershipManager.memberEpoch());
        membershipManager = this.createMemberInStableState("instance1");
        this.mockLeaveGroup();
        membershipManager.leaveGroupOnClose(CloseOptions.GroupMembershipOperation.LEAVE_GROUP);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        membershipManager = this.createMemberInStableState("instance1");
        this.mockLeaveGroup();
        membershipManager.leaveGroupOnClose(CloseOptions.GroupMembershipOperation.REMAIN_IN_GROUP);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-2, (int)membershipManager.memberEpoch());
        membershipManager = this.createMemberInStableState(null);
        this.mockLeaveGroup();
        membershipManager.leaveGroupOnClose(CloseOptions.GroupMembershipOperation.DEFAULT);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        membershipManager = this.createMemberInStableState(null);
        this.mockLeaveGroup();
        membershipManager.leaveGroupOnClose(CloseOptions.GroupMembershipOperation.LEAVE_GROUP);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testDelayedReconciliationResultDiscardedIfMemberNotInReconcilingStateAnymore() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        List<TopicIdPartition> owned = Collections.singletonList(new TopicIdPartition(topicId1, new TopicPartition(topic1, 0)));
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId1, topic1, owned);
        CompletableFuture<Void> commitResult = this.mockEmptyAssignmentAndRevocationStuckOnCommit(membershipManager);
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        commitResult.complete(null);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed((Collection)ArgumentMatchers.anySet());
        Assertions.assertNotEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
    }

    @Test
    public void testDelayedReconciliationResultDiscardedAfterCommitIfMemberRejoins() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        List<TopicIdPartition> owned = Collections.singletonList(new TopicIdPartition(topicId1, new TopicPartition(topic1, 0)));
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId1, topic1, owned);
        CompletableFuture<Void> commitResult = this.mockNewAssignmentAndRevocationStuckOnCommit(membershipManager, topicId1, topic1, Arrays.asList(1, 2), true);
        Map<Uuid, SortedSet<Integer>> assignment1 = this.topicIdPartitionsMap(topicId1, 1, 2);
        Assertions.assertEquals(assignment1, (Object)membershipManager.topicPartitionsAwaitingReconciliation());
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining(membershipManager);
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        Map<Uuid, SortedSet<Integer>> assignmentAfterRejoin = this.receiveAssignmentAfterRejoin(Collections.singletonList(5), membershipManager, owned);
        commitResult.complete(null);
        this.assertInitialReconciliationDiscardedAfterRejoin(membershipManager, assignmentAfterRejoin);
    }

    @Test
    public void testDelayedReconciliationResultDiscardedAfterPartitionsRevokedCallbackIfMemberRejoins() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        List<TopicIdPartition> owned = Collections.singletonList(new TopicIdPartition(topicId1, new TopicPartition(topic1, 0)));
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId1, topic1, owned);
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        ConsumerRebalanceListenerCallbackCompletedEvent callbackCompletedEvent = this.mockNewAssignmentStuckOnPartitionsRevokedCallback(membershipManager, topicId1, topic1, Arrays.asList(1, 2), owned.get(0).topicPartition(), invoker);
        Map<Uuid, SortedSet<Integer>> assignment1 = this.topicIdPartitionsMap(topicId1, 1, 2);
        Assertions.assertEquals(assignment1, (Object)membershipManager.topicPartitionsAwaitingReconciliation());
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining(membershipManager);
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        Map<Uuid, SortedSet<Integer>> assignmentAfterRejoin = this.receiveAssignmentAfterRejoin(Collections.singletonList(5), membershipManager, owned);
        this.completeCallback(callbackCompletedEvent, membershipManager);
        this.assertInitialReconciliationDiscardedAfterRejoin(membershipManager, assignmentAfterRejoin);
    }

    @Test
    public void testDelayedReconciliationResultDiscardedAfterPartitionsAssignedCallbackIfMemberRejoins() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        int newPartition = 1;
        ConsumerRebalanceListenerCallbackCompletedEvent callbackCompletedEvent = this.mockNewAssignmentStuckOnPartitionsAssignedCallback(membershipManager, topicId1, topic1, newPartition, invoker);
        Map<Uuid, SortedSet<Integer>> assignment1 = this.topicIdPartitionsMap(topicId1, newPartition);
        Assertions.assertEquals(assignment1, (Object)membershipManager.topicPartitionsAwaitingReconciliation());
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining(membershipManager);
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        Map<Uuid, SortedSet<Integer>> assignmentAfterRejoin = this.receiveAssignmentAfterRejoin(Collections.singletonList(5), membershipManager, Collections.emptyList());
        this.completeCallback(callbackCompletedEvent, membershipManager);
        this.assertInitialReconciliationDiscardedAfterRejoin(membershipManager, assignmentAfterRejoin);
    }

    @Test
    public void testSameAssignmentReconciledAgainWhenFenced() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topic1 = Uuid.randomUuid();
        ConsumerGroupHeartbeatResponseData.Assignment assignment1 = new ConsumerGroupHeartbeatResponseData.Assignment();
        ConsumerGroupHeartbeatResponseData.Assignment assignment2 = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Arrays.asList(0, 1, 2))));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topic1, "topic1"));
        Assertions.assertEquals(this.toTopicIdPartitionMap(assignment1), (Object)membershipManager.currentAssignment().partitions);
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(assignment2, membershipManager.memberId()));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        CompletableFuture<Object> commitResult = new CompletableFuture<Object>();
        Mockito.when((Object)this.commitRequestManager.maybeAutoCommitSyncBeforeRebalance(ArgumentMatchers.anyLong())).thenReturn(commitResult);
        membershipManager.maybeReconcile(false);
        membershipManager.transitionToFenced();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        Assertions.assertTrue((boolean)this.subscriptionState.assignedPartitions().isEmpty());
        commitResult.complete(null);
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        Assertions.assertTrue((boolean)this.subscriptionState.assignedPartitions().isEmpty());
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(assignment1, membershipManager.memberId()));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.maybeReconcile(true);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals(this.toTopicIdPartitionMap(assignment1), (Object)membershipManager.currentAssignment().partitions);
    }

    @Test
    public void testSameAssignmentReconciledAgainWithMissingTopic() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topic1 = Uuid.randomUuid();
        Uuid topic2 = Uuid.randomUuid();
        ConsumerGroupHeartbeatResponseData.Assignment assignment1 = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Collections.singletonList(0)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Collections.singletonList(0))));
        ConsumerGroupHeartbeatResponseData.Assignment assignment2 = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Arrays.asList(0, 1)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Collections.singletonList(0))));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topic1, "topic1"));
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(assignment1, membershipManager.memberId()));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.maybeReconcile(true);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, Collections.singletonList(new TopicIdPartition(topic1, new TopicPartition("topic1", 0))));
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new ConsumerMembershipManager[]{membershipManager});
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(assignment2, membershipManager.memberId()));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(assignment1, membershipManager.memberId()));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.maybeReconcile(false);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singletonMap(topic1, Utils.mkSortedSet((Comparable[])new Integer[]{0})), (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertEquals(Set.of(topic2), (Object)membershipManager.topicsAwaitingReconciliation());
    }

    private Map<Uuid, SortedSet<Integer>> toTopicIdPartitionMap(ConsumerGroupHeartbeatResponseData.Assignment assignment) {
        HashMap<Uuid, SortedSet<Integer>> result = new HashMap<Uuid, SortedSet<Integer>>();
        for (ConsumerGroupHeartbeatResponseData.TopicPartitions topicPartitions : assignment.topicPartitions()) {
            result.put(topicPartitions.topicId(), new TreeSet(topicPartitions.partitions()));
        }
        return result;
    }

    @Test
    public void testDelayedReconciliationResultAppliedWhenTargetChangedWithMetadataUpdate() {
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        ConsumerMembershipManager membershipManager = this.mockMemberSuccessfullyReceivesAndAcksAssignment(topicId1, topic1, Collections.singletonList(0));
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new Object[]{membershipManager, this.subscriptionState});
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(new TopicPartition(topic1, 0)));
        Uuid topicId2 = Uuid.randomUuid();
        String topic2 = "topic2";
        CompletableFuture<Void> commitResult = this.mockNewAssignmentAndRevocationStuckOnCommit(membershipManager, topicId2, topic2, Arrays.asList(1, 2), false);
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Assertions.assertEquals(Collections.singleton(topicId2), (Object)membershipManager.topicsAwaitingReconciliation());
        Map<Uuid, String> topic2Metadata = Collections.singletonMap(topicId2, topic2);
        this.mockTopicNameInMetadataCache(topic2Metadata, true);
        Assertions.assertEquals(Collections.singleton(topicId2), (Object)membershipManager.topicsAwaitingReconciliation());
        this.verifyReconciliationNotTriggered(membershipManager);
        commitResult.complete(null);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(Collections.emptySet(), Collections.emptySet());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Map<Uuid, SortedSet<Integer>> topic2Assignment = this.topicIdPartitionsMap(topicId2, 1, 2);
        Assertions.assertEquals(topic2Assignment, (Object)membershipManager.topicPartitionsAwaitingReconciliation());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(topic2Assignment, (Object)membershipManager.topicPartitionsAwaitingReconciliation());
        membershipManager.maybeReconcile(true);
        Assertions.assertEquals(Collections.emptySet(), (Object)membershipManager.topicsAwaitingReconciliation());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(ConsumerMembershipManagerTest.topicPartitions(topic2Assignment, topic2Metadata), ConsumerMembershipManagerTest.topicPartitions(topic2Assignment, topic2Metadata));
    }

    @Test
    public void testDelayedReconciliationResultAppliedWhenTargetChangedWithNewAssignment() {
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        TopicIdPartition topicId1Partition0 = new TopicIdPartition(topicId1, new TopicPartition(topic1, 0));
        Uuid topicId2 = Uuid.randomUuid();
        String topic2 = "topic2";
        TopicIdPartition topicId2Partition0 = new TopicIdPartition(topicId2, new TopicPartition(topic2, 0));
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.metadata.topicNames()).thenReturn((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId1, (Object)topic1), Utils.mkEntry((Object)topicId2, (Object)topic2)}));
        CompletableFuture<Void> commitFuture = this.mockNewAssignmentAndRevocationStuckOnCommit(membershipManager, topicId1, topic1, Collections.singletonList(0), false);
        Map newAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId1, (Object)Utils.mkSortedSet((Comparable[])new Integer[]{0})), Utils.mkEntry((Object)topicId2, (Object)Utils.mkSortedSet((Comparable[])new Integer[]{0}))});
        this.receiveAssignment(newAssignment, membershipManager);
        membershipManager.maybeReconcile(false);
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(Set.of(topicId1, topicId2), (Object)membershipManager.topicsAwaitingReconciliation());
        Mockito.clearInvocations((Object[])new RequestManager[]{membershipManager, this.commitRequestManager});
        commitFuture.complete(null);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertEquals(Set.of(topicId2), (Object)membershipManager.topicsAwaitingReconciliation());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new RequestManager[]{membershipManager, this.commitRequestManager});
        membershipManager.maybeReconcile(true);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, Arrays.asList(topicId1Partition0, topicId2Partition0));
    }

    @Test
    public void testDelayedMetadataUsedToCompleteAssignment() {
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        TopicIdPartition topicId1Partition0 = new TopicIdPartition(topicId1, new TopicPartition(topic1, 0));
        Uuid topicId2 = Uuid.randomUuid();
        String topic2 = "topic2";
        TopicIdPartition topicId2Partition0 = new TopicIdPartition(topicId2, new TopicPartition(topic2, 0));
        ConsumerMembershipManager membershipManager = this.mockMemberSuccessfullyReceivesAndAcksAssignment(topicId1, topic1, Collections.singletonList(0));
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.getTopicPartitions(Collections.singleton(topicId1Partition0)));
        Mockito.clearInvocations((Object[])new Object[]{membershipManager, this.subscriptionState});
        Map newAssignment = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId1, (Object)Utils.mkSortedSet((Comparable[])new Integer[]{0})), Utils.mkEntry((Object)topicId2, (Object)Utils.mkSortedSet((Comparable[])new Integer[]{0}))});
        this.receiveAssignment(newAssignment, membershipManager);
        membershipManager.maybeReconcile(false);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.shouldHeartbeatNow());
        membershipManager.onHeartbeatRequestGenerated();
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(Collections.singleton(topicId2), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Mockito.clearInvocations((Object[])new RequestManager[]{membershipManager, this.commitRequestManager});
        Map fullTopicMetadata = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId1, (Object)topic1), Utils.mkEntry((Object)topicId2, (Object)topic2)});
        Mockito.when((Object)this.metadata.topicNames()).thenReturn((Object)fullTopicMetadata);
        membershipManager.maybeReconcile(true);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, Arrays.asList(topicId1Partition0, topicId2Partition0));
    }

    @Test
    public void testLeaveGroupWhenStateIsStable() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testHeartbeatSuccessfulResponseWhenLeavingGroupCompletesLeave() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(this.createAssignment(true), membershipManager.memberId()));
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupLeaveResponse(membershipManager.memberId()));
        this.assertSendLeaveCompleted(membershipManager, leaveResult);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testHeartbeatFailedResponseWhenLeavingGroupCompletesLeave(boolean retriableResponseError) {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatFailure(retriableResponseError);
        this.assertSendLeaveCompleted(membershipManager, leaveResult);
    }

    private void assertSendLeaveCompleted(ConsumerMembershipManager membershipManager, CompletableFuture<Void> sendLeave) {
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state(), (String)"Member should remain UNSUBSCRIBED after receiving the response to the HB to leave");
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        Assertions.assertTrue((boolean)sendLeave.isDone(), (String)"Leave group result should complete when the response to the heartbeat request to leave is received.");
        Assertions.assertFalse((boolean)sendLeave.isCompletedExceptionally());
    }

    @ParameterizedTest
    @MethodSource(value={"notInGroupStates"})
    public void testIgnoreHeartbeatResponseWhenNotInGroup(MemberState state) {
        ConsumerMembershipManager membershipManager = this.createMembershipManager(null);
        Mockito.when((Object)membershipManager.state()).thenReturn((Object)state);
        ConsumerGroupHeartbeatResponseData responseData = (ConsumerGroupHeartbeatResponseData)Mockito.mock(ConsumerGroupHeartbeatResponseData.class);
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(responseData));
        Assertions.assertEquals((Object)state, (Object)membershipManager.state());
        ((ConsumerGroupHeartbeatResponseData)Mockito.verify((Object)responseData, (VerificationMode)Mockito.never())).memberId();
        if (state != MemberState.UNSUBSCRIBED) {
            ((ConsumerGroupHeartbeatResponseData)Mockito.verify((Object)responseData, (VerificationMode)Mockito.never())).memberEpoch();
        }
        ((ConsumerGroupHeartbeatResponseData)Mockito.verify((Object)responseData, (VerificationMode)Mockito.never())).assignment();
    }

    @Test
    public void testIgnoreLeaveResponseWhenNotLeavingGroup() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.onHeartbeatSuccess(new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(membershipManager.memberId()).setMemberEpoch(1)));
        Assertions.assertFalse((boolean)leaveResult.isDone());
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupLeaveResponse(membershipManager.memberId()));
        membershipManager.onSubscriptionUpdated();
        membershipManager.onConsumerPoll();
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupLeaveResponse(membershipManager.memberId()));
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        Assertions.assertEquals((int)0, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testLeaveGroupWhenMemberOwnsAssignment() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        List<TopicIdPartition> assignedPartitions = Arrays.asList(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), new TopicIdPartition(topicId, new TopicPartition(topicName, 1)));
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
        Assertions.assertEquals((int)1, (int)membershipManager.currentAssignment().partitions.size());
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(membershipManager);
    }

    @Test
    public void testFencedWhenAssignmentEmpty() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)false);
        membershipManager.transitionToFenced();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenMemberAlreadyLeaving() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertFalse((boolean)leaveResult1.isDone());
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        this.mockLeaveGroup();
        CompletableFuture leaveResult2 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).unsubscribe();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).rebalanceListener();
        Assertions.assertFalse((boolean)leaveResult2.isDone());
        this.assertTransitionToUnsubscribeOnHBSentAndWaitForResponseToCompleteLeave(membershipManager, leaveResult1);
        Assertions.assertTrue((boolean)leaveResult2.isDone());
        Assertions.assertFalse((boolean)leaveResult2.isCompletedExceptionally());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenMemberAlreadyLeft() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        this.assertTransitionToUnsubscribeOnHBSentAndWaitForResponseToCompleteLeave(membershipManager, leaveResult1);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        this.mockLeaveGroup();
        CompletableFuture leaveResult2 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertTrue((boolean)leaveResult2.isDone());
        Assertions.assertFalse((boolean)leaveResult2.isCompletedExceptionally());
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).rebalanceListener();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenMemberFenced() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        ConsumerRebalanceListenerCallbackCompletedEvent callbackEvent = this.mockFencedMemberStuckOnUserCallback(membershipManager, invoker);
        Assertions.assertEquals((Object)MemberState.FENCED, (Object)membershipManager.state());
        this.mockLeaveGroup();
        CompletableFuture leaveOperation = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)leaveOperation.isDone());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        this.completeCallback(callbackEvent, membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
    }

    @Test
    public void testLeaveGroupWhenMemberIsStale() {
        ConsumerMembershipManager membershipManager = this.mockStaleMember();
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertTrue((boolean)leaveResult1.isDone());
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
    }

    @Test
    public void testFatalFailureWhenStateIsUnjoined() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
    }

    @Test
    public void testFatalFailureWhenStateIsStable() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState(null);
        this.testStateUpdateOnFatalFailure(membershipManager);
    }

    @Test
    public void testFatalFailureWhenStateIsPrepareLeaving() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        ConsumerRebalanceListenerCallbackCompletedEvent callbackEvent = this.mockPrepareLeavingStuckOnUserCallback(membershipManager, invoker);
        Assertions.assertEquals((Object)MemberState.PREPARE_LEAVING, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
        this.completeCallback(callbackEvent, membershipManager);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFatalFailureWhenStateIsLeaving() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveOperation = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveOperation.isDone());
        this.testStateUpdateOnFatalFailure(membershipManager);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)leaveOperation.isDone(), (String)"Member should complete the ongoing leave operation when transitioning to FATAL state");
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFatalFailureWhenMemberAlreadyLeft() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture sendLeave = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        MockRebalanceListener rebalanceListener = new MockRebalanceListener();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(rebalanceListener));
        membershipManager.onHeartbeatFailure(false);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((int)0, (int)rebalanceListener.lostCount);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)sendLeave.isDone());
        Assertions.assertFalse((boolean)sendLeave.isCompletedExceptionally(), (String)"Send leave should complete when a response to the leave group is received, even if it contains errors.");
    }

    @Test
    public void testUpdateStateFailsOnResponsesWithErrors() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ConsumerGroupHeartbeatResponse unknownMemberResponse = this.createConsumerGroupHeartbeatResponseWithError(Errors.UNKNOWN_MEMBER_ID, membershipManager.memberId());
        Assertions.assertThrows(IllegalArgumentException.class, () -> membershipManager.onHeartbeatSuccess(unknownMemberResponse));
    }

    @Test
    public void testNewAssignmentReplacesPreviousOneWaitingOnMetadata() {
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, Collections.singletonList(0), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        Set<TopicPartition> expectedAssignment = Collections.singleton(new TopicPartition(topicName, 0));
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(expectedAssignment, expectedAssignment);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
    }

    @Test
    public void testNewEmptyAssignmentReplacesPreviousOneWaitingOnMetadata() {
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, Collections.emptyList());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testNewAssignmentNotInMetadataReplacesPreviousOneWaitingOnMetadata() {
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        this.receiveAssignment(topicId, Collections.singletonList(0), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(false);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Assertions.assertEquals((Object)topicId, membershipManager.topicsAwaitingReconciliation().iterator().next());
    }

    @Test
    public void testUnresolvedTargetAssignmentIsReconciledWhenMetadataReceived() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topicId = Uuid.randomUuid();
        this.receiveAssignment(topicId, Collections.singletonList(1), membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty());
        membershipManager.maybeReconcile(true);
        Set<TopicPartition> expectedAssignment = Collections.singleton(new TopicPartition(topicName, 1));
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(expectedAssignment, expectedAssignment);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
    }

    @Test
    public void testMemberKeepsUnresolvedAssignmentWaitingForMetadataUntilResolved() {
        Uuid topic1 = Uuid.randomUuid();
        String topic1Name = "topic1";
        Uuid topic2 = Uuid.randomUuid();
        ConsumerGroupHeartbeatResponseData.Assignment assignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Collections.singletonList(0)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Arrays.asList(1, 3))));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topic1, topic1Name));
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true, assignment);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Assertions.assertEquals(Collections.singleton(topic2), (Object)membershipManager.topicsAwaitingReconciliation());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.onHeartbeatSuccess(this.createConsumerGroupHeartbeatResponse(assignment, membershipManager.memberId()));
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(Collections.singleton(topic2), (Object)membershipManager.topicsAwaitingReconciliation());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
    }

    @Test
    public void testReconcileNewPartitionsAssignedWhenNoPartitionOwned() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        List<TopicIdPartition> assignedPartitions = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
    }

    @Test
    public void testReconcileNewPartitionsAssignedWhenOtherPartitionsOwned() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        TopicIdPartition ownedPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.singletonList(ownedPartition));
        this.receiveAssignment(topicId, Arrays.asList(0, 1, 2), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        ArrayList<TopicIdPartition> assignedPartitions = new ArrayList<TopicIdPartition>();
        assignedPartitions.add(ownedPartition);
        assignedPartitions.addAll(this.topicIdPartitions(topicId, topicName, 1, 2));
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
    }

    @Test
    public void testReconciliationSkippedWhenSameAssignmentReceived() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        List<TopicIdPartition> expectedAssignmentReconciled = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, expectedAssignmentReconciled);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new Object[]{this.subscriptionState, membershipManager});
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, expectedAssignmentReconciled);
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationCompleted();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((Object)1.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceTotal));
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.failedRebalanceTotal));
    }

    @Test
    public void testReconcilePartitionsRevokedNoAutoCommitNoCallbacks() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockOwnedPartition(membershipManager, Uuid.randomUuid(), "topic1");
        this.mockRevocationNoCallbacks(false);
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        this.testRevocationOfAllPartitionsCompleted(membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.times((int)2))).markPendingRevocation(Set.of(new TopicPartition("topic1", 0)));
    }

    @Test
    public void testReconcilePartitionsRevokedWithSuccessfulAutoCommitNoCallbacks() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockOwnedPartition(membershipManager, Uuid.randomUuid(), "topic1");
        CompletableFuture<Void> commitResult = this.mockRevocationNoCallbacks(true);
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        Mockito.when((Object)this.commitRequestManager.maybeAutoCommitSyncBeforeRebalance(ArgumentMatchers.anyLong())).thenReturn(commitResult);
        membershipManager.maybeReconcile(true);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        commitResult.complete(null);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.subscriptionState, this.commitRequestManager});
        ((SubscriptionState)inOrder.verify((Object)this.subscriptionState)).markPendingRevocation(Set.of(new TopicPartition("topic1", 0)));
        ((CommitRequestManager)inOrder.verify((Object)this.commitRequestManager)).maybeAutoCommitSyncBeforeRebalance(ArgumentMatchers.anyLong());
        ((SubscriptionState)inOrder.verify((Object)this.subscriptionState)).markPendingRevocation(Set.of(new TopicPartition("topic1", 0)));
        this.testRevocationOfAllPartitionsCompleted(membershipManager);
    }

    @Test
    public void testReconcilePartitionsRevokedWithFailedAutoCommitCompletesRevocationAnyway() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockOwnedPartition(membershipManager, Uuid.randomUuid(), "topic1");
        CompletableFuture<Void> commitResult = this.mockRevocationNoCallbacks(true);
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        commitResult.completeExceptionally(new KafkaException("Commit request failed with non-retriable error"));
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.times((int)2))).markPendingRevocation(Set.of(new TopicPartition("topic1", 0)));
        this.testRevocationOfAllPartitionsCompleted(membershipManager);
    }

    @Test
    public void testReconcileNewPartitionsAssignedAndRevoked() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        TopicIdPartition ownedPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.singletonList(ownedPartition));
        this.mockRevocationNoCallbacks(false);
        this.receiveAssignment(topicId, Arrays.asList(1, 2), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        TreeSet<TopicPartition> expectedSet = new TreeSet<TopicPartition>((Comparator<TopicPartition>)AbstractMembershipManager.TOPIC_PARTITION_COMPARATOR);
        expectedSet.add(new TopicPartition(topicName, 1));
        expectedSet.add(new TopicPartition(topicName, 2));
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 1, 2), (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(expectedSet, expectedSet);
    }

    @Test
    public void testMetadataUpdatesReconcilesUnresolvedAssignments() {
        Uuid topicId = Uuid.randomUuid();
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(Arrays.asList(0, 1))));
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true, targetAssignment);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        String topicName = "topic1";
        this.mockTopicNameInMetadataCache(Collections.singletonMap(topicId, topicName), true);
        membershipManager.maybeReconcile(true);
        List<TopicIdPartition> expectedAssignmentReconciled = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, expectedAssignmentReconciled);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
    }

    @Test
    public void testMetadataUpdatesRequestsAnotherUpdateIfNeeded() {
        Uuid topicId = Uuid.randomUuid();
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(Arrays.asList(0, 1))));
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true, targetAssignment);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        membershipManager.maybeReconcile(false);
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsAwaitingReconciliation());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)2))).requestUpdate(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRevokePartitionsUsesTopicNamesLocalCacheWhenMetadataNotAvailable() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).markPendingRevocation(Set.of());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        List<Integer> partitions = Arrays.asList(0, 1);
        Set assignedPartitions = partitions.stream().map(p -> new TopicPartition(topicName, p.intValue())).collect(Collectors.toSet());
        Map<Uuid, TreeSet<Integer>> assignedTopicIdPartitions = Collections.singletonMap(topicId, new TreeSet<Integer>(partitions));
        Assertions.assertEquals(assignedTopicIdPartitions, (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        this.mockAckSent(membershipManager);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(assignedPartitions);
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        this.mockRevocationNoCallbacks(false);
        this.mockTopicNameInMetadataCache(Collections.singletonMap(topicId, topicName), false);
        this.receiveAssignment(topicId, Collections.singletonList(1), membershipManager);
        membershipManager.maybeReconcile(true);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.times((int)2))).markPendingRevocation(Set.of(new TopicPartition(topicName, 0)));
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.never())).requestUpdate(ArgumentMatchers.anyBoolean());
        List<TopicIdPartition> remainingAssignment = this.topicIdPartitions(topicId, topicName, 1);
        this.testRevocationCompleted(membershipManager, remainingAssignment);
    }

    @Test
    public void testOnSubscriptionUpdatedDoesNotTransitionToJoiningIfInGroup() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        membershipManager.onSubscriptionUpdated();
        Assertions.assertTrue((boolean)membershipManager.subscriptionUpdated());
        membershipManager.onConsumerPoll();
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).transitionToJoining();
        Assertions.assertFalse((boolean)membershipManager.subscriptionUpdated());
    }

    @Test
    public void testOnSubscriptionUpdatedTransitionsToJoiningOnPollIfNotInGroup() {
        ConsumerMembershipManager membershipManager = this.createMembershipManager(null);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.onSubscriptionUpdated();
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).transitionToJoining();
        Assertions.assertTrue((boolean)membershipManager.subscriptionUpdated());
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.onConsumerPoll();
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager)).transitionToJoining();
    }

    @Test
    public void testListenerCallbacksBasic() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, this.topicPartitions(topicName, 0, 1), true);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 0, 1), (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)1, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.topicPartitions(topicName, 0, 1));
        this.receiveEmptyAssignment(membershipManager);
        membershipManager.maybeReconcile(true);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions(topicName, 0, 1), true);
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, Collections.emptySortedSet(), true);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((int)1, (int)listener.revokedCount());
        Assertions.assertEquals((int)2, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
    }

    @Test
    public void testListenerCallbacksThrowsErrorOnPartitionsRevoked() {
        this.testErrorsOnPartitionsRevoked((RuntimeException)((Object)new WakeupException()));
        this.testErrorsOnPartitionsRevoked((RuntimeException)new InterruptException("Intentional onPartitionsRevoked() error"));
        this.testErrorsOnPartitionsRevoked(new IllegalArgumentException("Intentional onPartitionsRevoked() error"));
    }

    private void testErrorsOnPartitionsRevoked(RuntimeException error) {
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        this.mockOwnedPartition(membershipManager, topicId, topicName);
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener(Optional.ofNullable(error), Optional.empty(), Optional.empty());
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 0), (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions(topicName, 0), true);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals((int)1, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
    }

    @Test
    public void testListenerCallbacksThrowsErrorOnPartitionsAssigned() {
        this.testErrorsOnPartitionsAssigned((RuntimeException)((Object)new WakeupException()));
        this.testErrorsOnPartitionsAssigned((RuntimeException)new InterruptException("Intentional error"));
        this.testErrorsOnPartitionsAssigned(new IllegalArgumentException("Intentional error"));
    }

    private void testErrorsOnPartitionsAssigned(RuntimeException error) {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        this.mockOwnedPartition(membershipManager, topicId, topicName);
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener(Optional.empty(), Optional.ofNullable(error), Optional.empty());
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 0), (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions("topic1", 0), true);
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, Collections.emptySortedSet(), true);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals((int)1, (int)listener.revokedCount());
        Assertions.assertEquals((int)1, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
    }

    @Test
    public void testAddedPartitionsTemporarilyDisabledAwaitingOnPartitionsAssignedCallback() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        String topicName = "topic1";
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        int partitionOwned = 0;
        int partitionAdded = 1;
        SortedSet<TopicPartition> assignedPartitions = this.topicPartitions(topicName, partitionOwned, partitionAdded);
        SortedSet<TopicPartition> addedPartitions = this.topicPartitions(topicName, partitionAdded);
        this.mockPartitionOwnedAndNewPartitionAdded(topicName, partitionOwned, partitionAdded, new CounterConsumerRebalanceListener(), membershipManager);
        membershipManager.maybeReconcile(true);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(assignedPartitions, addedPartitions);
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, addedPartitions, true);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).enablePartitionsAwaitingCallback(assignedPartitions);
    }

    @Test
    public void testAddedPartitionsNotEnabledAfterFailedOnPartitionsAssignedCallback() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        String topicName = "topic1";
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        int partitionOwned = 0;
        int partitionAdded = 1;
        SortedSet<TopicPartition> assignedPartitions = this.topicPartitions(topicName, partitionOwned, partitionAdded);
        SortedSet<TopicPartition> addedPartitions = this.topicPartitions(topicName, partitionAdded);
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener(Optional.empty(), Optional.of(new RuntimeException("onPartitionsAssigned failed!")), Optional.empty());
        this.mockPartitionOwnedAndNewPartitionAdded(topicName, partitionOwned, partitionAdded, listener, membershipManager);
        membershipManager.maybeReconcile(true);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(assignedPartitions, addedPartitions);
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, addedPartitions, true);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).enablePartitionsAwaitingCallback((Collection)ArgumentMatchers.any());
    }

    @Test
    public void testOnPartitionsLostNoError() {
        this.testOnPartitionsLost(null);
    }

    @Test
    public void testOnPartitionsLostError() {
        this.testOnPartitionsLost((RuntimeException)((Object)new KafkaException("Intentional error for test")));
        this.testOnPartitionsLost((RuntimeException)((Object)new WakeupException()));
        this.testOnPartitionsLost((RuntimeException)new InterruptException("Intentional error for test"));
    }

    private void assertLeaveGroupDueToExpiredPollAndTransitionToStale(ConsumerMembershipManager membershipManager) {
        Assertions.assertDoesNotThrow(() -> membershipManager.transitionToSendingLeaveGroup(true));
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        membershipManager.onHeartbeatRequestGenerated();
        this.assertStaleMemberLeavesGroupAndClearsAssignment(membershipManager);
    }

    @Test
    public void testTransitionToLeavingWhileReconcilingDueToStaleMember() {
        ConsumerMembershipManager membershipManager = this.memberJoinWithAssignment();
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.assertLeaveGroupDueToExpiredPollAndTransitionToStale(membershipManager);
    }

    @Test
    public void testTransitionToLeavingWhileJoiningDueToStaleMember() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.assertLeaveGroupDueToExpiredPollAndTransitionToStale(membershipManager);
    }

    @Test
    public void testTransitionToLeavingWhileStableDueToStaleMember() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState(null);
        this.assertLeaveGroupDueToExpiredPollAndTransitionToStale(membershipManager);
    }

    @Test
    public void testTransitionToLeavingWhileAcknowledgingDueToStaleMember() {
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true);
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        this.assertLeaveGroupDueToExpiredPollAndTransitionToStale(membershipManager);
    }

    @Test
    public void testStaleMemberDoesNotSendHeartbeatAndAllowsTransitionToJoiningToRecover() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        membershipManager.transitionToSendingLeaveGroup(true);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.shouldSkipHeartbeat(), (String)"Stale member should not send heartbeats");
        Assertions.assertDoesNotThrow(() -> ((ConsumerMembershipManager)membershipManager).maybeRejoinStaleMember());
    }

    @Test
    public void testStaleMemberRejoinsWhenTimerResetsNoCallbacks() {
        ConsumerMembershipManager membershipManager = this.mockStaleMember();
        this.assertStaleMemberLeavesGroupAndClearsAssignment(membershipManager);
        membershipManager.maybeRejoinStaleMember();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
    }

    @Test
    public void testStaleMemberWaitsForCallbackToRejoinWhenTimerReset() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        int ownedPartition = 0;
        TopicPartition tp = new TopicPartition(topicName, ownedPartition);
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.singletonList(new TopicIdPartition(topicId, tp)));
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        membershipManager.transitionToSendingLeaveGroup(true);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)this.backgroundEventQueue.isEmpty());
        Assertions.assertInstanceOf(ConsumerRebalanceListenerCallbackNeededEvent.class, this.backgroundEventQueue.peek());
        ConsumerRebalanceListenerCallbackCompletedEvent callbackEvent = this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_LOST, this.topicPartitions(topicName, ownedPartition), false);
        membershipManager.maybeRejoinStaleMember();
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state(), (String)"Member should not transition out of the STALE state when the timer is reset if the callback has not completed.");
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed((Collection)ArgumentMatchers.any());
        this.completeCallback(callbackEvent, membershipManager);
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    private ConsumerMembershipManager mockStaleMember() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).assignFromSubscribed((Collection)ArgumentMatchers.any());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToSendingLeaveGroup(true);
        membershipManager.onHeartbeatRequestGenerated();
        return membershipManager;
    }

    private void mockPartitionOwnedAndNewPartitionAdded(String topicName, int partitionOwned, int partitionAdded, CounterConsumerRebalanceListener listener, ConsumerMembershipManager membershipManager) {
        Uuid topicId = Uuid.randomUuid();
        TopicPartition owned = new TopicPartition(topicName, partitionOwned);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(owned));
        membershipManager.updateAssignment(Collections.singletonMap(topicId, Utils.mkSortedSet((Comparable[])new Integer[]{partitionOwned})));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.ofNullable(listener));
        this.receiveAssignment(topicId, Arrays.asList(partitionOwned, partitionAdded), membershipManager);
    }

    private void testOnPartitionsLost(RuntimeException lostError) {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        this.mockOwnedPartition(membershipManager, topicId, topicName);
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener(Optional.empty(), Optional.empty(), Optional.ofNullable(lostError));
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        membershipManager.transitionToFenced();
        Assertions.assertEquals((Object)MemberState.FENCED, (Object)membershipManager.state());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        Assertions.assertTrue((boolean)membershipManager.shouldSkipHeartbeat(), (String)"Member should not send heartbeat while fenced");
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_LOST, this.topicPartitions("topic1", 0), true);
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)1, (int)listener.lostCount());
    }

    private ConsumerRebalanceListenerInvoker consumerRebalanceListenerInvoker() {
        return new ConsumerRebalanceListenerInvoker(new LogContext(), this.subscriptionState, this.time, new RebalanceCallbackMetricsManager(new Metrics(this.time)));
    }

    private static SortedSet<TopicPartition> topicPartitions(Map<Uuid, SortedSet<Integer>> topicIdMap, Map<Uuid, String> topicIdNames) {
        TreeSet<TopicPartition> topicPartitions = new TreeSet<TopicPartition>((Comparator<TopicPartition>)new Utils.TopicPartitionComparator());
        for (Uuid topicId : topicIdMap.keySet()) {
            Iterator iterator = topicIdMap.get(topicId).iterator();
            while (iterator.hasNext()) {
                int partition = (Integer)iterator.next();
                topicPartitions.add(new TopicPartition(topicIdNames.get(topicId), partition));
            }
        }
        return topicPartitions;
    }

    private SortedSet<TopicPartition> topicPartitions(String topicName, int ... partitions) {
        TreeSet<TopicPartition> topicPartitions = new TreeSet<TopicPartition>((Comparator<TopicPartition>)new Utils.TopicPartitionComparator());
        for (int partition : partitions) {
            topicPartitions.add(new TopicPartition(topicName, partition));
        }
        return topicPartitions;
    }

    private SortedSet<TopicIdPartition> topicIdPartitionsSet(Uuid topicId, String topicName, int ... partitions) {
        TreeSet<TopicIdPartition> topicIdPartitions = new TreeSet<TopicIdPartition>((Comparator<TopicIdPartition>)new Utils.TopicIdPartitionComparator());
        for (int partition : partitions) {
            topicIdPartitions.add(new TopicIdPartition(topicId, new TopicPartition(topicName, partition)));
        }
        return topicIdPartitions;
    }

    private List<TopicIdPartition> topicIdPartitions(Uuid topicId, String topicName, int ... partitions) {
        return new ArrayList<TopicIdPartition>(this.topicIdPartitionsSet(topicId, topicName, partitions));
    }

    private Map<Uuid, SortedSet<Integer>> topicIdPartitionsMap(Uuid topicId, int ... partitions) {
        TreeSet<Integer> topicIdPartitions = new TreeSet<Integer>();
        for (int partition : partitions) {
            topicIdPartitions.add(partition);
        }
        return Collections.singletonMap(topicId, topicIdPartitions);
    }

    private ConsumerRebalanceListenerCallbackCompletedEvent performCallback(ConsumerMembershipManager membershipManager, ConsumerRebalanceListenerInvoker invoker, ConsumerRebalanceListenerMethodName expectedMethodName, SortedSet<TopicPartition> expectedPartitions, boolean complete) {
        Assertions.assertEquals((int)1, (int)this.backgroundEventQueue.size());
        Assertions.assertNotNull(this.backgroundEventQueue.peek());
        Assertions.assertInstanceOf(ConsumerRebalanceListenerCallbackNeededEvent.class, this.backgroundEventQueue.peek());
        ConsumerRebalanceListenerCallbackNeededEvent neededEvent = (ConsumerRebalanceListenerCallbackNeededEvent)this.backgroundEventQueue.poll();
        Assertions.assertNotNull((Object)neededEvent);
        Assertions.assertEquals((Object)expectedMethodName, (Object)neededEvent.methodName());
        Assertions.assertEquals(expectedPartitions, (Object)neededEvent.partitions());
        ConsumerRebalanceListenerCallbackCompletedEvent invokedEvent = AsyncKafkaConsumer.invokeRebalanceCallbacks((ConsumerRebalanceListenerInvoker)invoker, (ConsumerRebalanceListenerMethodName)neededEvent.methodName(), (SortedSet)neededEvent.partitions(), (CompletableFuture)neededEvent.future());
        if (complete) {
            this.completeCallback(invokedEvent, membershipManager);
        }
        return invokedEvent;
    }

    private void completeCallback(ConsumerRebalanceListenerCallbackCompletedEvent callbackCompletedEvent, ConsumerMembershipManager membershipManager) {
        membershipManager.consumerRebalanceListenerCallbackCompleted(callbackCompletedEvent);
    }

    private void testFenceIsNoOp(ConsumerMembershipManager membershipManager) {
        Assertions.assertNotEquals((int)0, (int)membershipManager.memberEpoch());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).rebalanceListener();
    }

    private void assertStaleMemberLeavesGroupAndClearsAssignment(ConsumerMembershipManager membershipManager) {
        Assertions.assertEquals((Object)MemberState.STALE, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        Assertions.assertTrue((boolean)membershipManager.topicsAwaitingReconciliation().isEmpty());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).unsubscribe();
    }

    @Test
    public void testMemberJoiningTransitionsToStableWhenReceivingEmptyAssignment() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty());
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testMemberJoiningCallsRebalanceListenerWhenReceivingEmptyAssignment() {
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        this.receiveEmptyAssignment(membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, new TreeSet<TopicPartition>(Collections.emptyList()), true);
        Assertions.assertEquals((int)1, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
    }

    @Test
    public void testMetricsWhenHeartbeatFailed() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        membershipManager.onHeartbeatFailure(false);
        Assertions.assertEquals((Object)1.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceTotal));
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.failedRebalanceTotal));
    }

    @Test
    public void testRebalanceMetricsOnSuccessfulRebalance() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        this.mockOwnedPartition(membershipManager, Uuid.randomUuid(), "topic1");
        CompletableFuture<Void> commitResult = this.mockRevocationNoCallbacks(true);
        this.receiveEmptyAssignment(membershipManager);
        long reconciliationDurationMs = 1234L;
        this.time.sleep(reconciliationDurationMs);
        membershipManager.maybeReconcile(true);
        commitResult.complete(null);
        Assertions.assertEquals((Object)reconciliationDurationMs, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceLatencyTotal));
        Assertions.assertEquals((Object)reconciliationDurationMs, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceLatencyAvg));
        Assertions.assertEquals((Object)reconciliationDurationMs, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceLatencyMax));
        Assertions.assertEquals((Object)1.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceTotal));
        Assertions.assertEquals((double)120.0, (double)1.0, (double)((Double)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceRatePerHour)));
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.failedRebalanceRate));
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.failedRebalanceTotal));
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.lastRebalanceSecondsAgo));
    }

    @Test
    public void testRebalanceMetricsForMultipleReconciliations() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        SleepyRebalanceListener listener = new SleepyRebalanceListener(1453L, this.time);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        membershipManager.maybeReconcile(true);
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, this.topicPartitions(topicName, 0, 1), true);
        long firstRebalanaceTimesMs = listener.sleepMs;
        listener.reset();
        membershipManager.onHeartbeatRequestGenerated();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.topicPartitions(topicName, 0, 1));
        this.receiveAssignment(topicId, Collections.singletonList(2), membershipManager);
        membershipManager.maybeReconcile(true);
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions(topicName, 0, 1), true);
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, this.topicPartitions(topicName, 2), true);
        membershipManager.onHeartbeatRequestGenerated();
        long secondRebalanceMs = listener.sleepMs;
        long total = firstRebalanaceTimesMs + secondRebalanceMs;
        double avg = (double)total / 3.0;
        long max = Math.max(firstRebalanaceTimesMs, secondRebalanceMs);
        Assertions.assertEquals((Object)total, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceLatencyTotal));
        Assertions.assertEquals((double)avg, (double)((Double)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceLatencyAvg)), (double)1.0);
        Assertions.assertEquals((Object)max, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceLatencyMax));
        Assertions.assertEquals((Object)3.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceTotal));
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.failedRebalanceRate));
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.failedRebalanceTotal));
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.lastRebalanceSecondsAgo));
    }

    @Test
    public void testRebalanceMetricsOnFailedRebalance() {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        Uuid topicId = Uuid.randomUuid();
        this.receiveAssignment(topicId, Arrays.asList(0, 1), membershipManager);
        this.time.sleep(2300L);
        Assertions.assertTrue((boolean)this.rebalanceMetricsManager.rebalanceStarted());
        membershipManager.onHeartbeatFailure(false);
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceLatencyTotal));
        Assertions.assertEquals((Object)0.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.rebalanceTotal));
        Assertions.assertEquals((Object)120.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.failedRebalanceRate));
        Assertions.assertEquals((Object)1.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.failedRebalanceTotal));
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetricValue(this.metrics, this.rebalanceMetricsManager.lastRebalanceSecondsAgo));
    }

    @Test
    public void testPollMustCallsMaybeReconcileWithFalse() {
        ConsumerMembershipManager membershipManager = this.createMemberInStableState();
        membershipManager.poll(this.time.milliseconds());
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager)).maybeReconcile(false);
        this.verifyReconciliationNotTriggered(membershipManager);
    }

    private Object getMetricValue(Metrics metrics, MetricName name) {
        return ((KafkaMetric)metrics.metrics().get(name)).metricValue();
    }

    private ConsumerMembershipManager mockMemberSuccessfullyReceivesAndAcksAssignment(Uuid topicId, String topicName, List<Integer> partitions) {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, partitions, membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        List<TopicIdPartition> assignedPartitions = partitions.stream().map(tp -> new TopicIdPartition(topicId, new TopicPartition(topicName, tp.intValue()))).collect(Collectors.toList());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
        return membershipManager;
    }

    private CompletableFuture<Void> mockEmptyAssignmentAndRevocationStuckOnCommit(ConsumerMembershipManager membershipManager) {
        CompletableFuture<Void> commitResult = this.mockRevocationNoCallbacks(true);
        this.receiveEmptyAssignment(membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        this.verifyReconciliationTriggered(membershipManager);
        Mockito.clearInvocations((Object[])new ConsumerMembershipManager[]{membershipManager});
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        return commitResult;
    }

    private CompletableFuture<Void> mockNewAssignmentAndRevocationStuckOnCommit(ConsumerMembershipManager membershipManager, Uuid topicId, String topicName, List<Integer> partitions, boolean mockMetadata) {
        CompletableFuture<Void> commitResult = this.mockRevocationNoCallbacks(true);
        if (mockMetadata) {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        }
        this.receiveAssignment(topicId, partitions, membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        membershipManager.maybeReconcile(true);
        this.verifyReconciliationTriggered(membershipManager);
        Mockito.clearInvocations((Object[])new ConsumerMembershipManager[]{membershipManager});
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        return commitResult;
    }

    private ConsumerRebalanceListenerCallbackCompletedEvent mockNewAssignmentStuckOnPartitionsRevokedCallback(ConsumerMembershipManager membershipManager, Uuid topicId, String topicName, List<Integer> partitions, TopicPartition ownedPartition, ConsumerRebalanceListenerInvoker invoker) {
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        Mockito.when((Object)this.commitRequestManager.autoCommitEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, partitions, membershipManager);
        membershipManager.maybeReconcile(true);
        this.verifyReconciliationTriggered(membershipManager);
        Mockito.clearInvocations((Object[])new ConsumerMembershipManager[]{membershipManager});
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        return this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions(ownedPartition.topic(), ownedPartition.partition()), false);
    }

    private ConsumerRebalanceListenerCallbackCompletedEvent mockNewAssignmentStuckOnPartitionsAssignedCallback(ConsumerMembershipManager membershipManager, Uuid topicId, String topicName, int newPartition, ConsumerRebalanceListenerInvoker invoker) {
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        Mockito.when((Object)this.commitRequestManager.autoCommitEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, Collections.singletonList(newPartition), membershipManager);
        membershipManager.maybeReconcile(true);
        this.verifyReconciliationTriggered(membershipManager);
        Mockito.clearInvocations((Object[])new ConsumerMembershipManager[]{membershipManager});
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        return this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, this.topicPartitions(topicName, newPartition), false);
    }

    private void verifyReconciliationTriggered(ConsumerMembershipManager membershipManager) {
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager)).markReconciliationInProgress();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
    }

    private void verifyReconciliationNotTriggered(ConsumerMembershipManager membershipManager) {
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationCompleted();
    }

    private void verifyReconciliationTriggeredAndCompleted(ConsumerMembershipManager membershipManager, List<TopicIdPartition> expectedAssignment) {
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager)).markReconciliationInProgress();
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager)).markReconciliationCompleted();
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        List<TopicPartition> expectedTopicPartitions = this.buildTopicPartitions(expectedAssignment);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback((Collection)ArgumentMatchers.eq(new HashSet<TopicPartition>(expectedTopicPartitions)), (Collection)ArgumentMatchers.any());
        Map<Uuid, SortedSet<Integer>> assignmentByTopicId = this.assignmentByTopicId(expectedAssignment);
        Assertions.assertEquals(assignmentByTopicId, (Object)membershipManager.currentAssignment().partitions);
        ((CommitRequestManager)Mockito.verify((Object)this.commitRequestManager)).resetAutoCommitTimer();
    }

    private List<TopicPartition> buildTopicPartitions(List<TopicIdPartition> topicIdPartitions) {
        return topicIdPartitions.stream().map(TopicIdPartition::topicPartition).collect(Collectors.toList());
    }

    private void mockAckSent(ConsumerMembershipManager membershipManager) {
        membershipManager.onHeartbeatRequestGenerated();
    }

    private void mockTopicNameInMetadataCache(Map<Uuid, String> topicNames, boolean isPresent) {
        if (isPresent) {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(topicNames);
        } else {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        }
    }

    private CompletableFuture<Void> mockRevocationNoCallbacks(boolean withAutoCommit) {
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty()).thenReturn(Optional.empty());
        if (withAutoCommit) {
            Mockito.when((Object)this.commitRequestManager.autoCommitEnabled()).thenReturn((Object)true);
            CompletableFuture<Void> commitResult = new CompletableFuture<Void>();
            Mockito.when((Object)this.commitRequestManager.maybeAutoCommitSyncBeforeRebalance(ArgumentMatchers.anyLong())).thenReturn(commitResult);
            return commitResult;
        }
        return CompletableFuture.completedFuture(null);
    }

    private void mockMemberHasAutoAssignedPartition() {
        String topicName = "topic1";
        TopicPartition ownedPartition = new TopicPartition(topicName, 0);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty()).thenReturn(Optional.empty());
    }

    private void testRevocationOfAllPartitionsCompleted(ConsumerMembershipManager membershipManager) {
        this.testRevocationCompleted(membershipManager, Collections.emptyList());
    }

    private void testRevocationCompleted(ConsumerMembershipManager membershipManager, List<TopicIdPartition> expectedCurrentAssignment) {
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Map<Uuid, SortedSet<Integer>> assignmentByTopicId = this.assignmentByTopicId(expectedCurrentAssignment);
        Assertions.assertEquals(assignmentByTopicId, (Object)membershipManager.currentAssignment().partitions);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        List<TopicPartition> expectedTopicPartitionAssignment = this.buildTopicPartitions(expectedCurrentAssignment);
        HashSet<TopicPartition> expectedSet = new HashSet<TopicPartition>(expectedTopicPartitionAssignment);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(expectedSet, Collections.emptySet());
    }

    private Map<Uuid, SortedSet<Integer>> assignmentByTopicId(List<TopicIdPartition> topicIdPartitions) {
        HashMap<Uuid, SortedSet<Integer>> assignmentByTopicId = new HashMap<Uuid, SortedSet<Integer>>();
        topicIdPartitions.forEach(topicIdPartition -> {
            Uuid topicId = topicIdPartition.topicId();
            assignmentByTopicId.computeIfAbsent(topicId, k -> new TreeSet()).add(topicIdPartition.partition());
        });
        return assignmentByTopicId;
    }

    private void mockOwnedPartitionAndAssignmentReceived(ConsumerMembershipManager membershipManager, Uuid topicId, String topicName, Collection<TopicIdPartition> previouslyOwned) {
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.getTopicPartitions(previouslyOwned));
        HashMap partitionsByTopicId = new HashMap();
        partitionsByTopicId.put(topicId, new TreeSet(previouslyOwned.stream().map(TopicIdPartition::partition).collect(Collectors.toSet())));
        membershipManager.updateAssignment(partitionsByTopicId);
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty()).thenReturn(Optional.empty());
    }

    private Set<TopicPartition> getTopicPartitions(Collection<TopicIdPartition> topicIdPartitions) {
        return topicIdPartitions.stream().map(topicIdPartition -> new TopicPartition(topicIdPartition.topic(), topicIdPartition.partition())).collect(Collectors.toSet());
    }

    private void mockOwnedPartition(ConsumerMembershipManager membershipManager, Uuid topicId, String topic) {
        int partition = 0;
        TopicPartition previouslyOwned = new TopicPartition(topic, partition);
        membershipManager.updateAssignment(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)topicId, new TreeSet<Integer>(Collections.singletonList(partition)))}));
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(previouslyOwned));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
    }

    private ConsumerMembershipManager mockJoinAndReceiveAssignment(boolean triggerReconciliation) {
        return this.mockJoinAndReceiveAssignment(triggerReconciliation, this.createAssignment(triggerReconciliation));
    }

    private ConsumerMembershipManager mockJoinAndReceiveAssignment(boolean triggerReconciliation, ConsumerGroupHeartbeatResponseData.Assignment assignment) {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup();
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(assignment, membershipManager.memberId());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty()).thenReturn(Optional.empty());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        if (triggerReconciliation) {
            membershipManager.maybeReconcile(true);
            ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribedAwaitingCallback(ArgumentMatchers.anyCollection(), ArgumentMatchers.anyCollection());
        } else {
            ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        }
        Mockito.clearInvocations((Object[])new RequestManager[]{membershipManager, this.commitRequestManager});
        return membershipManager;
    }

    private ConsumerMembershipManager createMemberInStableState() {
        return this.createMemberInStableState(null);
    }

    private ConsumerMembershipManager createMemberInStableState(String groupInstanceId) {
        ConsumerMembershipManager membershipManager = this.createMembershipManagerJoiningGroup(groupInstanceId, null, null);
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData.Assignment(), membershipManager.memberId());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.maybeReconcile(true);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new Object[]{this.subscriptionState, membershipManager, this.commitRequestManager});
        return membershipManager;
    }

    private void receiveAssignment(Map<Uuid, SortedSet<Integer>> topicIdPartitionList, ConsumerMembershipManager membershipManager) {
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(topicIdPartitionList.entrySet().stream().map(tp -> new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId((Uuid)tp.getKey()).setPartitions(new ArrayList((Collection)tp.getValue()))).collect(Collectors.toList()));
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(targetAssignment, membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
    }

    private void receiveAssignment(Uuid topicId, List<Integer> partitions, ConsumerMembershipManager membershipManager) {
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(partitions)));
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(targetAssignment, membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
    }

    private Map<Uuid, SortedSet<Integer>> receiveAssignmentAfterRejoin(List<Integer> partitions, ConsumerMembershipManager membershipManager, Collection<TopicIdPartition> owned) {
        Uuid topicId = Uuid.randomUuid();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, "topic3", owned);
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(partitions)));
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponseWithBumpedEpoch(targetAssignment, membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
        this.verifyReconciliationNotTriggered(membershipManager);
        Map<Uuid, SortedSet<Integer>> assignmentAfterRejoin = this.topicIdPartitionsMap(topicId, 5);
        Assertions.assertEquals(assignmentAfterRejoin, (Object)membershipManager.topicPartitionsAwaitingReconciliation());
        return assignmentAfterRejoin;
    }

    private void assertInitialReconciliationDiscardedAfterRejoin(ConsumerMembershipManager membershipManager, Map<Uuid, SortedSet<Integer>> assignmentAfterRejoin) {
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).markPendingRevocation((Set)ArgumentMatchers.any());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        Assertions.assertNotEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertEquals(assignmentAfterRejoin, (Object)membershipManager.topicPartitionsAwaitingReconciliation());
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        Mockito.clearInvocations((Object[])new ConsumerMembershipManager[]{membershipManager});
        membershipManager.maybeReconcile(true);
        ((ConsumerMembershipManager)Mockito.verify((Object)membershipManager)).markReconciliationInProgress();
    }

    private void receiveEmptyAssignment(ConsumerMembershipManager membershipManager) {
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.emptyList());
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(targetAssignment, membershipManager.memberId());
        membershipManager.onHeartbeatSuccess(heartbeatResponse);
    }

    private void testFencedMemberReleasesAssignmentAndTransitionsToJoining(ConsumerMembershipManager membershipManager) {
        this.mockMemberHasAutoAssignedPartition();
        membershipManager.transitionToFenced();
        Assertions.assertEquals((int)0, (int)membershipManager.memberEpoch());
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
    }

    private void testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(ConsumerMembershipManager membershipManager) {
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).unsubscribe();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone(), (String)"Leave group result should not complete until the heartbeat request to leave is sent out.");
        this.assertTransitionToUnsubscribeOnHBSentAndWaitForResponseToCompleteLeave(membershipManager, leaveResult);
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isNone());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    private void mockLeaveGroup() {
        this.mockMemberHasAutoAssignedPartition();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
    }

    private ConsumerRebalanceListenerCallbackCompletedEvent mockPrepareLeavingStuckOnUserCallback(ConsumerMembershipManager membershipManager, ConsumerRebalanceListenerInvoker invoker) {
        String topicName = "topic1";
        TopicPartition ownedPartition = new TopicPartition(topicName, 0);
        this.mockPrepareLeaving(ownedPartition);
        membershipManager.leaveGroup();
        return this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions(ownedPartition.topic(), ownedPartition.partition()), false);
    }

    private void mockPrepareLeaving(TopicPartition ownedPartition) {
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        Mockito.when((Object)this.commitRequestManager.autoCommitEnabled()).thenReturn((Object)false);
    }

    private ConsumerRebalanceListenerCallbackCompletedEvent mockFencedMemberStuckOnUserCallback(ConsumerMembershipManager membershipManager, ConsumerRebalanceListenerInvoker invoker) {
        String topicName = "topic1";
        TopicPartition ownedPartition = new TopicPartition(topicName, 0);
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        Mockito.when((Object)this.commitRequestManager.autoCommitEnabled()).thenReturn((Object)false);
        membershipManager.transitionToFenced();
        return this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_LOST, this.topicPartitions(ownedPartition.topic(), ownedPartition.partition()), false);
    }

    private void testStateUpdateOnFatalFailure(ConsumerMembershipManager membershipManager) {
        String memberId = membershipManager.memberId();
        int lastEpoch = membershipManager.memberEpoch();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.onHeartbeatFailure(false);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        Assertions.assertEquals((Object)memberId, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)lastEpoch, (int)membershipManager.memberEpoch());
    }

    private ConsumerGroupHeartbeatResponse createConsumerGroupHeartbeatResponse(ConsumerGroupHeartbeatResponseData data) {
        return new ConsumerGroupHeartbeatResponse(data);
    }

    private ConsumerGroupHeartbeatResponse createConsumerGroupHeartbeatResponse(ConsumerGroupHeartbeatResponseData.Assignment assignment, String memberId) {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(memberId).setMemberEpoch(1).setAssignment(assignment));
    }

    private ConsumerGroupHeartbeatResponse createConsumerGroupLeaveResponse(String memberId) {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(memberId).setMemberEpoch(-1));
    }

    private ConsumerGroupHeartbeatResponse createConsumerGroupHeartbeatResponseWithBumpedEpoch(ConsumerGroupHeartbeatResponseData.Assignment assignment, String memberId) {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(memberId).setMemberEpoch(2).setAssignment(assignment));
    }

    private ConsumerGroupHeartbeatResponse createConsumerGroupHeartbeatResponseWithError(Errors error, String memberId) {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(error.code()).setMemberId(memberId).setMemberEpoch(5));
    }

    private ConsumerGroupHeartbeatResponseData.Assignment createAssignment(boolean mockMetadata) {
        Uuid topic1 = Uuid.randomUuid();
        Uuid topic2 = Uuid.randomUuid();
        if (mockMetadata) {
            HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
            topicNames.put(topic1, "topic1");
            topicNames.put(topic2, "topic2");
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(topicNames);
        }
        return new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Arrays.asList(0, 1, 2)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Arrays.asList(3, 4, 5))));
    }

    private ConsumerMembershipManager memberJoinWithAssignment() {
        Uuid topicId = Uuid.randomUuid();
        ConsumerMembershipManager membershipManager = this.mockJoinAndReceiveAssignment(true);
        membershipManager.onHeartbeatRequestGenerated();
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, "topic"));
        this.receiveAssignment(topicId, Collections.singletonList(0), membershipManager);
        membershipManager.onHeartbeatRequestGenerated();
        Assertions.assertFalse((boolean)membershipManager.currentAssignment().isNone());
        return membershipManager;
    }

    private void assertMemberIdIsGenerated(String memberId) {
        Assertions.assertNotNull((Object)memberId, (String)"Member Id should be generated at startup");
        Assertions.assertFalse((boolean)memberId.isEmpty(), (String)"Member Id should be generated at startup");
    }

    private static Stream<Arguments> notInGroupStates() {
        return Stream.of(Arguments.of((Object[])new Object[]{MemberState.UNSUBSCRIBED}), Arguments.of((Object[])new Object[]{MemberState.FENCED}), Arguments.of((Object[])new Object[]{MemberState.FATAL}), Arguments.of((Object[])new Object[]{MemberState.STALE}));
    }

    private static class SleepyRebalanceListener
    implements ConsumerRebalanceListener {
        private long sleepMs;
        private final long sleepDurationMs;
        private final Time time;

        SleepyRebalanceListener(long sleepDurationMs, Time time) {
            this.sleepDurationMs = sleepDurationMs;
            this.time = time;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.sleepMs += this.sleepDurationMs;
            this.time.sleep(this.sleepDurationMs);
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.sleepMs += this.sleepDurationMs;
            this.time.sleep(this.sleepDurationMs);
        }

        public void reset() {
            this.sleepMs = 0L;
        }
    }
}

