/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.errors;

import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.ApplicationRecoverableException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ConcurrentTransactionsException;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidRequiredAcksException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RefreshRetriableException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TransactionalIdAuthorizationException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TransactionExceptionHierarchyTest {
    @ParameterizedTest
    @ValueSource(classes={TimeoutException.class, NotEnoughReplicasException.class, CoordinatorLoadInProgressException.class, CorruptRecordException.class, NotEnoughReplicasAfterAppendException.class, ConcurrentTransactionsException.class})
    void testRetriableExceptionHierarchy(Class<? extends Exception> exceptionClass) {
        Assertions.assertTrue((boolean)RetriableException.class.isAssignableFrom(exceptionClass), (String)(exceptionClass.getSimpleName() + " should extend RetriableException"));
        Assertions.assertFalse((boolean)RefreshRetriableException.class.isAssignableFrom(exceptionClass), (String)(exceptionClass.getSimpleName() + " should NOT extend RefreshRetriableException"));
    }

    @Test
    void testRefreshRetriableException() {
        Assertions.assertTrue((boolean)RetriableException.class.isAssignableFrom(RefreshRetriableException.class), (String)"RefreshRetriableException should extend RetriableException");
    }

    @ParameterizedTest
    @ValueSource(classes={UnknownTopicOrPartitionException.class, NotLeaderOrFollowerException.class, NotCoordinatorException.class, CoordinatorNotAvailableException.class})
    void testRefreshRetriableExceptionHierarchy(Class<? extends Exception> exceptionClass) {
        Assertions.assertTrue((boolean)RefreshRetriableException.class.isAssignableFrom(exceptionClass), (String)(exceptionClass.getSimpleName() + " should extend RefreshRetriableException"));
    }

    @ParameterizedTest
    @ValueSource(classes={FencedInstanceIdException.class, IllegalGenerationException.class, InvalidPidMappingException.class, InvalidProducerEpochException.class, ProducerFencedException.class, UnknownMemberIdException.class})
    void testApplicationRecoverableExceptionHierarchy(Class<? extends Exception> exceptionClass) {
        Assertions.assertTrue((boolean)ApplicationRecoverableException.class.isAssignableFrom(exceptionClass), (String)(exceptionClass.getSimpleName() + " should extend ApplicationRecoverableException"));
    }

    @ParameterizedTest
    @ValueSource(classes={AuthenticationException.class, AuthorizationException.class, ClusterAuthorizationException.class, TransactionalIdAuthorizationException.class, UnsupportedVersionException.class, UnsupportedForMessageFormatException.class, InvalidRecordException.class, InvalidRequiredAcksException.class, RecordBatchTooLargeException.class, InvalidTopicException.class, TopicAuthorizationException.class, GroupAuthorizationException.class})
    void testInvalidConfigurationExceptionHierarchy(Class<? extends Exception> exceptionClass) {
        Assertions.assertTrue((boolean)InvalidConfigurationException.class.isAssignableFrom(exceptionClass), (String)(exceptionClass.getSimpleName() + " should extend InvalidConfigurationException"));
    }
}

