/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;

class EchoServer
extends Thread {
    private static final int SO_TIMEOUT_MS = 30000;
    public final int port;
    private final ServerSocket serverSocket;
    private final List<Thread> threads;
    private final List<Socket> sockets;
    private volatile boolean closing = false;
    private final SslFactory sslFactory;
    private final AtomicBoolean renegotiate = new AtomicBoolean();

    public EchoServer(SecurityProtocol securityProtocol, Map<String, ?> configs) throws Exception {
        switch (securityProtocol) {
            case SSL: {
                this.sslFactory = new SslFactory(ConnectionMode.SERVER);
                this.sslFactory.configure(configs);
                SSLContext sslContext = ((DefaultSslEngineFactory)this.sslFactory.sslEngineFactory()).sslContext();
                this.serverSocket = sslContext.getServerSocketFactory().createServerSocket(0);
                this.serverSocket.setSoTimeout(30000);
                break;
            }
            case PLAINTEXT: {
                this.serverSocket = new ServerSocket(0);
                this.sslFactory = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported securityProtocol " + String.valueOf(securityProtocol));
            }
        }
        this.port = this.serverSocket.getLocalPort();
        this.threads = Collections.synchronizedList(new ArrayList());
        this.sockets = Collections.synchronizedList(new ArrayList());
    }

    public void renegotiate() {
        this.renegotiate.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.closing) {
                Socket socket = this.serverSocket.accept();
                if (this.sslFactory != null) {
                    socket.setSoTimeout(30000);
                }
                List<Socket> list = this.sockets;
                synchronized (list) {
                    if (this.closing) {
                        socket.close();
                        return;
                    }
                    this.sockets.add(socket);
                    Thread thread = new Thread(() -> {
                        try {
                            DataInputStream input = new DataInputStream(socket.getInputStream());
                            DataOutputStream output = new DataOutputStream(socket.getOutputStream());
                            while (socket.isConnected() && !socket.isClosed()) {
                                int size = input.readInt();
                                if (this.renegotiate.get()) {
                                    this.renegotiate.set(false);
                                    ((SSLSocket)socket).startHandshake();
                                }
                                byte[] bytes = new byte[size];
                                input.readFully(bytes);
                                output.writeInt(size);
                                output.write(bytes);
                                output.flush();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            try {
                                socket.close();
                            }
                            catch (IOException iOException) {}
                        }
                    });
                    thread.start();
                    this.threads.add(thread);
                }
            }
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnections() throws IOException {
        List<Socket> list = this.sockets;
        synchronized (list) {
            for (Socket socket : this.sockets) {
                socket.close();
            }
        }
    }

    public void close() throws IOException, InterruptedException {
        this.closing = true;
        this.serverSocket.close();
        this.closeConnections();
        for (Thread t : this.threads) {
            t.join();
        }
        this.join();
    }
}

