/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.SslSelectorTest;
import org.apache.kafka.common.test.api.Flaky;
import org.apache.kafka.test.TestSslUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Tls13SelectorTest
extends SslSelectorTest {
    @Override
    protected Map<String, Object> createSslClientConfigs(File trustStoreFile) throws GeneralSecurityException, IOException {
        Map<String, Object> configs = TestSslUtils.createSslConfig(false, false, ConnectionMode.CLIENT, trustStoreFile, "client");
        configs.put("ssl.enabled.protocols", Collections.singletonList("TLSv1.3"));
        return configs;
    }

    @Override
    @Flaky(value="KAFKA-14249", comment="Copied from base class. Remove this override once the flakiness has been resolved.")
    @Test
    public void testCloseOldestConnection() throws Exception {
        super.testCloseOldestConnection();
    }

    @Test
    public void testKeyUpdate() throws Exception {
        String node = "0";
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelReady(this.selector, node);
        this.selector.send(this.createSend(node, node + "-0"));
        this.selector.poll(0L);
        this.server.renegotiate();
        this.selector.send(this.createSend(node, node + "-1"));
        ArrayList received = new ArrayList();
        TestUtils.waitForCondition(() -> {
            try {
                this.selector.poll(1000L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (NetworkReceive receive : this.selector.completedReceives()) {
                if (!receive.source().equals(node)) continue;
                received.add(receive);
            }
            return received.size() == 2;
        }, "Expected two receives, got " + received.size());
        Assertions.assertEquals(Arrays.asList("0-0", "0-1"), received.stream().map(this::asString).collect(Collectors.toList()));
    }
}

